/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.Proxy;
import com.sun.jdmk.ProxyHandler;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.RuntimeProxyException;
import com.sun.jdmk.comm.RemoteMBeanServer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class GenericProxy
implements Proxy {
    private ObjectName myName = null;
    private ObjectInstance objectInstance = null;
    private ProxyHandler server = null;

    public GenericProxy(ObjectInstance objectInstance) {
        this.setMBeanObjectInstance(objectInstance);
    }

    public GenericProxy(ObjectInstance objectInstance, ProxyHandler proxyHandler) {
        this.setMBeanObjectInstance(objectInstance);
        this.server = proxyHandler;
    }

    public void bind(RemoteMBeanServer remoteMBeanServer) {
        if (this.server != null) {
            throw new RuntimeProxyException("Generic Proxy has been already bound");
        }
        remoteMBeanServer.addProxy(this);
        this.server = remoteMBeanServer;
    }

    public void deleteMBean() throws InstanceNotFoundException, MBeanRegistrationException {
        this.server.unregisterMBean(this.objectInstance.getObjectName());
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        return this.server.getAttribute(this.myName, string);
    }

    public AttributeList getAttributes(String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.server.getAttributes(this.myName, stringArray);
    }

    public MBeanInfo getMBeanInfo() throws InstanceNotFoundException, ProxyMBeanInstantiationException, ReflectionException, IntrospectionException {
        return this.server.getMBeanInfo(this.myName);
    }

    public ObjectInstance getMBeanObjectInstance() {
        return this.objectInstance;
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        if (this.server instanceof RemoteMBeanServer) {
            return (RemoteMBeanServer)this.server;
        }
        return null;
    }

    public ProxyHandler getServer() {
        return this.server;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.server.invoke(this.myName, string, objectArray, stringArray);
    }

    public boolean isBound() {
        return this.server != null;
    }

    public void setAttribute(Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.server.setAttribute(this.myName, attribute);
    }

    public AttributeList setAttributes(AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.server.setAttributes(this.myName, attributeList);
    }

    public void setMBeanObjectInstance(ObjectInstance objectInstance) {
        if (objectInstance == null) {
            throw new IllegalArgumentException("Cannot set to a null ObjectInstance.");
        }
        this.objectInstance = objectInstance;
        this.myName = this.objectInstance.getObjectName();
    }

    public void setRemoteMBeanServer(RemoteMBeanServer remoteMBeanServer) {
        this.server = remoteMBeanServer;
    }

    public void setServer(ProxyHandler proxyHandler) {
        this.server = proxyHandler;
    }

    public void unbind() {
        if (this.server != null) {
            this.server = null;
            if (this.server instanceof RemoteMBeanServer) {
                ((RemoteMBeanServer)this.server).removeProxy(this);
            }
        } else {
            throw new RuntimeProxyException("The proxy has not been bound to a server.");
        }
    }
}

