/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.GroupGenerator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CodeGenerator
extends Generator
implements Serializable {
    protected GroupGenerator groupGenerator = null;
    protected String domainSeparator = "_";

    public CodeGenerator(ResourceManager resourceManager, Context context) {
        super(resourceManager, context);
        this.groupGenerator = new GroupGenerator(resourceManager, context.duplicate());
    }

    public void addExternalSymbol(Context context, String string) {
        this.groupGenerator.addExternalSymbol(context, string);
    }

    public String appendName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return new String(String.valueOf(string) + this.domainSeparator + string2);
    }

    private void buildSymbolTable(Context context, MibGenerator mibGenerator, MibNode mibNode) throws IOException {
        this.buildSymbolTable(context, mibGenerator, mibNode, null, null);
    }

    private void buildSymbolTable(Context context, MibGenerator mibGenerator, MibNode mibNode, MibNode mibNode2, String string) throws IOException {
        Object object;
        if (mibNode.isGroup()) {
            try {
                mibNode.isValidGroup();
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                String string3 = this.getClassName(mibNode.getComputedOid());
                String string4 = MessageHandler.getMessage("generate.error.mib", string3, this.getClassName(string2));
                mibGenerator.endMib();
                throw iOException;
            }
            this.groupGenerator.buildSymbolTable(mibNode, context);
            if (!mibNode.hasNestedGroups()) {
                return;
            }
            object = CodeGenerator.getSymbolName(context, mibNode);
            if (object != null) {
                string = this.appendName(string, (String)object);
            }
            mibNode2 = mibNode;
        }
        object = mibNode.getChildren();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            this.buildSymbolTable(context, mibGenerator, (MibNode)enumeration.nextElement(), mibNode2, string);
        }
    }

    public void generateCode(ASTMib aSTMib, int n) throws IOException {
        Context context = this.context.duplicate();
        context.mib = aSTMib;
        context.gentype = n;
        context.codegen = this;
        MibGenerator mibGenerator = new MibGenerator(this.manager, aSTMib, context);
        mibGenerator.setDomainSeparator(this.domainSeparator);
        context.mibgen = mibGenerator;
        MibTree mibTree = aSTMib.getMibTree();
        MibNode mibNode = mibTree.getRoot();
        this.groupGenerator.setContext(context);
        this.setContext(context);
        this.buildSymbolTable(context, mibGenerator, mibNode);
        this.generateCode(context, mibGenerator, mibNode);
        mibGenerator.endMib();
    }

    private void generateCode(Context context, MibGenerator mibGenerator, MibNode mibNode) throws IOException {
        this.generateNode(context, mibGenerator, mibNode, null, null);
    }

    private void generateNode(Context context, MibGenerator mibGenerator, MibNode mibNode, MibNode mibNode2, String string) throws IOException {
        Object object;
        if (mibNode.isGroup()) {
            try {
                mibNode.isValidGroup();
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                String string3 = this.getClassName(mibNode.getComputedOid());
                String string4 = MessageHandler.getMessage("generate.error.mib", string3, this.getClassName(string2));
                mibGenerator.endMib();
                throw iOException;
            }
            this.groupGenerator.generateCode(mibNode, context);
            mibGenerator.registerNode(mibNode, context, string);
            if (!mibNode.hasNestedGroups()) {
                return;
            }
            object = CodeGenerator.getSymbolName(context, mibNode);
            if (object != null) {
                string = this.appendName(string, (String)object);
            }
            mibNode2 = mibNode;
        }
        object = mibNode.getChildren();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            this.generateNode(context, mibGenerator, (MibNode)enumeration.nextElement(), mibNode2, string);
        }
    }

    public static String getSymbolName(Context context, MibNode mibNode) {
        if (mibNode == null) {
            return null;
        }
        if (mibNode.getSymbolName() != null) {
            return mibNode.getSymbolName();
        }
        String string = context.mib.getAssociatedSymbol(mibNode.getComputedOid());
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        string2 = string2.replace('-', '_');
        string2 = string2.replace('.', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(' ', '_');
        return String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1, string2.length());
    }

    public String setDomainSeparator(String string) {
        if (string != null) {
            this.domainSeparator = string;
        }
        return this.domainSeparator;
    }
}

