/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibAgentMBean;
import com.sun.jdmk.snmp.agent.SnmpMibHandler;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;
import com.sun.jdmk.snmp.agent.SnmpMibRequestImpl;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMibAgent
implements SnmpMibAgentMBean,
MBeanRegistration,
Serializable {
    protected String mibName;
    protected MBeanServer server;
    private ObjectName adaptorName;
    private transient SnmpMibHandler adaptor;

    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.check(snmpMibRequest.getSubList());
    }

    public void check(Vector vector) throws SnmpStatusException {
    }

    private void concatVector(SnmpMibRequest snmpMibRequest, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpMibRequest.addVarBind(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
        }
    }

    private void concatVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            vector.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
        }
    }

    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.get(snmpMibRequest.getSubList(), snmpMibRequest.getVersion());
    }

    public void get(Vector vector, int n) throws SnmpStatusException {
    }

    public boolean getBindingState() {
        return this.adaptor != null;
    }

    public void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        this.getBulk(snmpMibRequest.getSubList(), n, n2, snmpMibRequest.getVersion());
    }

    public void getBulk(Vector vector, int n, int n2, int n3) throws SnmpStatusException {
    }

    void getBulkWithGetNext(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        Vector vector = snmpMibRequest.getSubList();
        int n3 = vector.size();
        int n4 = Math.max(Math.min(n, n3), 0);
        int n5 = Math.max(n2, 0);
        int n6 = n3 - n4;
        if (n3 != 0) {
            this.getNext(snmpMibRequest);
            Vector vector2 = this.splitFrom(vector, n4);
            SnmpMibRequestImpl snmpMibRequestImpl = new SnmpMibRequestImpl(vector2, 1, snmpMibRequest.getUserData());
            int n7 = 2;
            while (n7 <= n5) {
                this.getNext(snmpMibRequestImpl);
                this.concatVector(snmpMibRequest, vector2);
                ++n7;
            }
        }
    }

    void getBulkWithGetNext(Vector vector, int n, int n2, int n3) throws SnmpStatusException {
        SnmpMibRequestImpl snmpMibRequestImpl = new SnmpMibRequestImpl(vector, n3, null);
        this.getBulkWithGetNext(snmpMibRequestImpl, n, n2);
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public String getMibName() {
        return this.mibName;
    }

    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.getNext(snmpMibRequest.getSubList(), snmpMibRequest.getVersion());
    }

    public void getNext(Vector vector, int n) throws SnmpStatusException {
    }

    public abstract long[] getRootOid();

    public SnmpMibHandler getSnmpAdaptor() {
        return this.adaptor;
    }

    public ObjectName getSnmpAdaptorName() {
        return this.adaptorName;
    }

    public abstract void init() throws IllegalAccessException;

    public static SnmpMibRequest newMibRequest(Vector vector, int n, Object object) {
        return new SnmpMibRequestImpl(vector, n, object);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public abstract ObjectName preRegister(MBeanServer var1, ObjectName var2) throws Exception;

    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.set(snmpMibRequest.getSubList(), snmpMibRequest.getVersion());
    }

    public void set(Vector vector, int n) throws SnmpStatusException {
    }

    public void setSnmpAdaptor(SnmpMibHandler snmpMibHandler) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = snmpMibHandler;
        if (this.adaptor != null) {
            this.adaptor.addMib(this);
        }
    }

    public void setSnmpAdaptorName(ObjectName objectName) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(String.valueOf(this.mibName) + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] objectArray = new Object[]{this};
        String[] stringArray = new String[]{"com.sun.jdmk.snmp.agent.SnmpMibAgent"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(objectName, "addMib", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        catch (ReflectionException reflectionException) {
            throw new ServiceNotFoundException(objectName.toString());
        }
        catch (MBeanException mBeanException) {}
        this.adaptorName = objectName;
    }

    private Vector splitFrom(Vector vector, int n) {
        int n2 = vector.size();
        Vector<SnmpVarBind> vector2 = new Vector<SnmpVarBind>(n2 - n);
        int n3 = n;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            if (n3 <= 0) {
                vector2.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
            }
            --n3;
        }
        return vector2;
    }

    private static Vector vector(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }
}

