/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMonitor;
import com.sun.jdmk.discovery.DiscoveryResponderNotification;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.Vector;

class ActualMonitor
extends DiscoveryCommon
implements Serializable {
    private static long sequenceNumber = 0L;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private Thread listeningThread = null;
    private volatile boolean stopRequested = false;
    public Boolean interrupted = new Boolean(false);
    private transient int state = 1;
    private transient DiscoveryMonitor monitor = null;
    private Vector listeners = new Vector();

    public ActualMonitor(String string, int n, DiscoveryMonitor discoveryMonitor) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualMonitor";
        if (this.isTraceOn()) {
            this.trace("constructor ", "initialize multicast socket");
        }
        this.multicastGroup = string;
        this.multicastPort = n;
        this.monitor = discoveryMonitor;
    }

    private void processMsg(ResponsePDU responsePDU) throws IOException {
        if (responsePDU == null) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "received a nul pdu '");
            }
            return;
        }
        if (this.isTraceOn()) {
            this.trace("processMsg ", "received pdu '" + responsePDU.printState() + "'");
        }
        if (!responsePDU.getEvent()) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "not an event message");
            }
            return;
        }
        DiscoveryResponse discoveryResponse = new DiscoveryResponse();
        discoveryResponse.host = responsePDU.getHost();
        discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
        discoveryResponse.specificationName = responsePDU.getSpecificationName();
        discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
        discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
        discoveryResponse.implementationName = responsePDU.getImplementationName();
        discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
        discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
        discoveryResponse.objectList = responsePDU.getObjectList();
        discoveryResponse.userData = responsePDU.getUserData();
        DiscoveryResponderNotification discoveryResponderNotification = new DiscoveryResponderNotification(this.monitor, responsePDU.getAgentState(), discoveryResponse, sequenceNumber++);
        this.monitor.sendNotification(discoveryResponderNotification);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        block24: {
            if (this.isTraceOn()) {
                this.trace("run ", "start");
            }
            try {
                this.connectToGroup();
            }
            catch (IOException v0) {
                this.stopRequested = true;
            }
            block17: while (true) {
                while (!this.stopRequested) {
                    this.monitor.changeState(0);
                    try {
                        if (this.isTraceOn()) {
                            this.trace("run ", "Start Waiting ");
                        }
                        var3_1 /* !! */  = (ResponsePDU)this.receiveMsg(this);
                        this.processMsg((ResponsePDU)var3_1 /* !! */ );
                        continue block17;
                    }
                    catch (InterruptedIOException v1) {
                        if (this.isTraceOn()) {
                            this.trace("run ", "Stop execution ");
                        }
                        this.stopRequested = true;
                        continue block17;
                    }
                    catch (IOException v2) {
                        if (!this.isTraceOn()) continue block17;
                        this.trace("run ", "Not a event msg - continue - ");
                        continue block17;
                    }
                    catch (ClassCastException v3) {
                        if (!this.isTraceOn()) continue block17;
                        this.trace("run ", "Not a event msg - continue - ");
                        continue block17;
                    }
                    catch (ClassNotFoundException v4) {
                        if (!this.isTraceOn()) ** break;
                        this.trace("run ", "Not a event msg - continue - ");
                    }
                }
                break;
            }
            var2_3 = null;
            var3_1 /* !! */  = this.interrupted;
            synchronized (var3_1 /* !! */ ) {
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
            }
            try {
                this.disconnectFromGroup();
                this.monitor.changeState(1);
                break block24;
            }
            catch (IOException var3_1 /* !! */ ) {
                if (this.isDebugOn()) {
                    this.debug("run ", (Exception)var3_1 /* !! */ );
                }
                break block24;
            }
            catch (Throwable var1_5) {
                block25: {
                    var2_4 = null;
                    var3_2 /* !! */  = this.interrupted;
                    synchronized (var3_2 /* !! */ ) {
                        this.interrupted = new Boolean(true);
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    try {
                        this.disconnectFromGroup();
                        this.monitor.changeState(1);
                    }
                    catch (IOException var3_2 /* !! */ ) {
                        if (!this.isDebugOn()) break block25;
                        this.debug("run ", (Exception)var3_2 /* !! */ );
                    }
                }
                this.close();
                throw var1_5;
            }
        }
        this.close();
    }

    public void stopMonitor() {
        this.stopRequested = true;
    }
}

