/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.HttpSendInputStream;
import com.sun.jdmk.comm.HttpSendOutputStream;
import com.sun.jdmk.comm.TimedURLConnection;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Properties;

class HttpSendSocket
extends Socket {
    protected String host;
    protected int port;
    protected URL url;
    protected GenericHttpConnectorClient connector;
    protected URLConnection conn = null;
    protected TimedURLConnection timedConn = null;
    private static boolean got_timedProperty = false;
    private static boolean useTimedURLConnection = false;
    private static Integer urlConn_timeoutvalue = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected HttpSendInputStream inNotifier;
    protected HttpSendOutputStream outNotifier;
    private final String dbgTag = "HttpSendSocket";

    public HttpSendSocket(String string, int n) throws IOException {
        this(string, n, new URL("http", string, n, "/"), null);
        if (!got_timedProperty) {
            Properties properties = System.getProperties();
            String string2 = null;
            string2 = properties.getProperty("com.sun.jdmk.connectionTimeout");
            if (string2 != null) {
                useTimedURLConnection = true;
                try {
                    urlConn_timeoutvalue = new Integer(string2);
                }
                catch (Exception exception) {
                    urlConn_timeoutvalue = new Integer(10000);
                }
            }
            got_timedProperty = true;
        }
    }

    public HttpSendSocket(String string, int n, URL uRL, GenericHttpConnectorClient genericHttpConnectorClient) throws IOException {
        super((SocketImpl)null);
        if (!got_timedProperty) {
            Properties properties = System.getProperties();
            String string2 = null;
            string2 = properties.getProperty("com.sun.jdmk.urlconnectionTimeout");
            if (string2 != null) {
                useTimedURLConnection = true;
                try {
                    urlConn_timeoutvalue = new Integer(string2);
                }
                catch (Exception exception) {
                    urlConn_timeoutvalue = new Integer(10000);
                }
            }
            got_timedProperty = true;
        }
        this.host = string;
        this.port = n;
        this.url = uRL;
        this.connector = genericHttpConnectorClient;
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(this.writeNotify(), this);
    }

    public HttpSendSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress.getHostName(), n);
        if (!got_timedProperty) {
            Properties properties = System.getProperties();
            String string = null;
            string = properties.getProperty("USE_TIMED_URLCONN");
            if (string != null) {
                useTimedURLConnection = true;
                try {
                    urlConn_timeoutvalue = new Integer(string);
                }
                catch (Exception exception) {
                    urlConn_timeoutvalue = new Integer(10000);
                }
            }
            got_timedProperty = true;
        }
    }

    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    private void debug(String string, String string2) {
        this.debug("HttpSendSocket", string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 8, string, string2, string3);
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.inNotifier;
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getLocalPort() {
        return -1;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outNotifier;
    }

    public int getPort() {
        return this.port;
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 8);
    }

    public synchronized InputStream readNotify() throws IOException {
        AuthSchemeInfo authSchemeInfo;
        block10: {
            this.outNotifier.deactivate();
            this.out.close();
            this.out = null;
            try {
                if (!useTimedURLConnection) {
                    ((HttpURLConnection)this.conn).getResponseCode();
                    this.in = ((HttpURLConnection)this.conn).getErrorStream();
                } else {
                    this.timedConn.getResponseCode();
                    this.in = this.timedConn.getErrorStream();
                }
            }
            catch (IOException iOException) {
                if (!this.isDebugOn()) break block10;
                this.debug("readNotify", "got Exception:");
                iOException.printStackTrace();
            }
        }
        if (this.in == null) {
            try {
                this.in = !useTimedURLConnection ? this.conn.getInputStream() : this.timedConn.getInputStream();
            }
            catch (IOException iOException) {
                throw new IOException("HTTP request failed");
            }
        }
        String string = null;
        if (!useTimedURLConnection ? (string = this.conn.getContentType()) == null || !this.conn.getContentType().equals("application/octet-stream") : (string = this.timedConn.getURLConnection().getContentType()) == null || !this.timedConn.getURLConnection().getContentType().equals("application/octet-stream")) {
            throw new IOException("HTTP request failed");
        }
        String string2 = null;
        string2 = !useTimedURLConnection ? this.conn.getHeaderField("WWW-Authenticate") : this.timedConn.getURLConnection().getHeaderField("WWW-Authenticate");
        if (string2 != null && this.connector.authSchemeInfoList != null && (authSchemeInfo = (AuthSchemeInfo)this.connector.authSchemeInfoList.get(Thread.currentThread())) != null) {
            authSchemeInfo.setChallenge(string2);
        }
        int n = 0;
        n = !useTimedURLConnection ? ((HttpURLConnection)this.conn).getResponseCode() : this.timedConn.getResponseCode();
        if (n == 401) {
            throw new UnauthorizedSecurityException("Unauthorized");
        }
        return this.in;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
    }

    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }

    public synchronized OutputStream writeNotify() throws IOException {
        String string;
        AuthSchemeInfo authSchemeInfo;
        if (this.conn != null) {
            throw new IOException("Attempt to write on HttpSendSocket after request has been sent");
        }
        if (!useTimedURLConnection) {
            this.conn = this.url.openConnection();
            this.conn.setDoOutput(true);
            this.conn.setUseCaches(false);
            this.conn.setRequestProperty("Accept", "application/octet-stream");
            this.conn.setRequestProperty("User-Agent", "JDMK4.2/Java2");
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
        } else {
            this.timedConn = new TimedURLConnection(this.url, urlConn_timeoutvalue.intValue());
            if (this.timedConn.getURLConnection() == null) {
                throw new IOException("Failed to write notification (no connection)");
            }
            this.timedConn.getURLConnection().setDoOutput(true);
            this.timedConn.getURLConnection().setUseCaches(false);
            this.timedConn.getURLConnection().setRequestProperty("Accept", "application/octet-stream");
            this.timedConn.getURLConnection().setRequestProperty("User-Agent", "JDMK4.2/Java2");
            this.timedConn.getURLConnection().setRequestProperty("Content-Type", "application/octet-stream");
        }
        if (this.connector.authSchemeInfoList != null && (authSchemeInfo = (AuthSchemeInfo)this.connector.authSchemeInfoList.get(Thread.currentThread())) != null && (string = authSchemeInfo.getResponse()) != null) {
            if (!useTimedURLConnection) {
                this.conn.setRequestProperty("Authorization", string);
            } else {
                this.timedConn.getURLConnection().setRequestProperty("Authorization", string);
            }
            authSchemeInfo.setResponse(null);
        }
        this.inNotifier.deactivate();
        this.in = null;
        this.out = !useTimedURLConnection ? this.conn.getOutputStream() : this.timedConn.getOutputStream();
        return this.out;
    }
}

