/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpRequestHandler;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class GenericHttpConnectorServer
extends CommunicatorServer {
    transient GenericHttpSocket sockListen = null;
    InetAddress addrLastClient = null;
    Vector authInfo = new Vector();
    int index = 0;
    final int MAX_CHALLENGES = 100;
    String[] challengeList = new String[100];
    ServerNotificationDispatcher serverNotificationDispatcher = null;
    HeartBeatServerHandler heartbeatServerHandler = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpConnectorServer(int n) throws IllegalArgumentException {
        super(n);
        this.maxActiveClientCount = 10;
    }

    public GenericHttpConnectorServer(int n, int n2) throws IllegalArgumentException {
        this(n);
        this.port = n2;
    }

    public GenericHttpConnectorServer(int n, int n2, AuthInfo[] authInfoArray) throws IllegalArgumentException {
        this(n, n2);
        if (authInfoArray != null) {
            int n3 = 0;
            while (n3 < authInfoArray.length) {
                this.addUserAuthenticationInfo(authInfoArray[n3]);
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] var1_1, byte[] var2_2) {
        var3_3 = 64;
        var4_4 = null;
        try {
            var4_4 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException v0) {}
        if (var2_2.length > 64) {
            var2_2 = var4_4.digest(var2_2);
        }
        var5_5 = new byte[64];
        var6_6 = new byte[64];
        var8_7 = 0;
        ** GOTO lbl21
        {
            var5_5[var8_7] = var2_2[var8_7];
            var6_6[var8_7] = var2_2[var8_7];
            ++var8_7;
            do {
                if (var8_7 < var2_2.length) continue block2;
                var5_5[var8_7] = 0;
                var6_6[var8_7] = 0;
                ++var8_7;
lbl21:
                // 2 sources

            } while (var8_7 < 64);
        }
        var8_7 = 0;
        while (var8_7 < 64) {
            v1 = var8_7;
            var5_5[v1] = (byte)(var5_5[v1] ^ 54);
            v2 = var8_7++;
            var6_6[v2] = (byte)(var6_6[v2] ^ 92);
        }
        var4_4.update(var5_5);
        var4_4.update(var1_1);
        var7_8 = var4_4.digest();
        var4_4.update(var6_6);
        var4_4.update(var7_8);
        var7_8 = var4_4.digest();
        var9_9 = new StringBuffer();
        var8_7 = 0;
        while (var8_7 < var7_8.length) {
            if ((var7_8[var8_7] & 255) < 16) {
                var9_9.append("0" + Integer.toHexString(var7_8[var8_7] & 255));
            } else {
                var9_9.append(Integer.toHexString(var7_8[var8_7] & 255));
            }
            ++var8_7;
        }
        return var9_9.toString();
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
            this.authInfo.addElement(authInfo);
        }
    }

    synchronized AuthInfo checkChallengeResponse(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.substring(0, string.lastIndexOf(32));
        String string3 = string.substring(string.lastIndexOf(32) + 1);
        AuthInfo authInfo = null;
        boolean bl = false;
        Enumeration enumeration = this.authInfo.elements();
        while (enumeration.hasMoreElements()) {
            authInfo = (AuthInfo)enumeration.nextElement();
            if (!authInfo.getLogin().equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        byte[] byArray = authInfo.getPassword().getBytes();
        int n = 0;
        while (n < 100) {
            String string4;
            String string5 = this.challengeList[n];
            if (string5 != null && string3.equals(string4 = this.HMAC_MD5(string5.getBytes(), byArray))) {
                this.challengeList[n] = null;
                return authInfo;
            }
            ++n;
        }
        return null;
    }

    abstract GenericHttpSocket createSocket();

    protected void doBind() throws InterruptedException, CommunicationException {
        try {
            this.sockListen = this.createSocket().createServerSocket(this.port);
            this.sockListen.doBind();
            this.port = this.sockListen.getLocalPort();
            this.dbgTag = this.makeDebugTag();
            if (this.isTraceOn()) {
                this.trace("doBind", String.valueOf(this.sockListen.toString()) + " bound to " + this.sockListen.getLocalAddress() + " port " + this.sockListen.getLocalPort());
            }
        }
        catch (SocketException socketException) {
            if (this.isTraceOn()) {
                this.trace("doBind", "EXCEPTION MSG = '" + socketException.getMessage() + "'");
            }
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doProcess() throws InterruptedException, CommunicationException {
        if (this.isTraceOn()) {
            this.trace("doProcess", "Address of last connected client [" + this.addrLastClient + "]");
        }
        GenericHttpRequestHandler genericHttpRequestHandler = new GenericHttpRequestHandler(this, this.getServedClientCount(), (GenericHttpSocket)this.sockListen.clone(), this.topMBS, this.objectName);
    }

    protected void doReceive() throws InterruptedException, CommunicationException {
        try {
            this.sockListen.doReceive();
            this.addrLastClient = this.sockListen.getRemoteAddress();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(iOException.toString());
            }
            throw new CommunicationException(iOException);
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            if (this.isTraceOn()) {
                this.trace("doReceive", "EXCEPTION MSG = '" + exception.getMessage() + "'");
            }
            throw new InterruptedException();
        }
    }

    protected void doUnbind() throws InterruptedException, CommunicationException {
        try {
            if (this.sockListen != null) {
                if (this.isTraceOn()) {
                    this.trace("doUnbind", "Port [" + this.port + "] has been definitively closed");
                }
                this.sockListen.doUnbind();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    synchronized String generateChallengeResponse() {
        Object object;
        String string = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "UnknownHost";
        }
        object = "<" + System.currentTimeMillis() + "@" + string + ">";
        if (this.index == 100) {
            this.index = 0;
        }
        this.challengeList[this.index] = object;
        ++this.index;
        return object;
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return new String("unknown");
        }
        return this.addrLastClient.toString();
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    abstract GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress var1);

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public boolean isAuthenticationOn() {
        return this.authInfo.isEmpty() ^ true;
    }

    String makeDebugTag() {
        return "GenericHttpConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        NotificationHandlerInternal notificationHandlerInternal = new NotificationHandlerInternal(this);
        this.serverNotificationDispatcher = new ServerNotificationDispatcher(notificationHandlerInternal, this.topMBS);
        this.heartbeatServerHandler = new HeartBeatServerHandler(this.topMBS, this.serverNotificationDispatcher);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return super.preRegister(mBeanServer, objectName);
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
        }
    }

    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        super.setMBeanServer(mBeanServer);
        this.serverNotificationDispatcher.setMBeanServer(mBeanServer);
    }

    public void setMaxActiveClientCount(int n) throws IllegalStateException {
        super.setMaxActiveClientCount(n);
    }

    NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
        if (connectorAddress == null) {
            throw new IllegalArgumentException("ConnectorAddress cannot be null");
        }
        if (!(connectorAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("ConnectorAddress must be an instance of GenericHttpConnectorAddress");
        }
        GenericHttpNotificationForwarder genericHttpNotificationForwarder = null;
        try {
            if (this.isDebugOn()) {
                this.debug("startPush", "Create new NotificationForwarder");
            }
            genericHttpNotificationForwarder = this.getNotificationForwarder((GenericHttpConnectorAddress)connectorAddress);
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
        if (this.isDebugOn()) {
            this.debug("startPush", "Start forwarding events");
        }
        genericHttpNotificationForwarder.connect();
        return genericHttpNotificationForwarder;
    }

    public void stop() {
        block2: {
            if (this.state != 0 && this.state != 3) break block2;
            super.stop();
            this.heartbeatServerHandler.cleanupClientResources();
            try {
                GenericHttpSocket genericHttpSocket = this.sockListen.createClientSocket();
                genericHttpSocket.doConnect(InetAddress.getLocalHost().getHostAddress(), this.port);
                genericHttpSocket.doSend("", null);
                genericHttpSocket.doDisconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    void stopPush(NotificationBackConnector notificationBackConnector) {
        if (!(notificationBackConnector instanceof GenericHttpNotificationForwarder)) {
            throw new IllegalArgumentException("NotificationBackConnector must be an instance of GenericHttpNotificationForwarder");
        }
        ((GenericHttpNotificationForwarder)notificationBackConnector).disconnect();
    }

    private class NotificationHandlerInternal
    implements ServerNotificationHandlerInternal {
        private GenericHttpConnectorServer connector;

        public NotificationHandlerInternal(GenericHttpConnectorServer genericHttpConnectorServer2) {
            this.connector = genericHttpConnectorServer2;
        }

        public NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
            return this.connector.startPush(connectorAddress);
        }

        public void stopPush(NotificationBackConnector notificationBackConnector) {
            this.connector.stopPush(notificationBackConnector);
        }
    }
}

