/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.manager.SendQ;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSendServer;
import javax.management.snmp.manager.SnmpTimerServer;
import javax.management.snmp.manager.WaitQ;

final class SnmpQManager
implements Serializable {
    static final long pollMargin = 900L;
    static String dbgTag = "SnmpQManager";
    private SendQ newq = new SendQ(20, 5);
    private WaitQ waitq = new WaitQ(20, 5);
    private static SnmpQManager theSnmpq = new SnmpQManager();
    private ThreadGroup queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
    private Thread requestQThread = null;
    private Thread timerQThread = null;
    private int nbSessions = 0;

    private SnmpQManager() {
        this.startQThreads();
    }

    public void addRequest(SnmpRequest snmpRequest) {
        this.newq.addRequest(snmpRequest);
    }

    public void addWaiting(SnmpRequest snmpRequest) {
        this.waitq.addWaiting(snmpRequest);
    }

    static void debug(String string, String string2) {
        SnmpQManager.debug(dbgTag, string, string2);
    }

    static void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    static void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    static void debug(String string, Throwable throwable) {
        SnmpQManager.debug(dbgTag, string, throwable);
    }

    synchronized void decNbSessions() {
        if (--this.nbSessions == 0) {
            ((SnmpTimerServer)this.timerQThread).isBeingDestroyed = true;
            this.waitq.isBeingDestroyed = true;
            ((SnmpSendServer)this.requestQThread).isBeingDestroyed = true;
            this.newq.isBeingDestroyed = true;
            this.stopQThreads();
        }
    }

    public void finalize() {
        this.queueThreadGroup.destroy();
    }

    public SnmpPduFactory findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactory snmpPduFactory = this.newq.findPduFactory(inetAddress, n);
        if (snmpPduFactory == null) {
            snmpPduFactory = this.waitq.findPduFactory(inetAddress, n);
        }
        return snmpPduFactory;
    }

    public Vector getAllOutstandingRequest(long l) {
        return this.newq.getAllOutstandingRequest(l);
    }

    public SnmpRequest getOutstandingRequest() {
        return this.newq.getOutstandingRequest();
    }

    public static synchronized SnmpQManager getTheInstance() {
        if (theSnmpq == null) {
            theSnmpq = new SnmpQManager();
        }
        return theSnmpq;
    }

    public SnmpRequest getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    synchronized void incNbSessions() {
        ++this.nbSessions;
    }

    static boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    static boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public String listQContents() {
        try {
            long l = System.currentTimeMillis();
            StringBuffer stringBuffer = new StringBuffer("******* Qdump begins ****\n");
            stringBuffer.append(String.valueOf(this.newq.printAllRequest(l)) + "\n");
            stringBuffer.append(String.valueOf(this.waitq.printAllRequest(l)) + "\n");
            stringBuffer.append("********* Qdump ends ***********\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            if (SnmpQManager.isDebugOn()) {
                SnmpQManager.debug("listQContents", exception);
            }
            return null;
        }
    }

    public SnmpRequest removeRequest(long l) {
        SnmpRequest snmpRequest = null;
        snmpRequest = this.newq.removeRequest(l);
        if (snmpRequest == null) {
            snmpRequest = this.waitq.removeRequest(l);
        }
        return snmpRequest;
    }

    public void removeRequest(SnmpRequest snmpRequest) {
        this.newq.removeElement(snmpRequest);
        this.waitq.removeElement(snmpRequest);
    }

    public void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public String statusReport() {
        return new String("Requests outstanding/waiting : " + this.newq.size() + "/" + this.waitq.size() + " Send/timer servers : " + this.requestQThread.isAlive() + "/" + this.timerQThread.isAlive());
    }

    public void stopQThreads() {
        if (this.timerQThread != null && this.timerQThread.isAlive()) {
            ((SnmpTimerServer)this.timerQThread).stopTimerServer();
        }
        this.waitq = null;
        this.timerQThread = null;
        if (this.requestQThread != null && this.requestQThread.isAlive()) {
            ((SnmpSendServer)this.requestQThread).stopSendServer();
        }
        this.newq = null;
        this.requestQThread = null;
        theSnmpq = null;
    }

    static void trace(String string, String string2) {
        SnmpQManager.trace(dbgTag, string, string2);
    }

    static void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

