/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryExpSupport;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryExpSupport {
    private AttributeValueExp exp;
    private String pattern;

    public MatchQueryExp() {
    }

    public MatchQueryExp(AttributeValueExp attributeValueExp, StringValueExp stringValueExp) {
        this.exp = attributeValueExp;
        this.pattern = stringValueExp.getValue();
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp.apply(objectName);
        if (!(valueExp instanceof StringValueExp)) {
            return false;
        }
        return MatchQueryExp.wildmatch(((StringValueExp)valueExp).getValue(), this.pattern);
    }

    public AttributeValueExp getAttribute() {
        return this.exp;
    }

    public String getPattern() {
        return this.pattern;
    }

    private static String likeTranslate(String string) {
        return string.replace('?', '_').replace('*', '%');
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.exp)) + " like " + new StringValueExp(MatchQueryExp.likeTranslate(this.pattern));
    }

    private static boolean wildmatch(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        while (n2 < n4) {
            char c;
            if ((c = string2.charAt(n2++)) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '[') {
                boolean bl = true;
                boolean bl2 = false;
                if (string2.charAt(n2) == '!') {
                    bl = false;
                    ++n2;
                }
                while (++n2 < n4 && (c = string2.charAt(n2)) != ']') {
                    if (string2.charAt(n2) == '-' && n2 + 1 < n4) {
                        if (string.charAt(n) >= c && string.charAt(n) <= string2.charAt(n2 + 1)) {
                            bl2 = true;
                        }
                        ++n2;
                        continue;
                    }
                    if (c != string.charAt(n)) continue;
                    bl2 = true;
                }
                if (n2 >= n4 || bl != bl2) {
                    return false;
                }
                ++n2;
                ++n;
                continue;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!MatchQueryExp.wildmatch(string.substring(n), string2.substring(n2))) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (!(c == '\\' ? n2 >= n4 || string2.charAt(n2++) != string.charAt(n++) : n >= n3 || c != string.charAt(n++))) continue;
            return false;
        }
        return n == n3;
    }
}

