/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpGenericMetaServer;
import com.sun.jdmk.snmp.agent.SnmpMibSubRequest;
import com.sun.jdmk.snmp.agent.SnmpMibTable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class SnmpGenericObjectServer {
    protected final MBeanServer server;

    public SnmpGenericObjectServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public void check(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Object object = snmpMibSubRequest.getUserData();
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            try {
                long l = snmpVarBind.oid.getOidArc(n);
                this.check(snmpGenericMetaServer, objectName, snmpVarBind.value, l, object);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
            }
        }
    }

    public void check(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        snmpGenericMetaServer.checkSetAccess(snmpValue, l, object);
        try {
            String string = snmpGenericMetaServer.getAttributeName(l);
            Object object2 = snmpGenericMetaServer.buildAttributeValue(l, snmpValue);
            Object[] objectArray = new Object[1];
            String[] stringArray = new String[1];
            objectArray[0] = object2;
            stringArray[0] = object2.getClass().getName();
            this.server.invoke(objectName, "check" + string, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new SnmpStatusException(18);
        }
        catch (ReflectionException reflectionException) {
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
    }

    public SnmpValue get(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, long l, Object object) throws SnmpStatusException {
        String string = snmpGenericMetaServer.getAttributeName(l);
        Object object2 = null;
        try {
            object2 = this.server.getAttribute(objectName, string);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(224);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(224);
        }
        return snmpGenericMetaServer.buildSnmpValue(l, object2);
    }

    public void get(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Cloneable cloneable;
        int n2 = snmpMibSubRequest.getSize();
        Object object = snmpMibSubRequest.getUserData();
        String[] stringArray = new String[n2];
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        long[] lArray = new long[n2];
        int n3 = 0;
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            cloneable = (SnmpVarBind)enumeration.nextElement();
            try {
                long l = ((SnmpVarBind)cloneable).oid.getOidArc(n);
                stringArray[n3] = snmpGenericMetaServer.getAttributeName(l);
                snmpVarBindArray[n3] = cloneable;
                lArray[n3] = l;
                snmpGenericMetaServer.checkGetAccess(l, object);
                ++n3;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerGetException((SnmpVarBind)cloneable, snmpStatusException);
            }
        }
        cloneable = null;
        int n4 = 224;
        try {
            cloneable = this.server.getAttributes(objectName, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            cloneable = new AttributeList();
        }
        catch (ReflectionException reflectionException) {
            cloneable = new AttributeList();
        }
        catch (Exception exception) {
            cloneable = new AttributeList();
        }
        Iterator iterator = ((AbstractList)((Object)cloneable)).iterator();
        int n5 = 0;
        while (n5 < n3) {
            Serializable serializable;
            if (!iterator.hasNext()) {
                serializable = new SnmpStatusException(n4);
                snmpMibSubRequest.registerGetException(snmpVarBindArray[n5], (SnmpStatusException)serializable);
            } else {
                serializable = (Attribute)iterator.next();
                while (n5 < n3 && !stringArray[n5].equals(((Attribute)serializable).getName())) {
                    SnmpStatusException snmpStatusException = new SnmpStatusException(n4);
                    snmpMibSubRequest.registerGetException(snmpVarBindArray[n5], snmpStatusException);
                    ++n5;
                }
                if (n5 == n3) break;
                try {
                    snmpVarBindArray[n5].value = snmpGenericMetaServer.buildSnmpValue(lArray[n5], ((Attribute)serializable).getValue());
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpMibSubRequest.registerGetException(snmpVarBindArray[n5], snmpStatusException);
                }
            }
            ++n5;
        }
    }

    public void registerTableEntry(SnmpMibTable snmpMibTable, SnmpOid snmpOid, ObjectName objectName, Object object) throws SnmpStatusException {
        if (objectName == null) {
            throw new SnmpStatusException(18);
        }
        try {
            if (object != null && !this.server.isRegistered(objectName)) {
                this.server.registerMBean(object, objectName);
            }
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new SnmpStatusException(18);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new SnmpStatusException(6);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new SnmpStatusException(5);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new SnmpStatusException(5);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(5);
        }
    }

    public void set(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Serializable serializable;
        Object object;
        Cloneable cloneable;
        int n2 = snmpMibSubRequest.getSize();
        AttributeList attributeList = new AttributeList(n2);
        String[] stringArray = new String[n2];
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        long[] lArray = new long[n2];
        int n3 = 0;
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            cloneable = (SnmpVarBind)enumeration.nextElement();
            try {
                long l = cloneable.oid.getOidArc(n);
                String string = snmpGenericMetaServer.getAttributeName(l);
                object = snmpGenericMetaServer.buildAttributeValue(l, cloneable.value);
                serializable = new Attribute(string, object);
                attributeList.add((Attribute)serializable);
                stringArray[n3] = string;
                snmpVarBindArray[n3] = cloneable;
                lArray[n3] = l;
                ++n3;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerSetException((SnmpVarBind)cloneable, snmpStatusException);
            }
        }
        cloneable = null;
        int n4 = 6;
        try {
            cloneable = this.server.setAttributes(objectName, attributeList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            cloneable = new AttributeList();
            n4 = 18;
        }
        catch (ReflectionException reflectionException) {
            n4 = 18;
            cloneable = new AttributeList();
        }
        catch (Exception exception) {
            cloneable = new AttributeList();
        }
        Iterator iterator = ((AbstractList)((Object)cloneable)).iterator();
        int n5 = 0;
        while (n5 < n3) {
            if (!iterator.hasNext()) {
                object = new SnmpStatusException(n4);
                snmpMibSubRequest.registerSetException(snmpVarBindArray[n5], (SnmpStatusException)object);
            } else {
                object = (Attribute)iterator.next();
                while (n5 < n3 && !stringArray[n5].equals(((Attribute)object).getName())) {
                    serializable = new SnmpStatusException(6);
                    snmpMibSubRequest.registerSetException(snmpVarBindArray[n5], (SnmpStatusException)serializable);
                    ++n5;
                }
                if (n5 == n3) break;
                try {
                    snmpVarBindArray[n5].value = snmpGenericMetaServer.buildSnmpValue(lArray[n5], ((Attribute)object).getValue());
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpMibSubRequest.registerSetException(snmpVarBindArray[n5], snmpStatusException);
                }
            }
            ++n5;
        }
    }

    public SnmpValue set(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        String string = snmpGenericMetaServer.getAttributeName(l);
        Object object2 = snmpGenericMetaServer.buildAttributeValue(l, snmpValue);
        Attribute attribute = new Attribute(string, object2);
        Object object3 = null;
        try {
            this.server.setAttribute(objectName, attribute);
            object3 = this.server.getAttribute(objectName, string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new SnmpStatusException(10);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new SnmpStatusException(18);
        }
        catch (ReflectionException reflectionException) {
            throw new SnmpStatusException(18);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
        return snmpGenericMetaServer.buildSnmpValue(l, object3);
    }
}

