/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.IPAcl;

import com.sun.jdmk.Trace;
import com.sun.jdmk.snmp.IPAcl.AclEntryImpl;
import com.sun.jdmk.snmp.IPAcl.AclImpl;
import com.sun.jdmk.snmp.IPAcl.JDMAccess;
import com.sun.jdmk.snmp.IPAcl.JDMAclItem;
import com.sun.jdmk.snmp.IPAcl.JDMCommunities;
import com.sun.jdmk.snmp.IPAcl.JDMHost;
import com.sun.jdmk.snmp.IPAcl.JDMHostInform;
import com.sun.jdmk.snmp.IPAcl.JDMHostTrap;
import com.sun.jdmk.snmp.IPAcl.JDMInformCommunity;
import com.sun.jdmk.snmp.IPAcl.JDMInformInterestedHost;
import com.sun.jdmk.snmp.IPAcl.JDMInformItem;
import com.sun.jdmk.snmp.IPAcl.JDMManagers;
import com.sun.jdmk.snmp.IPAcl.JDMTrapCommunity;
import com.sun.jdmk.snmp.IPAcl.JDMTrapInterestedHost;
import com.sun.jdmk.snmp.IPAcl.JDMTrapItem;
import com.sun.jdmk.snmp.IPAcl.Parser;
import com.sun.jdmk.snmp.IPAcl.PrincipalImpl;
import com.sun.jdmk.snmp.IPAcl.SimpleNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.util.Hashtable;
import java.util.Vector;

abstract class Host
extends SimpleNode
implements Serializable {
    String dbgTag = "Host";

    public Host(int n) {
        super(n);
    }

    public Host(Parser parser, int n) {
        super(parser, n);
    }

    public void buildAclEntries(PrincipalImpl principalImpl, AclImpl aclImpl) {
        PrincipalImpl principalImpl2 = null;
        try {
            principalImpl2 = this.createAssociatedPrincipal();
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildAclEntries", "Cannot create ACL entry for " + unknownHostException.getMessage());
            }
            return;
        }
        AclEntryImpl aclEntryImpl = null;
        try {
            aclEntryImpl = new AclEntryImpl(principalImpl2);
            this.registerPermission(aclEntryImpl);
            aclImpl.addEntry(principalImpl, aclEntryImpl);
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildAclEntries", "Cannot create ACL entry for " + unknownHostException.getMessage());
            }
            return;
        }
        catch (NotOwnerException notOwnerException) {
            if (this.isDebugOn()) {
                this.debug("buildAclEntries", "Not owner of ACL " + notOwnerException.getMessage());
            }
            return;
        }
    }

    public void buildInformEntries(Hashtable hashtable) {
        JDMHostInform jDMHostInform = (JDMHostInform)this.jjtGetParent();
        JDMInformInterestedHost jDMInformInterestedHost = (JDMInformInterestedHost)jDMHostInform.jjtGetParent();
        JDMInformItem jDMInformItem = (JDMInformItem)jDMInformInterestedHost.jjtGetParent();
        JDMInformCommunity jDMInformCommunity = jDMInformItem.getCommunity();
        String string = jDMInformCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildInformEntries", "Cannot create INFORM entry for " + unknownHostException.getMessage());
            }
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }

    public void buildTrapEntries(Hashtable hashtable) {
        JDMHostTrap jDMHostTrap = (JDMHostTrap)this.jjtGetParent();
        JDMTrapInterestedHost jDMTrapInterestedHost = (JDMTrapInterestedHost)jDMHostTrap.jjtGetParent();
        JDMTrapItem jDMTrapItem = (JDMTrapItem)jDMTrapInterestedHost.jjtGetParent();
        JDMTrapCommunity jDMTrapCommunity = jDMTrapItem.getCommunity();
        String string = jDMTrapCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isDebugOn()) {
                this.debug("buildTrapEntries", "Cannot create TRAP entry for " + unknownHostException.getMessage());
            }
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }

    protected abstract PrincipalImpl createAssociatedPrincipal() throws UnknownHostException;

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    protected abstract String getHname();

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private void registerPermission(AclEntryImpl aclEntryImpl) {
        JDMHost jDMHost = (JDMHost)this.jjtGetParent();
        JDMManagers jDMManagers = (JDMManagers)jDMHost.jjtGetParent();
        JDMAclItem jDMAclItem = (JDMAclItem)jDMManagers.jjtGetParent();
        JDMAccess jDMAccess = jDMAclItem.getAccess();
        jDMAccess.putPermission(aclEntryImpl);
        JDMCommunities jDMCommunities = jDMAclItem.getCommunities();
        jDMCommunities.buildCommunities(aclEntryImpl);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

