/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpMibTree;
import com.sun.jdmk.comm.SnmpSubBulkRequestHandler;
import com.sun.jdmk.comm.SnmpSubNextRequestHandler;
import com.sun.jdmk.comm.SnmpSubRequestHandler;
import com.sun.jdmk.snmp.IPAcl.IPAcl;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpUserDataFactory;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;

class SnmpRequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable subs = null;
    private transient SnmpMibTree root;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public SnmpRequestHandler(SnmpAdaptorServer snmpAdaptorServer, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        super(snmpAdaptorServer, n, mBeanServer, objectName);
        this.socket = datagramSocket;
        this.packet = datagramPacket;
        this.root = snmpMibTree;
        this.mibs = (Vector)vector.clone();
        this.subs = new Hashtable(this.mibs.size());
        this.ipacl = object;
        this.pduFactory = snmpPduFactory;
        this.userDataFactory = snmpUserDataFactory;
        this.thread.start();
    }

    private SnmpPduPacket checkAcl(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = null;
        String string = new String(snmpPduPacket.community);
        if (this.ipacl != null) {
            if (snmpPduPacket.type == 163) {
                if (!((IPAcl)this.ipacl).checkWritePermission(snmpPduPacket.address, string)) {
                    if (this.isTraceOn()) {
                        this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                        this.trace("checkAcl", "sender has no write permission");
                    }
                    snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 4, 0);
                } else if (this.isTraceOn()) {
                    this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                    this.trace("checkAcl", "sender has write permission");
                }
            } else if (!((IPAcl)this.ipacl).checkReadPermission(snmpPduPacket.address, string)) {
                if (this.isTraceOn()) {
                    this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                    this.trace("checkAcl", "sender has no read permission");
                }
                snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 2, 0);
            } else if (this.isTraceOn()) {
                this.trace("checkAcl", "sender is " + snmpPduPacket.address + " with " + string);
                this.trace("checkAcl", "sender has read permission");
            }
        }
        if (snmpPduRequest != null) {
            SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
            snmpAdaptorServer.incSnmpInBadCommunityUses(1);
            if (!((IPAcl)this.ipacl).checkCommunity(string)) {
                snmpAdaptorServer.incSnmpInBadCommunityNames(1);
            }
        }
        return snmpPduRequest;
    }

    private boolean checkPduType(SnmpPduPacket snmpPduPacket) {
        boolean bl = true;
        switch (snmpPduPacket.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                bl = true;
                break;
            }
            default: {
                if (this.isDebugOn()) {
                    this.debug("checkPduType", "cannot respond to this kind of PDU");
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send(2, 1024, string, string2, string3);
    }

    protected void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 1024, string, string2, throwable);
    }

    protected void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    public void doRun() {
        block8: {
            if (this.isTraceOn()) {
                this.trace("doRun", "Packet received:\n" + SnmpMessage.dumpHexBuffer(this.packet.getData(), 0, this.packet.getLength()));
            }
            DatagramPacket datagramPacket = this.makeResponsePacket(this.packet);
            if (this.isTraceOn() && datagramPacket != null) {
                this.trace("doRun", "Packet to be sent:\n" + SnmpMessage.dumpHexBuffer(datagramPacket.getData(), 0, datagramPacket.getLength()));
            }
            if (datagramPacket == null) break block8;
            try {
                this.socket.send(datagramPacket);
            }
            catch (SocketException socketException) {
                if (!this.isDebugOn()) break block8;
                if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                    this.debug("doRun", "interrupted");
                    break block8;
                }
                this.debug("doRun", "i/o exception");
                this.debug("doRun", socketException);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isDebugOn()) {
                    this.debug("doRun", "interrupted");
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block8;
                this.debug("doRun", "failure when sending response");
                this.debug("doRun", exception);
            }
        }
    }

    private SnmpPduPacket executeSubRequest(SnmpPduPacket snmpPduPacket, Object object) {
        SnmpSubRequestHandler snmpSubRequestHandler;
        Enumeration enumeration;
        Enumeration enumeration2;
        int n;
        int n2 = 0;
        int n3 = this.subs.size();
        Thread[] threadArray = new Thread[n3];
        if (snmpPduPacket.type == 163) {
            n = 0;
            enumeration2 = this.subs.elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = (SnmpSubRequestHandler)enumeration2.nextElement();
                ((SnmpSubRequestHandler)((Object)enumeration)).setUserData(object);
                ((SnmpSubRequestHandler)((Object)enumeration)).type = 253;
                threadArray[n] = new Thread((Runnable)((Object)enumeration));
                threadArray[n].start();
                ++n;
            }
            n = 0;
            enumeration = this.subs.elements();
            while (enumeration.hasMoreElements()) {
                block12: {
                    try {
                        threadArray[n].join();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.isDebugOn()) break block12;
                        this.debug("executeSubRequest", interruptedException);
                    }
                }
                snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
                snmpSubRequestHandler.type = 163;
                n2 = snmpSubRequestHandler.getErrorStatus();
                if (n2 != 0) {
                    return this.newErrorResponsePdu(snmpPduPacket, n2, snmpSubRequestHandler.getErrorIndex() + 1);
                }
                ++n;
            }
        }
        n = 0;
        enumeration2 = this.subs.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = (SnmpSubRequestHandler)enumeration2.nextElement();
            ((SnmpSubRequestHandler)((Object)enumeration)).setUserData(object);
            threadArray[n] = new Thread((Runnable)((Object)enumeration));
            threadArray[n].start();
            ++n;
        }
        n = 0;
        enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            block13: {
                try {
                    threadArray[n].join();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.isDebugOn()) break block13;
                    this.debug("executeSubRequest", interruptedException);
                }
            }
            snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            n2 = snmpSubRequestHandler.getErrorStatus();
            if (n2 != 0) {
                if (this.isDebugOn()) {
                    this.debug("executeSubRequest", "an error occurs");
                }
                int n4 = snmpSubRequestHandler.getErrorIndex() + 1;
                return this.newErrorResponsePdu(snmpPduPacket, n2, n4);
            }
            ++n;
        }
        return null;
    }

    protected boolean isDebugOn() {
        return Trace.isSelected(2, 1024);
    }

    protected boolean isTraceOn() {
        return Trace.isSelected(1, 1024);
    }

    protected String makeDebugTag() {
        return "SnmpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    SnmpPduPacket makeErrorVarbindPdu(SnmpPduPacket snmpPduPacket, int n) {
        SnmpVarBind[] snmpVarBindArray = snmpPduPacket.varBindList;
        int n2 = snmpVarBindArray.length;
        switch (n) {
            case 130: {
                int n3 = 0;
                while (n3 < n2) {
                    snmpVarBindArray[n3].value = SnmpVarBind.endOfMibView;
                    ++n3;
                }
                break;
            }
            case 128: {
                int n4 = 0;
                while (n4 < n2) {
                    snmpVarBindArray[n4].value = SnmpVarBind.noSuchObject;
                    ++n4;
                }
                break;
            }
            case 129: {
                int n5 = 0;
                while (n5 < n2) {
                    snmpVarBindArray[n5].value = SnmpVarBind.noSuchInstance;
                    ++n5;
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(snmpPduPacket, 5, 1);
            }
        }
        return this.newValidResponsePdu(snmpPduPacket, snmpVarBindArray);
    }

    private SnmpPduPacket makeGetBulkResponsePdu(SnmpPduBulk snmpPduBulk, Object object) {
        SnmpVarBind[] snmpVarBindArray = null;
        int n = snmpPduBulk.varBindList.length;
        int n2 = Math.max(Math.min(snmpPduBulk.nonRepeaters, n), 0);
        int n3 = Math.max(snmpPduBulk.maxRepetitions, 0);
        int n4 = n - n2;
        if (snmpPduBulk.varBindList == null) {
            return this.newValidResponsePdu(snmpPduBulk, null);
        }
        this.splitBulkRequest(snmpPduBulk, n2, n3, n4);
        SnmpPduPacket snmpPduPacket = this.executeSubRequest(snmpPduBulk, object);
        if (snmpPduPacket != null) {
            return snmpPduPacket;
        }
        snmpVarBindArray = this.mergeBulkResponses(n2 + n3 * n4);
        int n5 = snmpVarBindArray.length;
        while (n5 > n2 && snmpVarBindArray[n5 - 1].value.equals(SnmpVarBind.endOfMibView)) {
            --n5;
        }
        int n6 = n5 == n2 ? n2 + n4 : n2 + ((n5 - 1 - n2) / n4 + 2) * n4;
        if (n6 < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray2 = new SnmpVarBind[n6];
            int n7 = 0;
            while (n7 < n6) {
                snmpVarBindArray2[n7] = snmpVarBindArray[n7];
                ++n7;
            }
            snmpVarBindArray = snmpVarBindArray2;
        }
        return this.newValidResponsePdu(snmpPduBulk, snmpVarBindArray);
    }

    private SnmpPduPacket makeGetSetResponsePdu(SnmpPduRequest snmpPduRequest, Object object) {
        if (snmpPduRequest.varBindList == null) {
            return this.newValidResponsePdu(snmpPduRequest, null);
        }
        this.splitRequest(snmpPduRequest);
        int n = this.subs.size();
        if (n == 1) {
            return this.turboProcessingGetSet(snmpPduRequest, object);
        }
        SnmpPduPacket snmpPduPacket = this.executeSubRequest(snmpPduRequest, object);
        if (snmpPduPacket != null) {
            return snmpPduPacket;
        }
        if (this.isTraceOn()) {
            this.trace("makeGetSetResponsePdu", "Build the unified response for request " + snmpPduRequest.requestId);
        }
        return this.mergeResponses(snmpPduRequest);
    }

    SnmpPduPacket makeNoMibErrorPdu(SnmpPduRequest snmpPduRequest, Object object) {
        if (snmpPduRequest.version == 0) {
            return this.newErrorResponsePdu(snmpPduRequest, 2, 1);
        }
        if (snmpPduRequest.version == 1) {
            switch (snmpPduRequest.type) {
                case 163: 
                case 253: {
                    return this.newErrorResponsePdu(snmpPduRequest, 6, 1);
                }
                case 160: {
                    return this.makeErrorVarbindPdu(snmpPduRequest, 128);
                }
                case 161: 
                case 165: {
                    return this.makeErrorVarbindPdu(snmpPduRequest, 130);
                }
            }
        }
        return this.newErrorResponsePdu(snmpPduRequest, 5, 1);
    }

    private SnmpMessage makeResponseMessage(SnmpMessage snmpMessage) {
        SnmpMessage snmpMessage2;
        block28: {
            Object object;
            SnmpPduPacket snmpPduPacket;
            block27: {
                snmpMessage2 = null;
                snmpPduPacket = null;
                object = null;
                try {
                    snmpPduPacket = this.pduFactory.decodePdu(snmpMessage);
                    if (snmpPduPacket != null && this.userDataFactory != null) {
                        object = this.userDataFactory.allocateUserData(snmpPduPacket);
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpPduPacket = null;
                    SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
                    snmpAdaptorServer.incSnmpInASNParseErrs(1);
                    if (snmpStatusException.getStatus() == 243) {
                        snmpAdaptorServer.incSnmpInBadVersions(1);
                    }
                    if (!this.isDebugOn()) break block27;
                    this.debug("makeResponseMessage", "message decoding failed");
                }
            }
            SnmpPduPacket snmpPduPacket2 = null;
            if (snmpPduPacket != null) {
                snmpPduPacket2 = this.makeResponsePdu(snmpPduPacket, object);
                try {
                    if (this.userDataFactory != null) {
                        this.userDataFactory.releaseUserData(object, snmpPduPacket2);
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpPduPacket2 = null;
                }
            }
            if (snmpPduPacket2 == null) break block28;
            try {
                snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMessage2 = null;
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "response message is too big");
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw snmpTooBigException;
                    }
                    int n = snmpTooBigException.getVarBindCount();
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "fail on element" + n);
                    }
                    int n2 = 0;
                    while (true) {
                        try {
                            snmpPduPacket2 = this.reduceResponsePdu(snmpPduPacket, snmpPduPacket2, n);
                            snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException snmpTooBigException2) {
                            if (this.isDebugOn()) {
                                this.debug("makeResponseMessage", "response message is still too big");
                            }
                            n2 = n;
                            n = snmpTooBigException2.getVarBindCount();
                            if (!this.isDebugOn()) continue;
                            this.debug("makeResponseMessage", "fail on element" + n);
                            if (n != n2) continue;
                            throw snmpTooBigException2;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpMessage2 = null;
                    if (!this.isDebugOn()) break block28;
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    try {
                        snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                        snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException snmpTooBigException4) {
                        snmpMessage2 = null;
                        if (this.isDebugOn()) {
                            this.debug("makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                    }
                    catch (Exception exception) {
                        snmpMessage2 = null;
                    }
                }
                catch (Exception exception) {
                    snmpMessage2 = null;
                }
            }
        }
        return snmpMessage2;
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket) {
        DatagramPacket datagramPacket2;
        block9: {
            datagramPacket2 = null;
            SnmpMessage snmpMessage = new SnmpMessage();
            try {
                snmpMessage.decodeMessage(datagramPacket.getData(), datagramPacket.getLength());
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "packet decoding failed");
                }
                snmpMessage = null;
                ((SnmpAdaptorServer)this.adaptorServer).incSnmpInASNParseErrs(1);
            }
            SnmpMessage snmpMessage2 = null;
            if (snmpMessage != null) {
                snmpMessage2 = this.makeResponseMessage(snmpMessage);
            }
            if (snmpMessage2 == null) break block9;
            try {
                datagramPacket.setLength(snmpMessage2.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    snmpMessage2 = this.newTooBigMessage(snmpMessage);
                    datagramPacket.setLength(snmpMessage2.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (!this.isDebugOn()) break block9;
                    this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                }
            }
        }
        return datagramPacket2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SnmpPduPacket makeResponsePdu(SnmpPduPacket snmpPduPacket, Object object) {
        SnmpAdaptorServer snmpAdaptorServer = (SnmpAdaptorServer)this.adaptorServer;
        SnmpPduPacket snmpPduPacket2 = null;
        snmpAdaptorServer.updateRequestCounters(snmpPduPacket.type);
        if (snmpPduPacket.varBindList != null) {
            snmpAdaptorServer.updateVarCounters(snmpPduPacket.type, snmpPduPacket.varBindList.length);
        }
        if (!this.checkPduType(snmpPduPacket)) return snmpPduPacket2;
        snmpPduPacket2 = this.checkAcl(snmpPduPacket);
        if (snmpPduPacket2 == null) {
            if (this.mibs.size() < 1) {
                if (!this.isTraceOn()) return this.makeNoMibErrorPdu((SnmpPduRequest)snmpPduPacket, object);
                this.trace("makeResponsePdu", "Request " + snmpPduPacket.requestId + " received but no MIB registered.");
                return this.makeNoMibErrorPdu((SnmpPduRequest)snmpPduPacket, object);
            }
            switch (snmpPduPacket.type) {
                case 160: 
                case 161: 
                case 163: {
                    return this.makeGetSetResponsePdu((SnmpPduRequest)snmpPduPacket, object);
                }
                case 165: {
                    return this.makeGetBulkResponsePdu((SnmpPduBulk)snmpPduPacket, object);
                }
                default: {
                    return snmpPduPacket2;
                }
            }
        }
        if (!snmpAdaptorServer.getAuthRespEnabled()) {
            snmpPduPacket2 = null;
        }
        if (!snmpAdaptorServer.getAuthTrapEnabled()) return snmpPduPacket2;
        try {
            snmpAdaptorServer.snmpV1Trap(4, 0, new SnmpVarBindList());
            return snmpPduPacket2;
        }
        catch (Exception exception) {
            if (!this.isDebugOn()) return snmpPduPacket2;
            this.debug("makeResponsePdu", "failure when sending authentication trap");
            this.debug("makeResponsePdu", exception);
        }
        return snmpPduPacket2;
    }

    private SnmpVarBind[] mergeBulkResponses(int n) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            snmpVarBindArray[n2] = new SnmpVarBind();
            snmpVarBindArray[n2].value = SnmpVarBind.endOfMibView;
            --n2;
        }
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return snmpVarBindArray;
    }

    private SnmpPduPacket mergeNextResponses(SnmpPduRequest snmpPduRequest) {
        int n = snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        if (snmpPduRequest.version == 1) {
            return this.newValidResponsePdu(snmpPduRequest, snmpVarBindArray);
        }
        int n2 = 0;
        while (n2 < n) {
            SnmpValue snmpValue = snmpVarBindArray[n2].value;
            if (snmpValue == SnmpVarBind.endOfMibView) {
                return this.newErrorResponsePdu(snmpPduRequest, 2, n2 + 1);
            }
            ++n2;
        }
        return this.newValidResponsePdu(snmpPduRequest, snmpVarBindArray);
    }

    private SnmpPduPacket mergeResponses(SnmpPduRequest snmpPduRequest) {
        if (snmpPduRequest.type == 161) {
            return this.mergeNextResponses(snmpPduRequest);
        }
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return this.newValidResponsePdu(snmpPduRequest, snmpVarBindArray);
    }

    private SnmpPduRequest newErrorResponsePdu(SnmpPduPacket snmpPduPacket, int n, int n2) {
        SnmpPduRequest snmpPduRequest = this.newValidResponsePdu(snmpPduPacket, null);
        snmpPduRequest.errorStatus = n;
        snmpPduRequest.errorIndex = n2;
        snmpPduRequest.varBindList = snmpPduPacket.varBindList;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(snmpPduRequest.errorStatus);
        return snmpPduRequest;
    }

    private SnmpMessage newTooBigMessage(SnmpMessage snmpMessage) throws SnmpTooBigException {
        SnmpMessage snmpMessage2 = null;
        SnmpPduPacket snmpPduPacket = null;
        try {
            snmpPduPacket = this.pduFactory.decodePdu(snmpMessage);
            if (snmpPduPacket != null) {
                SnmpPduPacket snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            throw new InternalError();
        }
        return snmpMessage2;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 1, 0);
        snmpPduRequest.varBindList = null;
        return snmpPduRequest;
    }

    private SnmpPduRequest newValidResponsePdu(SnmpPduPacket snmpPduPacket, SnmpVarBind[] snmpVarBindArray) {
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = snmpPduPacket.address;
        snmpPduRequest.port = snmpPduPacket.port;
        snmpPduRequest.version = snmpPduPacket.version;
        snmpPduRequest.community = snmpPduPacket.community;
        snmpPduRequest.type = 162;
        snmpPduRequest.requestId = snmpPduPacket.requestId;
        snmpPduRequest.errorStatus = 0;
        snmpPduRequest.errorIndex = 0;
        snmpPduRequest.varBindList = snmpVarBindArray;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(snmpPduRequest.errorStatus);
        return snmpPduRequest;
    }

    private SnmpPduPacket reduceResponsePdu(SnmpPduPacket snmpPduPacket, SnmpPduPacket snmpPduPacket2, int n) throws SnmpTooBigException {
        if (snmpPduPacket.type != 165) {
            if (this.isDebugOn()) {
                this.debug("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        int n2 = snmpPduPacket2.varBindList.length;
        n2 = n >= 3 ? Math.min(n - 1, snmpPduPacket2.varBindList.length) : (n == 1 ? 1 : snmpPduPacket2.varBindList.length / 2);
        if (n2 < 1) {
            if (this.isDebugOn()) {
                this.debug("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        int n3 = 0;
        while (n3 < n2) {
            snmpVarBindArray[n3] = snmpPduPacket2.varBindList[n3];
            ++n3;
        }
        if (this.isDebugOn()) {
            this.debug("reduceResponsePdu", String.valueOf(snmpPduPacket2.varBindList.length - snmpVarBindArray.length) + " items have been removed");
        }
        snmpPduPacket2.varBindList = snmpVarBindArray;
        return snmpPduPacket2;
    }

    private void splitBulkRequest(SnmpPduBulk snmpPduBulk, int n, int n2, int n3) {
        SnmpSubBulkRequestHandler snmpSubBulkRequestHandler;
        int n4 = this.mibs.size();
        SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.mibs.firstElement();
        if (n4 == 1) {
            this.subs.put(snmpMibAgent, new SnmpSubBulkRequestHandler(snmpMibAgent, snmpPduBulk, n, n2, n3, true));
            return;
        }
        int n5 = snmpPduBulk.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduBulk.varBindList;
        int n6 = 0;
        while (n6 < n) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n6].oid);
            snmpSubBulkRequestHandler = (SnmpSubBulkRequestHandler)this.subs.get(snmpMibAgent);
            if (snmpSubBulkRequestHandler == null) {
                snmpSubBulkRequestHandler = new SnmpSubBulkRequestHandler(snmpMibAgent, snmpPduBulk, n2, n3);
                this.subs.put(snmpMibAgent, snmpSubBulkRequestHandler);
            }
            snmpSubBulkRequestHandler.updateRequestNonRepeater(snmpVarBindArray[n6], n6);
            ++n6;
        }
        if (n2 == 0) {
            return;
        }
        int n7 = n;
        while (n7 < n5) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n7].oid);
            snmpSubBulkRequestHandler = (SnmpSubBulkRequestHandler)this.subs.get(snmpMibAgent);
            if (snmpSubBulkRequestHandler == null) {
                snmpSubBulkRequestHandler = new SnmpSubBulkRequestHandler(snmpMibAgent, snmpPduBulk, n2, n3);
                this.subs.put(snmpMibAgent, snmpSubBulkRequestHandler);
            }
            snmpSubBulkRequestHandler.updateRequest(snmpVarBindArray[n7], n7);
            ++n7;
        }
    }

    private void splitRequest(SnmpPduRequest snmpPduRequest) {
        int n = this.mibs.size();
        SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.mibs.firstElement();
        if (n == 1) {
            this.subs.put(snmpMibAgent, new SnmpSubRequestHandler(snmpMibAgent, snmpPduRequest, true));
            return;
        }
        if (snmpPduRequest.type == 161) {
            Enumeration enumeration = this.mibs.elements();
            while (enumeration.hasMoreElements()) {
                SnmpMibAgent snmpMibAgent2 = (SnmpMibAgent)enumeration.nextElement();
                this.subs.put(snmpMibAgent2, new SnmpSubNextRequestHandler(snmpMibAgent2, snmpPduRequest));
            }
            return;
        }
        int n2 = snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        int n3 = 0;
        while (n3 < n2) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n3].oid);
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.get(snmpMibAgent);
            if (snmpSubRequestHandler == null) {
                snmpSubRequestHandler = new SnmpSubRequestHandler(snmpMibAgent, snmpPduRequest);
                this.subs.put(snmpMibAgent, snmpSubRequestHandler);
            }
            snmpSubRequestHandler.updateRequest(snmpVarBindArray[n3], n3);
            ++n3;
        }
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send(1, 1024, string, string2, string3);
    }

    private SnmpPduPacket turboProcessingGetSet(SnmpPduRequest snmpPduRequest, Object object) {
        int n = 0;
        SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.elements().nextElement();
        snmpSubRequestHandler.setUserData(object);
        if (snmpPduRequest.type == 163) {
            snmpSubRequestHandler.type = 253;
            snmpSubRequestHandler.run();
            snmpSubRequestHandler.type = 163;
            n = snmpSubRequestHandler.getErrorStatus();
            if (n != 0) {
                return this.newErrorResponsePdu(snmpPduRequest, n, snmpSubRequestHandler.getErrorIndex() + 1);
            }
        }
        snmpSubRequestHandler.run();
        n = snmpSubRequestHandler.getErrorStatus();
        if (n != 0) {
            if (this.isDebugOn()) {
                this.debug("turboProcessingGetSet", "an error occurs");
            }
            int n2 = snmpSubRequestHandler.getErrorIndex() + 1;
            return this.newErrorResponsePdu(snmpPduRequest, n, n2);
        }
        if (this.isTraceOn()) {
            this.trace("turboProcessingGetSet", "build the unified response for request " + snmpPduRequest.requestId);
        }
        return this.mergeResponses(snmpPduRequest);
    }
}

