/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.cascading;

import com.sun.jdmk.GenericProxy;
import com.sun.jdmk.Trace;
import com.sun.jdmk.cascading.CascadeGenericProxy;
import com.sun.jdmk.cascading.CascadingAgentMBean;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatNotification;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ServiceNotFoundException;

public class CascadingAgent
implements Serializable,
NotificationListener,
MBeanRegistration,
CascadingAgentMBean,
NotificationFilter {
    private int timeout = 0;
    private boolean timeoutedSocket = false;
    private MBeanServer mserver = null;
    private ConnectorAddress address = new RmiConnectorAddress("localhost", 1099, "name=RmiConnectorServer");
    private String conClName = null;
    private transient boolean isActive = false;
    private transient boolean isStopping = false;
    private transient RemoteMBeanServer conClient = null;
    private transient Vector registeredRemoteObjs = new Vector();
    private transient QueryExp query = null;
    private transient ObjectName pattern = null;
    private String dbgTag = "CascadingAgent";
    private Object[] subAgentParams;
    private String[] subAgentSignature = null;

    public CascadingAgent() {
    }

    public CascadingAgent(ConnectorAddress connectorAddress) {
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string) {
        this.address = connectorAddress;
        this.conClName = string;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string, ObjectName objectName, QueryExp queryExp) {
        this.address = connectorAddress;
        this.conClName = string;
        this.pattern = objectName;
        this.query = queryExp;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string, ObjectName objectName, QueryExp queryExp, int n) throws IOException {
        this.address = connectorAddress;
        this.conClName = string;
        this.pattern = objectName;
        this.query = queryExp;
        this.timeoutedSocket = true;
        Object var6_6 = null;
        if (n <= 0) {
            System.out.println("timeout<=0");
            throw var6_6;
        }
        this.timeout = n;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, ObjectName objectName, QueryExp queryExp) {
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
        this.pattern = objectName;
        this.query = queryExp;
    }

    public static boolean containsProperties(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        String string3 = stringTokenizer.nextToken();
        vector.addElement(string3);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            vector.addElement(string3);
        }
        int n = 0;
        while (n < vector.size()) {
            if (string.indexOf(vector.elementAt(n).toString()) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 32, string, string2, string3);
    }

    private void debugex(String string, String string2, Throwable throwable) {
        Trace.send(2, 32, string, string2, throwable);
    }

    private void debugex(String string, Throwable throwable) {
        this.debugex(this.dbgTag, string, throwable);
    }

    private String findConnectorClientClassName(ConnectorAddress connectorAddress) {
        if (connectorAddress instanceof RmiConnectorAddress) {
            return "com.sun.jdmk.comm.RmiConnectorClient";
        }
        if (connectorAddress instanceof HttpConnectorAddress) {
            return "com.sun.jdmk.comm.HttpConnectorClient";
        }
        if (connectorAddress instanceof HttpsConnectorAddress) {
            return "com.sun.jdmk.comm.HttpsConnectorClient";
        }
        throw new IllegalArgumentException("The ConnectorAddress passed in parameter does not correspond to a JDMK ConnectorAddress implementation");
    }

    public ConnectorAddress getAddress() {
        return this.address;
    }

    public String getClientConnectorClassName() {
        if (this.conClName != null) {
            return this.conClName;
        }
        return "com.sun.jdmk.comm.RmiConnectorClient";
    }

    private Boolean getConnected() {
        boolean bl = this.conClient == null ? false : this.conClient.isConnected();
        return new Boolean(bl);
    }

    public Integer getNbOfRemoteMBeans() {
        return new Integer(this.registeredRemoteObjs.size());
    }

    public ObjectName getPattern() {
        return this.pattern;
    }

    public QueryExp getQuery() {
        return this.query;
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        return this.conClient;
    }

    public synchronized Set getRemoteMBeans() {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        ObjectInstance objectInstance = null;
        Enumeration enumeration = this.registeredRemoteObjs.elements();
        while (enumeration.hasMoreElements()) {
            block3: {
                try {
                    objectInstance = this.conClient.getObjectInstance((ObjectName)enumeration.nextElement());
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block3;
                    this.debug("getRemoteMBeans", "got exception: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    private void handleHeartbeatNotification(Notification notification) {
        if (!this.isStopping && notification.getType().equals("jdmk.connector.heartbeat.connection.lost")) {
            this.stop();
        }
    }

    private void handleLocalNotification(Notification notification) {
        block2: {
            ObjectName objectName;
            if (this.isStopping || !notification.getType().equals("JMX.mbean.unregistered") || !this.registeredRemoteObjs.contains(objectName = ((MBeanServerNotification)notification).getMBeanName())) break block2;
            try {
                this.conClient.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block2;
                this.debug("handleLocalNotification", "Could not unregister object  " + objectName + " " + exception.getMessage());
            }
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (object == null) {
            if (notification instanceof HeartBeatNotification) {
                this.handleHeartbeatNotification(notification);
            } else {
                this.handleRemoteNotification(notification);
            }
        } else {
            this.handleLocalNotification(notification);
        }
    }

    private void handleRemoteNotification(Notification notification) {
        block10: {
            ObjectName objectName;
            block11: {
                objectName = ((MBeanServerNotification)notification).getMBeanName();
                if (this.pattern != null) {
                    String string = this.pattern.getDomain().equals("") ? this.conClient.getDefaultDomain() : this.pattern.getDomain();
                    if (!this.wildmatch(objectName.getDomain(), string) || !this.pattern.getCanonicalKeyPropertyListString().equals("") && !CascadingAgent.containsProperties(objectName.getCanonicalKeyPropertyListString(), this.pattern.getCanonicalKeyPropertyListString())) {
                        return;
                    }
                }
                if (!notification.getType().equals("JMX.mbean.registered")) break block11;
                try {
                    HashSet hashSet = (HashSet)this.conClient.queryNames(objectName, this.query);
                    if (hashSet.size() != 1) break block10;
                    Object var5_7 = null;
                    ObjectInstance objectInstance = null;
                    GenericProxy genericProxy = null;
                    try {
                        objectInstance = this.conClient.getObjectInstance(objectName);
                        genericProxy = new GenericProxy(objectInstance, this.conClient);
                        this.register(new CascadeGenericProxy(genericProxy), objectName);
                        break block10;
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                        if (this.isActive && this.isDebugOn()) {
                            this.debug("handleRemoteNotification", "Could not get GenericProxy for object " + objectName + " " + instanceAlreadyExistsException.getMessage());
                        }
                        break block10;
                    }
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block10;
                    this.debug("handleRemoteNotification", "Could not get GenericProxy for object " + objectName + " " + exception.getMessage());
                }
                break block10;
            }
            if (!notification.getType().equals("JMX.mbean.unregistered")) break block10;
            try {
                if (this.isTraceOn()) {
                    this.trace("handleRemoteNotification", "Remove deleted MBean " + objectName);
                }
                this.unregister(objectName);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block10;
                this.debug("handleRemoteNotification", "Could not unregister object  " + objectName + " " + exception.getMessage());
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 32);
    }

    public boolean isNotificationEnabled(Notification notification) {
        ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
        return this.registeredRemoteObjs.contains(objectName);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 32);
    }

    private void loadRemoteObjects(ObjectName objectName, QueryExp queryExp) throws ServiceNotFoundException, CommunicationException, IllegalAccessException {
        HashSet hashSet = null;
        hashSet = (HashSet)this.conClient.queryMBeans(objectName, queryExp);
        if (this.isDebugOn()) {
            this.debug("loadRemoteObjects", "Found " + hashSet.size() + " names");
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            CascadeGenericProxy cascadeGenericProxy;
            GenericProxy genericProxy;
            ObjectInstance objectInstance;
            block9: {
                objectInstance = (ObjectInstance)iterator.next();
                genericProxy = null;
                cascadeGenericProxy = null;
                try {
                    genericProxy = new GenericProxy(objectInstance, this.conClient);
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block9;
                    this.debug("loadRemoteObjects", "Could not get GenericProxy for object " + objectInstance + " " + exception.getMessage());
                }
            }
            if (cascadeGenericProxy == null) {
                cascadeGenericProxy = new CascadeGenericProxy(genericProxy);
            }
            if (objectInstance.getObjectName().getDomain().equals("JMImplementation")) continue;
            try {
                this.register(cascadeGenericProxy, objectInstance.getObjectName());
                if (!this.isTraceOn()) continue;
                this.trace("loadRemoteObjects", "Proxy MBean " + objectInstance.getObjectName() + " has been registered");
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (!this.isActive || !this.isDebugOn()) continue;
                this.debugex("loadRemoteObjects", instanceAlreadyExistsException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (!this.isDebugOn()) continue;
                this.debugex("loadRemoteObjects", mBeanRegistrationException);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (!this.isDebugOn()) continue;
                this.debugex("loadRemoteObjects", notCompliantMBeanException);
            }
        }
    }

    public void postDeregister() {
        block2: {
            try {
                this.stop();
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block2;
                this.debugex("postDeregister", exception);
            }
        }
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mserver = mBeanServer;
        if (this.conClient == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.getClientConnectorClassName());
                if (this.subAgentSignature == null) {
                    this.conClient = (RemoteMBeanServer)clazz.newInstance();
                } else {
                    Class[] classArray = new Class[this.subAgentSignature.length];
                    int n = 0;
                    while (n < this.subAgentSignature.length) {
                        classArray[n] = Class.forName(this.subAgentSignature[n]);
                        ++n;
                    }
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    this.conClient = (RemoteMBeanServer)constructor.newInstance(this.subAgentParams);
                }
                if (this.timeoutedSocket && this.conClient instanceof RmiConnectorClient) {
                    ((RmiConnectorClient)this.conClient).setTimeout(this.timeout);
                }
            }
            catch (Exception exception) {
                throw new ServiceNotFoundException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
        }
        return objectName;
    }

    private synchronized void register(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.mserver.registerMBean(object, objectName);
        this.registeredRemoteObjs.addElement(objectName);
    }

    public void setAddress(ConnectorAddress connectorAddress) {
        if (this.isActive) {
            throw new IllegalStateException("The cascading agent is active");
        }
        this.address = connectorAddress;
    }

    public void setClientConnectorClassName(String string) {
        if (this.isActive) {
            throw new IllegalStateException("The cascading agent is active");
        }
        this.conClName = string;
    }

    public void setSubAgentParams(Object[] objectArray, String[] stringArray) {
        if (this.conClient != null) {
            throw new IllegalStateException("The client has been created!");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Null signature.");
        }
        this.subAgentParams = objectArray == null ? null : (Object[])objectArray.clone();
        this.subAgentSignature = (String[])stringArray.clone();
    }

    public synchronized void start() {
        block26: {
            if (!this.isActive) {
                block25: {
                    block24: {
                        block23: {
                            if (this.conClient == null || !this.conClient.getClass().getName().equals(this.getClientConnectorClassName())) {
                                Class<?> clazz = null;
                                try {
                                    clazz = Class.forName(this.getClientConnectorClassName());
                                    if (this.subAgentSignature == null) {
                                        this.conClient = (RemoteMBeanServer)clazz.newInstance();
                                    } else {
                                        Class[] classArray = new Class[this.subAgentSignature.length];
                                        int n = 0;
                                        while (n < this.subAgentSignature.length) {
                                            classArray[n] = Class.forName(this.subAgentSignature[n]);
                                            ++n;
                                        }
                                        Constructor<?> constructor = clazz.getConstructor(classArray);
                                        this.conClient = (RemoteMBeanServer)constructor.newInstance(this.subAgentParams);
                                    }
                                    if (this.timeoutedSocket && this.conClient instanceof RmiConnectorClient) {
                                        ((RmiConnectorClient)this.conClient).setTimeout(this.timeout);
                                    }
                                }
                                catch (Exception exception) {
                                    if (this.isDebugOn()) {
                                        this.debug("start", "got exception while trying to get client connector: " + exception.getMessage());
                                        exception.printStackTrace();
                                    }
                                    throw new JMRuntimeException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
                                }
                            }
                            try {
                                this.conClient.connect(this.address);
                            }
                            catch (CommunicationException communicationException) {
                                if (this.isDebugOn()) {
                                    this.debug("start", "got exception while connecting: " + communicationException.getMessage());
                                    communicationException.printStackTrace();
                                }
                                throw communicationException;
                            }
                            if (this.conClient instanceof HeartBeatClientHandler) {
                                try {
                                    ((HeartBeatClientHandler)((Object)this.conClient)).setHeartBeatPeriod(2000);
                                    ((HeartBeatClientHandler)((Object)this.conClient)).addHeartBeatNotificationListener(this, null, null);
                                }
                                catch (Exception exception) {
                                    if (!this.isDebugOn()) break block23;
                                    this.debug("start", "Failed to become listener of heartbeat notifications on the remote MBean Server " + exception.getMessage());
                                }
                            }
                        }
                        try {
                            this.conClient.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                        }
                        catch (Exception exception) {
                            if (!this.isDebugOn()) break block24;
                            this.debug("start", "Failed to become listener of the remote MBean Server " + exception.getMessage());
                        }
                    }
                    try {
                        this.loadRemoteObjects(this.pattern, this.query);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block25;
                        this.debug("start", "got exception while loading remote objects: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                }
                this.isActive = true;
                this.isStopping = false;
            } else if (this.isTraceOn()) {
                this.trace("start", "The CascadingAgent is already activated.");
            }
            try {
                this.mserver.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, (NotificationFilter)this, (Object)new String("local"));
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block26;
                this.debug("start", "Failed to become listener of the local MBean Server " + exception.getMessage());
            }
        }
    }

    public synchronized void stop() {
        if (this.isActive) {
            block20: {
                block19: {
                    try {
                        this.conClient.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block19;
                        this.debug("stop", "failed to remove us as a regular listener of the REMOTE mbean server: " + exception.getMessage());
                    }
                }
                if (this.conClient instanceof HeartBeatClientHandler) {
                    try {
                        ((HeartBeatClientHandler)((Object)this.conClient)).removeHeartBeatNotificationListener(this);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block20;
                        this.debug("stop", "failed to remove us as a heart beat listener of the REMOTE mbean server: " + exception.getMessage());
                    }
                }
            }
            try {
                try {
                    this.isStopping = true;
                    while (!this.registeredRemoteObjs.isEmpty()) {
                        Object e = this.registeredRemoteObjs.firstElement();
                        try {
                            this.unregister((ObjectName)e);
                        }
                        catch (InstanceNotFoundException instanceNotFoundException) {
                            if (this.isDebugOn()) {
                                this.debug("stop", "failed to unregister object: " + (ObjectName)e + ", got exception: " + instanceNotFoundException.getMessage());
                            }
                            this.registeredRemoteObjs.removeElement(e);
                        }
                        catch (MBeanRegistrationException mBeanRegistrationException) {
                            if (this.isDebugOn()) {
                                this.debug("stop", "failed (2) to unregister object: " + (ObjectName)e + ", got exception: " + mBeanRegistrationException.getMessage());
                            }
                            this.registeredRemoteObjs.removeElement(e);
                        }
                    }
                    if (this.conClient.isConnected()) {
                        this.conClient.disconnect();
                    }
                }
                catch (CommunicationException communicationException) {
                    if (this.isDebugOn()) {
                        this.debug("stop", "failed (3) to unregister objects, got exception: " + communicationException.getMessage());
                    }
                    throw communicationException;
                }
                Object var2_10 = null;
                this.isActive = false;
                this.isStopping = false;
            }
            catch (Throwable throwable) {
                Object var2_11 = null;
                this.isActive = false;
                this.isStopping = false;
                throw throwable;
            }
        }
        if (this.isTraceOn()) {
            this.trace("stop", "The CascadingAgent is already deactivated.");
        }
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 32, string, string2, string3);
    }

    private synchronized void unregister(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.registeredRemoteObjs.removeElement(objectName);
        this.mserver.unregisterMBean(objectName);
    }

    private boolean wildmatch(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        while (n2 < n4) {
            char c;
            if ((c = string2.charAt(n2++)) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!this.wildmatch(string.substring(n), string2.substring(n2))) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (n < n3 && c == string.charAt(n++)) continue;
            return false;
        }
        return n == n3;
    }
}

