/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.swing;

import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.swing.JTreeComponentDescriptionWrapper;
import com.sun.prodreg.swing.JTreeComponentSelectableViewAdapter;
import com.sun.prodreg.swing.ProdRegTreeWillExpandListener;
import com.sun.prodreg.swing.ProdregTreeCellRenderer;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ComponentSelectableViewListener;
import com.sun.prodreg.view.TreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SwingTreeView
extends JPanel
implements TreeView {
    private ComponentSelectableView csv = null;
    private ProdRegTreeWillExpandListener el = null;
    private JTreeComponentDescriptionWrapper topNode = null;
    private DefaultTreeModel treeModel = null;
    private JTree tree = null;

    public SwingTreeView(ProdRegTreeNode prodRegTreeNode) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/images/damage.gif"));
        this.topNode = new JTreeComponentDescriptionWrapper(prodRegTreeNode, null);
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new ProdregTreeCellRenderer(image));
        this.el = new ProdRegTreeWillExpandListener();
        this.tree.addTreeWillExpandListener(this.el);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JTreeComponentSelectableViewAdapter jTreeComponentSelectableViewAdapter = new JTreeComponentSelectableViewAdapter(this.tree);
        this.tree.addTreeSelectionListener(jTreeComponentSelectableViewAdapter);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.csv = jTreeComponentSelectableViewAdapter;
    }

    public void addComponentSelectableViewListener(ComponentSelectableViewListener componentSelectableViewListener) {
        if (this.csv != null) {
            this.csv.addComponentSelectableViewListener(componentSelectableViewListener);
        }
    }

    public void addExpansionListener(ExpansionListener expansionListener) {
        if (this.el != null) {
            this.el.addExpansionListener(expansionListener);
        }
    }

    public void refresh(Vector vector, boolean bl) {
        Vector vector2 = new Vector();
        this.topNode.refresh(vector2, vector);
        this.treeModel.reload();
        int n = 0;
        while (n < vector2.size()) {
            TreeNode treeNode = (TreeNode)vector2.elementAt(n);
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(treeNode));
            if (bl) {
                this.tree.expandPath(treePath);
            }
            this.tree.setSelectionPath(treePath);
            ++n;
        }
    }

    public void removeComponentSelectableViewListener(ComponentSelectableViewListener componentSelectableViewListener) {
        if (this.csv != null) {
            this.csv.removeComponentSelectableViewListener(componentSelectableViewListener);
        }
    }

    public void removeExpansionListener(ExpansionListener expansionListener) {
        if (this.el != null) {
            this.el.removeExpansionListener(expansionListener);
        }
    }

    public void setEnabled(boolean bl) {
        this.tree.setEnabled(bl);
    }
}

