/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.AppletFrame;
import com.sun.prodreg.Article;
import com.sun.prodreg.CannotRegister;
import com.sun.prodreg.ClusterArticle;
import com.sun.prodreg.ErrorDialog;
import com.sun.prodreg.ProductView;
import com.sun.prodreg.RegException;
import com.sun.prodreg.Registry;
import com.sun.prodreg._;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProdReg
extends Applet {
    static Registry[] allRegistries;
    static Registry systemRegistry;
    static Registry userRegistry;
    public static boolean Swing;
    static PrintStream stderr;
    static Frame frame;
    private static String pkgRoot;
    private static String[] args;
    private static byte[] buf;
    static boolean helpInitialized;
    private static String[] usage;
    static String versionRes;
    static String copyrightRes;
    static String buildDateRes;
    static Component productViewPanel;

    static {
        stderr = System.err;
        buf = new byte[1024];
        helpInitialized = false;
        usage = new String[]{"usage-syntax", "$ prodreg", "$ prodreg swing", "$ prodreg awt", "$ prodreg help", "$ prodreg version"};
    }

    private static void command(boolean bl) {
        while (true) {
            String string;
            if (bl) {
                System.out.print("prodreg> ");
            }
            if ((string = ProdReg.getLine()) == null) {
                return;
            }
            ProdReg.prTrace(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            args = new String[vector.size()];
            vector.copyInto(args);
            try {
                ProdReg.doCommand();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) continue;
            System.out.print("\u0005");
            System.err.print("\u0005");
            System.out.flush();
            System.err.flush();
        }
    }

    public void destroy() {
    }

    private static void doCommand() {
        try {
            if (args.length < 1) {
                return;
            }
            if (args[0].equals("awt")) {
                ProdReg.view(false);
            } else if (args[0].equals("command")) {
                ProdReg.command(true);
            } else if (args[0].equals("commandnp")) {
                ProdReg.command(false);
            } else if (args[0].equals("exit")) {
                System.exit(0);
            } else if (args[0].equals("help")) {
                ProdReg.help();
            } else if (args[0].equals("list")) {
                ProdReg.listCmd();
            } else if (args[0].equals("lookup")) {
                ProdReg.lookup();
            } else if (args[0].equals("lookupComponents")) {
                ProdReg.lookupComponents();
            } else if (args[0].equals("lookupProducts")) {
                ProdReg.lookupProducts();
            } else if (args[0].equals("register")) {
                ProdReg.register();
            } else if (args[0].equals("swing")) {
                ProdReg.view(true);
            } else if (args[0].equals("uninstall")) {
                ProdReg.uninstall();
            } else if (args[0].equals("unregister")) {
                ProdReg.unregister();
            } else if (args[0].equals("version")) {
                ProdReg.version();
            } else {
                ProdReg.syntaxError(_.__("badSubcommandEr", args[0]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getLine() {
        try {
            int n = System.in.read(buf);
            if (n < 0) {
                return null;
            }
            return new String(buf, 0, n);
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            System.exit(1);
            return null;
        }
    }

    public static String getPkgRoot() {
        return pkgRoot;
    }

    private static void help() {
        int n;
        if (!helpInitialized) {
            n = 0;
            while (n < usage.length) {
                if (!usage[n].startsWith("$")) {
                    ProdReg.usage[n] = _.__(usage[n]);
                }
                ++n;
            }
            helpInitialized = true;
        }
        n = 0;
        while (n < usage.length) {
            stderr.println(usage[n]);
            ++n;
        }
    }

    public void init() {
        try {
            Registry.openAllRegistries(false);
            ClusterArticle.readClusterInfo();
        }
        catch (Exception exception) {
            ErrorDialog.report((Component)this, exception);
            System.exit(1);
        }
        System.out.println(_.__("settingUp1"));
        this.setLayout(new BorderLayout(0, 0));
        productViewPanel = ProductView.newProductView(allRegistries);
        this.add("Center", productViewPanel);
    }

    private static void listCmd() throws Exception {
        if (args.length < 3) {
            ProdReg.syntaxError(_.__("badListEr"));
            return;
        }
        String string = args[1];
        String[] stringArray = new String[args.length - 2];
        System.arraycopy(args, 2, stringArray, 0, stringArray.length);
        String string2 = Registry.list(string, stringArray);
        System.out.print(string2);
    }

    private static void loadResources(Object object) {
        int n;
        InputStream inputStream;
        byte[] byArray = new byte[256];
        Class<?> clazz = object.getClass();
        try {
            inputStream = clazz.getResourceAsStream("/Version");
            n = inputStream.read(byArray);
            inputStream.close();
            versionRes = new String(byArray, 0, n);
        }
        catch (Exception exception) {
            versionRes = "error: can't read in version";
        }
        try {
            inputStream = clazz.getResourceAsStream("/copyright");
            n = inputStream.read(byArray);
            inputStream.close();
            copyrightRes = new String(byArray, 0, n);
        }
        catch (Exception exception) {
            copyrightRes = "error: can't read in copyright";
        }
        try {
            inputStream = clazz.getResourceAsStream("/builddate");
            n = inputStream.read(byArray);
            inputStream.close();
            buildDateRes = new String(byArray, 0, n);
        }
        catch (Exception exception) {
            buildDateRes = "error: can't read in build date";
        }
    }

    private static void lookup() throws Exception {
        if (args.length != 2 && args.length != 3) {
            ProdReg.syntaxError(_.__("badLookupEr"));
            return;
        }
        String string = args.length == 2 ? Registry.lookup(args[1]) : Registry.lookup(args[1], args[2]);
        System.out.print(string);
    }

    private static void lookupComponents() throws Exception {
        if (args.length != 3) {
            ProdReg.syntaxError(_.__("badLookupCompEr"));
            return;
        }
        String string = args[1];
        String string2 = args[2];
        Registry.openAllRegistries(false);
        Article article = Article.lookup(string, string2);
        if (article == null) {
            stderr.println(_.__("prodNotRegEr", string, string2));
            return;
        }
        System.out.println(article.getAttribute("articles", ""));
    }

    private static void lookupProducts() throws Exception {
        if (args.length < 2) {
            ProdReg.syntaxError(_.__("badLookupProdEr"));
            return;
        }
        Registry.openAllRegistries(false);
        int n = 1;
        while (n < args.length) {
            Article article = Article.lookup(args[n]);
            if (article != null) {
                System.out.print(String.valueOf(args[n]) + ' ');
            }
            ++n;
        }
        System.out.println();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.1.3") < 0) {
            stderr.println("This software needs at least java 1.1.3 to run.");
            System.exit(1);
        }
        pkgRoot = System.getProperty("prodreg.pkgroot", "/");
        _.initLocalizedResources();
        args = stringArray;
        if (args.length < 1) {
            ProdReg.view(true);
            return;
        }
        ProdReg.doCommand();
    }

    public static void prTrace(String string) {
    }

    private static void register() throws Exception {
        try {
            String string = null;
            switch (args.length) {
                case 1: {
                    Registry.register();
                    break;
                }
                case 3: {
                    string = Registry.register(args[1], args[2]);
                    System.out.println(string);
                    break;
                }
                case 5: {
                    string = Registry.register(args[1], args[2], args[3], args[4]);
                    System.out.println(string);
                    break;
                }
                default: {
                    ProdReg.syntaxError(_.__("badNoArgsEr"));
                    break;
                }
            }
        }
        catch (CannotRegister cannotRegister) {
            stderr.println(_.__("cantRegisterEr", cannotRegister.toString()));
        }
    }

    private static void syntaxError(String string) {
        if (string != null) {
            stderr.println(string);
        }
        stderr.print("   prodreg ");
        int n = 0;
        while (n < args.length) {
            stderr.print(" " + args[n]);
            ++n;
        }
        stderr.println();
        stderr.println(_.__("forUsage"));
    }

    private static void uninstall() throws Exception {
        if (args.length != 3) {
            ProdReg.syntaxError(_.__("badUninstallEr"));
            return;
        }
        Registry.uninstall(args[1], args[2]);
    }

    private static void unregister() throws Exception {
        if (args.length != 3) {
            ProdReg.syntaxError(_.__("badUnregisterEr"));
            return;
        }
        Registry.unregister(args[1], args[2]);
    }

    private static void version() throws Exception {
        Class<?> clazz = new Article("").getClass();
        InputStream inputStream = clazz.getResourceAsStream("/Version");
        byte[] byArray = new byte[100];
        inputStream.read(byArray);
        inputStream.close();
        System.out.println(new String(byArray));
    }

    private static void view(boolean bl) throws RegException {
        System.out.println(_.__("settingUp0"));
        try {
            new Font("Dialog", 0, 10);
        }
        catch (InternalError internalError) {
            stderr.println(internalError.toString());
            stderr.println("\n" + _.__("xhost") + "\n");
            System.exit(1);
        }
        try {
            Class.forName("javax.swing.JLabel");
            Swing = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Swing = false;
        }
        if (!bl) {
            Swing = false;
        }
        ProdReg prodReg = new ProdReg();
        ProdReg.loadResources(prodReg);
        frame = new AppletFrame(_.__("prodReg"), prodReg, 800, 480);
    }
}

