/*
 * Copyright 11/30/01 Sun Microsystems, Inc.  All Rights Reserved.
 */

#ifndef _SUNPERF_H
#define _SUNPERF_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __STDC__
#define __P(p)  p
#else
#define __P(p)  ()
#endif

#ifndef _SUNPERF_COMPLEX
#define _SUNPERF_COMPLEX
typedef struct {
        float r;
        float i;
} complex;
typedef struct {
        double r;
        double i;
} doublecomplex;
#endif  /* !defined(_SUNPERF_COMPLEX) */

extern void available_threads __P((int*, int*));
extern void available_threads_64 __P((long*, long*));
extern void caxpy __P((int, complex*, complex*, int, complex*, int));
extern void caxpy_64 __P((long, complex*, complex*, long, complex*, long));
extern void caxpyi __P((int, complex*, complex*, int*, complex*));
extern void caxpyi_64 __P((long, complex*, complex*, long*, complex*));
extern void cbcomm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int, int, complex*, int, complex*, complex*, int));
extern void cbcomm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long, long, complex*, long, complex*, complex*, long));
extern void cbdimm __P((int, int, int, int, complex*, int*, complex*, int, int*, int, int, complex*, int, complex*, complex*, int));
extern void cbdimm_64 __P((long, long, long, long, complex*, long*, complex*, long, long*, long, long, complex*, long, complex*, complex*, long));
extern void cbdism __P((int, int, int, int, complex*, complex*, int*, complex*, int, int*, int, int, complex*, int, complex*, complex*, int));
extern void cbdism_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long, long*, long, long, complex*, long, complex*, complex*, long));
extern void cbdsqr __P((char, int, int, int, int, float*, float*, complex*, int, complex*, int, complex*, int, int*));
extern void cbdsqr_64 __P((char, long, long, long, long, float*, float*, complex*, long, complex*, long, complex*, long, long*));
extern void cbelmm __P((int, int, int, int, complex*, int*, complex*, int*, int, int, int, complex*, int, complex*, complex*, int));
extern void cbelmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long, long, long, complex*, long, complex*, complex*, long));
extern void cbelsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int, int, int, complex*, int, complex*, complex*, int));
extern void cbelsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long, long, long, complex*, long, complex*, complex*, long));
extern void cbscmm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int*, int, complex*, int, complex*, complex*, int));
extern void cbscmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long*, long, complex*, long, complex*, complex*, long));
extern void cbscsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int*, int*, int, complex*, int, complex*, complex*, int));
extern void cbscsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long*, long*, long, complex*, long, complex*, complex*, long));
extern void cbsrmm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int*, int, complex*, int, complex*, complex*, int));
extern void cbsrmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long*, long, complex*, long, complex*, complex*, long));
extern void cbsrsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int*, int*, int, complex*, int, complex*, complex*, int));
extern void cbsrsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long*, long*, long, complex*, long, complex*, complex*, long));
extern void ccnvcor __P((char, char, int, complex*, int, int, int, int, int, complex*, int, int, int, int, int, complex*, int, int, int, complex*, int));
extern void ccnvcor_64 __P((char, char, long, complex*, long, long, long, long, long, complex*, long, long, long, long, long, complex*, long, long, long, complex*, long));
extern void ccnvcor2 __P((char, char, char, char, char, char, int, int, complex*, int, int, int, int, int, complex*, int, int, int, complex*, int, complex*, int));
extern void ccnvcor2_64 __P((char, char, char, char, char, char, long, long, complex*, long, long, long, long, long, complex*, long, long, long, complex*, long, complex*, long));
extern void ccoomm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int, complex*, int, complex*, complex*, int));
extern void ccoomm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long, complex*, long, complex*, complex*, long));
extern void ccopy __P((int, complex*, int, complex*, int));
extern void ccopy_64 __P((long, complex*, long, complex*, long));
extern void ccscmm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int*, complex*, int, complex*, complex*, int));
extern void ccscmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long*, complex*, long, complex*, complex*, long));
extern void ccscsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int*, int*, complex*, int, complex*, complex*, int));
extern void ccscsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long*, long*, complex*, long, complex*, complex*, long));
extern void ccsrmm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int*, complex*, int, complex*, complex*, int));
extern void ccsrmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long*, complex*, long, complex*, complex*, long));
extern void ccsrsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int*, int*, complex*, int, complex*, complex*, int));
extern void ccsrsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long*, long*, complex*, long, complex*, complex*, long));
extern void cdiamm __P((int, int, int, int, complex*, int*, complex*, int, int*, int, complex*, int, complex*, complex*, int));
extern void cdiamm_64 __P((long, long, long, long, complex*, long*, complex*, long, long*, long, complex*, long, complex*, complex*, long));
extern void cdiasm __P((int, int, int, int, complex*, complex*, int*, complex*, int, int*, int, complex*, int, complex*, complex*, int));
extern void cdiasm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long, long*, long, complex*, long, complex*, complex*, long));
extern complex cdotc __P((int, complex*, int, complex*, int));
extern complex cdotc_64 __P((long, complex*, long, complex*, long));
extern complex cdotci __P((int, complex*, int*, complex*));
extern complex cdotci_64 __P((long, complex*, long*, complex*));
extern complex cdotu __P((int, complex*, int, complex*, int));
extern complex cdotu_64 __P((long, complex*, long, complex*, long));
extern complex cdotui __P((int, complex*, int*, complex*));
extern complex cdotui_64 __P((long, complex*, long*, complex*));
extern void cellmm __P((int, int, int, int, complex*, int*, complex*, int*, int, int, complex*, int, complex*, complex*, int));
extern void cellmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long, long, complex*, long, complex*, complex*, long));
extern void cellsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int, int, complex*, int, complex*, complex*, int));
extern void cellsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long, long, complex*, long, complex*, complex*, long));
extern void cfft2b __P((int, int, complex*, int, float*, int));
extern void cfft2b_64 __P((long, long, complex*, long, float*, long));
extern void cfft2f __P((int, int, complex*, int, float*, int));
extern void cfft2f_64 __P((long, long, complex*, long, float*, long));
extern void cfft2i __P((int, int, float*));
extern void cfft2i_64 __P((long, long, float*));
extern void cfft3b __P((int, int, int, complex*, int, int, float*, int));
extern void cfft3b_64 __P((long, long, long, complex*, long, long, float*, long));
extern void cfft3f __P((int, int, int, complex*, int, int, float*, int));
extern void cfft3f_64 __P((long, long, long, complex*, long, long, float*, long));
extern void cfft3i __P((int, int, int, float*));
extern void cfft3i_64 __P((long, long, long, float*));
extern void cfftb __P((int, complex*, float*));
extern void cfftb_64 __P((long, complex*, float*));
extern void cfftf __P((int, complex*, float*));
extern void cfftf_64 __P((long, complex*, float*));
extern void cffti __P((int, float*));
extern void cffti_64 __P((long, float*));
extern int cfftopt __P((int));
extern long cfftopt_64 __P((long));
extern void cgbbrd __P((char, int, int, int, int, int, complex*, int, float*, float*, complex*, int, complex*, int, complex*, int, int*));
extern void cgbbrd_64 __P((char, long, long, long, long, long, complex*, long, float*, float*, complex*, long, complex*, long, complex*, long, long*));
extern void cgbcon __P((char, int, int, int, complex*, int, int*, float, float*, int*));
extern void cgbcon_64 __P((char, long, long, long, complex*, long, long*, float, float*, long*));
extern void cgbequ __P((int, int, int, int, complex*, int, float*, float*, float*, float*, float*, int*));
extern void cgbequ_64 __P((long, long, long, long, complex*, long, float*, float*, float*, float*, float*, long*));
extern void cgbmv __P((char, int, int, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void cgbmv_64 __P((char, long, long, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void cgbrfs __P((char, int, int, int, int, complex*, int, complex*, int, int*, complex*, int, complex*, int, float*, float*, int*));
extern void cgbrfs_64 __P((char, long, long, long, long, complex*, long, complex*, long, long*, complex*, long, complex*, long, float*, float*, long*));
extern void cgbsv __P((int, int, int, int, complex*, int, int*, complex*, int, int*));
extern void cgbsv_64 __P((long, long, long, long, complex*, long, long*, complex*, long, long*));
extern void cgbsvx __P((char, char, int, int, int, int, complex*, int, complex*, int, int*, char, float*, float*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cgbsvx_64 __P((char, char, long, long, long, long, complex*, long, complex*, long, long*, char, float*, float*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cgbtf2 __P((int, int, int, int, complex*, int, int*, int*));
extern void cgbtf2_64 __P((long, long, long, long, complex*, long, long*, long*));
extern void cgbtrf __P((int, int, int, int, complex*, int, int*, int*));
extern void cgbtrf_64 __P((long, long, long, long, complex*, long, long*, long*));
extern void cgbtrs __P((char, int, int, int, int, complex*, int, int*, complex*, int, int*));
extern void cgbtrs_64 __P((char, long, long, long, long, complex*, long, long*, complex*, long, long*));
extern void cgebak __P((char, char, int, int, int, float*, int, complex*, int, int*));
extern void cgebak_64 __P((char, char, long, long, long, float*, long, complex*, long, long*));
extern void cgebal __P((char, int, complex*, int, int*, int*, float*, int*));
extern void cgebal_64 __P((char, long, complex*, long, long*, long*, float*, long*));
extern void cgebrd __P((int, int, complex*, int, float*, float*, complex*, complex*, int*));
extern void cgebrd_64 __P((long, long, complex*, long, float*, float*, complex*, complex*, long*));
extern void cgecon __P((char, int, complex*, int, float, float*, int*));
extern void cgecon_64 __P((char, long, complex*, long, float, float*, long*));
extern void cgeequ __P((int, int, complex*, int, float*, float*, float*, float*, float*, int*));
extern void cgeequ_64 __P((long, long, complex*, long, float*, float*, float*, float*, float*, long*));
extern void cgees __P((char, char, int(*select)(complex), int, complex*, int, int*, complex*, complex*, int, int*));
extern void cgees_64 __P((char, char, long(*select)(complex), long, complex*, long, long*, complex*, complex*, long, long*));
extern void cgeesx __P((char, char, int(*select)(complex), char, int, complex*, int, int*, complex*, complex*, int, float*, float*, int*));
extern void cgeesx_64 __P((char, char, long(*select)(complex), char, long, complex*, long, long*, complex*, complex*, long, float*, float*, long*));
extern void cgeev __P((char, char, int, complex*, int, complex*, complex*, int, complex*, int, int*));
extern void cgeev_64 __P((char, char, long, complex*, long, complex*, complex*, long, complex*, long, long*));
extern void cgeevx __P((char, char, char, char, int, complex*, int, complex*, complex*, int, complex*, int, int*, int*, float*, float*, float*, float*, int*));
extern void cgeevx_64 __P((char, char, char, char, long, complex*, long, complex*, complex*, long, complex*, long, long*, long*, float*, float*, float*, float*, long*));
extern void cgegs __P((char, char, int, complex*, int, complex*, int, complex*, complex*, complex*, int, complex*, int, int*));
extern void cgegs_64 __P((char, char, long, complex*, long, complex*, long, complex*, complex*, complex*, long, complex*, long, long*));
extern void cgegv __P((char, char, int, complex*, int, complex*, int, complex*, complex*, complex*, int, complex*, int, int*));
extern void cgegv_64 __P((char, char, long, complex*, long, complex*, long, complex*, complex*, complex*, long, complex*, long, long*));
extern void cgehrd __P((int, int, int, complex*, int, complex*, int*));
extern void cgehrd_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cgelqf __P((int, int, complex*, int, complex*, int*));
extern void cgelqf_64 __P((long, long, complex*, long, complex*, long*));
extern void cgels __P((char, int, int, int, complex*, int, complex*, int, int*));
extern void cgels_64 __P((char, long, long, long, complex*, long, complex*, long, long*));
extern void cgelsd __P((int, int, int, complex*, int, complex*, int, float*, float, int*, int*));
extern void cgelsd_64 __P((long, long, long, complex*, long, complex*, long, float*, float, long*, long*));
extern void cgelss __P((int, int, int, complex*, int, complex*, int, float*, float, int*, int*));
extern void cgelss_64 __P((long, long, long, complex*, long, complex*, long, float*, float, long*, long*));
extern void cgelsx __P((int, int, int, complex*, int, complex*, int, int*, float, int*, int*));
extern void cgelsx_64 __P((long, long, long, complex*, long, complex*, long, long*, float, long*, long*));
extern void cgelsy __P((int, int, int, complex*, int, complex*, int, int*, float, int*, int*));
extern void cgelsy_64 __P((long, long, long, complex*, long, complex*, long, long*, float, long*, long*));
extern void cgemm __P((char, char, int, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void cgemm_64 __P((char, char, long, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void cgemv __P((char, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void cgemv_64 __P((char, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void cgeqlf __P((int, int, complex*, int, complex*, int*));
extern void cgeqlf_64 __P((long, long, complex*, long, complex*, long*));
extern void cgeqp3 __P((int, int, complex*, int, int*, complex*, int*));
extern void cgeqp3_64 __P((long, long, complex*, long, long*, complex*, long*));
extern void cgeqpf __P((int, int, complex*, int, int*, complex*, int*));
extern void cgeqpf_64 __P((long, long, complex*, long, long*, complex*, long*));
extern void cgeqrf __P((int, int, complex*, int, complex*, int*));
extern void cgeqrf_64 __P((long, long, complex*, long, complex*, long*));
extern void cgerc __P((int, int, complex*, complex*, int, complex*, int, complex*, int));
extern void cgerc_64 __P((long, long, complex*, complex*, long, complex*, long, complex*, long));
extern void cgerfs __P((char, int, int, complex*, int, complex*, int, int*, complex*, int, complex*, int, float*, float*, int*));
extern void cgerfs_64 __P((char, long, long, complex*, long, complex*, long, long*, complex*, long, complex*, long, float*, float*, long*));
extern void cgerqf __P((int, int, complex*, int, complex*, int*));
extern void cgerqf_64 __P((long, long, complex*, long, complex*, long*));
extern void cgeru __P((int, int, complex*, complex*, int, complex*, int, complex*, int));
extern void cgeru_64 __P((long, long, complex*, complex*, long, complex*, long, complex*, long));
extern void cgesdd __P((char, int, int, complex*, int, float*, complex*, int, complex*, int, int*));
extern void cgesdd_64 __P((char, long, long, complex*, long, float*, complex*, long, complex*, long, long*));
extern void cgesv __P((int, int, complex*, int, int*, complex*, int, int*));
extern void cgesv_64 __P((long, long, complex*, long, long*, complex*, long, long*));
extern void cgesvd __P((char, char, int, int, complex*, int, float*, complex*, int, complex*, int, int*));
extern void cgesvd_64 __P((char, char, long, long, complex*, long, float*, complex*, long, complex*, long, long*));
extern void cgesvx __P((char, char, int, int, complex*, int, complex*, int, int*, char, float*, float*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cgesvx_64 __P((char, char, long, long, complex*, long, complex*, long, long*, char, float*, float*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cgetf2 __P((int, int, complex*, int, int*, int*));
extern void cgetf2_64 __P((long, long, complex*, long, long*, long*));
extern void cgetrf __P((int, int, complex*, int, int*, int*));
extern void cgetrf_64 __P((long, long, complex*, long, long*, long*));
extern void cgetri __P((int, complex*, int, int*, int*));
extern void cgetri_64 __P((long, complex*, long, long*, long*));
extern void cgetrs __P((char, int, int, complex*, int, int*, complex*, int, int*));
extern void cgetrs_64 __P((char, long, long, complex*, long, long*, complex*, long, long*));
extern void cggbak __P((char, char, int, int, int, float*, float*, int, complex*, int, int*));
extern void cggbak_64 __P((char, char, long, long, long, float*, float*, long, complex*, long, long*));
extern void cggbal __P((char, int, complex*, int, complex*, int, int*, int*, float*, float*, int*));
extern void cggbal_64 __P((char, long, complex*, long, complex*, long, long*, long*, float*, float*, long*));
extern void cgges __P((char, char, char, int(*selctg)(complex*,complex), int, complex*, int, complex*, int, int*, complex*, complex*, complex*, int, complex*, int, int*));
extern void cgges_64 __P((char, char, char, long(*selctg)(complex*,complex), long, complex*, long, complex*, long, long*, complex*, complex*, complex*, long, complex*, long, long*));
extern void cggesx __P((char, char, char, int(*selctg)(complex*,complex), char, int, complex*, int, complex*, int, int*, complex*, complex*, complex*, int, complex*, int, float*, float*, int*));
extern void cggesx_64 __P((char, char, char, long(*selctg)(complex*,complex), char, long, complex*, long, complex*, long, long*, complex*, complex*, complex*, long, complex*, long, float*, float*, long*));
extern void cggev __P((char, char, int, complex*, int, complex*, int, complex*, complex*, complex*, int, complex*, int, int*));
extern void cggev_64 __P((char, char, long, complex*, long, complex*, long, complex*, complex*, complex*, long, complex*, long, long*));
extern void cggevx __P((char, char, char, char, int, complex*, int, complex*, int, complex*, complex*, complex*, int, complex*, int, int*, int*, float*, float*, float*, float*, float*, float*, int*));
extern void cggevx_64 __P((char, char, char, char, long, complex*, long, complex*, long, complex*, complex*, complex*, long, complex*, long, long*, long*, float*, float*, float*, float*, float*, float*, long*));
extern void cggglm __P((int, int, int, complex*, int, complex*, int, complex*, complex*, complex*, int*));
extern void cggglm_64 __P((long, long, long, complex*, long, complex*, long, complex*, complex*, complex*, long*));
extern void cgghrd __P((char, char, int, int, int, complex*, int, complex*, int, complex*, int, complex*, int, int*));
extern void cgghrd_64 __P((char, char, long, long, long, complex*, long, complex*, long, complex*, long, complex*, long, long*));
extern void cgglse __P((int, int, int, complex*, int, complex*, int, complex*, complex*, complex*, int*));
extern void cgglse_64 __P((long, long, long, complex*, long, complex*, long, complex*, complex*, complex*, long*));
extern void cggqrf __P((int, int, int, complex*, int, complex*, complex*, int, complex*, int*));
extern void cggqrf_64 __P((long, long, long, complex*, long, complex*, complex*, long, complex*, long*));
extern void cggrqf __P((int, int, int, complex*, int, complex*, complex*, int, complex*, int*));
extern void cggrqf_64 __P((long, long, long, complex*, long, complex*, complex*, long, complex*, long*));
extern void cggsvd __P((char, char, char, int, int, int, int*, int*, complex*, int, complex*, int, float*, float*, complex*, int, complex*, int, complex*, int, int*, int*));
extern void cggsvd_64 __P((char, char, char, long, long, long, long*, long*, complex*, long, complex*, long, float*, float*, complex*, long, complex*, long, complex*, long, long*, long*));
extern void cggsvp __P((char, char, char, int, int, int, complex*, int, complex*, int, float, float, int*, int*, complex*, int, complex*, int, complex*, int, int*));
extern void cggsvp_64 __P((char, char, char, long, long, long, complex*, long, complex*, long, float, float, long*, long*, complex*, long, complex*, long, complex*, long, long*));
extern void cgtcon __P((char, int, complex*, complex*, complex*, complex*, int*, float, float*, int*));
extern void cgtcon_64 __P((char, long, complex*, complex*, complex*, complex*, long*, float, float*, long*));
extern void cgthr __P((int, complex*, complex*, int*));
extern void cgthr_64 __P((long, complex*, complex*, long*));
extern void cgthrz __P((int, complex*, complex*, int*));
extern void cgthrz_64 __P((long, complex*, complex*, long*));
extern void cgtrfs __P((char, int, int, complex*, complex*, complex*, complex*, complex*, complex*, complex*, int*, complex*, int, complex*, int, float*, float*, int*));
extern void cgtrfs_64 __P((char, long, long, complex*, complex*, complex*, complex*, complex*, complex*, complex*, long*, complex*, long, complex*, long, float*, float*, long*));
extern void cgtsv __P((int, int, complex*, complex*, complex*, complex*, int, int*));
extern void cgtsv_64 __P((long, long, complex*, complex*, complex*, complex*, long, long*));
extern void cgtsvx __P((char, char, int, int, complex*, complex*, complex*, complex*, complex*, complex*, complex*, int*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cgtsvx_64 __P((char, char, long, long, complex*, complex*, complex*, complex*, complex*, complex*, complex*, long*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cgttrf __P((int, complex*, complex*, complex*, complex*, int*, int*));
extern void cgttrf_64 __P((long, complex*, complex*, complex*, complex*, long*, long*));
extern void cgttrs __P((char, int, int, complex*, complex*, complex*, complex*, int*, complex*, int, int*));
extern void cgttrs_64 __P((char, long, long, complex*, complex*, complex*, complex*, long*, complex*, long, long*));
extern void chbev __P((char, char, int, int, complex*, int, float*, complex*, int, int*));
extern void chbev_64 __P((char, char, long, long, complex*, long, float*, complex*, long, long*));
extern void chbevd __P((char, char, int, int, complex*, int, float*, complex*, int, int*));
extern void chbevd_64 __P((char, char, long, long, complex*, long, float*, complex*, long, long*));
extern void chbevx __P((char, char, char, int, int, complex*, int, complex*, int, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void chbevx_64 __P((char, char, char, long, long, complex*, long, complex*, long, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void chbgst __P((char, char, int, int, int, complex*, int, complex*, int, complex*, int, int*));
extern void chbgst_64 __P((char, char, long, long, long, complex*, long, complex*, long, complex*, long, long*));
extern void chbgv __P((char, char, int, int, int, complex*, int, complex*, int, float*, complex*, int, int*));
extern void chbgv_64 __P((char, char, long, long, long, complex*, long, complex*, long, float*, complex*, long, long*));
extern void chbgvd __P((char, char, int, int, int, complex*, int, complex*, int, float*, complex*, int, int*));
extern void chbgvd_64 __P((char, char, long, long, long, complex*, long, complex*, long, float*, complex*, long, long*));
extern void chbgvx __P((char, char, char, int, int, int, complex*, int, complex*, int, complex*, int, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void chbgvx_64 __P((char, char, char, long, long, long, complex*, long, complex*, long, complex*, long, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void chbmv __P((char, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void chbmv_64 __P((char, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void chbtrd __P((char, char, int, int, complex*, int, float*, float*, complex*, int, int*));
extern void chbtrd_64 __P((char, char, long, long, complex*, long, float*, float*, complex*, long, long*));
extern void checon __P((char, int, complex*, int, int*, float, float*, int*));
extern void checon_64 __P((char, long, complex*, long, long*, float, float*, long*));
extern void cheev __P((char, char, int, complex*, int, float*, int*));
extern void cheev_64 __P((char, char, long, complex*, long, float*, long*));
extern void cheevd __P((char, char, int, complex*, int, float*, int*));
extern void cheevd_64 __P((char, char, long, complex*, long, float*, long*));
extern void cheevr __P((char, char, char, int, complex*, int, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void cheevr_64 __P((char, char, char, long, complex*, long, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void cheevx __P((char, char, char, int, complex*, int, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void cheevx_64 __P((char, char, char, long, complex*, long, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void chegs2 __P((int, char, int, complex*, int, complex*, int, int*));
extern void chegs2_64 __P((long, char, long, complex*, long, complex*, long, long*));
extern void chegst __P((int, char, int, complex*, int, complex*, int, int*));
extern void chegst_64 __P((long, char, long, complex*, long, complex*, long, long*));
extern void chegv __P((int, char, char, int, complex*, int, complex*, int, float*, int*));
extern void chegv_64 __P((long, char, char, long, complex*, long, complex*, long, float*, long*));
extern void chegvd __P((int, char, char, int, complex*, int, complex*, int, float*, int*));
extern void chegvd_64 __P((long, char, char, long, complex*, long, complex*, long, float*, long*));
extern void chegvx __P((int, char, char, char, int, complex*, int, complex*, int, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void chegvx_64 __P((long, char, char, char, long, complex*, long, complex*, long, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void chemm __P((char, char, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void chemm_64 __P((char, char, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void chemv __P((char, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void chemv_64 __P((char, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void cher __P((char, int, float, complex*, int, complex*, int));
extern void cher_64 __P((char, long, float, complex*, long, complex*, long));
extern void cher2 __P((char, int, complex*, complex*, int, complex*, int, complex*, int));
extern void cher2_64 __P((char, long, complex*, complex*, long, complex*, long, complex*, long));
extern void cher2k __P((char, char, int, int, complex*, complex*, int, complex*, int, float, complex*, int));
extern void cher2k_64 __P((char, char, long, long, complex*, complex*, long, complex*, long, float, complex*, long));
extern void cherfs __P((char, int, int, complex*, int, complex*, int, int*, complex*, int, complex*, int, float*, float*, int*));
extern void cherfs_64 __P((char, long, long, complex*, long, complex*, long, long*, complex*, long, complex*, long, float*, float*, long*));
extern void cherk __P((char, char, int, int, float, complex*, int, float, complex*, int));
extern void cherk_64 __P((char, char, long, long, float, complex*, long, float, complex*, long));
extern void chesv __P((char, int, int, complex*, int, int*, complex*, int, int*));
extern void chesv_64 __P((char, long, long, complex*, long, long*, complex*, long, long*));
extern void chesvx __P((char, char, int, int, complex*, int, complex*, int, int*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void chesvx_64 __P((char, char, long, long, complex*, long, complex*, long, long*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void chetf2 __P((char, int, complex*, int, int*, int*));
extern void chetf2_64 __P((char, long, complex*, long, long*, long*));
extern void chetrd __P((char, int, complex*, int, float*, float*, complex*, int*));
extern void chetrd_64 __P((char, long, complex*, long, float*, float*, complex*, long*));
extern void chetrf __P((char, int, complex*, int, int*, int*));
extern void chetrf_64 __P((char, long, complex*, long, long*, long*));
extern void chetri __P((char, int, complex*, int, int*, int*));
extern void chetri_64 __P((char, long, complex*, long, long*, long*));
extern void chetrs __P((char, int, int, complex*, int, int*, complex*, int, int*));
extern void chetrs_64 __P((char, long, long, complex*, long, long*, complex*, long, long*));
extern void chgeqz __P((char, char, char, int, int, int, complex*, int, complex*, int, complex*, complex*, complex*, int, complex*, int, int*));
extern void chgeqz_64 __P((char, char, char, long, long, long, complex*, long, complex*, long, complex*, complex*, complex*, long, complex*, long, long*));
extern void chpcon __P((char, int, complex*, int*, float, float*, int*));
extern void chpcon_64 __P((char, long, complex*, long*, float, float*, long*));
extern void chpev __P((char, char, int, complex*, float*, complex*, int, int*));
extern void chpev_64 __P((char, char, long, complex*, float*, complex*, long, long*));
extern void chpevd __P((char, char, int, complex*, float*, complex*, int, int*));
extern void chpevd_64 __P((char, char, long, complex*, float*, complex*, long, long*));
extern void chpevx __P((char, char, char, int, complex*, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void chpevx_64 __P((char, char, char, long, complex*, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void chpgst __P((int, char, int, complex*, complex*, int*));
extern void chpgst_64 __P((long, char, long, complex*, complex*, long*));
extern void chpgv __P((int, char, char, int, complex*, complex*, float*, complex*, int, int*));
extern void chpgv_64 __P((long, char, char, long, complex*, complex*, float*, complex*, long, long*));
extern void chpgvd __P((int, char, char, int, complex*, complex*, float*, complex*, int, int*));
extern void chpgvd_64 __P((long, char, char, long, complex*, complex*, float*, complex*, long, long*));
extern void chpgvx __P((int, char, char, char, int, complex*, complex*, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void chpgvx_64 __P((long, char, char, char, long, complex*, complex*, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void chpmv __P((char, int, complex*, complex*, complex*, int, complex*, complex*, int));
extern void chpmv_64 __P((char, long, complex*, complex*, complex*, long, complex*, complex*, long));
extern void chpr __P((char, int, float, complex*, int, complex*));
extern void chpr_64 __P((char, long, float, complex*, long, complex*));
extern void chpr2 __P((char, int, complex*, complex*, int, complex*, int, complex*));
extern void chpr2_64 __P((char, long, complex*, complex*, long, complex*, long, complex*));
extern void chprfs __P((char, int, int, complex*, complex*, int*, complex*, int, complex*, int, float*, float*, int*));
extern void chprfs_64 __P((char, long, long, complex*, complex*, long*, complex*, long, complex*, long, float*, float*, long*));
extern void chpsv __P((char, int, int, complex*, int*, complex*, int, int*));
extern void chpsv_64 __P((char, long, long, complex*, long*, complex*, long, long*));
extern void chpsvx __P((char, char, int, int, complex*, complex*, int*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void chpsvx_64 __P((char, char, long, long, complex*, complex*, long*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void chptrd __P((char, int, complex*, float*, float*, complex*, int*));
extern void chptrd_64 __P((char, long, complex*, float*, float*, complex*, long*));
extern void chptrf __P((char, int, complex*, int*, int*));
extern void chptrf_64 __P((char, long, complex*, long*, long*));
extern void chptri __P((char, int, complex*, int*, int*));
extern void chptri_64 __P((char, long, complex*, long*, long*));
extern void chptrs __P((char, int, int, complex*, int*, complex*, int, int*));
extern void chptrs_64 __P((char, long, long, complex*, long*, complex*, long, long*));
extern void chsein __P((char, char, char, int*, int, complex*, int, complex*, complex*, int, complex*, int, int, int*, int*, int*, int*));
extern void chsein_64 __P((char, char, char, long*, long, complex*, long, complex*, complex*, long, complex*, long, long, long*, long*, long*, long*));
extern void chseqr __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void chseqr_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cjadmm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int, int*, complex*, int, complex*, complex*, int));
extern void cjadmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long, long*, complex*, long, complex*, complex*, long));
extern void cjadrp __P((int, int, int, complex*, int*, int*, int, int*));
extern void cjadrp_64 __P((long, long, long, complex*, long*, long*, long, long*));
extern void cjadsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int*, int, int*, complex*, int, complex*, complex*, int));
extern void cjadsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long*, long, long*, complex*, long, complex*, complex*, long));
extern void clarz __P((char, int, int, int, complex*, int, complex*, complex*, int));
extern void clarz_64 __P((char, long, long, long, complex*, long, complex*, complex*, long));
extern void clarzb __P((char, char, char, char, int, int, int, int, complex*, int, complex*, int, complex*, int, int));
extern void clarzb_64 __P((char, char, char, char, long, long, long, long, complex*, long, complex*, long, complex*, long, long));
extern void clarzt __P((char, char, int, int, complex*, int, complex*, complex*, int));
extern void clarzt_64 __P((char, char, long, long, complex*, long, complex*, complex*, long));
extern void clatzm __P((char, int, int, complex*, int, complex*, complex*, complex*, int));
extern void clatzm_64 __P((char, long, long, complex*, long, complex*, complex*, complex*, long));
extern void cosqb __P((int, float*, float*));
extern void cosqb_64 __P((long, float*, float*));
extern void cosqf __P((int, float*, float*));
extern void cosqf_64 __P((long, float*, float*));
extern void cosqi __P((int, float*));
extern void cosqi_64 __P((long, float*));
extern void cost __P((int, float*, float*));
extern void cost_64 __P((long, float*, float*));
extern void costi __P((int, float*));
extern void costi_64 __P((long, float*));
extern void cpbcon __P((char, int, int, complex*, int, float, float*, int*));
extern void cpbcon_64 __P((char, long, long, complex*, long, float, float*, long*));
extern void cpbequ __P((char, int, int, complex*, int, float*, float*, float*, int*));
extern void cpbequ_64 __P((char, long, long, complex*, long, float*, float*, float*, long*));
extern void cpbrfs __P((char, int, int, int, complex*, int, complex*, int, complex*, int, complex*, int, float*, float*, int*));
extern void cpbrfs_64 __P((char, long, long, long, complex*, long, complex*, long, complex*, long, complex*, long, float*, float*, long*));
extern void cpbstf __P((char, int, int, complex*, int, int*));
extern void cpbstf_64 __P((char, long, long, complex*, long, long*));
extern void cpbsv __P((char, int, int, int, complex*, int, complex*, int, int*));
extern void cpbsv_64 __P((char, long, long, long, complex*, long, complex*, long, long*));
extern void cpbsvx __P((char, char, int, int, int, complex*, int, complex*, int, char, float*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cpbsvx_64 __P((char, char, long, long, long, complex*, long, complex*, long, char, float*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cpbtf2 __P((char, int, int, complex*, int, int*));
extern void cpbtf2_64 __P((char, long, long, complex*, long, long*));
extern void cpbtrf __P((char, int, int, complex*, int, int*));
extern void cpbtrf_64 __P((char, long, long, complex*, long, long*));
extern void cpbtrs __P((char, int, int, int, complex*, int, complex*, int, int*));
extern void cpbtrs_64 __P((char, long, long, long, complex*, long, complex*, long, long*));
extern void cpocon __P((char, int, complex*, int, float, float*, int*));
extern void cpocon_64 __P((char, long, complex*, long, float, float*, long*));
extern void cpoequ __P((int, complex*, int, float*, float*, float*, int*));
extern void cpoequ_64 __P((long, complex*, long, float*, float*, float*, long*));
extern void cporfs __P((char, int, int, complex*, int, complex*, int, complex*, int, complex*, int, float*, float*, int*));
extern void cporfs_64 __P((char, long, long, complex*, long, complex*, long, complex*, long, complex*, long, float*, float*, long*));
extern void cposv __P((char, int, int, complex*, int, complex*, int, int*));
extern void cposv_64 __P((char, long, long, complex*, long, complex*, long, long*));
extern void cposvx __P((char, char, int, int, complex*, int, complex*, int, char, float*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cposvx_64 __P((char, char, long, long, complex*, long, complex*, long, char, float*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cpotf2 __P((char, int, complex*, int, int*));
extern void cpotf2_64 __P((char, long, complex*, long, long*));
extern void cpotrf __P((char, int, complex*, int, int*));
extern void cpotrf_64 __P((char, long, complex*, long, long*));
extern void cpotri __P((char, int, complex*, int, int*));
extern void cpotri_64 __P((char, long, complex*, long, long*));
extern void cpotrs __P((char, int, int, complex*, int, complex*, int, int*));
extern void cpotrs_64 __P((char, long, long, complex*, long, complex*, long, long*));
extern void cppcon __P((char, int, complex*, float, float*, int*));
extern void cppcon_64 __P((char, long, complex*, float, float*, long*));
extern void cppequ __P((char, int, complex*, float*, float*, float*, int*));
extern void cppequ_64 __P((char, long, complex*, float*, float*, float*, long*));
extern void cpprfs __P((char, int, int, complex*, complex*, complex*, int, complex*, int, float*, float*, int*));
extern void cpprfs_64 __P((char, long, long, complex*, complex*, complex*, long, complex*, long, float*, float*, long*));
extern void cppsv __P((char, int, int, complex*, complex*, int, int*));
extern void cppsv_64 __P((char, long, long, complex*, complex*, long, long*));
extern void cppsvx __P((char, char, int, int, complex*, complex*, char, float*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cppsvx_64 __P((char, char, long, long, complex*, complex*, char, float*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cpptrf __P((char, int, complex*, int*));
extern void cpptrf_64 __P((char, long, complex*, long*));
extern void cpptri __P((char, int, complex*, int*));
extern void cpptri_64 __P((char, long, complex*, long*));
extern void cpptrs __P((char, int, int, complex*, complex*, int, int*));
extern void cpptrs_64 __P((char, long, long, complex*, complex*, long, long*));
extern void cptcon __P((int, float*, complex*, float, float*, int*));
extern void cptcon_64 __P((long, float*, complex*, float, float*, long*));
extern void cpteqr __P((char, int, float*, float*, complex*, int, int*));
extern void cpteqr_64 __P((char, long, float*, float*, complex*, long, long*));
extern void cptrfs __P((char, int, int, float*, complex*, float*, complex*, complex*, int, complex*, int, float*, float*, int*));
extern void cptrfs_64 __P((char, long, long, float*, complex*, float*, complex*, complex*, long, complex*, long, float*, float*, long*));
extern void cptsv __P((int, int, float*, complex*, complex*, int, int*));
extern void cptsv_64 __P((long, long, float*, complex*, complex*, long, long*));
extern void cptsvx __P((char, int, int, float*, complex*, float*, complex*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cptsvx_64 __P((char, long, long, float*, complex*, float*, complex*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void cpttrf __P((int, float*, complex*, int*));
extern void cpttrf_64 __P((long, float*, complex*, long*));
extern void cpttrs __P((char, int, int, float*, complex*, complex*, int, int*));
extern void cpttrs_64 __P((char, long, long, float*, complex*, complex*, long, long*));
extern void cptts2 __P((int, int, int, float*, complex*, complex*, int));
extern void cptts2_64 __P((long, long, long, float*, complex*, complex*, long));
extern void crot __P((int, complex*, int, complex*, int, float, complex*));
extern void crot_64 __P((long, complex*, long, complex*, long, float, complex*));
extern void crotg __P((complex*, complex*, float*, complex*));
extern void crotg_64 __P((complex*, complex*, float*, complex*));
extern void cscal __P((int, complex*, complex*, int));
extern void cscal_64 __P((long, complex*, complex*, long));
extern void csctr __P((int, complex*, int*, complex*));
extern void csctr_64 __P((long, complex*, long*, complex*));
extern void cskymm __P((int, int, int, int, complex*, int*, complex*, int*, complex*, int, complex*, complex*, int));
extern void cskymm_64 __P((long, long, long, long, complex*, long*, complex*, long*, complex*, long, complex*, complex*, long));
extern void cskysm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, complex*, int, complex*, complex*, int));
extern void cskysm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, complex*, long, complex*, complex*, long));
extern void cspcon __P((char, int, complex*, int*, float, float*, int*));
extern void cspcon_64 __P((char, long, complex*, long*, float, float*, long*));
extern void cspmv __P((char, int, complex*, complex*, complex*, int, complex*, complex*, int));
extern void cspmv_64 __P((char, long, complex*, complex*, complex*, long, complex*, complex*, long));
extern void csprfs __P((char, int, int, complex*, complex*, int*, complex*, int, complex*, int, float*, float*, int*));
extern void csprfs_64 __P((char, long, long, complex*, complex*, long*, complex*, long, complex*, long, float*, float*, long*));
extern void cspsv __P((char, int, int, complex*, int*, complex*, int, int*));
extern void cspsv_64 __P((char, long, long, complex*, long*, complex*, long, long*));
extern void cspsvx __P((char, char, int, int, complex*, complex*, int*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void cspsvx_64 __P((char, char, long, long, complex*, complex*, long*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void csptrf __P((char, int, complex*, int*, int*));
extern void csptrf_64 __P((char, long, complex*, long*, long*));
extern void csptri __P((char, int, complex*, int*, int*));
extern void csptri_64 __P((char, long, complex*, long*, long*));
extern void csptrs __P((char, int, int, complex*, int*, complex*, int, int*));
extern void csptrs_64 __P((char, long, long, complex*, long*, complex*, long, long*));
extern void csrot __P((int, complex*, int, complex*, int, float, float));
extern void csrot_64 __P((long, complex*, long, complex*, long, float, float));
extern void csscal __P((int, float, complex*, int));
extern void csscal_64 __P((long, float, complex*, long));
extern void cstedc __P((char, int, float*, float*, complex*, int, int*));
extern void cstedc_64 __P((char, long, float*, float*, complex*, long, long*));
extern void cstegr __P((char, char, int, float*, float*, float, float, int, int, float, int*, float*, complex*, int, int*, int*));
extern void cstegr_64 __P((char, char, long, float*, float*, float, float, long, long, float, long*, float*, complex*, long, long*, long*));
extern void cstein __P((int, float*, float*, int, float*, int*, int*, complex*, int, int*, int*));
extern void cstein_64 __P((long, float*, float*, long, float*, long*, long*, complex*, long, long*, long*));
extern void csteqr __P((char, int, float*, float*, complex*, int, int*));
extern void csteqr_64 __P((char, long, float*, float*, complex*, long, long*));
extern void cstsv __P((int, int, complex*, complex*, complex*, complex*, int, int*, int*));
extern void cstsv_64 __P((long, long, complex*, complex*, complex*, complex*, long, long*, long*));
extern void csttrf __P((int, complex*, complex*, complex*, int*, int*));
extern void csttrf_64 __P((long, complex*, complex*, complex*, long*, long*));
extern void csttrs __P((int, int, complex*, complex*, complex*, complex*, int, int*, int*));
extern void csttrs_64 __P((long, long, complex*, complex*, complex*, complex*, long, long*, long*));
extern void cswap __P((int, complex*, int, complex*, int));
extern void cswap_64 __P((long, complex*, long, complex*, long));
extern void csycon __P((char, int, complex*, int, int*, float, float*, int*));
extern void csycon_64 __P((char, long, complex*, long, long*, float, float*, long*));
extern void csymm __P((char, char, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void csymm_64 __P((char, char, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void csyr2k __P((char, char, int, int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void csyr2k_64 __P((char, char, long, long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern void csyrfs __P((char, int, int, complex*, int, complex*, int, int*, complex*, int, complex*, int, float*, float*, int*));
extern void csyrfs_64 __P((char, long, long, complex*, long, complex*, long, long*, complex*, long, complex*, long, float*, float*, long*));
extern void csyrk __P((char, char, int, int, complex*, complex*, int, complex*, complex*, int));
extern void csyrk_64 __P((char, char, long, long, complex*, complex*, long, complex*, complex*, long));
extern void csysv __P((char, int, int, complex*, int, int*, complex*, int, int*));
extern void csysv_64 __P((char, long, long, complex*, long, long*, complex*, long, long*));
extern void csysvx __P((char, char, int, int, complex*, int, complex*, int, int*, complex*, int, complex*, int, float*, float*, float*, int*));
extern void csysvx_64 __P((char, char, long, long, complex*, long, complex*, long, long*, complex*, long, complex*, long, float*, float*, float*, long*));
extern void csytf2 __P((char, int, complex*, int, int*, int*));
extern void csytf2_64 __P((char, long, complex*, long, long*, long*));
extern void csytrf __P((char, int, complex*, int, int*, int*));
extern void csytrf_64 __P((char, long, complex*, long, long*, long*));
extern void csytri __P((char, int, complex*, int, int*, int*));
extern void csytri_64 __P((char, long, complex*, long, long*, long*));
extern void csytrs __P((char, int, int, complex*, int, int*, complex*, int, int*));
extern void csytrs_64 __P((char, long, long, complex*, long, long*, complex*, long, long*));
extern void ctbcon __P((char, char, char, int, int, complex*, int, float*, int*));
extern void ctbcon_64 __P((char, char, char, long, long, complex*, long, float*, long*));
extern void ctbmv __P((char, char, char, int, int, complex*, int, complex*, int));
extern void ctbmv_64 __P((char, char, char, long, long, complex*, long, complex*, long));
extern void ctbrfs __P((char, char, char, int, int, int, complex*, int, complex*, int, complex*, int, float*, float*, int*));
extern void ctbrfs_64 __P((char, char, char, long, long, long, complex*, long, complex*, long, complex*, long, float*, float*, long*));
extern void ctbsv __P((char, char, char, int, int, complex*, int, complex*, int));
extern void ctbsv_64 __P((char, char, char, long, long, complex*, long, complex*, long));
extern void ctbtrs __P((char, char, char, int, int, int, complex*, int, complex*, int, int*));
extern void ctbtrs_64 __P((char, char, char, long, long, long, complex*, long, complex*, long, long*));
extern void ctgevc __P((char, char, int*, int, complex*, int, complex*, int, complex*, int, complex*, int, int, int*, int*));
extern void ctgevc_64 __P((char, char, long*, long, complex*, long, complex*, long, complex*, long, complex*, long, long, long*, long*));
extern void ctgexc __P((int, int, int, complex*, int, complex*, int, complex*, int, complex*, int, int*, int*, int*));
extern void ctgexc_64 __P((long, long, long, complex*, long, complex*, long, complex*, long, complex*, long, long*, long*, long*));
extern void ctgsen __P((int, int, int, int*, int, complex*, int, complex*, int, complex*, complex*, complex*, int, complex*, int, int*, float*, float*, float*, int*));
extern void ctgsen_64 __P((long, long, long, long*, long, complex*, long, complex*, long, complex*, complex*, complex*, long, complex*, long, long*, float*, float*, float*, long*));
extern void ctgsja __P((char, char, char, int, int, int, int, int, complex*, int, complex*, int, float, float, float*, float*, complex*, int, complex*, int, complex*, int, int*, int*));
extern void ctgsja_64 __P((char, char, char, long, long, long, long, long, complex*, long, complex*, long, float, float, float*, float*, complex*, long, complex*, long, complex*, long, long*, long*));
extern void ctgsna __P((char, char, int*, int, complex*, int, complex*, int, complex*, int, complex*, int, float*, float*, int, int*, int*));
extern void ctgsna_64 __P((char, char, long*, long, complex*, long, complex*, long, complex*, long, complex*, long, float*, float*, long, long*, long*));
extern void ctgsyl __P((char, int, int, int, complex*, int, complex*, int, complex*, int, complex*, int, complex*, int, complex*, int, float*, float*, int*));
extern void ctgsyl_64 __P((char, long, long, long, complex*, long, complex*, long, complex*, long, complex*, long, complex*, long, complex*, long, float*, float*, long*));
extern void ctpcon __P((char, char, char, int, complex*, float*, int*));
extern void ctpcon_64 __P((char, char, char, long, complex*, float*, long*));
extern void ctpmv __P((char, char, char, int, complex*, complex*, int));
extern void ctpmv_64 __P((char, char, char, long, complex*, complex*, long));
extern void ctprfs __P((char, char, char, int, int, complex*, complex*, int, complex*, int, float*, float*, int*));
extern void ctprfs_64 __P((char, char, char, long, long, complex*, complex*, long, complex*, long, float*, float*, long*));
extern void ctpsv __P((char, char, char, int, complex*, complex*, int));
extern void ctpsv_64 __P((char, char, char, long, complex*, complex*, long));
extern void ctptri __P((char, char, int, complex*, int*));
extern void ctptri_64 __P((char, char, long, complex*, long*));
extern void ctptrs __P((char, char, char, int, int, complex*, complex*, int, int*));
extern void ctptrs_64 __P((char, char, char, long, long, complex*, complex*, long, long*));
extern void ctrans __P((char, complex*, complex*, int, int, complex*));
extern void ctrans_64 __P((char, complex*, complex*, long, long, complex*));
extern void ctrcon __P((char, char, char, int, complex*, int, float*, int*));
extern void ctrcon_64 __P((char, char, char, long, complex*, long, float*, long*));
extern void ctrevc __P((char, char, int*, int, complex*, int, complex*, int, complex*, int, int, int*, int*));
extern void ctrevc_64 __P((char, char, long*, long, complex*, long, complex*, long, complex*, long, long, long*, long*));
extern void ctrexc __P((char, int, complex*, int, complex*, int, int, int, int*));
extern void ctrexc_64 __P((char, long, complex*, long, complex*, long, long, long, long*));
extern void ctrmm __P((char, char, char, char, int, int, complex*, complex*, int, complex*, int));
extern void ctrmm_64 __P((char, char, char, char, long, long, complex*, complex*, long, complex*, long));
extern void ctrmv __P((char, char, char, int, complex*, int, complex*, int));
extern void ctrmv_64 __P((char, char, char, long, complex*, long, complex*, long));
extern void ctrrfs __P((char, char, char, int, int, complex*, int, complex*, int, complex*, int, float*, float*, int*));
extern void ctrrfs_64 __P((char, char, char, long, long, complex*, long, complex*, long, complex*, long, float*, float*, long*));
extern void ctrsen __P((char, char, int*, int, complex*, int, complex*, int, complex*, int*, float*, float*, int*));
extern void ctrsen_64 __P((char, char, long*, long, complex*, long, complex*, long, complex*, long*, float*, float*, long*));
extern void ctrsm __P((char, char, char, char, int, int, complex*, complex*, int, complex*, int));
extern void ctrsm_64 __P((char, char, char, char, long, long, complex*, complex*, long, complex*, long));
extern void ctrsna __P((char, char, int*, int, complex*, int, complex*, int, complex*, int, float*, float*, int, int*, int, int*));
extern void ctrsna_64 __P((char, char, long*, long, complex*, long, complex*, long, complex*, long, float*, float*, long, long*, long, long*));
extern void ctrsv __P((char, char, char, int, complex*, int, complex*, int));
extern void ctrsv_64 __P((char, char, char, long, complex*, long, complex*, long));
extern void ctrsyl __P((char, char, int, int, int, complex*, int, complex*, int, complex*, int, float*, int*));
extern void ctrsyl_64 __P((char, char, long, long, long, complex*, long, complex*, long, complex*, long, float*, long*));
extern void ctrti2 __P((char, char, int, complex*, int, int*));
extern void ctrti2_64 __P((char, char, long, complex*, long, long*));
extern void ctrtri __P((char, char, int, complex*, int, int*));
extern void ctrtri_64 __P((char, char, long, complex*, long, long*));
extern void ctrtrs __P((char, char, char, int, int, complex*, int, complex*, int, int*));
extern void ctrtrs_64 __P((char, char, char, long, long, complex*, long, complex*, long, long*));
extern void ctzrqf __P((int, int, complex*, int, complex*, int*));
extern void ctzrqf_64 __P((long, long, complex*, long, complex*, long*));
extern void ctzrzf __P((int, int, complex*, int, complex*, int*));
extern void ctzrzf_64 __P((long, long, complex*, long, complex*, long*));
extern void cung2l __P((int, int, int, complex*, int, complex*, int*));
extern void cung2l_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cung2r __P((int, int, int, complex*, int, complex*, int*));
extern void cung2r_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungbr __P((char, int, int, int, complex*, int, complex*, int*));
extern void cungbr_64 __P((char, long, long, long, complex*, long, complex*, long*));
extern void cunghr __P((int, int, int, complex*, int, complex*, int*));
extern void cunghr_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungl2 __P((int, int, int, complex*, int, complex*, int*));
extern void cungl2_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cunglq __P((int, int, int, complex*, int, complex*, int*));
extern void cunglq_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungql __P((int, int, int, complex*, int, complex*, int*));
extern void cungql_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungqr __P((int, int, int, complex*, int, complex*, int*));
extern void cungqr_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungr2 __P((int, int, int, complex*, int, complex*, int*));
extern void cungr2_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungrq __P((int, int, int, complex*, int, complex*, int*));
extern void cungrq_64 __P((long, long, long, complex*, long, complex*, long*));
extern void cungtr __P((char, int, complex*, int, complex*, int*));
extern void cungtr_64 __P((char, long, complex*, long, complex*, long*));
extern void cunmbr __P((char, char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmbr_64 __P((char, char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmhr __P((char, char, int, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmhr_64 __P((char, char, long, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunml2 __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunml2_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmlq __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmlq_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmql __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmql_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmqr __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmqr_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmr2 __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmr2_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmrq __P((char, char, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmrq_64 __P((char, char, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmrz __P((char, char, int, int, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmrz_64 __P((char, char, long, long, long, long, complex*, long, complex*, complex*, long, long*));
extern void cunmtr __P((char, char, char, int, int, complex*, int, complex*, complex*, int, int*));
extern void cunmtr_64 __P((char, char, char, long, long, complex*, long, complex*, complex*, long, long*));
extern void cupgtr __P((char, int, complex*, complex*, complex*, int, int*));
extern void cupgtr_64 __P((char, long, complex*, complex*, complex*, long, long*));
extern void cupmtr __P((char, char, char, int, int, complex*, complex*, complex*, int, int*));
extern void cupmtr_64 __P((char, char, char, long, long, complex*, complex*, complex*, long, long*));
extern void cvbrmm __P((int, int, int, int, complex*, int*, complex*, int*, int*, int*, int*, int*, int*, complex*, int, complex*, complex*, int));
extern void cvbrmm_64 __P((long, long, long, long, complex*, long*, complex*, long*, long*, long*, long*, long*, long*, complex*, long, complex*, complex*, long));
extern void cvbrsm __P((int, int, int, int, complex*, complex*, int*, complex*, int*, int*, int*, int*, int*, int*, complex*, int, complex*, complex*, int));
extern void cvbrsm_64 __P((long, long, long, long, complex*, complex*, long*, complex*, long*, long*, long*, long*, long*, long*, complex*, long, complex*, complex*, long));
extern void cvmul __P((int, complex*, complex*, int, complex*, int, complex*, complex*, int));
extern void cvmul_64 __P((long, complex*, complex*, long, complex*, long, complex*, complex*, long));
extern double dasum __P((int, double*, int));
extern double dasum_64 __P((long, double*, long));
extern void daxpy __P((int, double, double*, int, double*, int));
extern void daxpy_64 __P((long, double, double*, long, double*, long));
extern void daxpyi __P((int, double, double*, int*, double*));
extern void daxpyi_64 __P((long, double, double*, long*, double*));
extern void dbcomm __P((int, int, int, int, double, int*, double*, int*, int*, int, int, double*, int, double, double*, int));
extern void dbcomm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long, long, double*, long, double, double*, long));
extern void dbdimm __P((int, int, int, int, double, int*, double*, int, int*, int, int, double*, int, double, double*, int));
extern void dbdimm_64 __P((long, long, long, long, double, long*, double*, long, long*, long, long, double*, long, double, double*, long));
extern void dbdism __P((int, int, int, int, double*, double, int*, double*, int, int*, int, int, double*, int, double, double*, int));
extern void dbdism_64 __P((long, long, long, long, double*, double, long*, double*, long, long*, long, long, double*, long, double, double*, long));
extern void dbdsdc __P((char, char, int, double*, double*, double*, int, double*, int, double*, int*, int*));
extern void dbdsdc_64 __P((char, char, long, double*, double*, double*, long, double*, long, double*, long*, long*));
extern void dbdsqr __P((char, int, int, int, int, double*, double*, double*, int, double*, int, double*, int, int*));
extern void dbdsqr_64 __P((char, long, long, long, long, double*, double*, double*, long, double*, long, double*, long, long*));
extern void dbelmm __P((int, int, int, int, double, int*, double*, int*, int, int, int, double*, int, double, double*, int));
extern void dbelmm_64 __P((long, long, long, long, double, long*, double*, long*, long, long, long, double*, long, double, double*, long));
extern void dbelsm __P((int, int, int, int, double*, double, int*, double*, int*, int, int, int, double*, int, double, double*, int));
extern void dbelsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long, long, long, double*, long, double, double*, long));
extern void dbscmm __P((int, int, int, int, double, int*, double*, int*, int*, int*, int, double*, int, double, double*, int));
extern void dbscmm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long*, long, double*, long, double, double*, long));
extern void dbscsm __P((int, int, int, int, double*, double, int*, double*, int*, int*, int*, int, double*, int, double, double*, int));
extern void dbscsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long*, long*, long, double*, long, double, double*, long));
extern void dbsrmm __P((int, int, int, int, double, int*, double*, int*, int*, int*, int, double*, int, double, double*, int));
extern void dbsrmm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long*, long, double*, long, double, double*, long));
extern void dbsrsm __P((int, int, int, int, double*, double, int*, double*, int*, int*, int*, int, double*, int, double, double*, int));
extern void dbsrsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long*, long*, long, double*, long, double, double*, long));
extern void dcnvcor __P((char, char, int, double*, int, int, int, int, int, double*, int, int, int, int, int, double*, int, int, int, double*, int));
extern void dcnvcor_64 __P((char, char, long, double*, long, long, long, long, long, double*, long, long, long, long, long, double*, long, long, long, double*, long));
extern void dcnvcor2 __P((char, char, char, char, char, char, int, int, double*, int, int, int, int, int, double*, int, int, int, double*, int, doublecomplex*, int));
extern void dcnvcor2_64 __P((char, char, char, char, char, char, long, long, double*, long, long, long, long, long, double*, long, long, long, double*, long, doublecomplex*, long));
extern void dcoomm __P((int, int, int, int, double, int*, double*, int*, int*, int, double*, int, double, double*, int));
extern void dcoomm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long, double*, long, double, double*, long));
extern void dcopy __P((int, double*, int, double*, int));
extern void dcopy_64 __P((long, double*, long, double*, long));
extern void dcosqb __P((int, double*, double*));
extern void dcosqb_64 __P((long, double*, double*));
extern void dcosqf __P((int, double*, double*));
extern void dcosqf_64 __P((long, double*, double*));
extern void dcosqi __P((int, double*));
extern void dcosqi_64 __P((long, double*));
extern void dcost __P((int, double*, double*));
extern void dcost_64 __P((long, double*, double*));
extern void dcosti __P((int, double*));
extern void dcosti_64 __P((long, double*));
extern void dcscmm __P((int, int, int, int, double, int*, double*, int*, int*, int*, double*, int, double, double*, int));
extern void dcscmm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long*, double*, long, double, double*, long));
extern void dcscsm __P((int, int, int, int, double*, double, int*, double*, int*, int*, int*, double*, int, double, double*, int));
extern void dcscsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long*, long*, double*, long, double, double*, long));
extern void dcsrmm __P((int, int, int, int, double, int*, double*, int*, int*, int*, double*, int, double, double*, int));
extern void dcsrmm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long*, double*, long, double, double*, long));
extern void dcsrsm __P((int, int, int, int, double*, double, int*, double*, int*, int*, int*, double*, int, double, double*, int));
extern void dcsrsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long*, long*, double*, long, double, double*, long));
extern void ddiamm __P((int, int, int, int, double, int*, double*, int, int*, int, double*, int, double, double*, int));
extern void ddiamm_64 __P((long, long, long, long, double, long*, double*, long, long*, long, double*, long, double, double*, long));
extern void ddiasm __P((int, int, int, int, double*, double, int*, double*, int, int*, int, double*, int, double, double*, int));
extern void ddiasm_64 __P((long, long, long, long, double*, double, long*, double*, long, long*, long, double*, long, double, double*, long));
extern void ddisna __P((char, int, int, double*, double*, int*));
extern void ddisna_64 __P((char, long, long, double*, double*, long*));
extern double ddot __P((int, double*, int, double*, int));
extern double ddot_64 __P((long, double*, long, double*, long));
extern double ddoti __P((int, double*, int*, double*));
extern double ddoti_64 __P((long, double*, long*, double*));
extern void dellmm __P((int, int, int, int, double, int*, double*, int*, int, int, double*, int, double, double*, int));
extern void dellmm_64 __P((long, long, long, long, double, long*, double*, long*, long, long, double*, long, double, double*, long));
extern void dellsm __P((int, int, int, int, double*, double, int*, double*, int*, int, int, double*, int, double, double*, int));
extern void dellsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long, long, double*, long, double, double*, long));
extern void dezftb __P((int, double*, double, double*, double*, double*));
extern void dezftb_64 __P((long, double*, double, double*, double*, double*));
extern void dezftf __P((int, double*, double, double*, double*, double*));
extern void dezftf_64 __P((long, double*, double, double*, double*, double*));
extern void dezfti __P((int, double*));
extern void dezfti_64 __P((long, double*));
extern void dfft2b __P((char, int, int, double*, int, double*, int, double*, int));
extern void dfft2b_64 __P((char, long, long, double*, long, double*, long, double*, long));
extern void dfft2f __P((char, char, int, int, double*, int, double*, int, double*, int));
extern void dfft2f_64 __P((char, char, long, long, double*, long, double*, long, double*, long));
extern void dfft2i __P((int, int, double*));
extern void dfft2i_64 __P((long, long, double*));
extern void dfft3b __P((char, int, int, int, double*, int, double*, int, double*, int));
extern void dfft3b_64 __P((char, long, long, long, double*, long, double*, long, double*, long));
extern void dfft3f __P((char, char, int, int, int, double*, int, double*, int, double*, int));
extern void dfft3f_64 __P((char, char, long, long, long, double*, long, double*, long, double*, long));
extern void dfft3i __P((int, int, int, double*));
extern void dfft3i_64 __P((long, long, long, double*));
extern void dfftb __P((int, double*, double*));
extern void dfftb_64 __P((long, double*, double*));
extern void dfftf __P((int, double*, double*));
extern void dfftf_64 __P((long, double*, double*));
extern void dffti __P((int, double*));
extern void dffti_64 __P((long, double*));
extern int dfftopt __P((int));
extern long dfftopt_64 __P((long));
extern void dgbbrd __P((char, int, int, int, int, int, double*, int, double*, double*, double*, int, double*, int, double*, int, int*));
extern void dgbbrd_64 __P((char, long, long, long, long, long, double*, long, double*, double*, double*, long, double*, long, double*, long, long*));
extern void dgbcon __P((char, int, int, int, double*, int, int*, double, double*, int*));
extern void dgbcon_64 __P((char, long, long, long, double*, long, long*, double, double*, long*));
extern void dgbequ __P((int, int, int, int, double*, int, double*, double*, double*, double*, double*, int*));
extern void dgbequ_64 __P((long, long, long, long, double*, long, double*, double*, double*, double*, double*, long*));
extern void dgbmv __P((char, int, int, int, int, double, double*, int, double*, int, double, double*, int));
extern void dgbmv_64 __P((char, long, long, long, long, double, double*, long, double*, long, double, double*, long));
extern void dgbrfs __P((char, int, int, int, int, double*, int, double*, int, int*, double*, int, double*, int, double*, double*, int*));
extern void dgbrfs_64 __P((char, long, long, long, long, double*, long, double*, long, long*, double*, long, double*, long, double*, double*, long*));
extern void dgbsv __P((int, int, int, int, double*, int, int*, double*, int, int*));
extern void dgbsv_64 __P((long, long, long, long, double*, long, long*, double*, long, long*));
extern void dgbsvx __P((char, char, int, int, int, int, double*, int, double*, int, int*, char, double*, double*, double*, int, double*, int, double*, double*, double*, int*));
extern void dgbsvx_64 __P((char, char, long, long, long, long, double*, long, double*, long, long*, char, double*, double*, double*, long, double*, long, double*, double*, double*, long*));
extern void dgbtf2 __P((int, int, int, int, double*, int, int*, int*));
extern void dgbtf2_64 __P((long, long, long, long, double*, long, long*, long*));
extern void dgbtrf __P((int, int, int, int, double*, int, int*, int*));
extern void dgbtrf_64 __P((long, long, long, long, double*, long, long*, long*));
extern void dgbtrs __P((char, int, int, int, int, double*, int, int*, double*, int, int*));
extern void dgbtrs_64 __P((char, long, long, long, long, double*, long, long*, double*, long, long*));
extern void dgebak __P((char, char, int, int, int, double*, int, double*, int, int*));
extern void dgebak_64 __P((char, char, long, long, long, double*, long, double*, long, long*));
extern void dgebal __P((char, int, double*, int, int*, int*, double*, int*));
extern void dgebal_64 __P((char, long, double*, long, long*, long*, double*, long*));
extern void dgebrd __P((int, int, double*, int, double*, double*, double*, double*, int*));
extern void dgebrd_64 __P((long, long, double*, long, double*, double*, double*, double*, long*));
extern void dgecon __P((char, int, double*, int, double, double*, int*));
extern void dgecon_64 __P((char, long, double*, long, double, double*, long*));
extern void dgeequ __P((int, int, double*, int, double*, double*, double*, double*, double*, int*));
extern void dgeequ_64 __P((long, long, double*, long, double*, double*, double*, double*, double*, long*));
extern void dgees __P((char, char, int(*select)(double,double), int, double*, int, int*, double*, double*, double*, int, int*));
extern void dgees_64 __P((char, char, long(*select)(double,double), long, double*, long, long*, double*, double*, double*, long, long*));
extern void dgeesx __P((char, char, int(*select)(double,double), char, int, double*, int, int*, double*, double*, double*, int, double*, double*, int*));
extern void dgeesx_64 __P((char, char, long(*select)(double,double), char, long, double*, long, long*, double*, double*, double*, long, double*, double*, long*));
extern void dgeev __P((char, char, int, double*, int, double*, double*, double*, int, double*, int, int*));
extern void dgeev_64 __P((char, char, long, double*, long, double*, double*, double*, long, double*, long, long*));
extern void dgeevx __P((char, char, char, char, int, double*, int, double*, double*, double*, int, double*, int, int*, int*, double*, double*, double*, double*, int*));
extern void dgeevx_64 __P((char, char, char, char, long, double*, long, double*, double*, double*, long, double*, long, long*, long*, double*, double*, double*, double*, long*));
extern void dgegs __P((char, char, int, double*, int, double*, int, double*, double*, double*, double*, int, double*, int, int*));
extern void dgegs_64 __P((char, char, long, double*, long, double*, long, double*, double*, double*, double*, long, double*, long, long*));
extern void dgegv __P((char, char, int, double*, int, double*, int, double*, double*, double*, double*, int, double*, int, int*));
extern void dgegv_64 __P((char, char, long, double*, long, double*, long, double*, double*, double*, double*, long, double*, long, long*));
extern void dgehrd __P((int, int, int, double*, int, double*, int*));
extern void dgehrd_64 __P((long, long, long, double*, long, double*, long*));
extern void dgelqf __P((int, int, double*, int, double*, int*));
extern void dgelqf_64 __P((long, long, double*, long, double*, long*));
extern void dgels __P((char, int, int, int, double*, int, double*, int, int*));
extern void dgels_64 __P((char, long, long, long, double*, long, double*, long, long*));
extern void dgelsd __P((int, int, int, double*, int, double*, int, double*, double, int*, int*));
extern void dgelsd_64 __P((long, long, long, double*, long, double*, long, double*, double, long*, long*));
extern void dgelss __P((int, int, int, double*, int, double*, int, double*, double, int*, int*));
extern void dgelss_64 __P((long, long, long, double*, long, double*, long, double*, double, long*, long*));
extern void dgelsx __P((int, int, int, double*, int, double*, int, int*, double, int*, int*));
extern void dgelsx_64 __P((long, long, long, double*, long, double*, long, long*, double, long*, long*));
extern void dgelsy __P((int, int, int, double*, int, double*, int, int*, double, int*, int*));
extern void dgelsy_64 __P((long, long, long, double*, long, double*, long, long*, double, long*, long*));
extern void dgemm __P((char, char, int, int, int, double, double*, int, double*, int, double, double*, int));
extern void dgemm_64 __P((char, char, long, long, long, double, double*, long, double*, long, double, double*, long));
extern void dgemv __P((char, int, int, double, double*, int, double*, int, double, double*, int));
extern void dgemv_64 __P((char, long, long, double, double*, long, double*, long, double, double*, long));
extern void dgeqlf __P((int, int, double*, int, double*, int*));
extern void dgeqlf_64 __P((long, long, double*, long, double*, long*));
extern void dgeqp3 __P((int, int, double*, int, int*, double*, int*));
extern void dgeqp3_64 __P((long, long, double*, long, long*, double*, long*));
extern void dgeqpf __P((int, int, double*, int, int*, double*, int*));
extern void dgeqpf_64 __P((long, long, double*, long, long*, double*, long*));
extern void dgeqrf __P((int, int, double*, int, double*, int*));
extern void dgeqrf_64 __P((long, long, double*, long, double*, long*));
extern void dger __P((int, int, double, double*, int, double*, int, double*, int));
extern void dger_64 __P((long, long, double, double*, long, double*, long, double*, long));
extern void dgerfs __P((char, int, int, double*, int, double*, int, int*, double*, int, double*, int, double*, double*, int*));
extern void dgerfs_64 __P((char, long, long, double*, long, double*, long, long*, double*, long, double*, long, double*, double*, long*));
extern void dgerqf __P((int, int, double*, int, double*, int*));
extern void dgerqf_64 __P((long, long, double*, long, double*, long*));
extern void dgesdd __P((char, int, int, double*, int, double*, double*, int, double*, int, int*));
extern void dgesdd_64 __P((char, long, long, double*, long, double*, double*, long, double*, long, long*));
extern void dgesv __P((int, int, double*, int, int*, double*, int, int*));
extern void dgesv_64 __P((long, long, double*, long, long*, double*, long, long*));
extern void dgesvd __P((char, char, int, int, double*, int, double*, double*, int, double*, int, int*));
extern void dgesvd_64 __P((char, char, long, long, double*, long, double*, double*, long, double*, long, long*));
extern void dgesvx __P((char, char, int, int, double*, int, double*, int, int*, char, double*, double*, double*, int, double*, int, double*, double*, double*, int*));
extern void dgesvx_64 __P((char, char, long, long, double*, long, double*, long, long*, char, double*, double*, double*, long, double*, long, double*, double*, double*, long*));
extern void dgetf2 __P((int, int, double*, int, int*, int*));
extern void dgetf2_64 __P((long, long, double*, long, long*, long*));
extern void dgetrf __P((int, int, double*, int, int*, int*));
extern void dgetrf_64 __P((long, long, double*, long, long*, long*));
extern void dgetri __P((int, double*, int, int*, int*));
extern void dgetri_64 __P((long, double*, long, long*, long*));
extern void dgetrs __P((char, int, int, double*, int, int*, double*, int, int*));
extern void dgetrs_64 __P((char, long, long, double*, long, long*, double*, long, long*));
extern void dggbak __P((char, char, int, int, int, double*, double*, int, double*, int, int*));
extern void dggbak_64 __P((char, char, long, long, long, double*, double*, long, double*, long, long*));
extern void dggbal __P((char, int, double*, int, double*, int, int*, int*, double*, double*, int*));
extern void dggbal_64 __P((char, long, double*, long, double*, long, long*, long*, double*, double*, long*));
extern void dgges __P((char, char, char, int(*delctg)(double,double,double), int, double*, int, double*, int, int*, double*, double*, double*, double*, int, double*, int, int*));
extern void dgges_64 __P((char, char, char, long(*delctg)(double,double,double), long, double*, long, double*, long, long*, double*, double*, double*, double*, long, double*, long, long*));
extern void dggesx __P((char, char, char, int(*delctg)(double,double,double), char, int, double*, int, double*, int, int*, double*, double*, double*, double*, int, double*, int, double*, double*, int*));
extern void dggesx_64 __P((char, char, char, long(*delctg)(double,double,double), char, long, double*, long, double*, long, long*, double*, double*, double*, double*, long, double*, long, double*, double*, long*));
extern void dggev __P((char, char, int, double*, int, double*, int, double*, double*, double*, double*, int, double*, int, int*));
extern void dggev_64 __P((char, char, long, double*, long, double*, long, double*, double*, double*, double*, long, double*, long, long*));
extern void dggevx __P((char, char, char, char, int, double*, int, double*, int, double*, double*, double*, double*, int, double*, int, int*, int*, double*, double*, double*, double*, double*, double*, int*));
extern void dggevx_64 __P((char, char, char, char, long, double*, long, double*, long, double*, double*, double*, double*, long, double*, long, long*, long*, double*, double*, double*, double*, double*, double*, long*));
extern void dggglm __P((int, int, int, double*, int, double*, int, double*, double*, double*, int*));
extern void dggglm_64 __P((long, long, long, double*, long, double*, long, double*, double*, double*, long*));
extern void dgghrd __P((char, char, int, int, int, double*, int, double*, int, double*, int, double*, int, int*));
extern void dgghrd_64 __P((char, char, long, long, long, double*, long, double*, long, double*, long, double*, long, long*));
extern void dgglse __P((int, int, int, double*, int, double*, int, double*, double*, double*, int*));
extern void dgglse_64 __P((long, long, long, double*, long, double*, long, double*, double*, double*, long*));
extern void dggqrf __P((int, int, int, double*, int, double*, double*, int, double*, int*));
extern void dggqrf_64 __P((long, long, long, double*, long, double*, double*, long, double*, long*));
extern void dggrqf __P((int, int, int, double*, int, double*, double*, int, double*, int*));
extern void dggrqf_64 __P((long, long, long, double*, long, double*, double*, long, double*, long*));
extern void dggsvd __P((char, char, char, int, int, int, int*, int*, double*, int, double*, int, double*, double*, double*, int, double*, int, double*, int, int*, int*));
extern void dggsvd_64 __P((char, char, char, long, long, long, long*, long*, double*, long, double*, long, double*, double*, double*, long, double*, long, double*, long, long*, long*));
extern void dggsvp __P((char, char, char, int, int, int, double*, int, double*, int, double, double, int*, int*, double*, int, double*, int, double*, int, int*));
extern void dggsvp_64 __P((char, char, char, long, long, long, double*, long, double*, long, double, double, long*, long*, double*, long, double*, long, double*, long, long*));
extern void dgtcon __P((char, int, double*, double*, double*, double*, int*, double, double*, int*));
extern void dgtcon_64 __P((char, long, double*, double*, double*, double*, long*, double, double*, long*));
extern void dgthr __P((int, double*, double*, int*));
extern void dgthr_64 __P((long, double*, double*, long*));
extern void dgthrz __P((int, double*, double*, int*));
extern void dgthrz_64 __P((long, double*, double*, long*));
extern void dgtrfs __P((char, int, int, double*, double*, double*, double*, double*, double*, double*, int*, double*, int, double*, int, double*, double*, int*));
extern void dgtrfs_64 __P((char, long, long, double*, double*, double*, double*, double*, double*, double*, long*, double*, long, double*, long, double*, double*, long*));
extern void dgtsv __P((int, int, double*, double*, double*, double*, int, int*));
extern void dgtsv_64 __P((long, long, double*, double*, double*, double*, long, long*));
extern void dgtsvx __P((char, char, int, int, double*, double*, double*, double*, double*, double*, double*, int*, double*, int, double*, int, double*, double*, double*, int*));
extern void dgtsvx_64 __P((char, char, long, long, double*, double*, double*, double*, double*, double*, double*, long*, double*, long, double*, long, double*, double*, double*, long*));
extern void dgttrf __P((int, double*, double*, double*, double*, int*, int*));
extern void dgttrf_64 __P((long, double*, double*, double*, double*, long*, long*));
extern void dgttrs __P((char, int, int, double*, double*, double*, double*, int*, double*, int, int*));
extern void dgttrs_64 __P((char, long, long, double*, double*, double*, double*, long*, double*, long, long*));
extern void dhgeqz __P((char, char, char, int, int, int, double*, int, double*, int, double*, double*, double*, double*, int, double*, int, int*));
extern void dhgeqz_64 __P((char, char, char, long, long, long, double*, long, double*, long, double*, double*, double*, double*, long, double*, long, long*));
extern void dhsein __P((char, char, char, int*, int, double*, int, double*, double*, double*, int, double*, int, int, int*, int*, int*, int*));
extern void dhsein_64 __P((char, char, char, long*, long, double*, long, double*, double*, double*, long, double*, long, long, long*, long*, long*, long*));
extern void dhseqr __P((char, char, int, int, int, double*, int, double*, double*, double*, int, int*));
extern void dhseqr_64 __P((char, char, long, long, long, double*, long, double*, double*, double*, long, long*));
extern void djadmm __P((int, int, int, int, double, int*, double*, int*, int*, int, int*, double*, int, double, double*, int));
extern void djadmm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long, long*, double*, long, double, double*, long));
extern void djadrp __P((int, int, int, double*, int*, int*, int, int*));
extern void djadrp_64 __P((long, long, long, double*, long*, long*, long, long*));
extern void djadsm __P((int, int, int, int, double*, double, int*, double*, int*, int*, int, int*, double*, int, double, double*, int));
extern void djadsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long*, long, long*, double*, long, double, double*, long));
extern void dlaeda __P((int, int, int, int, int*, int*, int*, int*, double*, double*, int*, double*, double*, int*));
extern void dlaeda_64 __P((long, long, long, long, long*, long*, long*, long*, double*, double*, long*, double*, double*, long*));
extern void dlagtf __P((int, double*, double, double*, double*, double, double*, int*, int*));
extern void dlagtf_64 __P((long, double*, double, double*, double*, double, double*, long*, long*));
extern void dlamrg __P((int, int, double*, int, int, int*));
extern void dlamrg_64 __P((long, long, double*, long, long, long*));
extern void dlanv2 __P((double, double, double, double, double*, double*, double*, double*, double*, double*));
extern void dlanv2_64 __P((double, double, double, double, double*, double*, double*, double*, double*, double*));
extern void dlarz __P((char, int, int, int, double*, int, double, double*, int));
extern void dlarz_64 __P((char, long, long, long, double*, long, double, double*, long));
extern void dlarzb __P((char, char, char, char, int, int, int, int, double*, int, double*, int, double*, int, int));
extern void dlarzb_64 __P((char, char, char, char, long, long, long, long, double*, long, double*, long, double*, long, long));
extern void dlarzt __P((char, char, int, int, double*, int, double*, double*, int));
extern void dlarzt_64 __P((char, char, long, long, double*, long, double*, double*, long));
extern void dlasq1 __P((int, double*, double*, double*, int*));
extern void dlasq1_64 __P((long, double*, double*, double*, long*));
extern void dlasq2 __P((int, double*, int*));
extern void dlasq2_64 __P((long, double*, long*));
extern void dlasrt __P((char, int, double*, int*));
extern void dlasrt_64 __P((char, long, double*, long*));
extern void dlatzm __P((char, int, int, double*, int, double, double*, double*, int));
extern void dlatzm_64 __P((char, long, long, double*, long, double, double*, double*, long));
extern double dnrm2 __P((int, double*, int));
extern double dnrm2_64 __P((long, double*, long));
extern void dopgtr __P((char, int, double*, double*, double*, int, int*));
extern void dopgtr_64 __P((char, long, double*, double*, double*, long, long*));
extern void dopmtr __P((char, char, char, int, int, double*, double*, double*, int, int*));
extern void dopmtr_64 __P((char, char, char, long, long, double*, double*, double*, long, long*));
extern void dorg2l __P((int, int, int, double*, int, double*, int*));
extern void dorg2l_64 __P((long, long, long, double*, long, double*, long*));
extern void dorg2r __P((int, int, int, double*, int, double*, int*));
extern void dorg2r_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgbr __P((char, int, int, int, double*, int, double*, int*));
extern void dorgbr_64 __P((char, long, long, long, double*, long, double*, long*));
extern void dorghr __P((int, int, int, double*, int, double*, int*));
extern void dorghr_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgl2 __P((int, int, int, double*, int, double*, int*));
extern void dorgl2_64 __P((long, long, long, double*, long, double*, long*));
extern void dorglq __P((int, int, int, double*, int, double*, int*));
extern void dorglq_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgql __P((int, int, int, double*, int, double*, int*));
extern void dorgql_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgqr __P((int, int, int, double*, int, double*, int*));
extern void dorgqr_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgr2 __P((int, int, int, double*, int, double*, int*));
extern void dorgr2_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgrq __P((int, int, int, double*, int, double*, int*));
extern void dorgrq_64 __P((long, long, long, double*, long, double*, long*));
extern void dorgtr __P((char, int, double*, int, double*, int*));
extern void dorgtr_64 __P((char, long, double*, long, double*, long*));
extern void dorm2l __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dorm2l_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dorm2r __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dorm2r_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormbr __P((char, char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dormbr_64 __P((char, char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormhr __P((char, char, int, int, int, int, double*, int, double*, double*, int, int*));
extern void dormhr_64 __P((char, char, long, long, long, long, double*, long, double*, double*, long, long*));
extern void dorml2 __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dorml2_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormlq __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dormlq_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormql __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dormql_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormqr __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dormqr_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormr2 __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dormr2_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormr3 __P((char, char, int, int, int, int, double*, int, double*, double*, int, int*));
extern void dormr3_64 __P((char, char, long, long, long, long, double*, long, double*, double*, long, long*));
extern void dormrq __P((char, char, int, int, int, double*, int, double*, double*, int, int*));
extern void dormrq_64 __P((char, char, long, long, long, double*, long, double*, double*, long, long*));
extern void dormrz __P((char, char, int, int, int, int, double*, int, double*, double*, int, int*));
extern void dormrz_64 __P((char, char, long, long, long, long, double*, long, double*, double*, long, long*));
extern void dormtr __P((char, char, char, int, int, double*, int, double*, double*, int, int*));
extern void dormtr_64 __P((char, char, char, long, long, double*, long, double*, double*, long, long*));
extern void dpbcon __P((char, int, int, double*, int, double, double*, int*));
extern void dpbcon_64 __P((char, long, long, double*, long, double, double*, long*));
extern void dpbequ __P((char, int, int, double*, int, double*, double*, double*, int*));
extern void dpbequ_64 __P((char, long, long, double*, long, double*, double*, double*, long*));
extern void dpbrfs __P((char, int, int, int, double*, int, double*, int, double*, int, double*, int, double*, double*, int*));
extern void dpbrfs_64 __P((char, long, long, long, double*, long, double*, long, double*, long, double*, long, double*, double*, long*));
extern void dpbstf __P((char, int, int, double*, int, int*));
extern void dpbstf_64 __P((char, long, long, double*, long, long*));
extern void dpbsv __P((char, int, int, int, double*, int, double*, int, int*));
extern void dpbsv_64 __P((char, long, long, long, double*, long, double*, long, long*));
extern void dpbsvx __P((char, char, int, int, int, double*, int, double*, int, char, double*, double*, int, double*, int, double*, double*, double*, int*));
extern void dpbsvx_64 __P((char, char, long, long, long, double*, long, double*, long, char, double*, double*, long, double*, long, double*, double*, double*, long*));
extern void dpbtf2 __P((char, int, int, double*, int, int*));
extern void dpbtf2_64 __P((char, long, long, double*, long, long*));
extern void dpbtrf __P((char, int, int, double*, int, int*));
extern void dpbtrf_64 __P((char, long, long, double*, long, long*));
extern void dpbtrs __P((char, int, int, int, double*, int, double*, int, int*));
extern void dpbtrs_64 __P((char, long, long, long, double*, long, double*, long, long*));
extern void BLAS_dpermute __P((int, int*, int, double*, int));
extern void BLAS_dpermute_64 __P((long, long*, long, double*, long));
extern void dpermute __P((int, int*, int, double*, int));
extern void dpermute_64 __P((long, long*, long, double*, long));
extern void dpocon __P((char, int, double*, int, double, double*, int*));
extern void dpocon_64 __P((char, long, double*, long, double, double*, long*));
extern void dpoequ __P((int, double*, int, double*, double*, double*, int*));
extern void dpoequ_64 __P((long, double*, long, double*, double*, double*, long*));
extern void dporfs __P((char, int, int, double*, int, double*, int, double*, int, double*, int, double*, double*, int*));
extern void dporfs_64 __P((char, long, long, double*, long, double*, long, double*, long, double*, long, double*, double*, long*));
extern void dposv __P((char, int, int, double*, int, double*, int, int*));
extern void dposv_64 __P((char, long, long, double*, long, double*, long, long*));
extern void dposvx __P((char, char, int, int, double*, int, double*, int, char, double*, double*, int, double*, int, double*, double*, double*, int*));
extern void dposvx_64 __P((char, char, long, long, double*, long, double*, long, char, double*, double*, long, double*, long, double*, double*, double*, long*));
extern void dpotf2 __P((char, int, double*, int, int*));
extern void dpotf2_64 __P((char, long, double*, long, long*));
extern void dpotrf __P((char, int, double*, int, int*));
extern void dpotrf_64 __P((char, long, double*, long, long*));
extern void dpotri __P((char, int, double*, int, int*));
extern void dpotri_64 __P((char, long, double*, long, long*));
extern void dpotrs __P((char, int, int, double*, int, double*, int, int*));
extern void dpotrs_64 __P((char, long, long, double*, long, double*, long, long*));
extern void dppcon __P((char, int, double*, double, double*, int*));
extern void dppcon_64 __P((char, long, double*, double, double*, long*));
extern void dppequ __P((char, int, double*, double*, double*, double*, int*));
extern void dppequ_64 __P((char, long, double*, double*, double*, double*, long*));
extern void dpprfs __P((char, int, int, double*, double*, double*, int, double*, int, double*, double*, int*));
extern void dpprfs_64 __P((char, long, long, double*, double*, double*, long, double*, long, double*, double*, long*));
extern void dppsv __P((char, int, int, double*, double*, int, int*));
extern void dppsv_64 __P((char, long, long, double*, double*, long, long*));
extern void dppsvx __P((char, char, int, int, double*, double*, char, double*, double*, int, double*, int, double*, double*, double*, int*));
extern void dppsvx_64 __P((char, char, long, long, double*, double*, char, double*, double*, long, double*, long, double*, double*, double*, long*));
extern void dpptrf __P((char, int, double*, int*));
extern void dpptrf_64 __P((char, long, double*, long*));
extern void dpptri __P((char, int, double*, int*));
extern void dpptri_64 __P((char, long, double*, long*));
extern void dpptrs __P((char, int, int, double*, double*, int, int*));
extern void dpptrs_64 __P((char, long, long, double*, double*, long, long*));
extern void dptcon __P((int, double*, double*, double, double*, int*));
extern void dptcon_64 __P((long, double*, double*, double, double*, long*));
extern void dpteqr __P((char, int, double*, double*, double*, int, int*));
extern void dpteqr_64 __P((char, long, double*, double*, double*, long, long*));
extern void dptrfs __P((int, int, double*, double*, double*, double*, double*, int, double*, int, double*, double*, int*));
extern void dptrfs_64 __P((long, long, double*, double*, double*, double*, double*, long, double*, long, double*, double*, long*));
extern void dptsv __P((int, int, double*, double*, double*, int, int*));
extern void dptsv_64 __P((long, long, double*, double*, double*, long, long*));
extern void dptsvx __P((char, int, int, double*, double*, double*, double*, double*, int, double*, int, double*, double*, double*, int*));
extern void dptsvx_64 __P((char, long, long, double*, double*, double*, double*, double*, long, double*, long, double*, double*, double*, long*));
extern void dpttrf __P((int, double*, double*, int*));
extern void dpttrf_64 __P((long, double*, double*, long*));
extern void dpttrs __P((int, int, double*, double*, double*, int, int*));
extern void dpttrs_64 __P((long, long, double*, double*, double*, long, long*));
extern void dptts2 __P((int, int, double*, double*, double*, int));
extern void dptts2_64 __P((long, long, double*, double*, double*, long));
extern double dqdota __P((int, double, long double*, double*, int, double*, int));
extern double dqdota_64 __P((long, double, long double*, double*, long, double*, long));
extern double dqdoti __P((int, double, long double*, double*, int, double*, int));
extern double dqdoti_64 __P((long, double, long double*, double*, long, double*, long));
extern void drot __P((int, double*, int, double*, int, double, double));
extern void drot_64 __P((long, double*, long, double*, long, double, double));
extern void drotg __P((double*, double*, double*, double*));
extern void drotg_64 __P((double*, double*, double*, double*));
extern void droti __P((int, double*, int*, double*, double, double));
extern void droti_64 __P((long, double*, long*, double*, double, double));
extern void drotm __P((int, double*, int, double*, int, double*));
extern void drotm_64 __P((long, double*, long, double*, long, double*));
extern void drotmg __P((double, double, double, double, double*));
extern void drotmg_64 __P((double, double, double, double, double*));
extern void dsbev __P((char, char, int, int, double*, int, double*, double*, int, int*));
extern void dsbev_64 __P((char, char, long, long, double*, long, double*, double*, long, long*));
extern void dsbevd __P((char, char, int, int, double*, int, double*, double*, int, int*));
extern void dsbevd_64 __P((char, char, long, long, double*, long, double*, double*, long, long*));
extern void dsbevx __P((char, char, char, int, int, double*, int, double*, int, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dsbevx_64 __P((char, char, char, long, long, double*, long, double*, long, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dsbgst __P((char, char, int, int, int, double*, int, double*, int, double*, int, int*));
extern void dsbgst_64 __P((char, char, long, long, long, double*, long, double*, long, double*, long, long*));
extern void dsbgv __P((char, char, int, int, int, double*, int, double*, int, double*, double*, int, int*));
extern void dsbgv_64 __P((char, char, long, long, long, double*, long, double*, long, double*, double*, long, long*));
extern void dsbgvd __P((char, char, int, int, int, double*, int, double*, int, double*, double*, int, int*));
extern void dsbgvd_64 __P((char, char, long, long, long, double*, long, double*, long, double*, double*, long, long*));
extern void dsbgvx __P((char, char, char, int, int, int, double*, int, double*, int, double*, int, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dsbgvx_64 __P((char, char, char, long, long, long, double*, long, double*, long, double*, long, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dsbmv __P((char, int, int, double, double*, int, double*, int, double, double*, int));
extern void dsbmv_64 __P((char, long, long, double, double*, long, double*, long, double, double*, long));
extern void dsbtrd __P((char, char, int, int, double*, int, double*, double*, double*, int, int*));
extern void dsbtrd_64 __P((char, char, long, long, double*, long, double*, double*, double*, long, long*));
extern void dscal __P((int, double, double*, int));
extern void dscal_64 __P((long, double, double*, long));
extern void dsctr __P((int, double*, int*, double*));
extern void dsctr_64 __P((long, double*, long*, double*));
extern double dsdot __P((int, float*, int, float*, int));
extern double dsdot_64 __P((long, float*, long, float*, long));
extern double dsecnd __P((void));
extern double dsecnd_64 __P((void));
extern void dsinqb __P((int, double*, double*));
extern void dsinqb_64 __P((long, double*, double*));
extern void dsinqf __P((int, double*, double*));
extern void dsinqf_64 __P((long, double*, double*));
extern void dsinqi __P((int, double*));
extern void dsinqi_64 __P((long, double*));
extern void dsint __P((int, double*, double*));
extern void dsint_64 __P((long, double*, double*));
extern void dsinti __P((int, double*));
extern void dsinti_64 __P((long, double*));
extern void dskymm __P((int, int, int, int, double, int*, double*, int*, double*, int, double, double*, int));
extern void dskymm_64 __P((long, long, long, long, double, long*, double*, long*, double*, long, double, double*, long));
extern void dskysm __P((int, int, int, int, double*, double, int*, double*, int*, double*, int, double, double*, int));
extern void dskysm_64 __P((long, long, long, long, double*, double, long*, double*, long*, double*, long, double, double*, long));
extern void BLAS_dsort __P((int, int, double*, int));
extern void BLAS_dsort_64 __P((long, long, double*, long));
extern void BLAS_dsortv __P((int, int, double*, int, int*, int));
extern void BLAS_dsortv_64 __P((long, long, double*, long, long*, long));
extern void dsort __P((int, int, double*, int));
extern void dsort_64 __P((long, long, double*, long));
extern void dsortv __P((int, int, double*, int, int*, int));
extern void dsortv_64 __P((long, long, double*, long, long*, long));
extern void dspcon __P((char, int, double*, int*, double, double*, int*));
extern void dspcon_64 __P((char, long, double*, long*, double, double*, long*));
extern void dspev __P((char, char, int, double*, double*, double*, int, int*));
extern void dspev_64 __P((char, char, long, double*, double*, double*, long, long*));
extern void dspevd __P((char, char, int, double*, double*, double*, int, int*));
extern void dspevd_64 __P((char, char, long, double*, double*, double*, long, long*));
extern void dspevx __P((char, char, char, int, double*, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dspevx_64 __P((char, char, char, long, double*, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dspgst __P((int, char, int, double*, double*, int*));
extern void dspgst_64 __P((long, char, long, double*, double*, long*));
extern void dspgv __P((int, char, char, int, double*, double*, double*, double*, int, int*));
extern void dspgv_64 __P((long, char, char, long, double*, double*, double*, double*, long, long*));
extern void dspgvd __P((int, char, char, int, double*, double*, double*, double*, int, int*));
extern void dspgvd_64 __P((long, char, char, long, double*, double*, double*, double*, long, long*));
extern void dspgvx __P((int, char, char, char, int, double*, double*, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dspgvx_64 __P((long, char, char, char, long, double*, double*, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dspmv __P((char, int, double, double*, double*, int, double, double*, int));
extern void dspmv_64 __P((char, long, double, double*, double*, long, double, double*, long));
extern void dspr __P((char, int, double, double*, int, double*));
extern void dspr_64 __P((char, long, double, double*, long, double*));
extern void dspr2 __P((char, int, double, double*, int, double*, int, double*));
extern void dspr2_64 __P((char, long, double, double*, long, double*, long, double*));
extern void dsprfs __P((char, int, int, double*, double*, int*, double*, int, double*, int, double*, double*, int*));
extern void dsprfs_64 __P((char, long, long, double*, double*, long*, double*, long, double*, long, double*, double*, long*));
extern void dspsv __P((char, int, int, double*, int*, double*, int, int*));
extern void dspsv_64 __P((char, long, long, double*, long*, double*, long, long*));
extern void dspsvx __P((char, char, int, int, double*, double*, int*, double*, int, double*, int, double*, double*, double*, int*));
extern void dspsvx_64 __P((char, char, long, long, double*, double*, long*, double*, long, double*, long, double*, double*, double*, long*));
extern void dsptrd __P((char, int, double*, double*, double*, double*, int*));
extern void dsptrd_64 __P((char, long, double*, double*, double*, double*, long*));
extern void dsptrf __P((char, int, double*, int*, int*));
extern void dsptrf_64 __P((char, long, double*, long*, long*));
extern void dsptri __P((char, int, double*, int*, int*));
extern void dsptri_64 __P((char, long, double*, long*, long*));
extern void dsptrs __P((char, int, int, double*, int*, double*, int, int*));
extern void dsptrs_64 __P((char, long, long, double*, long*, double*, long, long*));
extern void dstebz __P((char, char, int, double, double, int, int, double, double*, double*, int*, int*, double*, int*, int*, int*));
extern void dstebz_64 __P((char, char, long, double, double, long, long, double, double*, double*, long*, long*, double*, long*, long*, long*));
extern void dstedc __P((char, int, double*, double*, double*, int, int*));
extern void dstedc_64 __P((char, long, double*, double*, double*, long, long*));
extern void dstegr __P((char, char, int, double*, double*, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dstegr_64 __P((char, char, long, double*, double*, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dstein __P((int, double*, double*, int, double*, int*, int*, double*, int, int*, int*));
extern void dstein_64 __P((long, double*, double*, long, double*, long*, long*, double*, long, long*, long*));
extern void dsteqr __P((char, int, double*, double*, double*, int, int*));
extern void dsteqr_64 __P((char, long, double*, double*, double*, long, long*));
extern void dsterf __P((int, double*, double*, int*));
extern void dsterf_64 __P((long, double*, double*, long*));
extern void dstev __P((char, int, double*, double*, double*, int, int*));
extern void dstev_64 __P((char, long, double*, double*, double*, long, long*));
extern void dstevd __P((char, int, double*, double*, double*, int, int*));
extern void dstevd_64 __P((char, long, double*, double*, double*, long, long*));
extern void dstevr __P((char, char, int, double*, double*, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dstevr_64 __P((char, char, long, double*, double*, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dstevx __P((char, char, int, double*, double*, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dstevx_64 __P((char, char, long, double*, double*, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dstsv __P((int, int, double*, double*, double*, double*, int, int*, int*));
extern void dstsv_64 __P((long, long, double*, double*, double*, double*, long, long*, long*));
extern void dsttrf __P((int, double*, double*, double*, int*, int*));
extern void dsttrf_64 __P((long, double*, double*, double*, long*, long*));
extern void dsttrs __P((int, int, double*, double*, double*, double*, int, int*, int*));
extern void dsttrs_64 __P((long, long, double*, double*, double*, double*, long, long*, long*));
extern void dswap __P((int, double*, int, double*, int));
extern void dswap_64 __P((long, double*, long, double*, long));
extern void dsycon __P((char, int, double*, int, int*, double, double*, int*));
extern void dsycon_64 __P((char, long, double*, long, long*, double, double*, long*));
extern void dsyev __P((char, char, int, double*, int, double*, int*));
extern void dsyev_64 __P((char, char, long, double*, long, double*, long*));
extern void dsyevd __P((char, char, int, double*, int, double*, int*));
extern void dsyevd_64 __P((char, char, long, double*, long, double*, long*));
extern void dsyevr __P((char, char, char, int, double*, int, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dsyevr_64 __P((char, char, char, long, double*, long, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dsyevx __P((char, char, char, int, double*, int, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dsyevx_64 __P((char, char, char, long, double*, long, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dsygs2 __P((int, char, int, double*, int, double*, int, int*));
extern void dsygs2_64 __P((long, char, long, double*, long, double*, long, long*));
extern void dsygst __P((int, char, int, double*, int, double*, int, int*));
extern void dsygst_64 __P((long, char, long, double*, long, double*, long, long*));
extern void dsygv __P((int, char, char, int, double*, int, double*, int, double*, int*));
extern void dsygv_64 __P((long, char, char, long, double*, long, double*, long, double*, long*));
extern void dsygvd __P((int, char, char, int, double*, int, double*, int, double*, int*));
extern void dsygvd_64 __P((long, char, char, long, double*, long, double*, long, double*, long*));
extern void dsygvx __P((int, char, char, char, int, double*, int, double*, int, double, double, int, int, double, int*, double*, double*, int, int*, int*));
extern void dsygvx_64 __P((long, char, char, char, long, double*, long, double*, long, double, double, long, long, double, long*, double*, double*, long, long*, long*));
extern void dsymm __P((char, char, int, int, double, double*, int, double*, int, double, double*, int));
extern void dsymm_64 __P((char, char, long, long, double, double*, long, double*, long, double, double*, long));
extern void dsymv __P((char, int, double, double*, int, double*, int, double, double*, int));
extern void dsymv_64 __P((char, long, double, double*, long, double*, long, double, double*, long));
extern void dsyr __P((char, int, double, double*, int, double*, int));
extern void dsyr_64 __P((char, long, double, double*, long, double*, long));
extern void dsyr2 __P((char, int, double, double*, int, double*, int, double*, int));
extern void dsyr2_64 __P((char, long, double, double*, long, double*, long, double*, long));
extern void dsyr2k __P((char, char, int, int, double, double*, int, double*, int, double, double*, int));
extern void dsyr2k_64 __P((char, char, long, long, double, double*, long, double*, long, double, double*, long));
extern void dsyrfs __P((char, int, int, double*, int, double*, int, int*, double*, int, double*, int, double*, double*, int*));
extern void dsyrfs_64 __P((char, long, long, double*, long, double*, long, long*, double*, long, double*, long, double*, double*, long*));
extern void dsyrk __P((char, char, int, int, double, double*, int, double, double*, int));
extern void dsyrk_64 __P((char, char, long, long, double, double*, long, double, double*, long));
extern void dsysv __P((char, int, int, double*, int, int*, double*, int, int*));
extern void dsysv_64 __P((char, long, long, double*, long, long*, double*, long, long*));
extern void dsysvx __P((char, char, int, int, double*, int, double*, int, int*, double*, int, double*, int, double*, double*, double*, int*));
extern void dsysvx_64 __P((char, char, long, long, double*, long, double*, long, long*, double*, long, double*, long, double*, double*, double*, long*));
extern void dsytd2 __P((char, int, double*, int, double*, double*, double*, int*));
extern void dsytd2_64 __P((char, long, double*, long, double*, double*, double*, long*));
extern void dsytf2 __P((char, int, double*, int, int*, int*));
extern void dsytf2_64 __P((char, long, double*, long, long*, long*));
extern void dsytrd __P((char, int, double*, int, double*, double*, double*, int*));
extern void dsytrd_64 __P((char, long, double*, long, double*, double*, double*, long*));
extern void dsytrf __P((char, int, double*, int, int*, int*));
extern void dsytrf_64 __P((char, long, double*, long, long*, long*));
extern void dsytri __P((char, int, double*, int, int*, int*));
extern void dsytri_64 __P((char, long, double*, long, long*, long*));
extern void dsytrs __P((char, int, int, double*, int, int*, double*, int, int*));
extern void dsytrs_64 __P((char, long, long, double*, long, long*, double*, long, long*));
extern void dtbcon __P((char, char, char, int, int, double*, int, double*, int*));
extern void dtbcon_64 __P((char, char, char, long, long, double*, long, double*, long*));
extern void dtbmv __P((char, char, char, int, int, double*, int, double*, int));
extern void dtbmv_64 __P((char, char, char, long, long, double*, long, double*, long));
extern void dtbrfs __P((char, char, char, int, int, int, double*, int, double*, int, double*, int, double*, double*, int*));
extern void dtbrfs_64 __P((char, char, char, long, long, long, double*, long, double*, long, double*, long, double*, double*, long*));
extern void dtbsv __P((char, char, char, int, int, double*, int, double*, int));
extern void dtbsv_64 __P((char, char, char, long, long, double*, long, double*, long));
extern void dtbtrs __P((char, char, char, int, int, int, double*, int, double*, int, int*));
extern void dtbtrs_64 __P((char, char, char, long, long, long, double*, long, double*, long, long*));
extern void dtgevc __P((char, char, int*, int, double*, int, double*, int, double*, int, double*, int, int, int*, int*));
extern void dtgevc_64 __P((char, char, long*, long, double*, long, double*, long, double*, long, double*, long, long, long*, long*));
extern void dtgexc __P((int, int, int, double*, int, double*, int, double*, int, double*, int, int*, int*, int*));
extern void dtgexc_64 __P((long, long, long, double*, long, double*, long, double*, long, double*, long, long*, long*, long*));
extern void dtgsen __P((int, int, int, int*, int, double*, int, double*, int, double*, double*, double*, double*, int, double*, int, int*, double*, double*, double*, int*));
extern void dtgsen_64 __P((long, long, long, long*, long, double*, long, double*, long, double*, double*, double*, double*, long, double*, long, long*, double*, double*, double*, long*));
extern void dtgsja __P((char, char, char, int, int, int, int, int, double*, int, double*, int, double, double, double*, double*, double*, int, double*, int, double*, int, int*, int*));
extern void dtgsja_64 __P((char, char, char, long, long, long, long, long, double*, long, double*, long, double, double, double*, double*, double*, long, double*, long, double*, long, long*, long*));
extern void dtgsna __P((char, char, int*, int, double*, int, double*, int, double*, int, double*, int, double*, double*, int, int*, int*));
extern void dtgsna_64 __P((char, char, long*, long, double*, long, double*, long, double*, long, double*, long, double*, double*, long, long*, long*));
extern void dtgsyl __P((char, int, int, int, double*, int, double*, int, double*, int, double*, int, double*, int, double*, int, double*, double*, int*));
extern void dtgsyl_64 __P((char, long, long, long, double*, long, double*, long, double*, long, double*, long, double*, long, double*, long, double*, double*, long*));
extern void dtpcon __P((char, char, char, int, double*, double*, int*));
extern void dtpcon_64 __P((char, char, char, long, double*, double*, long*));
extern void dtpmv __P((char, char, char, int, double*, double*, int));
extern void dtpmv_64 __P((char, char, char, long, double*, double*, long));
extern void dtprfs __P((char, char, char, int, int, double*, double*, int, double*, int, double*, double*, int*));
extern void dtprfs_64 __P((char, char, char, long, long, double*, double*, long, double*, long, double*, double*, long*));
extern void dtpsv __P((char, char, char, int, double*, double*, int));
extern void dtpsv_64 __P((char, char, char, long, double*, double*, long));
extern void dtptri __P((char, char, int, double*, int*));
extern void dtptri_64 __P((char, char, long, double*, long*));
extern void dtptrs __P((char, char, char, int, int, double*, double*, int, int*));
extern void dtptrs_64 __P((char, char, char, long, long, double*, double*, long, long*));
extern void dtrans __P((char, double, double*, int, int, double*));
extern void dtrans_64 __P((char, double, double*, long, long, double*));
extern void dtrcon __P((char, char, char, int, double*, int, double*, int*));
extern void dtrcon_64 __P((char, char, char, long, double*, long, double*, long*));
extern void dtrevc __P((char, char, int*, int, double*, int, double*, int, double*, int, int, int*, int*));
extern void dtrevc_64 __P((char, char, long*, long, double*, long, double*, long, double*, long, long, long*, long*));
extern void dtrexc __P((char, int, double*, int, double*, int, int*, int*, int*));
extern void dtrexc_64 __P((char, long, double*, long, double*, long, long*, long*, long*));
extern void dtrmm __P((char, char, char, char, int, int, double, double*, int, double*, int));
extern void dtrmm_64 __P((char, char, char, char, long, long, double, double*, long, double*, long));
extern void dtrmv __P((char, char, char, int, double*, int, double*, int));
extern void dtrmv_64 __P((char, char, char, long, double*, long, double*, long));
extern void dtrrfs __P((char, char, char, int, int, double*, int, double*, int, double*, int, double*, double*, int*));
extern void dtrrfs_64 __P((char, char, char, long, long, double*, long, double*, long, double*, long, double*, double*, long*));
extern void dtrsen __P((char, char, int*, int, double*, int, double*, int, double*, double*, int*, double*, double*, int*));
extern void dtrsen_64 __P((char, char, long*, long, double*, long, double*, long, double*, double*, long*, double*, double*, long*));
extern void dtrsm __P((char, char, char, char, int, int, double, double*, int, double*, int));
extern void dtrsm_64 __P((char, char, char, char, long, long, double, double*, long, double*, long));
extern void dtrsna __P((char, char, int*, int, double*, int, double*, int, double*, int, double*, double*, int, int*, int, int*));
extern void dtrsna_64 __P((char, char, long*, long, double*, long, double*, long, double*, long, double*, double*, long, long*, long, long*));
extern void dtrsv __P((char, char, char, int, double*, int, double*, int));
extern void dtrsv_64 __P((char, char, char, long, double*, long, double*, long));
extern void dtrsyl __P((char, char, int, int, int, double*, int, double*, int, double*, int, double*, int*));
extern void dtrsyl_64 __P((char, char, long, long, long, double*, long, double*, long, double*, long, double*, long*));
extern void dtrti2 __P((char, char, int, double*, int, int*));
extern void dtrti2_64 __P((char, char, long, double*, long, long*));
extern void dtrtri __P((char, char, int, double*, int, int*));
extern void dtrtri_64 __P((char, char, long, double*, long, long*));
extern void dtrtrs __P((char, char, char, int, int, double*, int, double*, int, int*));
extern void dtrtrs_64 __P((char, char, char, long, long, double*, long, double*, long, long*));
extern void dtzrqf __P((int, int, double*, int, double*, int*));
extern void dtzrqf_64 __P((long, long, double*, long, double*, long*));
extern void dtzrzf __P((int, int, double*, int, double*, int*));
extern void dtzrzf_64 __P((long, long, double*, long, double*, long*));
extern void dvbrmm __P((int, int, int, int, double, int*, double*, int*, int*, int*, int*, int*, int*, double*, int, double, double*, int));
extern void dvbrmm_64 __P((long, long, long, long, double, long*, double*, long*, long*, long*, long*, long*, long*, double*, long, double, double*, long));
extern void dvbrsm __P((int, int, int, int, double*, double, int*, double*, int*, int*, int*, int*, int*, int*, double*, int, double, double*, int));
extern void dvbrsm_64 __P((long, long, long, long, double*, double, long*, double*, long*, long*, long*, long*, long*, long*, double*, long, double, double*, long));
extern void dwiener __P((int, double*, double*, double*, double*, int*, int*));
extern void dwiener_64 __P((long, double*, double*, double*, double*, long*, long*));
extern double dzasum __P((int, doublecomplex*, int));
extern double dzasum_64 __P((long, doublecomplex*, long));
extern double dznrm2 __P((int, doublecomplex*, int));
extern double dznrm2_64 __P((long, doublecomplex*, long));
extern void ezfftb __P((int, float*, float, float*, float*, float*));
extern void ezfftb_64 __P((long, float*, float, float*, float*, float*));
extern void ezfftf __P((int, float*, float, float*, float*, float*));
extern void ezfftf_64 __P((long, float*, float, float*, float*, float*));
extern void ezffti __P((int, float*));
extern void ezffti_64 __P((long, float*));
extern int icamax __P((int, complex*, int));
extern long icamax_64 __P((long, complex*, long));
extern int idamax __P((int, double*, int));
extern long idamax_64 __P((long, double*, long));
extern int ilaenv __P((int, char, char, int, int, int, int));
extern long ilaenv_64 __P((long, char, char, long, long, long, long));
extern void BLAS_ipermute __P((int, int*, int, int*, int));
extern void BLAS_ipermute_64 __P((long, long*, long, long*, long));
extern void ipermute __P((int, int*, int, int*, int));
extern void ipermute_64 __P((long, long*, long, long*, long));
extern int isamax __P((int, float*, int));
extern long isamax_64 __P((long, float*, long));
extern void BLAS_isort __P((int, int, int*, int));
extern void BLAS_isort_64 __P((long, long, long*, long));
extern void BLAS_isortv __P((int, int, int*, int, int*, int));
extern void BLAS_isortv_64 __P((long, long, long*, long, long*, long));
extern void isort __P((int, int, int*, int));
extern void isort_64 __P((long, long, long*, long));
extern void isortv __P((int, int, int*, int, int*, int));
extern void isortv_64 __P((long, long, long*, long, long*, long));
extern int izamax __P((int, doublecomplex*, int));
extern long izamax_64 __P((long, doublecomplex*, long));
extern int lsame __P((char, char));
extern long lsame_64 __P((char, char));
extern void rfft2b __P((char, int, int, float*, int, float*, int, float*, int));
extern void rfft2b_64 __P((char, long, long, float*, long, float*, long, float*, long));
extern void rfft2f __P((char, char, int, int, float*, int, float*, int, float*, int));
extern void rfft2f_64 __P((char, char, long, long, float*, long, float*, long, float*, long));
extern void rfft2i __P((int, int, float*));
extern void rfft2i_64 __P((long, long, float*));
extern void rfft3b __P((char, int, int, int, float*, int, float*, int, float*, int));
extern void rfft3b_64 __P((char, long, long, long, float*, long, float*, long, float*, long));
extern void rfft3f __P((char, char, int, int, int, float*, int, float*, int, float*, int));
extern void rfft3f_64 __P((char, char, long, long, long, float*, long, float*, long, float*, long));
extern void rfft3i __P((int, int, int, float*));
extern void rfft3i_64 __P((long, long, long, float*));
extern void rfftb __P((int, float*, float*));
extern void rfftb_64 __P((long, float*, float*));
extern void rfftf __P((int, float*, float*));
extern void rfftf_64 __P((long, float*, float*));
extern void rffti __P((int, float*));
extern void rffti_64 __P((long, float*));
extern int rfftopt __P((int));
extern long rfftopt_64 __P((long));
extern float sasum __P((int, float*, int));
extern float sasum_64 __P((long, float*, long));
extern void saxpy __P((int, float, float*, int, float*, int));
extern void saxpy_64 __P((long, float, float*, long, float*, long));
extern void saxpyi __P((int, float, float*, int*, float*));
extern void saxpyi_64 __P((long, float, float*, long*, float*));
extern void sbcomm __P((int, int, int, int, float, int*, float*, int*, int*, int, int, float*, int, float, float*, int));
extern void sbcomm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long, long, float*, long, float, float*, long));
extern void sbdimm __P((int, int, int, int, float, int*, float*, int, int*, int, int, float*, int, float, float*, int));
extern void sbdimm_64 __P((long, long, long, long, float, long*, float*, long, long*, long, long, float*, long, float, float*, long));
extern void sbdism __P((int, int, int, int, float*, float, int*, float*, int, int*, int, int, float*, int, float, float*, int));
extern void sbdism_64 __P((long, long, long, long, float*, float, long*, float*, long, long*, long, long, float*, long, float, float*, long));
extern void sbdsdc __P((char, char, int, float*, float*, float*, int, float*, int, float*, int*, int*));
extern void sbdsdc_64 __P((char, char, long, float*, float*, float*, long, float*, long, float*, long*, long*));
extern void sbdsqr __P((char, int, int, int, int, float*, float*, float*, int, float*, int, float*, int, int*));
extern void sbdsqr_64 __P((char, long, long, long, long, float*, float*, float*, long, float*, long, float*, long, long*));
extern void sbelmm __P((int, int, int, int, float, int*, float*, int*, int, int, int, float*, int, float, float*, int));
extern void sbelmm_64 __P((long, long, long, long, float, long*, float*, long*, long, long, long, float*, long, float, float*, long));
extern void sbelsm __P((int, int, int, int, float*, float, int*, float*, int*, int, int, int, float*, int, float, float*, int));
extern void sbelsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long, long, long, float*, long, float, float*, long));
extern void sbscmm __P((int, int, int, int, float, int*, float*, int*, int*, int*, int, float*, int, float, float*, int));
extern void sbscmm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long*, long, float*, long, float, float*, long));
extern void sbscsm __P((int, int, int, int, float*, float, int*, float*, int*, int*, int*, int, float*, int, float, float*, int));
extern void sbscsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long*, long*, long, float*, long, float, float*, long));
extern void sbsrmm __P((int, int, int, int, float, int*, float*, int*, int*, int*, int, float*, int, float, float*, int));
extern void sbsrmm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long*, long, float*, long, float, float*, long));
extern void sbsrsm __P((int, int, int, int, float*, float, int*, float*, int*, int*, int*, int, float*, int, float, float*, int));
extern void sbsrsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long*, long*, long, float*, long, float, float*, long));
extern float scasum __P((int, complex*, int));
extern float scasum_64 __P((long, complex*, long));
extern float scnrm2 __P((int, complex*, int));
extern float scnrm2_64 __P((long, complex*, long));
extern void scnvcor __P((char, char, int, float*, int, int, int, int, int, float*, int, int, int, int, int, float*, int, int, int, float*, int));
extern void scnvcor_64 __P((char, char, long, float*, long, long, long, long, long, float*, long, long, long, long, long, float*, long, long, long, float*, long));
extern void scnvcor2 __P((char, char, char, char, char, char, int, int, float*, int, int, int, int, int, float*, int, int, int, float*, int, complex*, int));
extern void scnvcor2_64 __P((char, char, char, char, char, char, long, long, float*, long, long, long, long, long, float*, long, long, long, float*, long, complex*, long));
extern void scoomm __P((int, int, int, int, float, int*, float*, int*, int*, int, float*, int, float, float*, int));
extern void scoomm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long, float*, long, float, float*, long));
extern void scopy __P((int, float*, int, float*, int));
extern void scopy_64 __P((long, float*, long, float*, long));
extern void scscmm __P((int, int, int, int, float, int*, float*, int*, int*, int*, float*, int, float, float*, int));
extern void scscmm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long*, float*, long, float, float*, long));
extern void scscsm __P((int, int, int, int, float*, float, int*, float*, int*, int*, int*, float*, int, float, float*, int));
extern void scscsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long*, long*, float*, long, float, float*, long));
extern void scsrmm __P((int, int, int, int, float, int*, float*, int*, int*, int*, float*, int, float, float*, int));
extern void scsrmm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long*, float*, long, float, float*, long));
extern void scsrsm __P((int, int, int, int, float*, float, int*, float*, int*, int*, int*, float*, int, float, float*, int));
extern void scsrsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long*, long*, float*, long, float, float*, long));
extern void sdiamm __P((int, int, int, int, float, int*, float*, int, int*, int, float*, int, float, float*, int));
extern void sdiamm_64 __P((long, long, long, long, float, long*, float*, long, long*, long, float*, long, float, float*, long));
extern void sdiasm __P((int, int, int, int, float*, float, int*, float*, int, int*, int, float*, int, float, float*, int));
extern void sdiasm_64 __P((long, long, long, long, float*, float, long*, float*, long, long*, long, float*, long, float, float*, long));
extern void sdisna __P((char, int, int, float*, float*, int*));
extern void sdisna_64 __P((char, long, long, float*, float*, long*));
extern float sdot __P((int, float*, int, float*, int));
extern float sdot_64 __P((long, float*, long, float*, long));
extern float sdoti __P((int, float*, int*, float*));
extern float sdoti_64 __P((long, float*, long*, float*));
extern float sdsdot __P((int, float, float*, int, float*, int));
extern float sdsdot_64 __P((long, float, float*, long, float*, long));
extern float second __P((void));
extern float second_64 __P((void));
extern void sellmm __P((int, int, int, int, float, int*, float*, int*, int, int, float*, int, float, float*, int));
extern void sellmm_64 __P((long, long, long, long, float, long*, float*, long*, long, long, float*, long, float, float*, long));
extern void sellsm __P((int, int, int, int, float*, float, int*, float*, int*, int, int, float*, int, float, float*, int));
extern void sellsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long, long, float*, long, float, float*, long));
extern void sgbbrd __P((char, int, int, int, int, int, float*, int, float*, float*, float*, int, float*, int, float*, int, int*));
extern void sgbbrd_64 __P((char, long, long, long, long, long, float*, long, float*, float*, float*, long, float*, long, float*, long, long*));
extern void sgbcon __P((char, int, int, int, float*, int, int*, float, float*, int*));
extern void sgbcon_64 __P((char, long, long, long, float*, long, long*, float, float*, long*));
extern void sgbequ __P((int, int, int, int, float*, int, float*, float*, float*, float*, float*, int*));
extern void sgbequ_64 __P((long, long, long, long, float*, long, float*, float*, float*, float*, float*, long*));
extern void sgbmv __P((char, int, int, int, int, float, float*, int, float*, int, float, float*, int));
extern void sgbmv_64 __P((char, long, long, long, long, float, float*, long, float*, long, float, float*, long));
extern void sgbrfs __P((char, int, int, int, int, float*, int, float*, int, int*, float*, int, float*, int, float*, float*, int*));
extern void sgbrfs_64 __P((char, long, long, long, long, float*, long, float*, long, long*, float*, long, float*, long, float*, float*, long*));
extern void sgbsv __P((int, int, int, int, float*, int, int*, float*, int, int*));
extern void sgbsv_64 __P((long, long, long, long, float*, long, long*, float*, long, long*));
extern void sgbsvx __P((char, char, int, int, int, int, float*, int, float*, int, int*, char, float*, float*, float*, int, float*, int, float*, float*, float*, int*));
extern void sgbsvx_64 __P((char, char, long, long, long, long, float*, long, float*, long, long*, char, float*, float*, float*, long, float*, long, float*, float*, float*, long*));
extern void sgbtf2 __P((int, int, int, int, float*, int, int*, int*));
extern void sgbtf2_64 __P((long, long, long, long, float*, long, long*, long*));
extern void sgbtrf __P((int, int, int, int, float*, int, int*, int*));
extern void sgbtrf_64 __P((long, long, long, long, float*, long, long*, long*));
extern void sgbtrs __P((char, int, int, int, int, float*, int, int*, float*, int, int*));
extern void sgbtrs_64 __P((char, long, long, long, long, float*, long, long*, float*, long, long*));
extern void sgebak __P((char, char, int, int, int, float*, int, float*, int, int*));
extern void sgebak_64 __P((char, char, long, long, long, float*, long, float*, long, long*));
extern void sgebal __P((char, int, float*, int, int*, int*, float*, int*));
extern void sgebal_64 __P((char, long, float*, long, long*, long*, float*, long*));
extern void sgebrd __P((int, int, float*, int, float*, float*, float*, float*, int*));
extern void sgebrd_64 __P((long, long, float*, long, float*, float*, float*, float*, long*));
extern void sgecon __P((char, int, float*, int, float, float*, int*));
extern void sgecon_64 __P((char, long, float*, long, float, float*, long*));
extern void sgeequ __P((int, int, float*, int, float*, float*, float*, float*, float*, int*));
extern void sgeequ_64 __P((long, long, float*, long, float*, float*, float*, float*, float*, long*));
extern void sgees __P((char, char, int(*select)(float,float), int, float*, int, int*, float*, float*, float*, int, int*));
extern void sgees_64 __P((char, char, long(*select)(float,float), long, float*, long, long*, float*, float*, float*, long, long*));
extern void sgeesx __P((char, char, int(*select)(float,float), char, int, float*, int, int*, float*, float*, float*, int, float*, float*, int*));
extern void sgeesx_64 __P((char, char, long(*select)(float,float), char, long, float*, long, long*, float*, float*, float*, long, float*, float*, long*));
extern void sgeev __P((char, char, int, float*, int, float*, float*, float*, int, float*, int, int*));
extern void sgeev_64 __P((char, char, long, float*, long, float*, float*, float*, long, float*, long, long*));
extern void sgeevx __P((char, char, char, char, int, float*, int, float*, float*, float*, int, float*, int, int*, int*, float*, float*, float*, float*, int*));
extern void sgeevx_64 __P((char, char, char, char, long, float*, long, float*, float*, float*, long, float*, long, long*, long*, float*, float*, float*, float*, long*));
extern void sgegs __P((char, char, int, float*, int, float*, int, float*, float*, float*, float*, int, float*, int, int*));
extern void sgegs_64 __P((char, char, long, float*, long, float*, long, float*, float*, float*, float*, long, float*, long, long*));
extern void sgegv __P((char, char, int, float*, int, float*, int, float*, float*, float*, float*, int, float*, int, int*));
extern void sgegv_64 __P((char, char, long, float*, long, float*, long, float*, float*, float*, float*, long, float*, long, long*));
extern void sgehrd __P((int, int, int, float*, int, float*, int*));
extern void sgehrd_64 __P((long, long, long, float*, long, float*, long*));
extern void sgelqf __P((int, int, float*, int, float*, int*));
extern void sgelqf_64 __P((long, long, float*, long, float*, long*));
extern void sgels __P((char, int, int, int, float*, int, float*, int, int*));
extern void sgels_64 __P((char, long, long, long, float*, long, float*, long, long*));
extern void sgelsd __P((int, int, int, float*, int, float*, int, float*, float, int*, int*));
extern void sgelsd_64 __P((long, long, long, float*, long, float*, long, float*, float, long*, long*));
extern void sgelss __P((int, int, int, float*, int, float*, int, float*, float, int*, int*));
extern void sgelss_64 __P((long, long, long, float*, long, float*, long, float*, float, long*, long*));
extern void sgelsx __P((int, int, int, float*, int, float*, int, int*, float, int*, int*));
extern void sgelsx_64 __P((long, long, long, float*, long, float*, long, long*, float, long*, long*));
extern void sgelsy __P((int, int, int, float*, int, float*, int, int*, float, int*, int*));
extern void sgelsy_64 __P((long, long, long, float*, long, float*, long, long*, float, long*, long*));
extern void sgemm __P((char, char, int, int, int, float, float*, int, float*, int, float, float*, int));
extern void sgemm_64 __P((char, char, long, long, long, float, float*, long, float*, long, float, float*, long));
extern void sgemv __P((char, int, int, float, float*, int, float*, int, float, float*, int));
extern void sgemv_64 __P((char, long, long, float, float*, long, float*, long, float, float*, long));
extern void sgeqlf __P((int, int, float*, int, float*, int*));
extern void sgeqlf_64 __P((long, long, float*, long, float*, long*));
extern void sgeqp3 __P((int, int, float*, int, int*, float*, int*));
extern void sgeqp3_64 __P((long, long, float*, long, long*, float*, long*));
extern void sgeqpf __P((int, int, float*, int, int*, float*, int*));
extern void sgeqpf_64 __P((long, long, float*, long, long*, float*, long*));
extern void sgeqrf __P((int, int, float*, int, float*, int*));
extern void sgeqrf_64 __P((long, long, float*, long, float*, long*));
extern void sger __P((int, int, float, float*, int, float*, int, float*, int));
extern void sger_64 __P((long, long, float, float*, long, float*, long, float*, long));
extern void sgerfs __P((char, int, int, float*, int, float*, int, int*, float*, int, float*, int, float*, float*, int*));
extern void sgerfs_64 __P((char, long, long, float*, long, float*, long, long*, float*, long, float*, long, float*, float*, long*));
extern void sgerqf __P((int, int, float*, int, float*, int*));
extern void sgerqf_64 __P((long, long, float*, long, float*, long*));
extern void sgesdd __P((char, int, int, float*, int, float*, float*, int, float*, int, int*));
extern void sgesdd_64 __P((char, long, long, float*, long, float*, float*, long, float*, long, long*));
extern void sgesv __P((int, int, float*, int, int*, float*, int, int*));
extern void sgesv_64 __P((long, long, float*, long, long*, float*, long, long*));
extern void sgesvd __P((char, char, int, int, float*, int, float*, float*, int, float*, int, int*));
extern void sgesvd_64 __P((char, char, long, long, float*, long, float*, float*, long, float*, long, long*));
extern void sgesvx __P((char, char, int, int, float*, int, float*, int, int*, char, float*, float*, float*, int, float*, int, float*, float*, float*, int*));
extern void sgesvx_64 __P((char, char, long, long, float*, long, float*, long, long*, char, float*, float*, float*, long, float*, long, float*, float*, float*, long*));
extern void sgetf2 __P((int, int, float*, int, int*, int*));
extern void sgetf2_64 __P((long, long, float*, long, long*, long*));
extern void sgetrf __P((int, int, float*, int, int*, int*));
extern void sgetrf_64 __P((long, long, float*, long, long*, long*));
extern void sgetri __P((int, float*, int, int*, int*));
extern void sgetri_64 __P((long, float*, long, long*, long*));
extern void sgetrs __P((char, int, int, float*, int, int*, float*, int, int*));
extern void sgetrs_64 __P((char, long, long, float*, long, long*, float*, long, long*));
extern void sggbak __P((char, char, int, int, int, float*, float*, int, float*, int, int*));
extern void sggbak_64 __P((char, char, long, long, long, float*, float*, long, float*, long, long*));
extern void sggbal __P((char, int, float*, int, float*, int, int*, int*, float*, float*, int*));
extern void sggbal_64 __P((char, long, float*, long, float*, long, long*, long*, float*, float*, long*));
extern void sgges __P((char, char, char, int(*selctg)(float,float,float), int, float*, int, float*, int, int*, float*, float*, float*, float*, int, float*, int, int*));
extern void sgges_64 __P((char, char, char, long(*selctg)(float,float,float), long, float*, long, float*, long, long*, float*, float*, float*, float*, long, float*, long, long*));
extern void sggesx __P((char, char, char, int(*selctg)(float,float,float), char, int, float*, int, float*, int, int*, float*, float*, float*, float*, int, float*, int, float*, float*, int*));
extern void sggesx_64 __P((char, char, char, long(*selctg)(float,float,float), char, long, float*, long, float*, long, long*, float*, float*, float*, float*, long, float*, long, float*, float*, long*));
extern void sggev __P((char, char, int, float*, int, float*, int, float*, float*, float*, float*, int, float*, int, int*));
extern void sggev_64 __P((char, char, long, float*, long, float*, long, float*, float*, float*, float*, long, float*, long, long*));
extern void sggevx __P((char, char, char, char, int, float*, int, float*, int, float*, float*, float*, float*, int, float*, int, int*, int*, float*, float*, float*, float*, float*, float*, int*));
extern void sggevx_64 __P((char, char, char, char, long, float*, long, float*, long, float*, float*, float*, float*, long, float*, long, long*, long*, float*, float*, float*, float*, float*, float*, long*));
extern void sggglm __P((int, int, int, float*, int, float*, int, float*, float*, float*, int*));
extern void sggglm_64 __P((long, long, long, float*, long, float*, long, float*, float*, float*, long*));
extern void sgghrd __P((char, char, int, int, int, float*, int, float*, int, float*, int, float*, int, int*));
extern void sgghrd_64 __P((char, char, long, long, long, float*, long, float*, long, float*, long, float*, long, long*));
extern void sgglse __P((int, int, int, float*, int, float*, int, float*, float*, float*, int*));
extern void sgglse_64 __P((long, long, long, float*, long, float*, long, float*, float*, float*, long*));
extern void sggqrf __P((int, int, int, float*, int, float*, float*, int, float*, int*));
extern void sggqrf_64 __P((long, long, long, float*, long, float*, float*, long, float*, long*));
extern void sggrqf __P((int, int, int, float*, int, float*, float*, int, float*, int*));
extern void sggrqf_64 __P((long, long, long, float*, long, float*, float*, long, float*, long*));
extern void sggsvd __P((char, char, char, int, int, int, int*, int*, float*, int, float*, int, float*, float*, float*, int, float*, int, float*, int, int*, int*));
extern void sggsvd_64 __P((char, char, char, long, long, long, long*, long*, float*, long, float*, long, float*, float*, float*, long, float*, long, float*, long, long*, long*));
extern void sggsvp __P((char, char, char, int, int, int, float*, int, float*, int, float, float, int*, int*, float*, int, float*, int, float*, int, int*));
extern void sggsvp_64 __P((char, char, char, long, long, long, float*, long, float*, long, float, float, long*, long*, float*, long, float*, long, float*, long, long*));
extern void sgtcon __P((char, int, float*, float*, float*, float*, int*, float, float*, int*));
extern void sgtcon_64 __P((char, long, float*, float*, float*, float*, long*, float, float*, long*));
extern void sgthr __P((int, float*, float*, int*));
extern void sgthr_64 __P((long, float*, float*, long*));
extern void sgthrz __P((int, float*, float*, int*));
extern void sgthrz_64 __P((long, float*, float*, long*));
extern void sgtrfs __P((char, int, int, float*, float*, float*, float*, float*, float*, float*, int*, float*, int, float*, int, float*, float*, int*));
extern void sgtrfs_64 __P((char, long, long, float*, float*, float*, float*, float*, float*, float*, long*, float*, long, float*, long, float*, float*, long*));
extern void sgtsv __P((int, int, float*, float*, float*, float*, int, int*));
extern void sgtsv_64 __P((long, long, float*, float*, float*, float*, long, long*));
extern void sgtsvx __P((char, char, int, int, float*, float*, float*, float*, float*, float*, float*, int*, float*, int, float*, int, float*, float*, float*, int*));
extern void sgtsvx_64 __P((char, char, long, long, float*, float*, float*, float*, float*, float*, float*, long*, float*, long, float*, long, float*, float*, float*, long*));
extern void sgttrf __P((int, float*, float*, float*, float*, int*, int*));
extern void sgttrf_64 __P((long, float*, float*, float*, float*, long*, long*));
extern void sgttrs __P((char, int, int, float*, float*, float*, float*, int*, float*, int, int*));
extern void sgttrs_64 __P((char, long, long, float*, float*, float*, float*, long*, float*, long, long*));
extern void shgeqz __P((char, char, char, int, int, int, float*, int, float*, int, float*, float*, float*, float*, int, float*, int, int*));
extern void shgeqz_64 __P((char, char, char, long, long, long, float*, long, float*, long, float*, float*, float*, float*, long, float*, long, long*));
extern void shsein __P((char, char, char, int*, int, float*, int, float*, float*, float*, int, float*, int, int, int*, int*, int*, int*));
extern void shsein_64 __P((char, char, char, long*, long, float*, long, float*, float*, float*, long, float*, long, long, long*, long*, long*, long*));
extern void shseqr __P((char, char, int, int, int, float*, int, float*, float*, float*, int, int*));
extern void shseqr_64 __P((char, char, long, long, long, float*, long, float*, float*, float*, long, long*));
extern void sinqb __P((int, float*, float*));
extern void sinqb_64 __P((long, float*, float*));
extern void sinqf __P((int, float*, float*));
extern void sinqf_64 __P((long, float*, float*));
extern void sinqi __P((int, float*));
extern void sinqi_64 __P((long, float*));
extern void sint __P((int, float*, float*));
extern void sint_64 __P((long, float*, float*));
extern void sinti __P((int, float*));
extern void sinti_64 __P((long, float*));
extern void sjadmm __P((int, int, int, int, float, int*, float*, int*, int*, int, int*, float*, int, float, float*, int));
extern void sjadmm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long, long*, float*, long, float, float*, long));
extern void sjadrp __P((int, int, int, float*, int*, int*, int, int*));
extern void sjadrp_64 __P((long, long, long, float*, long*, long*, long, long*));
extern void sjadsm __P((int, int, int, int, float*, float, int*, float*, int*, int*, int, int*, float*, int, float, float*, int));
extern void sjadsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long*, long, long*, float*, long, float, float*, long));
extern void slaeda __P((int, int, int, int, int*, int*, int*, int*, float*, float*, int*, float*, float*, int*));
extern void slaeda_64 __P((long, long, long, long, long*, long*, long*, long*, float*, float*, long*, float*, float*, long*));
extern void slagtf __P((int, float*, float, float*, float*, float, float*, int*, int*));
extern void slagtf_64 __P((long, float*, float, float*, float*, float, float*, long*, long*));
extern void slamrg __P((int, int, float*, int, int, int*));
extern void slamrg_64 __P((long, long, float*, long, long, long*));
extern void slanv2 __P((float, float, float, float, float*, float*, float*, float*, float*, float*));
extern void slanv2_64 __P((float, float, float, float, float*, float*, float*, float*, float*, float*));
extern void slarz __P((char, int, int, int, float*, int, float, float*, int));
extern void slarz_64 __P((char, long, long, long, float*, long, float, float*, long));
extern void slarzb __P((char, char, char, char, int, int, int, int, float*, int, float*, int, float*, int, int));
extern void slarzb_64 __P((char, char, char, char, long, long, long, long, float*, long, float*, long, float*, long, long));
extern void slarzt __P((char, char, int, int, float*, int, float*, float*, int));
extern void slarzt_64 __P((char, char, long, long, float*, long, float*, float*, long));
extern void slasq1 __P((int, float*, float*, int*));
extern void slasq1_64 __P((long, float*, float*, long*));
extern void slasq2 __P((int, float*, int*));
extern void slasq2_64 __P((long, float*, long*));
extern void slasrt __P((char, int, float*, int*));
extern void slasrt_64 __P((char, long, float*, long*));
extern void slatzm __P((char, int, int, float*, int, float, float*, float*, int));
extern void slatzm_64 __P((char, long, long, float*, long, float, float*, float*, long));
extern float snrm2 __P((int, float*, int));
extern float snrm2_64 __P((long, float*, long));
extern void sopgtr __P((char, int, float*, float*, float*, int, int*));
extern void sopgtr_64 __P((char, long, float*, float*, float*, long, long*));
extern void sopmtr __P((char, char, char, int, int, float*, float*, float*, int, int*));
extern void sopmtr_64 __P((char, char, char, long, long, float*, float*, float*, long, long*));
extern void sorg2l __P((int, int, int, float*, int, float*, int*));
extern void sorg2l_64 __P((long, long, long, float*, long, float*, long*));
extern void sorg2r __P((int, int, int, float*, int, float*, int*));
extern void sorg2r_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgbr __P((char, int, int, int, float*, int, float*, int*));
extern void sorgbr_64 __P((char, long, long, long, float*, long, float*, long*));
extern void sorghr __P((int, int, int, float*, int, float*, int*));
extern void sorghr_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgl2 __P((int, int, int, float*, int, float*, int*));
extern void sorgl2_64 __P((long, long, long, float*, long, float*, long*));
extern void sorglq __P((int, int, int, float*, int, float*, int*));
extern void sorglq_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgql __P((int, int, int, float*, int, float*, int*));
extern void sorgql_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgqr __P((int, int, int, float*, int, float*, int*));
extern void sorgqr_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgr2 __P((int, int, int, float*, int, float*, int*));
extern void sorgr2_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgrq __P((int, int, int, float*, int, float*, int*));
extern void sorgrq_64 __P((long, long, long, float*, long, float*, long*));
extern void sorgtr __P((char, int, float*, int, float*, int*));
extern void sorgtr_64 __P((char, long, float*, long, float*, long*));
extern void sorm2l __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sorm2l_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sorm2r __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sorm2r_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormbr __P((char, char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sormbr_64 __P((char, char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormhr __P((char, char, int, int, int, int, float*, int, float*, float*, int, int*));
extern void sormhr_64 __P((char, char, long, long, long, long, float*, long, float*, float*, long, long*));
extern void sorml2 __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sorml2_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormlq __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sormlq_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormql __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sormql_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormqr __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sormqr_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormr2 __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sormr2_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormr3 __P((char, char, int, int, int, int, float*, int, float*, float*, int, int*));
extern void sormr3_64 __P((char, char, long, long, long, long, float*, long, float*, float*, long, long*));
extern void sormrq __P((char, char, int, int, int, float*, int, float*, float*, int, int*));
extern void sormrq_64 __P((char, char, long, long, long, float*, long, float*, float*, long, long*));
extern void sormrz __P((char, char, int, int, int, int, float*, int, float*, float*, int, int*));
extern void sormrz_64 __P((char, char, long, long, long, long, float*, long, float*, float*, long, long*));
extern void sormtr __P((char, char, char, int, int, float*, int, float*, float*, int, int*));
extern void sormtr_64 __P((char, char, char, long, long, float*, long, float*, float*, long, long*));
extern void spbcon __P((char, int, int, float*, int, float, float*, int*));
extern void spbcon_64 __P((char, long, long, float*, long, float, float*, long*));
extern void spbequ __P((char, int, int, float*, int, float*, float*, float*, int*));
extern void spbequ_64 __P((char, long, long, float*, long, float*, float*, float*, long*));
extern void spbrfs __P((char, int, int, int, float*, int, float*, int, float*, int, float*, int, float*, float*, int*));
extern void spbrfs_64 __P((char, long, long, long, float*, long, float*, long, float*, long, float*, long, float*, float*, long*));
extern void spbstf __P((char, int, int, float*, int, int*));
extern void spbstf_64 __P((char, long, long, float*, long, long*));
extern void spbsv __P((char, int, int, int, float*, int, float*, int, int*));
extern void spbsv_64 __P((char, long, long, long, float*, long, float*, long, long*));
extern void spbsvx __P((char, char, int, int, int, float*, int, float*, int, char, float*, float*, int, float*, int, float*, float*, float*, int*));
extern void spbsvx_64 __P((char, char, long, long, long, float*, long, float*, long, char, float*, float*, long, float*, long, float*, float*, float*, long*));
extern void spbtf2 __P((char, int, int, float*, int, int*));
extern void spbtf2_64 __P((char, long, long, float*, long, long*));
extern void spbtrf __P((char, int, int, float*, int, int*));
extern void spbtrf_64 __P((char, long, long, float*, long, long*));
extern void spbtrs __P((char, int, int, int, float*, int, float*, int, int*));
extern void spbtrs_64 __P((char, long, long, long, float*, long, float*, long, long*));
extern void BLAS_spermute __P((int, int*, int, float*, int));
extern void BLAS_spermute_64 __P((long, long*, long, float*, long));
extern void spermute __P((int, int*, int, float*, int));
extern void spermute_64 __P((long, long*, long, float*, long));
extern void spocon __P((char, int, float*, int, float, float*, int*));
extern void spocon_64 __P((char, long, float*, long, float, float*, long*));
extern void spoequ __P((int, float*, int, float*, float*, float*, int*));
extern void spoequ_64 __P((long, float*, long, float*, float*, float*, long*));
extern void sporfs __P((char, int, int, float*, int, float*, int, float*, int, float*, int, float*, float*, int*));
extern void sporfs_64 __P((char, long, long, float*, long, float*, long, float*, long, float*, long, float*, float*, long*));
extern void sposv __P((char, int, int, float*, int, float*, int, int*));
extern void sposv_64 __P((char, long, long, float*, long, float*, long, long*));
extern void sposvx __P((char, char, int, int, float*, int, float*, int, char, float*, float*, int, float*, int, float*, float*, float*, int*));
extern void sposvx_64 __P((char, char, long, long, float*, long, float*, long, char, float*, float*, long, float*, long, float*, float*, float*, long*));
extern void spotf2 __P((char, int, float*, int, int*));
extern void spotf2_64 __P((char, long, float*, long, long*));
extern void spotrf __P((char, int, float*, int, int*));
extern void spotrf_64 __P((char, long, float*, long, long*));
extern void spotri __P((char, int, float*, int, int*));
extern void spotri_64 __P((char, long, float*, long, long*));
extern void spotrs __P((char, int, int, float*, int, float*, int, int*));
extern void spotrs_64 __P((char, long, long, float*, long, float*, long, long*));
extern void sppcon __P((char, int, float*, float, float*, int*));
extern void sppcon_64 __P((char, long, float*, float, float*, long*));
extern void sppequ __P((char, int, float*, float*, float*, float*, int*));
extern void sppequ_64 __P((char, long, float*, float*, float*, float*, long*));
extern void spprfs __P((char, int, int, float*, float*, float*, int, float*, int, float*, float*, int*));
extern void spprfs_64 __P((char, long, long, float*, float*, float*, long, float*, long, float*, float*, long*));
extern void sppsv __P((char, int, int, float*, float*, int, int*));
extern void sppsv_64 __P((char, long, long, float*, float*, long, long*));
extern void sppsvx __P((char, char, int, int, float*, float*, char, float*, float*, int, float*, int, float*, float*, float*, int*));
extern void sppsvx_64 __P((char, char, long, long, float*, float*, char, float*, float*, long, float*, long, float*, float*, float*, long*));
extern void spptrf __P((char, int, float*, int*));
extern void spptrf_64 __P((char, long, float*, long*));
extern void spptri __P((char, int, float*, int*));
extern void spptri_64 __P((char, long, float*, long*));
extern void spptrs __P((char, int, int, float*, float*, int, int*));
extern void spptrs_64 __P((char, long, long, float*, float*, long, long*));
extern void sptcon __P((int, float*, float*, float, float*, int*));
extern void sptcon_64 __P((long, float*, float*, float, float*, long*));
extern void spteqr __P((char, int, float*, float*, float*, int, int*));
extern void spteqr_64 __P((char, long, float*, float*, float*, long, long*));
extern void sptrfs __P((int, int, float*, float*, float*, float*, float*, int, float*, int, float*, float*, int*));
extern void sptrfs_64 __P((long, long, float*, float*, float*, float*, float*, long, float*, long, float*, float*, long*));
extern void sptsv __P((int, int, float*, float*, float*, int, int*));
extern void sptsv_64 __P((long, long, float*, float*, float*, long, long*));
extern void sptsvx __P((char, int, int, float*, float*, float*, float*, float*, int, float*, int, float*, float*, float*, int*));
extern void sptsvx_64 __P((char, long, long, float*, float*, float*, float*, float*, long, float*, long, float*, float*, float*, long*));
extern void spttrf __P((int, float*, float*, int*));
extern void spttrf_64 __P((long, float*, float*, long*));
extern void spttrs __P((int, int, float*, float*, float*, int, int*));
extern void spttrs_64 __P((long, long, float*, float*, float*, long, long*));
extern void sptts2 __P((int, int, float*, float*, float*, int));
extern void sptts2_64 __P((long, long, float*, float*, float*, long));
extern void srot __P((int, float*, int, float*, int, float, float));
extern void srot_64 __P((long, float*, long, float*, long, float, float));
extern void srotg __P((float*, float*, float*, float*));
extern void srotg_64 __P((float*, float*, float*, float*));
extern void sroti __P((int, float*, int*, float*, float, float));
extern void sroti_64 __P((long, float*, long*, float*, float, float));
extern void srotm __P((int, float*, int, float*, int, float*));
extern void srotm_64 __P((long, float*, long, float*, long, float*));
extern void srotmg __P((float, float, float, float, float*));
extern void srotmg_64 __P((float, float, float, float, float*));
extern void ssbev __P((char, char, int, int, float*, int, float*, float*, int, int*));
extern void ssbev_64 __P((char, char, long, long, float*, long, float*, float*, long, long*));
extern void ssbevd __P((char, char, int, int, float*, int, float*, float*, int, int*));
extern void ssbevd_64 __P((char, char, long, long, float*, long, float*, float*, long, long*));
extern void ssbevx __P((char, char, char, int, int, float*, int, float*, int, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void ssbevx_64 __P((char, char, char, long, long, float*, long, float*, long, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void ssbgst __P((char, char, int, int, int, float*, int, float*, int, float*, int, int*));
extern void ssbgst_64 __P((char, char, long, long, long, float*, long, float*, long, float*, long, long*));
extern void ssbgv __P((char, char, int, int, int, float*, int, float*, int, float*, float*, int, int*));
extern void ssbgv_64 __P((char, char, long, long, long, float*, long, float*, long, float*, float*, long, long*));
extern void ssbgvd __P((char, char, int, int, int, float*, int, float*, int, float*, float*, int, int*));
extern void ssbgvd_64 __P((char, char, long, long, long, float*, long, float*, long, float*, float*, long, long*));
extern void ssbgvx __P((char, char, char, int, int, int, float*, int, float*, int, float*, int, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void ssbgvx_64 __P((char, char, char, long, long, long, float*, long, float*, long, float*, long, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void ssbmv __P((char, int, int, float, float*, int, float*, int, float, float*, int));
extern void ssbmv_64 __P((char, long, long, float, float*, long, float*, long, float, float*, long));
extern void ssbtrd __P((char, char, int, int, float*, int, float*, float*, float*, int, int*));
extern void ssbtrd_64 __P((char, char, long, long, float*, long, float*, float*, float*, long, long*));
extern void sscal __P((int, float, float*, int));
extern void sscal_64 __P((long, float, float*, long));
extern void ssctr __P((int, float*, int*, float*));
extern void ssctr_64 __P((long, float*, long*, float*));
extern void sskymm __P((int, int, int, int, float, int*, float*, int*, float*, int, float, float*, int));
extern void sskymm_64 __P((long, long, long, long, float, long*, float*, long*, float*, long, float, float*, long));
extern void sskysm __P((int, int, int, int, float*, float, int*, float*, int*, float*, int, float, float*, int));
extern void sskysm_64 __P((long, long, long, long, float*, float, long*, float*, long*, float*, long, float, float*, long));
extern void BLAS_ssort __P((int, int, float*, int));
extern void BLAS_ssort_64 __P((long, long, float*, long));
extern void BLAS_ssortv __P((int, int, float*, int, int*, int));
extern void BLAS_ssortv_64 __P((long, long, float*, long, long*, long));
extern void ssort __P((int, int, float*, int));
extern void ssort_64 __P((long, long, float*, long));
extern void ssortv __P((int, int, float*, int, int*, int));
extern void ssortv_64 __P((long, long, float*, long, long*, long));
extern void sspcon __P((char, int, float*, int*, float, float*, int*));
extern void sspcon_64 __P((char, long, float*, long*, float, float*, long*));
extern void sspev __P((char, char, int, float*, float*, float*, int, int*));
extern void sspev_64 __P((char, char, long, float*, float*, float*, long, long*));
extern void sspevd __P((char, char, int, float*, float*, float*, int, int*));
extern void sspevd_64 __P((char, char, long, float*, float*, float*, long, long*));
extern void sspevx __P((char, char, char, int, float*, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void sspevx_64 __P((char, char, char, long, float*, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void sspgst __P((int, char, int, float*, float*, int*));
extern void sspgst_64 __P((long, char, long, float*, float*, long*));
extern void sspgv __P((int, char, char, int, float*, float*, float*, float*, int, int*));
extern void sspgv_64 __P((long, char, char, long, float*, float*, float*, float*, long, long*));
extern void sspgvd __P((int, char, char, int, float*, float*, float*, float*, int, int*));
extern void sspgvd_64 __P((long, char, char, long, float*, float*, float*, float*, long, long*));
extern void sspgvx __P((int, char, char, char, int, float*, float*, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void sspgvx_64 __P((long, char, char, char, long, float*, float*, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void sspmv __P((char, int, float, float*, float*, int, float, float*, int));
extern void sspmv_64 __P((char, long, float, float*, float*, long, float, float*, long));
extern void sspr __P((char, int, float, float*, int, float*));
extern void sspr_64 __P((char, long, float, float*, long, float*));
extern void sspr2 __P((char, int, float, float*, int, float*, int, float*));
extern void sspr2_64 __P((char, long, float, float*, long, float*, long, float*));
extern void ssprfs __P((char, int, int, float*, float*, int*, float*, int, float*, int, float*, float*, int*));
extern void ssprfs_64 __P((char, long, long, float*, float*, long*, float*, long, float*, long, float*, float*, long*));
extern void sspsv __P((char, int, int, float*, int*, float*, int, int*));
extern void sspsv_64 __P((char, long, long, float*, long*, float*, long, long*));
extern void sspsvx __P((char, char, int, int, float*, float*, int*, float*, int, float*, int, float*, float*, float*, int*));
extern void sspsvx_64 __P((char, char, long, long, float*, float*, long*, float*, long, float*, long, float*, float*, float*, long*));
extern void ssptrd __P((char, int, float*, float*, float*, float*, int*));
extern void ssptrd_64 __P((char, long, float*, float*, float*, float*, long*));
extern void ssptrf __P((char, int, float*, int*, int*));
extern void ssptrf_64 __P((char, long, float*, long*, long*));
extern void ssptri __P((char, int, float*, int*, int*));
extern void ssptri_64 __P((char, long, float*, long*, long*));
extern void ssptrs __P((char, int, int, float*, int*, float*, int, int*));
extern void ssptrs_64 __P((char, long, long, float*, long*, float*, long, long*));
extern void sstebz __P((char, char, int, float, float, int, int, float, float*, float*, int*, int*, float*, int*, int*, int*));
extern void sstebz_64 __P((char, char, long, float, float, long, long, float, float*, float*, long*, long*, float*, long*, long*, long*));
extern void sstedc __P((char, int, float*, float*, float*, int, int*));
extern void sstedc_64 __P((char, long, float*, float*, float*, long, long*));
extern void sstegr __P((char, char, int, float*, float*, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void sstegr_64 __P((char, char, long, float*, float*, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void sstein __P((int, float*, float*, int, float*, int*, int*, float*, int, int*, int*));
extern void sstein_64 __P((long, float*, float*, long, float*, long*, long*, float*, long, long*, long*));
extern void ssteqr __P((char, int, float*, float*, float*, int, int*));
extern void ssteqr_64 __P((char, long, float*, float*, float*, long, long*));
extern void ssterf __P((int, float*, float*, int*));
extern void ssterf_64 __P((long, float*, float*, long*));
extern void sstev __P((char, int, float*, float*, float*, int, int*));
extern void sstev_64 __P((char, long, float*, float*, float*, long, long*));
extern void sstevd __P((char, int, float*, float*, float*, int, int*));
extern void sstevd_64 __P((char, long, float*, float*, float*, long, long*));
extern void sstevr __P((char, char, int, float*, float*, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void sstevr_64 __P((char, char, long, float*, float*, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void sstevx __P((char, char, int, float*, float*, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void sstevx_64 __P((char, char, long, float*, float*, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void sstsv __P((int, int, float*, float*, float*, float*, int, int*, int*));
extern void sstsv_64 __P((long, long, float*, float*, float*, float*, long, long*, long*));
extern void ssttrf __P((int, float*, float*, float*, int*, int*));
extern void ssttrf_64 __P((long, float*, float*, float*, long*, long*));
extern void ssttrs __P((int, int, float*, float*, float*, float*, int, int*, int*));
extern void ssttrs_64 __P((long, long, float*, float*, float*, float*, long, long*, long*));
extern void sswap __P((int, float*, int, float*, int));
extern void sswap_64 __P((long, float*, long, float*, long));
extern void ssycon __P((char, int, float*, int, int*, float, float*, int*));
extern void ssycon_64 __P((char, long, float*, long, long*, float, float*, long*));
extern void ssyev __P((char, char, int, float*, int, float*, int*));
extern void ssyev_64 __P((char, char, long, float*, long, float*, long*));
extern void ssyevd __P((char, char, int, float*, int, float*, int*));
extern void ssyevd_64 __P((char, char, long, float*, long, float*, long*));
extern void ssyevr __P((char, char, char, int, float*, int, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void ssyevr_64 __P((char, char, char, long, float*, long, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void ssyevx __P((char, char, char, int, float*, int, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void ssyevx_64 __P((char, char, char, long, float*, long, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void ssygs2 __P((int, char, int, float*, int, float*, int, int*));
extern void ssygs2_64 __P((long, char, long, float*, long, float*, long, long*));
extern void ssygst __P((int, char, int, float*, int, float*, int, int*));
extern void ssygst_64 __P((long, char, long, float*, long, float*, long, long*));
extern void ssygv __P((int, char, char, int, float*, int, float*, int, float*, int*));
extern void ssygv_64 __P((long, char, char, long, float*, long, float*, long, float*, long*));
extern void ssygvd __P((int, char, char, int, float*, int, float*, int, float*, int*));
extern void ssygvd_64 __P((long, char, char, long, float*, long, float*, long, float*, long*));
extern void ssygvx __P((int, char, char, char, int, float*, int, float*, int, float, float, int, int, float, int*, float*, float*, int, int*, int*));
extern void ssygvx_64 __P((long, char, char, char, long, float*, long, float*, long, float, float, long, long, float, long*, float*, float*, long, long*, long*));
extern void ssymm __P((char, char, int, int, float, float*, int, float*, int, float, float*, int));
extern void ssymm_64 __P((char, char, long, long, float, float*, long, float*, long, float, float*, long));
extern void ssymv __P((char, int, float, float*, int, float*, int, float, float*, int));
extern void ssymv_64 __P((char, long, float, float*, long, float*, long, float, float*, long));
extern void ssyr __P((char, int, float, float*, int, float*, int));
extern void ssyr_64 __P((char, long, float, float*, long, float*, long));
extern void ssyr2 __P((char, int, float, float*, int, float*, int, float*, int));
extern void ssyr2_64 __P((char, long, float, float*, long, float*, long, float*, long));
extern void ssyr2k __P((char, char, int, int, float, float*, int, float*, int, float, float*, int));
extern void ssyr2k_64 __P((char, char, long, long, float, float*, long, float*, long, float, float*, long));
extern void ssyrfs __P((char, int, int, float*, int, float*, int, int*, float*, int, float*, int, float*, float*, int*));
extern void ssyrfs_64 __P((char, long, long, float*, long, float*, long, long*, float*, long, float*, long, float*, float*, long*));
extern void ssyrk __P((char, char, int, int, float, float*, int, float, float*, int));
extern void ssyrk_64 __P((char, char, long, long, float, float*, long, float, float*, long));
extern void ssysv __P((char, int, int, float*, int, int*, float*, int, int*));
extern void ssysv_64 __P((char, long, long, float*, long, long*, float*, long, long*));
extern void ssysvx __P((char, char, int, int, float*, int, float*, int, int*, float*, int, float*, int, float*, float*, float*, int*));
extern void ssysvx_64 __P((char, char, long, long, float*, long, float*, long, long*, float*, long, float*, long, float*, float*, float*, long*));
extern void ssytd2 __P((char, int, float*, int, float*, float*, float*, int*));
extern void ssytd2_64 __P((char, long, float*, long, float*, float*, float*, long*));
extern void ssytf2 __P((char, int, float*, int, int*, int*));
extern void ssytf2_64 __P((char, long, float*, long, long*, long*));
extern void ssytrd __P((char, int, float*, int, float*, float*, float*, int*));
extern void ssytrd_64 __P((char, long, float*, long, float*, float*, float*, long*));
extern void ssytrf __P((char, int, float*, int, int*, int*));
extern void ssytrf_64 __P((char, long, float*, long, long*, long*));
extern void ssytri __P((char, int, float*, int, int*, int*));
extern void ssytri_64 __P((char, long, float*, long, long*, long*));
extern void ssytrs __P((char, int, int, float*, int, int*, float*, int, int*));
extern void ssytrs_64 __P((char, long, long, float*, long, long*, float*, long, long*));
extern void stbcon __P((char, char, char, int, int, float*, int, float*, int*));
extern void stbcon_64 __P((char, char, char, long, long, float*, long, float*, long*));
extern void stbmv __P((char, char, char, int, int, float*, int, float*, int));
extern void stbmv_64 __P((char, char, char, long, long, float*, long, float*, long));
extern void stbrfs __P((char, char, char, int, int, int, float*, int, float*, int, float*, int, float*, float*, int*));
extern void stbrfs_64 __P((char, char, char, long, long, long, float*, long, float*, long, float*, long, float*, float*, long*));
extern void stbsv __P((char, char, char, int, int, float*, int, float*, int));
extern void stbsv_64 __P((char, char, char, long, long, float*, long, float*, long));
extern void stbtrs __P((char, char, char, int, int, int, float*, int, float*, int, int*));
extern void stbtrs_64 __P((char, char, char, long, long, long, float*, long, float*, long, long*));
extern void stgevc __P((char, char, int*, int, float*, int, float*, int, float*, int, float*, int, int, int*, int*));
extern void stgevc_64 __P((char, char, long*, long, float*, long, float*, long, float*, long, float*, long, long, long*, long*));
extern void stgexc __P((int, int, int, float*, int, float*, int, float*, int, float*, int, int*, int*, int*));
extern void stgexc_64 __P((long, long, long, float*, long, float*, long, float*, long, float*, long, long*, long*, long*));
extern void stgsen __P((int, int, int, int*, int, float*, int, float*, int, float*, float*, float*, float*, int, float*, int, int*, float*, float*, float*, int*));
extern void stgsen_64 __P((long, long, long, long*, long, float*, long, float*, long, float*, float*, float*, float*, long, float*, long, long*, float*, float*, float*, long*));
extern void stgsja __P((char, char, char, int, int, int, int, int, float*, int, float*, int, float, float, float*, float*, float*, int, float*, int, float*, int, int*, int*));
extern void stgsja_64 __P((char, char, char, long, long, long, long, long, float*, long, float*, long, float, float, float*, float*, float*, long, float*, long, float*, long, long*, long*));
extern void stgsna __P((char, char, int*, int, float*, int, float*, int, float*, int, float*, int, float*, float*, int, int*, int*));
extern void stgsna_64 __P((char, char, long*, long, float*, long, float*, long, float*, long, float*, long, float*, float*, long, long*, long*));
extern void stgsyl __P((char, int, int, int, float*, int, float*, int, float*, int, float*, int, float*, int, float*, int, float*, float*, int*));
extern void stgsyl_64 __P((char, long, long, long, float*, long, float*, long, float*, long, float*, long, float*, long, float*, long, float*, float*, long*));
extern void stpcon __P((char, char, char, int, float*, float*, int*));
extern void stpcon_64 __P((char, char, char, long, float*, float*, long*));
extern void stpmv __P((char, char, char, int, float*, float*, int));
extern void stpmv_64 __P((char, char, char, long, float*, float*, long));
extern void stprfs __P((char, char, char, int, int, float*, float*, int, float*, int, float*, float*, int*));
extern void stprfs_64 __P((char, char, char, long, long, float*, float*, long, float*, long, float*, float*, long*));
extern void stpsv __P((char, char, char, int, float*, float*, int));
extern void stpsv_64 __P((char, char, char, long, float*, float*, long));
extern void stptri __P((char, char, int, float*, int*));
extern void stptri_64 __P((char, char, long, float*, long*));
extern void stptrs __P((char, char, char, int, int, float*, float*, int, int*));
extern void stptrs_64 __P((char, char, char, long, long, float*, float*, long, long*));
extern void strans __P((char, float, float*, int, int, float*));
extern void strans_64 __P((char, float, float*, long, long, float*));
extern void strcon __P((char, char, char, int, float*, int, float*, int*));
extern void strcon_64 __P((char, char, char, long, float*, long, float*, long*));
extern void strevc __P((char, char, int*, int, float*, int, float*, int, float*, int, int, int*, int*));
extern void strevc_64 __P((char, char, long*, long, float*, long, float*, long, float*, long, long, long*, long*));
extern void strexc __P((char, int, float*, int, float*, int, int*, int*, int*));
extern void strexc_64 __P((char, long, float*, long, float*, long, long*, long*, long*));
extern void strmm __P((char, char, char, char, int, int, float, float*, int, float*, int));
extern void strmm_64 __P((char, char, char, char, long, long, float, float*, long, float*, long));
extern void strmv __P((char, char, char, int, float*, int, float*, int));
extern void strmv_64 __P((char, char, char, long, float*, long, float*, long));
extern void strrfs __P((char, char, char, int, int, float*, int, float*, int, float*, int, float*, float*, int*));
extern void strrfs_64 __P((char, char, char, long, long, float*, long, float*, long, float*, long, float*, float*, long*));
extern void strsen __P((char, char, int*, int, float*, int, float*, int, float*, float*, int*, float*, float*, int*));
extern void strsen_64 __P((char, char, long*, long, float*, long, float*, long, float*, float*, long*, float*, float*, long*));
extern void strsm __P((char, char, char, char, int, int, float, float*, int, float*, int));
extern void strsm_64 __P((char, char, char, char, long, long, float, float*, long, float*, long));
extern void strsna __P((char, char, int*, int, float*, int, float*, int, float*, int, float*, float*, int, int*, int, int*));
extern void strsna_64 __P((char, char, long*, long, float*, long, float*, long, float*, long, float*, float*, long, long*, long, long*));
extern void strsv __P((char, char, char, int, float*, int, float*, int));
extern void strsv_64 __P((char, char, char, long, float*, long, float*, long));
extern void strsyl __P((char, char, int, int, int, float*, int, float*, int, float*, int, float*, int*));
extern void strsyl_64 __P((char, char, long, long, long, float*, long, float*, long, float*, long, float*, long*));
extern void strti2 __P((char, char, int, float*, int, int*));
extern void strti2_64 __P((char, char, long, float*, long, long*));
extern void strtri __P((char, char, int, float*, int, int*));
extern void strtri_64 __P((char, char, long, float*, long, long*));
extern void strtrs __P((char, char, char, int, int, float*, int, float*, int, int*));
extern void strtrs_64 __P((char, char, char, long, long, float*, long, float*, long, long*));
extern void stzrqf __P((int, int, float*, int, float*, int*));
extern void stzrqf_64 __P((long, long, float*, long, float*, long*));
extern void stzrzf __P((int, int, float*, int, float*, int*));
extern void stzrzf_64 __P((long, long, float*, long, float*, long*));
extern char *sunperf_version __P((int*, int*, int*));
extern char *sunperf_version_64 __P((long*, long*, long*));
extern void svbrmm __P((int, int, int, int, float, int*, float*, int*, int*, int*, int*, int*, int*, float*, int, float, float*, int));
extern void svbrmm_64 __P((long, long, long, long, float, long*, float*, long*, long*, long*, long*, long*, long*, float*, long, float, float*, long));
extern void svbrsm __P((int, int, int, int, float*, float, int*, float*, int*, int*, int*, int*, int*, int*, float*, int, float, float*, int));
extern void svbrsm_64 __P((long, long, long, long, float*, float, long*, float*, long*, long*, long*, long*, long*, long*, float*, long, float, float*, long));
extern void swiener __P((int, float*, float*, float*, float*, int*, int*));
extern void swiener_64 __P((long, float*, float*, float*, float*, long*, long*));
extern void use_threads __P((int));
extern void use_threads_64 __P((long));
extern int using_threads __P((void));
extern long using_threads_64 __P((void));
extern void vcfftb __P((int, int, complex*, complex*, int, char, complex*));
extern void vcfftb_64 __P((long, long, complex*, complex*, long, char, complex*));
extern void vcfftf __P((int, int, complex*, complex*, int, char, complex*));
extern void vcfftf_64 __P((long, long, complex*, complex*, long, char, complex*));
extern void vcffti __P((int, complex*));
extern void vcffti_64 __P((long, complex*));
extern void vcosqb __P((int, int, float*, float*, int, float*));
extern void vcosqb_64 __P((long, long, float*, float*, long, float*));
extern void vcosqf __P((int, int, float*, float*, int, float*));
extern void vcosqf_64 __P((long, long, float*, float*, long, float*));
extern void vcosqi __P((int, float*));
extern void vcosqi_64 __P((long, float*));
extern void vcost __P((int, int, float*, float*, int, float*));
extern void vcost_64 __P((long, long, float*, float*, long, float*));
extern void vcosti __P((int, float*));
extern void vcosti_64 __P((long, float*));
extern void vdcosqb __P((int, int, double*, double*, int, double*));
extern void vdcosqb_64 __P((long, long, double*, double*, long, double*));
extern void vdcosqf __P((int, int, double*, double*, int, double*));
extern void vdcosqf_64 __P((long, long, double*, double*, long, double*));
extern void vdcosqi __P((int, double*));
extern void vdcosqi_64 __P((long, double*));
extern void vdcost __P((int, int, double*, double*, int, double*));
extern void vdcost_64 __P((long, long, double*, double*, long, double*));
extern void vdcosti __P((int, double*));
extern void vdcosti_64 __P((long, double*));
extern void vdfftb __P((int, int, double*, double*, int, double*));
extern void vdfftb_64 __P((long, long, double*, double*, long, double*));
extern void vdfftf __P((int, int, double*, double*, int, double*));
extern void vdfftf_64 __P((long, long, double*, double*, long, double*));
extern void vdffti __P((int, double*));
extern void vdffti_64 __P((long, double*));
extern void vdsinqb __P((int, int, double*, double*, int, double*));
extern void vdsinqb_64 __P((long, long, double*, double*, long, double*));
extern void vdsinqf __P((int, int, double*, double*, int, double*));
extern void vdsinqf_64 __P((long, long, double*, double*, long, double*));
extern void vdsinqi __P((int, double*));
extern void vdsinqi_64 __P((long, double*));
extern void vdsint __P((int, int, double*, double*, int, double*));
extern void vdsint_64 __P((long, long, double*, double*, long, double*));
extern void vdsinti __P((int, double*));
extern void vdsinti_64 __P((long, double*));
extern void vrfftb __P((int, int, float*, float*, int, float*));
extern void vrfftb_64 __P((long, long, float*, float*, long, float*));
extern void vrfftf __P((int, int, float*, float*, int, float*));
extern void vrfftf_64 __P((long, long, float*, float*, long, float*));
extern void vrffti __P((int, float*));
extern void vrffti_64 __P((long, float*));
extern void vsinqb __P((int, int, float*, float*, int, float*));
extern void vsinqb_64 __P((long, long, float*, float*, long, float*));
extern void vsinqf __P((int, int, float*, float*, int, float*));
extern void vsinqf_64 __P((long, long, float*, float*, long, float*));
extern void vsinqi __P((int, float*));
extern void vsinqi_64 __P((long, float*));
extern void vsint __P((int, int, float*, float*, int, float*));
extern void vsint_64 __P((long, long, float*, float*, long, float*));
extern void vsinti __P((int, float*));
extern void vsinti_64 __P((long, float*));
extern void vzfftb __P((int, int, doublecomplex*, doublecomplex*, int, char, doublecomplex*));
extern void vzfftb_64 __P((long, long, doublecomplex*, doublecomplex*, long, char, doublecomplex*));
extern void vzfftf __P((int, int, doublecomplex*, doublecomplex*, int, char, doublecomplex*));
extern void vzfftf_64 __P((long, long, doublecomplex*, doublecomplex*, long, char, doublecomplex*));
extern void vzffti __P((int, doublecomplex*));
extern void vzffti_64 __P((long, doublecomplex*));
extern void xerbla __P((char*, int));
extern void xerbla_64 __P((char*, long));
extern void zaxpy __P((int, doublecomplex*, doublecomplex*, int, doublecomplex*, int));
extern void zaxpy_64 __P((long, doublecomplex*, doublecomplex*, long, doublecomplex*, long));
extern void zaxpyi __P((int, doublecomplex*, doublecomplex*, int*, doublecomplex*));
extern void zaxpyi_64 __P((long, doublecomplex*, doublecomplex*, long*, doublecomplex*));
extern void zbcomm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbcomm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbdimm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int, int*, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbdimm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long, long*, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbdism __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, int*, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbdism_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, long*, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbdsqr __P((char, int, int, int, int, double*, double*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zbdsqr_64 __P((char, long, long, long, long, double*, double*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zbelmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbelmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbelsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbelsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbscmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbscmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbscsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int*, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbscsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long*, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbsrmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbsrmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zbsrsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int*, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zbsrsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long*, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zcnvcor __P((char, char, int, doublecomplex*, int, int, int, int, int, doublecomplex*, int, int, int, int, int, doublecomplex*, int, int, int, doublecomplex*, int));
extern void zcnvcor_64 __P((char, char, long, doublecomplex*, long, long, long, long, long, doublecomplex*, long, long, long, long, long, doublecomplex*, long, long, long, doublecomplex*, long));
extern void zcnvcor2 __P((char, char, char, char, char, char, int, int, doublecomplex*, int, int, int, int, int, doublecomplex*, int, int, int, doublecomplex*, int, doublecomplex*, int));
extern void zcnvcor2_64 __P((char, char, char, char, char, char, long, long, doublecomplex*, long, long, long, long, long, doublecomplex*, long, long, long, doublecomplex*, long, doublecomplex*, long));
extern void zcoomm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zcoomm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zcopy __P((int, doublecomplex*, int, doublecomplex*, int));
extern void zcopy_64 __P((long, doublecomplex*, long, doublecomplex*, long));
extern void zcscmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zcscmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zcscsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zcscsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zcsrmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zcsrmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zcsrsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zcsrsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zdiamm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zdiamm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zdiasm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zdiasm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern doublecomplex zdotc __P((int, doublecomplex*, int, doublecomplex*, int));
extern doublecomplex zdotc_64 __P((long, doublecomplex*, long, doublecomplex*, long));
extern doublecomplex zdotci __P((int, doublecomplex*, int*, doublecomplex*));
extern doublecomplex zdotci_64 __P((long, doublecomplex*, long*, doublecomplex*));
extern doublecomplex zdotu __P((int, doublecomplex*, int, doublecomplex*, int));
extern doublecomplex zdotu_64 __P((long, doublecomplex*, long, doublecomplex*, long));
extern doublecomplex zdotui __P((int, doublecomplex*, int*, doublecomplex*));
extern doublecomplex zdotui_64 __P((long, doublecomplex*, long*, doublecomplex*));
extern void zdrot __P((int, doublecomplex*, int, doublecomplex*, int, double, double));
extern void zdrot_64 __P((long, doublecomplex*, long, doublecomplex*, long, double, double));
extern void zdscal __P((int, double, doublecomplex*, int));
extern void zdscal_64 __P((long, double, doublecomplex*, long));
extern void zellmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zellmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zellsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zellsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zfft2b __P((int, int, doublecomplex*, int, double*, int));
extern void zfft2b_64 __P((long, long, doublecomplex*, long, double*, long));
extern void zfft2f __P((int, int, doublecomplex*, int, double*, int));
extern void zfft2f_64 __P((long, long, doublecomplex*, long, double*, long));
extern void zfft2i __P((int, int, double*));
extern void zfft2i_64 __P((long, long, double*));
extern void zfft3b __P((int, int, int, doublecomplex*, int, int, double*, int));
extern void zfft3b_64 __P((long, long, long, doublecomplex*, long, long, double*, long));
extern void zfft3f __P((int, int, int, doublecomplex*, int, int, double*, int));
extern void zfft3f_64 __P((long, long, long, doublecomplex*, long, long, double*, long));
extern void zfft3i __P((int, int, int, double*));
extern void zfft3i_64 __P((long, long, long, double*));
extern void zfftb __P((int, doublecomplex*, double*));
extern void zfftb_64 __P((long, doublecomplex*, double*));
extern void zfftf __P((int, doublecomplex*, double*));
extern void zfftf_64 __P((long, doublecomplex*, double*));
extern void zffti __P((int, double*));
extern void zffti_64 __P((long, double*));
extern int zfftopt __P((int));
extern long zfftopt_64 __P((long));
extern void zgbbrd __P((char, int, int, int, int, int, doublecomplex*, int, double*, double*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgbbrd_64 __P((char, long, long, long, long, long, doublecomplex*, long, double*, double*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgbcon __P((char, int, int, int, doublecomplex*, int, int*, double, double*, int*));
extern void zgbcon_64 __P((char, long, long, long, doublecomplex*, long, long*, double, double*, long*));
extern void zgbequ __P((int, int, int, int, doublecomplex*, int, double*, double*, double*, double*, double*, int*));
extern void zgbequ_64 __P((long, long, long, long, doublecomplex*, long, double*, double*, double*, double*, double*, long*));
extern void zgbmv __P((char, int, int, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zgbmv_64 __P((char, long, long, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zgbrfs __P((char, int, int, int, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zgbrfs_64 __P((char, long, long, long, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zgbsv __P((int, int, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zgbsv_64 __P((long, long, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zgbsvx __P((char, char, int, int, int, int, doublecomplex*, int, doublecomplex*, int, int*, char, double*, double*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zgbsvx_64 __P((char, char, long, long, long, long, doublecomplex*, long, doublecomplex*, long, long*, char, double*, double*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zgbtf2 __P((int, int, int, int, doublecomplex*, int, int*, int*));
extern void zgbtf2_64 __P((long, long, long, long, doublecomplex*, long, long*, long*));
extern void zgbtrf __P((int, int, int, int, doublecomplex*, int, int*, int*));
extern void zgbtrf_64 __P((long, long, long, long, doublecomplex*, long, long*, long*));
extern void zgbtrs __P((char, int, int, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zgbtrs_64 __P((char, long, long, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zgebak __P((char, char, int, int, int, double*, int, doublecomplex*, int, int*));
extern void zgebak_64 __P((char, char, long, long, long, double*, long, doublecomplex*, long, long*));
extern void zgebal __P((char, int, doublecomplex*, int, int*, int*, double*, int*));
extern void zgebal_64 __P((char, long, doublecomplex*, long, long*, long*, double*, long*));
extern void zgebrd __P((int, int, doublecomplex*, int, double*, double*, doublecomplex*, doublecomplex*, int*));
extern void zgebrd_64 __P((long, long, doublecomplex*, long, double*, double*, doublecomplex*, doublecomplex*, long*));
extern void zgecon __P((char, int, doublecomplex*, int, double, double*, int*));
extern void zgecon_64 __P((char, long, doublecomplex*, long, double, double*, long*));
extern void zgeequ __P((int, int, doublecomplex*, int, double*, double*, double*, double*, double*, int*));
extern void zgeequ_64 __P((long, long, doublecomplex*, long, double*, double*, double*, double*, double*, long*));
extern void zgees __P((char, char, int(*select)(doublecomplex), int, doublecomplex*, int, int*, doublecomplex*, doublecomplex*, int, int*));
extern void zgees_64 __P((char, char, long(*select)(doublecomplex), long, doublecomplex*, long, long*, doublecomplex*, doublecomplex*, long, long*));
extern void zgeesx __P((char, char, int(*select)(doublecomplex), char, int, doublecomplex*, int, int*, doublecomplex*, doublecomplex*, int, double*, double*, int*));
extern void zgeesx_64 __P((char, char, long(*select)(doublecomplex), char, long, doublecomplex*, long, long*, doublecomplex*, doublecomplex*, long, double*, double*, long*));
extern void zgeev __P((char, char, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgeev_64 __P((char, char, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgeevx __P((char, char, char, char, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*, int*, double*, double*, double*, double*, int*));
extern void zgeevx_64 __P((char, char, char, char, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*, long*, double*, double*, double*, double*, long*));
extern void zgegs __P((char, char, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgegs_64 __P((char, char, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgegv __P((char, char, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgegv_64 __P((char, char, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgehrd __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zgehrd_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zgelqf __P((int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zgelqf_64 __P((long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zgels __P((char, int, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgels_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgelsd __P((int, int, int, doublecomplex*, int, doublecomplex*, int, double*, double, int*, int*));
extern void zgelsd_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, double*, double, long*, long*));
extern void zgelss __P((int, int, int, doublecomplex*, int, doublecomplex*, int, double*, double, int*, int*));
extern void zgelss_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, double*, double, long*, long*));
extern void zgelsx __P((int, int, int, doublecomplex*, int, doublecomplex*, int, int*, double, int*, int*));
extern void zgelsx_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, long*, double, long*, long*));
extern void zgelsy __P((int, int, int, doublecomplex*, int, doublecomplex*, int, int*, double, int*, int*));
extern void zgelsy_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, long*, double, long*, long*));
extern void zgemm __P((char, char, int, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zgemm_64 __P((char, char, long, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zgemv __P((char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zgemv_64 __P((char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zgeqlf __P((int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zgeqlf_64 __P((long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zgeqp3 __P((int, int, doublecomplex*, int, int*, doublecomplex*, int*));
extern void zgeqp3_64 __P((long, long, doublecomplex*, long, long*, doublecomplex*, long*));
extern void zgeqpf __P((int, int, doublecomplex*, int, int*, doublecomplex*, int*));
extern void zgeqpf_64 __P((long, long, doublecomplex*, long, long*, doublecomplex*, long*));
extern void zgeqrf __P((int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zgeqrf_64 __P((long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zgerc __P((int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int));
extern void zgerc_64 __P((long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long));
extern void zgerfs __P((char, int, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zgerfs_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zgerqf __P((int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zgerqf_64 __P((long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zgeru __P((int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int));
extern void zgeru_64 __P((long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long));
extern void zgesdd __P((char, int, int, doublecomplex*, int, double*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgesdd_64 __P((char, long, long, doublecomplex*, long, double*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgesv __P((int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zgesv_64 __P((long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zgesvd __P((char, char, int, int, doublecomplex*, int, double*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgesvd_64 __P((char, char, long, long, doublecomplex*, long, double*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgesvx __P((char, char, int, int, doublecomplex*, int, doublecomplex*, int, int*, char, double*, double*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zgesvx_64 __P((char, char, long, long, doublecomplex*, long, doublecomplex*, long, long*, char, double*, double*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zgetf2 __P((int, int, doublecomplex*, int, int*, int*));
extern void zgetf2_64 __P((long, long, doublecomplex*, long, long*, long*));
extern void zgetrf __P((int, int, doublecomplex*, int, int*, int*));
extern void zgetrf_64 __P((long, long, doublecomplex*, long, long*, long*));
extern void zgetri __P((int, doublecomplex*, int, int*, int*));
extern void zgetri_64 __P((long, doublecomplex*, long, long*, long*));
extern void zgetrs __P((char, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zgetrs_64 __P((char, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zggbak __P((char, char, int, int, int, double*, double*, int, doublecomplex*, int, int*));
extern void zggbak_64 __P((char, char, long, long, long, double*, double*, long, doublecomplex*, long, long*));
extern void zggbal __P((char, int, doublecomplex*, int, doublecomplex*, int, int*, int*, double*, double*, int*));
extern void zggbal_64 __P((char, long, doublecomplex*, long, doublecomplex*, long, long*, long*, double*, double*, long*));
extern void zgges __P((char, char, char, int(*delztg)(doublecomplex*,doublecomplex), int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgges_64 __P((char, char, char, long(*delztg)(doublecomplex*,doublecomplex), long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zggesx __P((char, char, char, int(*delctg)(doublecomplex*,doublecomplex), char, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zggesx_64 __P((char, char, char, long(*delctg)(doublecomplex*,doublecomplex), char, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zggev __P((char, char, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zggev_64 __P((char, char, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zggevx __P((char, char, char, char, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*, int*, double*, double*, double*, double*, double*, double*, int*));
extern void zggevx_64 __P((char, char, char, char, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*, long*, double*, double*, double*, double*, double*, double*, long*));
extern void zggglm __P((int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int*));
extern void zggglm_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long*));
extern void zgghrd __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zgghrd_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgglse __P((int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int*));
extern void zgglse_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long*));
extern void zggqrf __P((int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int*));
extern void zggqrf_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long*));
extern void zggrqf __P((int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int*));
extern void zggrqf_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long*));
extern void zggsvd __P((char, char, char, int, int, int, int*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*, int*));
extern void zggsvd_64 __P((char, char, char, long, long, long, long*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*, long*));
extern void zggsvp __P((char, char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, double, double, int*, int*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zggsvp_64 __P((char, char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, double, double, long*, long*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zgtcon __P((char, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int*, double, double*, int*));
extern void zgtcon_64 __P((char, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long*, double, double*, long*));
extern void zgthr __P((int, doublecomplex*, doublecomplex*, int*));
extern void zgthr_64 __P((long, doublecomplex*, doublecomplex*, long*));
extern void zgthrz __P((int, doublecomplex*, doublecomplex*, int*));
extern void zgthrz_64 __P((long, doublecomplex*, doublecomplex*, long*));
extern void zgtrfs __P((char, int, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zgtrfs_64 __P((char, long, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zgtsv __P((int, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int, int*));
extern void zgtsv_64 __P((long, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long, long*));
extern void zgtsvx __P((char, char, int, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zgtsvx_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zgttrf __P((int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int*, int*));
extern void zgttrf_64 __P((long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long*, long*));
extern void zgttrs __P((char, int, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, int*));
extern void zgttrs_64 __P((char, long, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, long*));
extern void zhbev __P((char, char, int, int, doublecomplex*, int, double*, doublecomplex*, int, int*));
extern void zhbev_64 __P((char, char, long, long, doublecomplex*, long, double*, doublecomplex*, long, long*));
extern void zhbevd __P((char, char, int, int, doublecomplex*, int, double*, doublecomplex*, int, int*));
extern void zhbevd_64 __P((char, char, long, long, doublecomplex*, long, double*, doublecomplex*, long, long*));
extern void zhbevx __P((char, char, char, int, int, doublecomplex*, int, doublecomplex*, int, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zhbevx_64 __P((char, char, char, long, long, doublecomplex*, long, doublecomplex*, long, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zhbgst __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zhbgst_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zhbgv __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, double*, doublecomplex*, int, int*));
extern void zhbgv_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, double*, doublecomplex*, long, long*));
extern void zhbgvd __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, double*, doublecomplex*, int, int*));
extern void zhbgvd_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, double*, doublecomplex*, long, long*));
extern void zhbgvx __P((char, char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zhbgvx_64 __P((char, char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zhbmv __P((char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zhbmv_64 __P((char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zhbtrd __P((char, char, int, int, doublecomplex*, int, double*, double*, doublecomplex*, int, int*));
extern void zhbtrd_64 __P((char, char, long, long, doublecomplex*, long, double*, double*, doublecomplex*, long, long*));
extern void zhecon __P((char, int, doublecomplex*, int, int*, double, double*, int*));
extern void zhecon_64 __P((char, long, doublecomplex*, long, long*, double, double*, long*));
extern void zheev __P((char, char, int, doublecomplex*, int, double*, int*));
extern void zheev_64 __P((char, char, long, doublecomplex*, long, double*, long*));
extern void zheevd __P((char, char, int, doublecomplex*, int, double*, int*));
extern void zheevd_64 __P((char, char, long, doublecomplex*, long, double*, long*));
extern void zheevr __P((char, char, char, int, doublecomplex*, int, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zheevr_64 __P((char, char, char, long, doublecomplex*, long, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zheevx __P((char, char, char, int, doublecomplex*, int, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zheevx_64 __P((char, char, char, long, doublecomplex*, long, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zhegs2 __P((int, char, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zhegs2_64 __P((long, char, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zhegst __P((int, char, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zhegst_64 __P((long, char, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zhegv __P((int, char, char, int, doublecomplex*, int, doublecomplex*, int, double*, int*));
extern void zhegv_64 __P((long, char, char, long, doublecomplex*, long, doublecomplex*, long, double*, long*));
extern void zhegvd __P((int, char, char, int, doublecomplex*, int, doublecomplex*, int, double*, int*));
extern void zhegvd_64 __P((long, char, char, long, doublecomplex*, long, doublecomplex*, long, double*, long*));
extern void zhegvx __P((int, char, char, char, int, doublecomplex*, int, doublecomplex*, int, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zhegvx_64 __P((long, char, char, char, long, doublecomplex*, long, doublecomplex*, long, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zhemm __P((char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zhemm_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zhemv __P((char, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zhemv_64 __P((char, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zher __P((char, int, double, doublecomplex*, int, doublecomplex*, int));
extern void zher_64 __P((char, long, double, doublecomplex*, long, doublecomplex*, long));
extern void zher2 __P((char, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int));
extern void zher2_64 __P((char, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long));
extern void zher2k __P((char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, double, doublecomplex*, int));
extern void zher2k_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, double, doublecomplex*, long));
extern void zherfs __P((char, int, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zherfs_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zherk __P((char, char, int, int, double, doublecomplex*, int, double, doublecomplex*, int));
extern void zherk_64 __P((char, char, long, long, double, doublecomplex*, long, double, doublecomplex*, long));
extern void zhesv __P((char, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zhesv_64 __P((char, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zhesvx __P((char, char, int, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zhesvx_64 __P((char, char, long, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zhetf2 __P((char, int, doublecomplex*, int, int*, int*));
extern void zhetf2_64 __P((char, long, doublecomplex*, long, long*, long*));
extern void zhetrd __P((char, int, doublecomplex*, int, double*, double*, doublecomplex*, int*));
extern void zhetrd_64 __P((char, long, doublecomplex*, long, double*, double*, doublecomplex*, long*));
extern void zhetrf __P((char, int, doublecomplex*, int, int*, int*));
extern void zhetrf_64 __P((char, long, doublecomplex*, long, long*, long*));
extern void zhetri __P((char, int, doublecomplex*, int, int*, int*));
extern void zhetri_64 __P((char, long, doublecomplex*, long, long*, long*));
extern void zhetrs __P((char, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zhetrs_64 __P((char, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zhgeqz __P((char, char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*));
extern void zhgeqz_64 __P((char, char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*));
extern void zhpcon __P((char, int, doublecomplex*, int*, double, double*, int*));
extern void zhpcon_64 __P((char, long, doublecomplex*, long*, double, double*, long*));
extern void zhpev __P((char, char, int, doublecomplex*, double*, doublecomplex*, int, int*));
extern void zhpev_64 __P((char, char, long, doublecomplex*, double*, doublecomplex*, long, long*));
extern void zhpevd __P((char, char, int, doublecomplex*, double*, doublecomplex*, int, int*));
extern void zhpevd_64 __P((char, char, long, doublecomplex*, double*, doublecomplex*, long, long*));
extern void zhpevx __P((char, char, char, int, doublecomplex*, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zhpevx_64 __P((char, char, char, long, doublecomplex*, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zhpgst __P((int, char, int, doublecomplex*, doublecomplex*, int*));
extern void zhpgst_64 __P((long, char, long, doublecomplex*, doublecomplex*, long*));
extern void zhpgv __P((int, char, char, int, doublecomplex*, doublecomplex*, double*, doublecomplex*, int, int*));
extern void zhpgv_64 __P((long, char, char, long, doublecomplex*, doublecomplex*, double*, doublecomplex*, long, long*));
extern void zhpgvd __P((int, char, char, int, doublecomplex*, doublecomplex*, double*, doublecomplex*, int, int*));
extern void zhpgvd_64 __P((long, char, char, long, doublecomplex*, doublecomplex*, double*, doublecomplex*, long, long*));
extern void zhpgvx __P((int, char, char, char, int, doublecomplex*, doublecomplex*, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zhpgvx_64 __P((long, char, char, char, long, doublecomplex*, doublecomplex*, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zhpmv __P((char, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zhpmv_64 __P((char, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zhpr __P((char, int, double, doublecomplex*, int, doublecomplex*));
extern void zhpr_64 __P((char, long, double, doublecomplex*, long, doublecomplex*));
extern void zhpr2 __P((char, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*));
extern void zhpr2_64 __P((char, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*));
extern void zhprfs __P((char, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zhprfs_64 __P((char, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zhpsv __P((char, int, int, doublecomplex*, int*, doublecomplex*, int, int*));
extern void zhpsv_64 __P((char, long, long, doublecomplex*, long*, doublecomplex*, long, long*));
extern void zhpsvx __P((char, char, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zhpsvx_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zhptrd __P((char, int, doublecomplex*, double*, double*, doublecomplex*, int*));
extern void zhptrd_64 __P((char, long, doublecomplex*, double*, double*, doublecomplex*, long*));
extern void zhptrf __P((char, int, doublecomplex*, int*, int*));
extern void zhptrf_64 __P((char, long, doublecomplex*, long*, long*));
extern void zhptri __P((char, int, doublecomplex*, int*, int*));
extern void zhptri_64 __P((char, long, doublecomplex*, long*, long*));
extern void zhptrs __P((char, int, int, doublecomplex*, int*, doublecomplex*, int, int*));
extern void zhptrs_64 __P((char, long, long, doublecomplex*, long*, doublecomplex*, long, long*));
extern void zhsein __P((char, char, char, int*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int, int*, int*, int*, int*));
extern void zhsein_64 __P((char, char, char, long*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long, long*, long*, long*, long*));
extern void zhseqr __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zhseqr_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zjadmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zjadmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zjadrp __P((int, int, int, doublecomplex*, int*, int*, int, int*));
extern void zjadrp_64 __P((long, long, long, doublecomplex*, long*, long*, long, long*));
extern void zjadsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int*, int, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zjadsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long*, long, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zlarz __P((char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zlarz_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zlarzb __P((char, char, char, char, int, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int));
extern void zlarzb_64 __P((char, char, char, char, long, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long));
extern void zlarzt __P((char, char, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zlarzt_64 __P((char, char, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zlatzm __P((char, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int));
extern void zlatzm_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long));
extern void zpbcon __P((char, int, int, doublecomplex*, int, double, double*, int*));
extern void zpbcon_64 __P((char, long, long, doublecomplex*, long, double, double*, long*));
extern void zpbequ __P((char, int, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zpbequ_64 __P((char, long, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zpbrfs __P((char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zpbrfs_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zpbstf __P((char, int, int, doublecomplex*, int, int*));
extern void zpbstf_64 __P((char, long, long, doublecomplex*, long, long*));
extern void zpbsv __P((char, int, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zpbsv_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zpbsvx __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, char, double*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zpbsvx_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, char, double*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zpbtf2 __P((char, int, int, doublecomplex*, int, int*));
extern void zpbtf2_64 __P((char, long, long, doublecomplex*, long, long*));
extern void zpbtrf __P((char, int, int, doublecomplex*, int, int*));
extern void zpbtrf_64 __P((char, long, long, doublecomplex*, long, long*));
extern void zpbtrs __P((char, int, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zpbtrs_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zpocon __P((char, int, doublecomplex*, int, double, double*, int*));
extern void zpocon_64 __P((char, long, doublecomplex*, long, double, double*, long*));
extern void zpoequ __P((int, doublecomplex*, int, double*, double*, double*, int*));
extern void zpoequ_64 __P((long, doublecomplex*, long, double*, double*, double*, long*));
extern void zporfs __P((char, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zporfs_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zposv __P((char, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zposv_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zposvx __P((char, char, int, int, doublecomplex*, int, doublecomplex*, int, char, double*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zposvx_64 __P((char, char, long, long, doublecomplex*, long, doublecomplex*, long, char, double*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zpotf2 __P((char, int, doublecomplex*, int, int*));
extern void zpotf2_64 __P((char, long, doublecomplex*, long, long*));
extern void zpotrf __P((char, int, doublecomplex*, int, int*));
extern void zpotrf_64 __P((char, long, doublecomplex*, long, long*));
extern void zpotri __P((char, int, doublecomplex*, int, int*));
extern void zpotri_64 __P((char, long, doublecomplex*, long, long*));
extern void zpotrs __P((char, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void zpotrs_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void zppcon __P((char, int, doublecomplex*, double, double*, int*));
extern void zppcon_64 __P((char, long, doublecomplex*, double, double*, long*));
extern void zppequ __P((char, int, doublecomplex*, double*, double*, double*, int*));
extern void zppequ_64 __P((char, long, doublecomplex*, double*, double*, double*, long*));
extern void zpprfs __P((char, int, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zpprfs_64 __P((char, long, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zppsv __P((char, int, int, doublecomplex*, doublecomplex*, int, int*));
extern void zppsv_64 __P((char, long, long, doublecomplex*, doublecomplex*, long, long*));
extern void zppsvx __P((char, char, int, int, doublecomplex*, doublecomplex*, char, double*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zppsvx_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, char, double*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zpptrf __P((char, int, doublecomplex*, int*));
extern void zpptrf_64 __P((char, long, doublecomplex*, long*));
extern void zpptri __P((char, int, doublecomplex*, int*));
extern void zpptri_64 __P((char, long, doublecomplex*, long*));
extern void zpptrs __P((char, int, int, doublecomplex*, doublecomplex*, int, int*));
extern void zpptrs_64 __P((char, long, long, doublecomplex*, doublecomplex*, long, long*));
extern void zptcon __P((int, double*, doublecomplex*, double, double*, int*));
extern void zptcon_64 __P((long, double*, doublecomplex*, double, double*, long*));
extern void zpteqr __P((char, int, double*, double*, doublecomplex*, int, int*));
extern void zpteqr_64 __P((char, long, double*, double*, doublecomplex*, long, long*));
extern void zptrfs __P((char, int, int, double*, doublecomplex*, double*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zptrfs_64 __P((char, long, long, double*, doublecomplex*, double*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zptsv __P((int, int, double*, doublecomplex*, doublecomplex*, int, int*));
extern void zptsv_64 __P((long, long, double*, doublecomplex*, doublecomplex*, long, long*));
extern void zptsvx __P((char, int, int, double*, doublecomplex*, double*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zptsvx_64 __P((char, long, long, double*, doublecomplex*, double*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zpttrf __P((int, double*, doublecomplex*, int*));
extern void zpttrf_64 __P((long, double*, doublecomplex*, long*));
extern void zpttrs __P((char, int, int, double*, doublecomplex*, doublecomplex*, int, int*));
extern void zpttrs_64 __P((char, long, long, double*, doublecomplex*, doublecomplex*, long, long*));
extern void zptts2 __P((int, int, int, double*, doublecomplex*, doublecomplex*, int));
extern void zptts2_64 __P((long, long, long, double*, doublecomplex*, doublecomplex*, long));
extern void zrot __P((int, doublecomplex*, int, doublecomplex*, int, double, doublecomplex*));
extern void zrot_64 __P((long, doublecomplex*, long, doublecomplex*, long, double, doublecomplex*));
extern void zrotg __P((doublecomplex*, doublecomplex*, double*, doublecomplex*));
extern void zrotg_64 __P((doublecomplex*, doublecomplex*, double*, doublecomplex*));
extern void zscal __P((int, doublecomplex*, doublecomplex*, int));
extern void zscal_64 __P((long, doublecomplex*, doublecomplex*, long));
extern void zsctr __P((int, doublecomplex*, int*, doublecomplex*));
extern void zsctr_64 __P((long, doublecomplex*, long*, doublecomplex*));
extern void zskymm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zskymm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zskysm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zskysm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zspcon __P((char, int, doublecomplex*, int*, double, double*, int*));
extern void zspcon_64 __P((char, long, doublecomplex*, long*, double, double*, long*));
extern void zspmv __P((char, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zspmv_64 __P((char, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zsprfs __P((char, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zsprfs_64 __P((char, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zspsv __P((char, int, int, doublecomplex*, int*, doublecomplex*, int, int*));
extern void zspsv_64 __P((char, long, long, doublecomplex*, long*, doublecomplex*, long, long*));
extern void zspsvx __P((char, char, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zspsvx_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zsptrf __P((char, int, doublecomplex*, int*, int*));
extern void zsptrf_64 __P((char, long, doublecomplex*, long*, long*));
extern void zsptri __P((char, int, doublecomplex*, int*, int*));
extern void zsptri_64 __P((char, long, doublecomplex*, long*, long*));
extern void zsptrs __P((char, int, int, doublecomplex*, int*, doublecomplex*, int, int*));
extern void zsptrs_64 __P((char, long, long, doublecomplex*, long*, doublecomplex*, long, long*));
extern void zstedc __P((char, int, double*, double*, doublecomplex*, int, int*));
extern void zstedc_64 __P((char, long, double*, double*, doublecomplex*, long, long*));
extern void zstegr __P((char, char, int, double*, double*, double, double, int, int, double, int*, double*, doublecomplex*, int, int*, int*));
extern void zstegr_64 __P((char, char, long, double*, double*, double, double, long, long, double, long*, double*, doublecomplex*, long, long*, long*));
extern void zstein __P((int, double*, double*, int, double*, int*, int*, doublecomplex*, int, int*, int*));
extern void zstein_64 __P((long, double*, double*, long, double*, long*, long*, doublecomplex*, long, long*, long*));
extern void zsteqr __P((char, int, double*, double*, doublecomplex*, int, int*));
extern void zsteqr_64 __P((char, long, double*, double*, doublecomplex*, long, long*));
extern void zstsv __P((int, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int, int*, int*));
extern void zstsv_64 __P((long, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long, long*, long*));
extern void zsttrf __P((int, doublecomplex*, doublecomplex*, doublecomplex*, int*, int*));
extern void zsttrf_64 __P((long, doublecomplex*, doublecomplex*, doublecomplex*, long*, long*));
extern void zsttrs __P((int, int, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, int, int*, int*));
extern void zsttrs_64 __P((long, long, doublecomplex*, doublecomplex*, doublecomplex*, doublecomplex*, long, long*, long*));
extern void zswap __P((int, doublecomplex*, int, doublecomplex*, int));
extern void zswap_64 __P((long, doublecomplex*, long, doublecomplex*, long));
extern void zsycon __P((char, int, doublecomplex*, int, int*, double, double*, int*));
extern void zsycon_64 __P((char, long, doublecomplex*, long, long*, double, double*, long*));
extern void zsymm __P((char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zsymm_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zsyr2k __P((char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zsyr2k_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zsyrfs __P((char, int, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void zsyrfs_64 __P((char, long, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void zsyrk __P((char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zsyrk_64 __P((char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zsysv __P((char, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zsysv_64 __P((char, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void zsysvx __P((char, char, int, int, doublecomplex*, int, doublecomplex*, int, int*, doublecomplex*, int, doublecomplex*, int, double*, double*, double*, int*));
extern void zsysvx_64 __P((char, char, long, long, doublecomplex*, long, doublecomplex*, long, long*, doublecomplex*, long, doublecomplex*, long, double*, double*, double*, long*));
extern void zsytf2 __P((char, int, doublecomplex*, int, int*, int*));
extern void zsytf2_64 __P((char, long, doublecomplex*, long, long*, long*));
extern void zsytrf __P((char, int, doublecomplex*, int, int*, int*));
extern void zsytrf_64 __P((char, long, doublecomplex*, long, long*, long*));
extern void zsytri __P((char, int, doublecomplex*, int, int*, int*));
extern void zsytri_64 __P((char, long, doublecomplex*, long, long*, long*));
extern void zsytrs __P((char, int, int, doublecomplex*, int, int*, doublecomplex*, int, int*));
extern void zsytrs_64 __P((char, long, long, doublecomplex*, long, long*, doublecomplex*, long, long*));
extern void ztbcon __P((char, char, char, int, int, doublecomplex*, int, double*, int*));
extern void ztbcon_64 __P((char, char, char, long, long, doublecomplex*, long, double*, long*));
extern void ztbmv __P((char, char, char, int, int, doublecomplex*, int, doublecomplex*, int));
extern void ztbmv_64 __P((char, char, char, long, long, doublecomplex*, long, doublecomplex*, long));
extern void ztbrfs __P((char, char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void ztbrfs_64 __P((char, char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void ztbsv __P((char, char, char, int, int, doublecomplex*, int, doublecomplex*, int));
extern void ztbsv_64 __P((char, char, char, long, long, doublecomplex*, long, doublecomplex*, long));
extern void ztbtrs __P((char, char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void ztbtrs_64 __P((char, char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void ztgevc __P((char, char, int*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int, int*, int*));
extern void ztgevc_64 __P((char, char, long*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long, long*, long*));
extern void ztgexc __P((int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*, int*, int*));
extern void ztgexc_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*, long*, long*));
extern void ztgsen __P((int, int, int, int*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, doublecomplex*, int, doublecomplex*, int, int*, double*, double*, double*, int*));
extern void ztgsen_64 __P((long, long, long, long*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, doublecomplex*, long, doublecomplex*, long, long*, double*, double*, double*, long*));
extern void ztgsja __P((char, char, char, int, int, int, int, int, doublecomplex*, int, doublecomplex*, int, double, double, double*, double*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int*, int*));
extern void ztgsja_64 __P((char, char, char, long, long, long, long, long, doublecomplex*, long, doublecomplex*, long, double, double, double*, double*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long*, long*));
extern void ztgsna __P((char, char, int*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int, int*, int*));
extern void ztgsna_64 __P((char, char, long*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long, long*, long*));
extern void ztgsyl __P((char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void ztgsyl_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void ztpcon __P((char, char, char, int, doublecomplex*, double*, int*));
extern void ztpcon_64 __P((char, char, char, long, doublecomplex*, double*, long*));
extern void ztpmv __P((char, char, char, int, doublecomplex*, doublecomplex*, int));
extern void ztpmv_64 __P((char, char, char, long, doublecomplex*, doublecomplex*, long));
extern void ztprfs __P((char, char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void ztprfs_64 __P((char, char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void ztpsv __P((char, char, char, int, doublecomplex*, doublecomplex*, int));
extern void ztpsv_64 __P((char, char, char, long, doublecomplex*, doublecomplex*, long));
extern void ztptri __P((char, char, int, doublecomplex*, int*));
extern void ztptri_64 __P((char, char, long, doublecomplex*, long*));
extern void ztptrs __P((char, char, char, int, int, doublecomplex*, doublecomplex*, int, int*));
extern void ztptrs_64 __P((char, char, char, long, long, doublecomplex*, doublecomplex*, long, long*));
extern void ztrans __P((char, doublecomplex*, doublecomplex*, int, int, doublecomplex*));
extern void ztrans_64 __P((char, doublecomplex*, doublecomplex*, long, long, doublecomplex*));
extern void ztrcon __P((char, char, char, int, doublecomplex*, int, double*, int*));
extern void ztrcon_64 __P((char, char, char, long, doublecomplex*, long, double*, long*));
extern void ztrevc __P((char, char, int*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, int, int*, int*));
extern void ztrevc_64 __P((char, char, long*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, long, long*, long*));
extern void ztrexc __P((char, int, doublecomplex*, int, doublecomplex*, int, int, int, int*));
extern void ztrexc_64 __P((char, long, doublecomplex*, long, doublecomplex*, long, long, long, long*));
extern void ztrmm __P((char, char, char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int));
extern void ztrmm_64 __P((char, char, char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long));
extern void ztrmv __P((char, char, char, int, doublecomplex*, int, doublecomplex*, int));
extern void ztrmv_64 __P((char, char, char, long, doublecomplex*, long, doublecomplex*, long));
extern void ztrrfs __P((char, char, char, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int*));
extern void ztrrfs_64 __P((char, char, char, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long*));
extern void ztrsen __P((char, char, int*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int*, double*, double*, int*));
extern void ztrsen_64 __P((char, char, long*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long*, double*, double*, long*));
extern void ztrsm __P((char, char, char, char, int, int, doublecomplex*, doublecomplex*, int, doublecomplex*, int));
extern void ztrsm_64 __P((char, char, char, char, long, long, doublecomplex*, doublecomplex*, long, doublecomplex*, long));
extern void ztrsna __P((char, char, int*, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, double*, int, int*, int, int*));
extern void ztrsna_64 __P((char, char, long*, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, double*, long, long*, long, long*));
extern void ztrsv __P((char, char, char, int, doublecomplex*, int, doublecomplex*, int));
extern void ztrsv_64 __P((char, char, char, long, doublecomplex*, long, doublecomplex*, long));
extern void ztrsyl __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, int, doublecomplex*, int, double*, int*));
extern void ztrsyl_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, long, doublecomplex*, long, double*, long*));
extern void ztrti2 __P((char, char, int, doublecomplex*, int, int*));
extern void ztrti2_64 __P((char, char, long, doublecomplex*, long, long*));
extern void ztrtri __P((char, char, int, doublecomplex*, int, int*));
extern void ztrtri_64 __P((char, char, long, doublecomplex*, long, long*));
extern void ztrtrs __P((char, char, char, int, int, doublecomplex*, int, doublecomplex*, int, int*));
extern void ztrtrs_64 __P((char, char, char, long, long, doublecomplex*, long, doublecomplex*, long, long*));
extern void ztzrqf __P((int, int, doublecomplex*, int, doublecomplex*, int*));
extern void ztzrqf_64 __P((long, long, doublecomplex*, long, doublecomplex*, long*));
extern void ztzrzf __P((int, int, doublecomplex*, int, doublecomplex*, int*));
extern void ztzrzf_64 __P((long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zung2l __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zung2l_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zung2r __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zung2r_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungbr __P((char, int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungbr_64 __P((char, long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zunghr __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zunghr_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungl2 __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungl2_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zunglq __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zunglq_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungql __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungql_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungqr __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungqr_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungr2 __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungr2_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungrq __P((int, int, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungrq_64 __P((long, long, long, doublecomplex*, long, doublecomplex*, long*));
extern void zungtr __P((char, int, doublecomplex*, int, doublecomplex*, int*));
extern void zungtr_64 __P((char, long, doublecomplex*, long, doublecomplex*, long*));
extern void zunmbr __P((char, char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmbr_64 __P((char, char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmhr __P((char, char, int, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmhr_64 __P((char, char, long, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunml2 __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunml2_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmlq __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmlq_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmql __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmql_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmqr __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmqr_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmr2 __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmr2_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmrq __P((char, char, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmrq_64 __P((char, char, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmrz __P((char, char, int, int, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmrz_64 __P((char, char, long, long, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zunmtr __P((char, char, char, int, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int, int*));
extern void zunmtr_64 __P((char, char, char, long, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long, long*));
extern void zupgtr __P((char, int, doublecomplex*, doublecomplex*, doublecomplex*, int, int*));
extern void zupgtr_64 __P((char, long, doublecomplex*, doublecomplex*, doublecomplex*, long, long*));
extern void zupmtr __P((char, char, char, int, int, doublecomplex*, doublecomplex*, doublecomplex*, int, int*));
extern void zupmtr_64 __P((char, char, char, long, long, doublecomplex*, doublecomplex*, doublecomplex*, long, long*));
extern void zvbrmm __P((int, int, int, int, doublecomplex*, int*, doublecomplex*, int*, int*, int*, int*, int*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zvbrmm_64 __P((long, long, long, long, doublecomplex*, long*, doublecomplex*, long*, long*, long*, long*, long*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zvbrsm __P((int, int, int, int, doublecomplex*, doublecomplex*, int*, doublecomplex*, int*, int*, int*, int*, int*, int*, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zvbrsm_64 __P((long, long, long, long, doublecomplex*, doublecomplex*, long*, doublecomplex*, long*, long*, long*, long*, long*, long*, doublecomplex*, long, doublecomplex*, doublecomplex*, long));
extern void zvmul __P((int, doublecomplex*, doublecomplex*, int, doublecomplex*, int, doublecomplex*, doublecomplex*, int));
extern void zvmul_64 __P((long, doublecomplex*, doublecomplex*, long, doublecomplex*, long, doublecomplex*, doublecomplex*, long));


#ifdef __cplusplus
}
#endif

#endif  /* !defined(_SUNPERF_H) */

