#ifndef _TIME_ISO_SUNWCC_H
#define _TIME_ISO_SUNWCC_H

#pragma ident "@(#)time_iso_SUNWCC.h	1.3  03/04/03 C++5.0"

extern "C" {

namespace std {

#ifndef NULL
  #if defined(_LP64)
    #define	NULL	0L
  #else
    #define	NULL	0
  #endif
#endif

#define	CLOCKS_PER_SEC		1000000

#if defined(_LP64) || defined(_I32LPx)
  typedef unsigned long size_t;
#else
  typedef unsigned	size_t;
#endif

typedef	long	clock_t;

typedef	long	time_t;

#ifndef _STD_STRUCT_TM
#define _STD_STRUCT_TM
  struct tm {
    int	tm_sec;
    int	tm_min;
    int	tm_hour;
    int	tm_mday;
    int	tm_mon;
    int	tm_year;
    int	tm_wday;
    int	tm_yday;
    int	tm_isdst;
  };
#endif

clock_t clock(void);
double  difftime(time_t, time_t);
time_t  mktime(struct tm*);
time_t  time(time_t*);
char*   asctime(const struct tm*);
char*   ctime(const time_t*);
struct tm* gmtime(const time_t*);
struct tm* localtime(const time_t*);
size_t  strftime(char*, size_t, const char*, const struct tm*);

} /* end of namespace std */

} /* end of extern "C" */

#endif	/* _TIME_ISO_SUNWCC_H */
