/*
	Copyright 03/04/03 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _STDLIB_ISO_SUNWCC_H
#define _STDLIB_ISO_SUNWCC_H

#pragma ident "@(#)stdlib_iso_SUNWCC.h	1.4  03/04/03 C++5.0"

// needed for 2.5.1
#ifndef _FILE_OFFSET_BITS
#define _FILE_OFFSET_BITS       32
#endif
#if     _FILE_OFFSET_BITS - 0 != 32 && _FILE_OFFSET_BITS - 0 != 64
#error  "invalid _FILE_OFFSET_BITS value specified"
#endif

#ifndef	NULL
  #if defined(_LP64)
    #define	NULL	0L
  #else
    #define	NULL	0
  #endif
#endif

#define	EXIT_FAILURE	1
#define	EXIT_SUCCESS    0
#define	RAND_MAX	32767


extern "C" {

extern unsigned char	__ctype[];
#define	MB_CUR_MAX	__ctype[520]

namespace std {

typedef	struct {
      int	quot;
      int	rem;
} div_t;

typedef struct {
      long	quot;
      long	rem;
} ldiv_t;

#if defined(_LP64) || defined(_I32LPx)
  typedef unsigned long	size_t;
#else
  typedef unsigned int  size_t;
#endif

double atof(const char *);
int    atoi(const char *);
long   int atol(const char *);
double strtod(const char *, char **);
long   int strtol(const char *, char **, int);
unsigned long strtoul(const char *, char **, int);
int    rand(void);
void   srand(unsigned int);
void*  calloc(size_t, size_t);
void   free(void *);
void*  malloc(size_t);
void*  realloc(void *, size_t);
void   abort(void);
int    atexit(void (*)(void));
void   exit(int);
char*  getenv(const char *);
int    system(const char *);
void*  bsearch(const void *, const void *, size_t, size_t,
	       int (*)(const void *, const void *));
extern "C++"
    void* bsearch(const void *, const void *, size_t, size_t,
	          int (*)(const void *, const void *));
void   qsort(void *, size_t, size_t, int (*)(const void *, const void *));
extern "C++"
    void qsort(void *, size_t, size_t, int (*)(const void *, const void *));
int    abs(int);
div_t  div(int, int);
long   labs(long);
ldiv_t ldiv(long, long);
int    mbtowc(wchar_t *, const char *, size_t);
int    mblen(const char *, size_t);
int    wctomb(char *, wchar_t);
size_t mbstowcs(wchar_t *, const char *, size_t);
size_t wcstombs(char *, const wchar_t *, size_t);

extern "C++" {
inline long   abs(long _l) { return labs(_l); }
inline ldiv_t div(long _l1, long _l2) { return ldiv(_l1, _l2); }
}

} /* end of namespace std */

} /* end of extern C */

#endif	/* _STDLIB_ISO_SUNWCC_H */
