/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.servlet.Reads;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CodebaseServlet
extends HttpServlet {
    private String codebase = null;
    private static Hashtable classList = null;
    private static ZipFile jarCacheFile = null;
    private static Vector jarCacheEntries = new Vector(10);
    private static String jarCacheName = "";
    private static long jarCacheTimeStamp = 0L;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.length() <= 1) {
            this.sendNotFoundError(httpServletResponse, string);
            return;
        }
        string = string.substring(1).trim();
        Debug.trace((String)"Codebase Servlet", (int)Debug.INFORMATION, (String)("Codebase Servlet: request: " + string), null);
        if (string.indexOf("..") >= 0) {
            this.sendNotFoundError(httpServletResponse, string);
            return;
        }
        String string2 = null;
        byte[] byArray = null;
        if (classList == null) {
            CodebaseServlet.reloadClassList();
        }
        if ((string2 = (String)classList.get(string)) == null) {
            string2 = String.valueOf(this.codebase) + string;
            byArray = this.getBitsFromFile(string2);
            if (byArray == null) {
                this.sendNotFoundError(httpServletResponse, string);
                return;
            }
        } else if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
            byArray = this.getBitsFromJar(string2, string);
        } else if (string2.endsWith(".class")) {
            byArray = this.getBitsFromFile(string2);
        }
        if (byArray == null) {
            byArray = this.getBitsFromFile(String.valueOf(this.codebase) + string);
        }
        if (byArray != null) {
            long l = new File(string2).lastModified();
            httpServletResponse.setDateHeader("Last-Modified", l);
            httpServletResponse.setContentType(this.getContentType(string));
            httpServletResponse.setContentLength(byArray.length);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.close();
            Debug.trace((String)"Codebase Servlet", (int)Debug.INFORMATION, (String)("Servlet loaded: " + string), null);
        } else {
            this.sendNotFoundError(httpServletResponse, string);
        }
    }

    private byte[] getBitsFromFile(String string) {
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Debug.trace((String)"Codebase Servlet", (int)Debug.WARNING, (String)("Codebase Servlet direct loading:" + iOException.getMessage()), (Throwable)iOException);
        }
        return byArray;
    }

    private synchronized byte[] getBitsFromJar(String string, String string2) {
        byte[] byArray = null;
        try {
            ZipConstants zipConstants;
            InputStream inputStream = null;
            boolean bl = false;
            File file = new File(string);
            if (jarCacheTimeStamp != file.lastModified() || !jarCacheName.equals(string)) {
                zipConstants = new ZipFile(string);
                jarCacheTimeStamp = file.lastModified();
                jarCacheFile = zipConstants;
                jarCacheEntries.removeAllElements();
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)zipConstants).entries();
                while (enumeration.hasMoreElements()) {
                    jarCacheEntries.add(enumeration.nextElement());
                }
                jarCacheName = string;
            }
            zipConstants = null;
            int n = 0;
            while (n < jarCacheEntries.size()) {
                zipConstants = (ZipEntry)jarCacheEntries.elementAt(n);
                if (((ZipEntry)zipConstants).getName().equals(string2)) {
                    inputStream = jarCacheFile.getInputStream((ZipEntry)zipConstants);
                    byArray = Reads.read(inputStream);
                    break;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            jarCacheName = "";
            jarCacheTimeStamp = 0L;
            Debug.trace((String)"Codebase Servlet", (int)Debug.WARNING, (String)("VCodebase Servlet: " + iOException.getMessage()), (Throwable)iOException);
        }
        return byArray;
    }

    private String getContentType(String string) {
        String string2 = string.toLowerCase();
        String string3 = "text/plain";
        if (string2.endsWith(".class") || string2.endsWith(".ser")) {
            string3 = "application/java";
        } else if (string2.endsWith(".gif")) {
            string3 = "image/gif";
        } else if (string2.endsWith(".jpg") || string2.endsWith(".jpeg")) {
            string3 = "image/jpeg";
        } else if (string2.endsWith(".html") || string2.endsWith(".htm")) {
            string3 = "text/html";
        } else if (string2.endsWith(".jar")) {
            string3 = "application/java-archive";
        } else if (string2.endsWith(".js")) {
            string3 = "application/x-javascript";
        }
        return string3;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.codebase = VRegistry.getCodebase();
    }

    public void log(String string) {
    }

    public void log(String string, Throwable throwable) {
    }

    protected static void reloadClassList() {
        classList = VRegistry.getClassList();
    }

    private void sendNotFoundError(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.sendError(404, "File " + string + " is NOT found in Viper codebase.");
    }
}

