#
#   File:    base-trap-info-d.x
#   Author:  Halcyon Inc.
#   Version: 1.8 03/09/02 17:13:56
#
#   Copyright (c) 1998 Halcyon Inc.
#
#   OpenAgent Daemon Standard Trap Generation Tree
#

    [ use BRANCH ]

    #
    # This object used to be used to generate status traps.
    #
    statusOID = { [ use OID ]
	setFilter		= parseScopedOid
	setActions		= trap
	setService(trap)	= .services.snmp
	setCommand(trap)	= "trap statusChange {{oid//%fulloid.0 \"OBJECT IDENTIFIER\" %value}} -context %context"

	shortDesc		= Status
	mediumDesc		= Status Trap
	fullDesc		= Status change trap object
    }

    #
    # This object used to be used to generate status traps.
    #
    refreshOID = { [ use OID ]
	setFilter		= parseScopedOid
	setActions		= trap
	setService(trap)	= .services.snmp
	setCommand(trap)	= "trap valueRefresh {{oid//%fulloid.0 \"OBJECT IDENTIFIER\" %value}} -context %context"

	shortDesc		= Refresh
	mediumDesc		= Refresh Trap
	fullDesc		= Value Refresh trap object
    }

    #
    # Object to generate Event Traps
    #
    eventInfo = { [ use STRING ]

	activateActions(post)		= logcoldstart initresend 

	#
	# This action generates an event on coldstart.
	# Gets triggered from class-mibnode.toe
	#
	activateService(logcoldstart)	= _internal
	activateCommand(logcoldstart)	= writeEvent S

        #
        # Periodic check to see if we need to re-send an event trap.
        # Resends only ever happen if the eventOutstanding flag is set.
        #
	activateService(initresend)	= _internal
	activateCommand(initresend)	= initEventResend

	#
	# This action is used to trigger an event trap whenever an
	# event occurs. Gets called from class-event.toe via 
	# a "setValue" call.
	#
	setActions		= trap
	setService(trap)	= .services.snmp
	setCommand(trap)	= trap event {{oid//%fulloid.0 %value}} 

        #
        # Shadow access attributes
        #
        shadowAccessMode(events)	= "useShadowAccess"; 
        shadowMIBAccessMode(events)	= "useReadMIBAccess"; 
        shadowUserAccess(events,%generalUsers,write) = "auth";

	# 
	# Here's the description of the object
	# 
	shortDesc		= Event
	mediumDesc 		= Event Trap 
	fullDesc 		= Event trap object
    }

#   Object to generate Configuration Traps.
#   ---------------------------------------
    userConfig = { [ use STRING ]
	setActions		= trap
	setService(trap)	= .services.snmp
	setCommand(trap)	= "trap userConfig {{oid//%fulloid.0 \"OCTET STRING\" %value}} -securityLevel noauth"

	shortDesc		= userConfig
	mediumDesc		= User Config
	fullDesc		= User Config Trap Object
    }


    #
    # Information for module load/unload traps
    # Trap not triggered by a set; triggered from sendModuleTrap in
    # base-mibman-d.prc
    # This object is used by both load and unload traps.
    #
    moduleInfo = { [ use STRING ]	
        shortDesc               = Module
        mediumDesc              = Module Trap
        fulldesc                = Module Load/Unload Trap Information
    }

