/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SMAlarmStatusData {
    private String ObjectId;
    private String SourceUrl;
    private String State;
    private String StatusMessage;
    private int Severity;
    private int Timestamp;
    private String updatedString;
    private Locale locale;

    public SMAlarmStatusData(String string, String string2, String string3, String string4, int n, int n2) {
        this(string, string2, string3, string4, n, n2, null);
    }

    public SMAlarmStatusData(String string, String string2, String string3, String string4, int n, int n2, Locale locale) {
        this.ObjectId = string;
        this.SourceUrl = string2;
        this.State = string3;
        this.StatusMessage = UcListUtil.AsciiToUnicode((String)string4);
        this.Severity = n;
        this.Timestamp = n2;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.updatedString = UcInternationalizer.translateKey((Locale)this.locale, (String)"base.console.ConsoleGeneric:standard.updated");
    }

    public static SMAlarmStatusData buildIrrationalData(String string) {
        return SMAlarmStatusData.buildIrrationalData(string, null);
    }

    public static SMAlarmStatusData buildIrrationalData(String string, Locale locale) {
        long l = new Date().getTime();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string2 = UcInternationalizer.translateKey((Locale)locale, (String)"base.console.ConsoleGeneric:standard.noalarm");
        return new SMAlarmStatusData(string, "", " IRR-99", string2, 99, (int)(l / 1000L), locale);
    }

    public static SMAlarmStatusData buildStatusData(String string, String string2, String string3) {
        return SMAlarmStatusData.buildStatusData(string, string2, string3, null);
    }

    public static SMAlarmStatusData buildStatusData(String string, String string2, String string3, Locale locale) {
        int n;
        Object object;
        int n2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int n3 = 0;
        String[] stringArray = new String[12];
        while (true) {
            if ((n2 = string2.indexOf(9)) < 0) break;
            stringArray[n3++] = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1);
        }
        stringArray[n3++] = string2;
        if (n3 != 11) {
            return null;
        }
        try {
            object = new Float(stringArray[9]);
            n2 = ((Float)object).intValue();
            n = Integer.parseInt(stringArray[10]);
        }
        catch (Exception exception) {
            return null;
        }
        if (stringArray[0].length() < 4) {
            stringArray[0] = " INF-0";
        }
        object = null;
        if (stringArray[2] != null) {
            stringArray[2] = UcInternationalizer.translateKey((Locale)locale, (String)stringArray[2]);
        }
        object = string3 == null ? String.valueOf(stringArray[5]) + " " + stringArray[6] + " " + stringArray[7] : (string3.equals("topology") ? (!stringArray[9].equals("0") ? String.valueOf(stringArray[1]) + " " + stringArray[2] + " " + stringArray[3] + " " + stringArray[5] + " " + stringArray[6] + " " + stringArray[7] : (!stringArray[5].equals("") ? String.valueOf(stringArray[5]) + " " + stringArray[7] : String.valueOf(stringArray[2]) + " " + stringArray[7])) : (string3.equals("") ? String.valueOf(stringArray[2]) + " " + stringArray[3] + " " + stringArray[5] + " " + stringArray[6] + " " + stringArray[7] : String.valueOf(stringArray[5]) + " " + stringArray[6] + " " + stringArray[7]));
        return new SMAlarmStatusData(string, stringArray[8], stringArray[0], (String)object, n2, n);
    }

    public String getFormattedTimestamp() {
        Date date = new Date((long)this.Timestamp * 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM. d, HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(date);
    }

    public String getObjectId() {
        return this.ObjectId;
    }

    public int getSeverity() {
        return this.Severity;
    }

    public String getSourceUrl() {
        return this.SourceUrl;
    }

    public String getState() {
        if (this.State.charAt(0) != '*') {
            if (this.State.length() >= 6 && this.State.substring(1, 6).compareTo("INF-0") == 0) {
                return "OK ";
            }
            return this.State.substring(1, 4);
        }
        return "ACK";
    }

    public String getStateString() {
        return UcInternationalizer.translateKey((Locale)this.locale, (String)("base.console.ConsoleGeneric:status." + SMAlarmStatusRequest.getStatusName(this.getState())));
    }

    public Color getStatusColor() {
        return SMAlarmStatusRequest.getStatusColor(this.getState());
    }

    public String getStatusInToolTip(String string) {
        return String.valueOf(this.getStateString()) + ": " + this.StatusMessage + string + this.updatedString + this.getFormattedTimestamp();
    }

    public String getStatusMessage() {
        return this.StatusMessage;
    }

    public int getTimestamp() {
        return this.Timestamp;
    }

    public boolean isAcknowledged() {
        return this.State.charAt(0) == '*';
    }

    public void setSourceUrl(String string) {
        this.SourceUrl = string;
    }
}

