/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.cli.alarm;

import com.sun.symon.base.cli.alarm.ClAlarmBase;
import com.sun.symon.base.cli.base.ClAgent;
import com.sun.symon.base.cli.base.ClCLIData;
import com.sun.symon.base.cli.base.ClCLIException;
import com.sun.symon.base.cli.base.ClSession;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmIteratorSync;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.topology.SMTopologyEntityInfo;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class ClCommandGetAlarms
extends ClAlarmBase {
    private static final String TOPOLOGYMODULE = "topology";

    public ClCommandGetAlarms(ClSession clSession, String string, ClCLIData clCLIData, ClCLIData clCLIData2) {
        super(clSession, string, clCLIData, clCLIData2);
    }

    private String addBrackets(String string) {
        return this.addBrackets(string, false);
    }

    private String addBrackets(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        StringTokenizer stringTokenizer = string.indexOf(",") == -1 ? new StringTokenizer(string, "'\" ") : new StringTokenizer(string, ",'\" ");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("{");
            if (bl) {
                stringBuffer.append("snmp://:");
            }
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append("}");
            if (stringTokenizer.countTokens() <= 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String processParam(String string, String string2, String string3) throws ClCLIException {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",'\" ");
        while (stringTokenizer.hasMoreTokens()) {
            if (string2.indexOf(stringTokenizer.nextToken()) != -1) continue;
            throw new ClCLIException(string3);
        }
        return this.addBrackets(string);
    }

    private String[] processParams(Hashtable hashtable) throws ClCLIException {
        String string = (String)hashtable.get("severity");
        String string2 = this.processParam(string, "DIS, DWN, ERR, OFF, INF, IRR, WRN", this.session_.getI18NMessage("Parameter.Invalid", string));
        string = (String)hashtable.get("state");
        String string3 = this.processParam(string, "C, F, O", this.session_.getI18NMessage("Parameter.Invalid", string));
        string = (String)hashtable.get("ack");
        String string4 = this.processParam(string, "A, N", this.session_.getI18NMessage("Parameter.Invalid", string));
        String[] stringArray = new String[]{string2, string3, string4, null, null, null};
        return stringArray;
    }

    public void runCommand() {
        ClCLIData clCLIData = this.getInput();
        ClCLIData clCLIData2 = this.getOutput();
        clCLIData2.appendTable(this.getCommand());
        try {
            int n;
            Vector vector;
            String string;
            if (!this.session_.isLogin()) {
                throw new ClCLIException(this.session_.getI18NMessage("Login.NotLoggedIn"));
            }
            Hashtable hashtable = clCLIData.getHashtable();
            String string2 = (String)hashtable.get("domain");
            if (string2 == null) {
                string = new SMUserDomainRequest(this.session_.getRawDataRequest());
                vector = string.getDefaultDomainInfo();
                string2 = vector != null ? vector.getDomainName() : "Default Domain";
            }
            string = (String)hashtable.get("a");
            vector = ClAgent.getAgents(string);
            if (string == null) {
                throw new ClCLIException(this.session_.getI18NMessage("Parameter.NotSet", "a"));
            }
            String string3 = (String)hashtable.get("m");
            String string4 = null;
            int n2 = n = string3 != null ? string3.indexOf("+") : -1;
            if (n != -1) {
                string4 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
            }
            String string5 = (String)hashtable.get("managed_object");
            String string6 = (String)hashtable.get("property");
            String string7 = (String)hashtable.get("property_instance");
            String string8 = (String)hashtable.get("qualifier");
            String[] stringArray = this.processParams(hashtable);
            SMTopologyRequest sMTopologyRequest = new SMTopologyRequest(this.session_.getRawDataRequest());
            boolean bl = string3 != null;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = 0;
            int n4 = vector.size();
            while (this.isRunning() && n3 < n4) {
                ClAgent clAgent = (ClAgent)vector.elementAt(n3);
                String string9 = clAgent.getHost();
                int n5 = clAgent.getPort();
                if (n5 == 0) {
                    n5 = 161;
                }
                try {
                    SMTopologyEntityInfo sMTopologyEntityInfo = sMTopologyRequest.getTopologyEntityInfo(string2, string9, n5);
                    if (sMTopologyEntityInfo == null) {
                        throw new Exception("topReq.getTopologyEntityInfo(" + string2 + ", " + string9 + ", " + n5 + ")=null");
                    }
                    String string10 = String.valueOf(sMTopologyEntityInfo.getParentUrl()) + "/entityViewTable/entityViewEntry/entityStatus#" + sMTopologyEntityInfo.getEntity() + "/";
                    String string11 = sMTopologyEntityInfo.getEventDest();
                    SMAlarmObjectRequest sMAlarmObjectRequest = new SMAlarmObjectRequest(this.session_.getRawDataRequest(), string11);
                    stringBuffer2.setLength(0);
                    stringBuffer.setLength(0);
                    String string12 = InetAddress.getByName(string9).getHostAddress();
                    if (bl) {
                        stringBuffer2.append('{');
                        stringBuffer2.append(SMRawDataRequest.createURL((String)string12, (int)n5, (String)string3, (String)string4, (String)string5, (String)string6, (boolean)false, (String)string8, (String)string7));
                        stringBuffer2.append('}');
                    } else {
                        stringBuffer2.append('{');
                        stringBuffer2.append("snmp://");
                        stringBuffer2.append(string12);
                        stringBuffer2.append(':');
                        stringBuffer2.append(new Integer(n5).toString());
                        stringBuffer2.append('}');
                    }
                    stringBuffer2.append(" {");
                    stringBuffer2.append(string10);
                    stringBuffer2.append('}');
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
                    simpleDateFormat.setTimeZone(TimeZone.getDefault());
                    SMAlarmIteratorSync sMAlarmIteratorSync = sMAlarmObjectRequest.getAlarms(Integer.toString(n3), null, stringBuffer2.toString(), stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                    Vector vector2 = sMAlarmIteratorSync.getData();
                    if (vector2.size() == 0) {
                        clCLIData2.appendRow(ClCLIData.ROW_TYPE_DATA);
                        clCLIData2.appendColumn("Host", string9);
                        clCLIData2.appendColumn("Port", Integer.toString(n5));
                        clCLIData2.appendColumn("state", this.session_.getI18NMessage("State.Fail"));
                        clCLIData2.appendColumn("message", this.session_.getI18NMessage("State.NoData"));
                    } else {
                        SMAlarmObjectData sMAlarmObjectData = null;
                        int n6 = vector2.size();
                        while (this.isRunning() && vector2.size() > 0) {
                            String string13 = ((SMAlarmObjectData)vector2.elementAt(0)).getHost();
                            int n7 = 0;
                            int n8 = vector2.size();
                            while (n7 < n8) {
                                sMAlarmObjectData = (SMAlarmObjectData)vector2.elementAt(n7);
                                if (!sMAlarmObjectData.getModule().equals(TOPOLOGYMODULE) && n5 != 0 && n5 != sMAlarmObjectData.getAgentPort()) {
                                    --n6;
                                } else {
                                    String string14 = simpleDateFormat.format(new Date(sMAlarmObjectData.getOpenTimestamp() * 1000L));
                                    String string15 = simpleDateFormat.format(new Date(sMAlarmObjectData.getUpdateTimestamp() * 1000L));
                                    String string16 = "";
                                    String string17 = "";
                                    String string18 = "";
                                    if (sMAlarmObjectData.getCloseTimestamp() != 0L) {
                                        string16 = simpleDateFormat.format(new Date(sMAlarmObjectData.getCloseTimestamp() * 1000L));
                                    }
                                    if (sMAlarmObjectData.getAckTimestamp() != 0L) {
                                        string17 = simpleDateFormat.format(new Date(sMAlarmObjectData.getAckTimestamp() * 1000L));
                                    }
                                    if (sMAlarmObjectData.getFixTimestamp() != 0L) {
                                        string18 = simpleDateFormat.format(new Date(sMAlarmObjectData.getFixTimestamp() * 1000L));
                                    }
                                    clCLIData2.appendRow(ClCLIData.ROW_TYPE_DATA);
                                    clCLIData2.appendColumn("Domain", string2);
                                    clCLIData2.appendColumn("Host", sMAlarmObjectData.getHost());
                                    clCLIData2.appendColumn("Port", Integer.toString(sMAlarmObjectData.getAgentPort()));
                                    clCLIData2.appendColumn("Alarm Id", sMAlarmObjectData.getAlarmId());
                                    clCLIData2.appendColumn("Rule Id", sMAlarmObjectData.getAlarmRuleId());
                                    clCLIData2.appendColumn("Open Timestamp", string14);
                                    clCLIData2.appendColumn("Text", sMAlarmObjectData.getAlarmShortText());
                                    clCLIData2.appendColumn("Long Key", sMAlarmObjectData.getAlarmLongKey());
                                    clCLIData2.appendColumn("Module", sMAlarmObjectData.getModule());
                                    clCLIData2.appendColumn("Module Instance", sMAlarmObjectData.getModuleInstance());
                                    clCLIData2.appendColumn("Managed Object", sMAlarmObjectData.getManagedObject());
                                    clCLIData2.appendColumn("Property", sMAlarmObjectData.getProperty());
                                    clCLIData2.appendColumn("Property Type", sMAlarmObjectData.getPropertyType() ? "scalar" : "table");
                                    clCLIData2.appendColumn("Property Instance", sMAlarmObjectData.getPropertyInstance());
                                    clCLIData2.appendColumn("Qualifier", sMAlarmObjectData.getAttribute());
                                    clCLIData2.appendColumn("State", sMAlarmObjectData.getAlarmState());
                                    clCLIData2.appendColumn("Severity", sMAlarmObjectData.getSeverity());
                                    clCLIData2.appendColumn("Update Timestamp", string15);
                                    clCLIData2.appendColumn("Update Reason", sMAlarmObjectData.getUpdateReason());
                                    clCLIData2.appendColumn("Machine Type", sMAlarmObjectData.getMachineType());
                                    clCLIData2.appendColumn("Rule Group", sMAlarmObjectData.getRuleGroup());
                                    clCLIData2.appendColumn("Close Timestamp", string16);
                                    clCLIData2.appendColumn("Ack Timestamp", string17);
                                    clCLIData2.appendColumn("Ack Operator", sMAlarmObjectData.getAckOperator());
                                    clCLIData2.appendColumn("Fix Timestamp", string18);
                                    clCLIData2.appendColumn("Fix Operator", sMAlarmObjectData.getFixOperator());
                                }
                                ++n7;
                            }
                            sMAlarmIteratorSync = sMAlarmIteratorSync.getNextAlarms();
                            vector2 = sMAlarmIteratorSync.getData();
                        }
                        if (n6 == 0) {
                            clCLIData2.appendRow(ClCLIData.ROW_TYPE_DATA);
                            clCLIData2.appendColumn("Host", string9);
                            clCLIData2.appendColumn("Port", Integer.toString(n5));
                            clCLIData2.appendColumn("state", this.session_.getI18NMessage("State.Fail"));
                            clCLIData2.appendColumn("message", this.session_.getI18NMessage("State.NoData"));
                        }
                    }
                }
                catch (Exception exception) {
                    clCLIData2.appendRow(ClCLIData.ROW_TYPE_ERROR);
                    clCLIData2.appendColumn("Host", string9);
                    clCLIData2.appendColumn("Port", Integer.toString(n5));
                    clCLIData2.appendColumn("state", this.session_.getI18NMessage("State.Fail"));
                    clCLIData2.appendColumn("message", this.session_.getI18NMessage("State.HostNotFound"));
                    System.err.println("getAlarms: " + exception.getMessage());
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            this.handleException(exception, this.session_.getI18NMessage("Alarm.GetFail"));
        }
    }
}

