/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.view;

import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.view.SMRemoteView;
import com.sun.symon.base.client.view.SMViewData;
import com.sun.symon.base.client.view.SMViewInfo;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.view.MvViewConstants;
import com.sun.symon.base.mgmtservice.view.MvViewController;
import com.sun.symon.base.mgmtservice.view.MvViewDBAccess;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.rmi.RemoteException;

public class MvViewService
extends MSBaseService
implements SMRemoteView,
MvViewConstants {
    private static MSSecurity scService;
    private static MSLogPrintWriter logWriter;
    private static MvViewDBAccess dbAccess;
    private static MvViewController controller;

    static {
        try {
            scService = MSSecurity.getInstance();
            dbAccess = MvViewDBAccess.getInstance();
            controller = MvViewController.getInstance();
            logWriter = controller.getLogWriter();
        }
        catch (SMSecurityException sMSecurityException) {
            logWriter.println("Security service is not available.\nExiting ...");
            System.exit(1);
        }
    }

    public MvViewService(ScSecurityCredential scSecurityCredential, String string) throws RemoteException {
        super("View_ViewService", scSecurityCredential, string);
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        controller.addViewChangeListener(this, sMDBRemoteChangeListener, 0);
    }

    public void addViewChangeListener(SMDBRemoteChangeListener sMDBRemoteChangeListener, int n) throws RemoteException {
        controller.addViewChangeListener(this, sMDBRemoteChangeListener, n);
    }

    public void delete(SMDBObjectID sMDBObjectID, int n) throws RemoteException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        this.checkAccess("delete", sMDBObjectID);
        dbAccess.delete(sMDBObjectID);
        controller.notifyChanges(sMDBObjectID, n, 3);
    }

    public SMViewInfo[] getAll() throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getAll");
        return dbAccess.getAll();
    }

    public SMViewInfo[] getAll(int n) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getAll");
        return dbAccess.getAll(n);
    }

    public SMViewData load(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        this.checkAccess("load", sMDBObjectID);
        return dbAccess.load(sMDBObjectID);
    }

    public SMViewData load(String string, String string2, int n) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        this.checkAccess("load");
        return dbAccess.load(string, string2, n);
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        controller.removeViewChangeListener(this, sMDBRemoteChangeListener, 0);
    }

    public void removeViewChangeListener(SMDBRemoteChangeListener sMDBRemoteChangeListener, int n) throws RemoteException {
        controller.removeViewChangeListener(this, sMDBRemoteChangeListener, n);
    }

    public SMDBObject save(SMViewData sMViewData) throws RemoteException, SMSecurityException, SMStaleDataException, SMDuplicateException, SMDatabaseException, SMNoSuchObjectException {
        SMDBObjectID sMDBObjectID = sMViewData.getObjectID();
        boolean bl = false;
        if (sMDBObjectID == null) {
            bl = true;
            this.checkAccess("save");
        } else {
            this.checkAccess("save", sMDBObjectID);
        }
        ScSecurityCredential scSecurityCredential = this.getUserSecurityCredential();
        try {
            sMViewData.setUpdatedBy(scSecurityCredential.getUser());
        }
        catch (Exception exception) {
            logWriter.println("User " + scSecurityCredential.getUser() + " " + exception.getMessage());
        }
        SMDBObject sMDBObject = dbAccess.save(sMViewData);
        sMViewData.refresh(sMDBObject);
        int n = 1;
        if (bl) {
            n = 2;
        }
        controller.notifyChanges(sMViewData.getObjectID(), sMViewData.getViewType(), n);
        return sMDBObject;
    }
}

