/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.log.SMRemoteLogReader;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBConcurrencyTimestamp;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.task.SMRemoteTask;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogReader;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.task.MtTaskDescriptor;
import com.sun.symon.base.mgmtservice.task.MtTaskSecurity;
import com.sun.symon.base.mgmtservice.task.MtTaskService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class MtTaskImpl
extends MSBaseService
implements SMRemoteTask {
    private static final String SP_DELETETASK = "{call DELETETASK(?)}";
    private static final int SP_DELETETASK_TASK_ID = 1;
    private static final String SP_DELETETASKOPERATION = "{call DELETETASKOPERATION(?)}";
    private static final int SP_DELETETASKOPERATION_TASK_ID = 1;
    private static final String SP_GETALLTASKS = "{call GETALLTASKS(?)}";
    private static final int SP_GETALLTASKS_CSR = 1;
    private static final String SP_GETTASK = "{call GETTASK(?,?,?)}";
    private static final int SP_GETTASK_TASK_ID = 1;
    private static final int SP_GETTASK_NAME = 2;
    private static final int SP_GETTASK_CSR = 3;
    private static final String SP_GETTASKOPERATION = "{call GETTASKOPERATION(?,?)}";
    private static final int SP_GETTASKOPERATION_TASK_ID = 1;
    private static final int SP_GETTASKOPERATION_CSR = 2;
    private static final String SP_UPDATETASK = "{call UPDATETASK(?,?,?,?,?,?,?)}";
    private static final int SP_UPDATETASK_TASK_ID = 1;
    private static final int SP_UPDATETASK_TASK_TYPE = 2;
    private static final int SP_UPDATETASK_NAME = 3;
    private static final int SP_UPDATETASK_DESCRIPTION = 4;
    private static final int SP_UPDATETASK_UPDATED_BY = 5;
    private static final int SP_UPDATETASK_TIMESTAMP = 6;
    private static final int SP_UPDATETASK_CREATED_DATE = 7;
    private static final String SP_UPDATETASKOPERATION = "{call UPDATETASKOPERATION(?,?,?,?,?,?,?,?)}";
    private static final int SP_UPDATETASKOPERATION_TASK_ID = 1;
    private static final int SP_UPDATETASKOPERATION_TASK_ORDER = 2;
    private static final int SP_UPDATETASKOPERATION_OPERATION = 3;
    private static final int SP_UPDATETASKOPERATION_OPERAND = 4;
    private static final int SP_UPDATETASKOPERATION_VALUE = 5;
    private static final int SP_UPDATETASKOPERATION_VALUE_TYPE = 6;
    private static final int SP_UPDATETASKOPERATION_USER_DATA = 7;
    private static final int SP_UPDATETASKOPERATION_ASYNC = 8;
    private ScSecurityCredential security_;
    private String name_;

    public MtTaskImpl(String string, ScSecurityCredential scSecurityCredential) throws RemoteException {
        super(string, scSecurityCredential);
        this.name_ = string;
        this.security_ = scSecurityCredential;
    }

    public MtTaskImpl(String string, ScSecurityCredential scSecurityCredential, String string2) throws RemoteException {
        super(string, scSecurityCredential, string2);
        this.name_ = string;
        this.security_ = scSecurityCredential;
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        MtTaskService.getTaskChangeMulticaster().add((MSBaseService)this, sMDBRemoteChangeListener);
    }

    public void cleanup() {
        MtTaskService.getTaskChangeMulticaster().remove((MSBaseService)this);
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        if (!"TASK".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "delete", this.getUserSecurityCredential(), sMDBObjectID);
        MtTaskSecurity.getInstance().checkAccess(this.getTaskTypeID(sMDBObjectID), "delete", this.security_);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_DELETETASK);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.execute();
                connection.commit();
                callableStatement.close();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    throw new SMNoSuchObjectException((Throwable)sQLException);
                }
                throw new SMDatabaseException((Throwable)sQLException);
            }
            catch (Exception exception) {
                MSDB.rollback((Connection)connection);
                throw new SMDatabaseException((Throwable)exception);
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        MtTaskService.getTaskChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObjectID, 3));
    }

    private void deleteOperations(Connection connection, SMDBObjectID sMDBObjectID) throws SMStaleDataException, SMNoSuchObjectException, SMDatabaseException {
        try {
            CallableStatement callableStatement = connection.prepareCall(SP_DELETETASKOPERATION);
            callableStatement.setLong(1, sMDBObjectID.getID());
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                throw new SMStaleDataException((Throwable)sQLException);
            }
            if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                throw new SMNoSuchObjectException((Throwable)sQLException);
            }
            throw new SMDatabaseException((Throwable)sQLException);
        }
    }

    private void fireEventForSave(SMDBObject sMDBObject, SMDBObject sMDBObject2) {
        int n = sMDBObject.getObjectID() == null ? 2 : 1;
        MtTaskService.getTaskChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObject2.getObjectID(), n));
    }

    public SMTaskInfo[] getAll() throws SMSecurityException, SMDatabaseException {
        MSSecurity.getInstance();
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "getAll", this.getUserSecurityCredential());
        Vector<SMTaskInfo> vector = new Vector<SMTaskInfo>();
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETALLTASKS);
                callableStatement.registerOutParameter(1, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(1);
                while (oracleResultSet.next()) {
                    SMTaskInfo sMTaskInfo = new SMTaskInfo(new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getInt("TASK_TYPE"));
                    try {
                        MtTaskSecurity.getInstance().checkAccess(sMTaskInfo.getTaskType(), "edit", this.security_);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    vector.addElement(sMTaskInfo);
                }
                callableStatement.close();
            }
            catch (SQLException sQLException) {
                throw new SMDatabaseException((Throwable)sQLException);
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        Object[] objectArray = new SMTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SMTaskInfo[] getAll(int n) throws SMSecurityException, SMDatabaseException {
        MtTaskSecurity.getInstance().checkAccess(n, "edit", this.security_);
        SMTaskInfo[] sMTaskInfoArray = this.getAll();
        Vector<SMTaskInfo> vector = new Vector<SMTaskInfo>();
        int n2 = 0;
        while (n2 < sMTaskInfoArray.length) {
            if (sMTaskInfoArray[n2].getTaskType() == n) {
                vector.addElement(sMTaskInfoArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new SMTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SMRemoteLogReader getLogReader(String string) throws Exception {
        MSLogReader mSLogReader = new MSLogReader(string);
        return mSLogReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SMTaskData getTask(SMDBObjectID sMDBObjectID, String string) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMTaskData sMTaskData;
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETTASK);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    throw new SMNoSuchObjectException("record not found: " + sMDBObjectID + ", " + string);
                }
                if (sMDBObjectID == null) {
                    sMDBObjectID = new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK");
                }
                SMTaskData sMTaskData2 = new SMTaskData(sMDBObjectID);
                sMTaskData2.setTaskType(oracleResultSet.getInt("TASK_TYPE"));
                sMTaskData2.setName(oracleResultSet.getString("NAME"));
                sMTaskData2.setDescription(oracleResultSet.getString("DESCRIPTION"));
                sMTaskData2.setUpdatedBy(oracleResultSet.getString("UPDATED_BY"));
                sMTaskData2.setTimestamp(new SMDBConcurrencyTimestamp(oracleResultSet.getTimestamp("TIMESTAMP")));
                sMTaskData2.setCreatedDate(oracleResultSet.getTimestamp("CREATED_DATE"));
                callableStatement.close();
                MtTaskSecurity.getInstance().checkAccess(sMTaskData2.getTaskType(), "edit", this.security_);
                callableStatement = connection.prepareCall(SP_GETTASKOPERATION);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                Vector<SMTaskOperationData> vector = new Vector<SMTaskOperationData>();
                while (true) {
                    if (!oracleResultSet.next()) {
                        Object[] objectArray = new SMTaskOperationData[vector.size()];
                        vector.copyInto(objectArray);
                        sMTaskData2.setOperations((SMTaskOperationData[])objectArray);
                        callableStatement.close();
                        sMTaskData2.setChanged(false);
                        sMTaskData = sMTaskData2;
                        Object var6_15 = null;
                        break;
                    }
                    SMTaskOperationData sMTaskOperationData = new SMTaskOperationData();
                    sMTaskOperationData.setOperation(oracleResultSet.getString("OPERATION"));
                    sMTaskOperationData.setOperand(oracleResultSet.getString("OPERAND"));
                    sMTaskOperationData.setValue(oracleResultSet.getString("VALUE"));
                    sMTaskOperationData.setValueType(oracleResultSet.getString("VALUE_TYPE"));
                    sMTaskOperationData.setUserData(oracleResultSet.getString("USER_DATA"));
                    sMTaskOperationData.setAsync(oracleResultSet.getBoolean("ASYNC"));
                    vector.addElement(sMTaskOperationData);
                }
            }
            catch (SQLException sQLException) {
                throw new SMDatabaseException((Throwable)sQLException);
            }
            catch (SMLengthException sMLengthException) {
                throw new SMDatabaseException((Throwable)sMLengthException);
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                throw new SMDatabaseException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMTaskData;
    }

    private int getTaskTypeID(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMTaskInfo sMTaskInfo = this.loadInfo(sMDBObjectID);
        return sMTaskInfo.getTaskType();
    }

    public SMTaskType[] getTaskTypes() throws SMSecurityException {
        return MtTaskDescriptor.getTaskTypes(this.security_);
    }

    public SMTaskData load(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        if (!"TASK".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        return this.getTask(sMDBObjectID, null);
    }

    public SMTaskData load(String string) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.getTask(null, string.trim());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMTaskInfo loadInfo(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMTaskInfo sMTaskInfo;
        if (!"TASK".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETTASK);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, null);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    throw new SMNoSuchObjectException("record not found: " + sMDBObjectID);
                }
                SMTaskInfo sMTaskInfo2 = new SMTaskInfo(new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getInt("TASK_TYPE"));
                MtTaskSecurity.getInstance().checkAccess(sMTaskInfo2.getTaskType(), "edit", this.security_);
                sMTaskInfo = sMTaskInfo2;
                Object var5_10 = null;
            }
            catch (SQLException sQLException) {
                throw new SMDatabaseException((Throwable)sQLException);
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                throw new SMDatabaseException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMTaskInfo;
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        MtTaskService.getTaskChangeMulticaster().remove((MSBaseService)this, sMDBRemoteChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMDBObject save(SMTaskData sMTaskData) throws SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        SMDBObject sMDBObject;
        Connection connection;
        block11: {
            SMDBObject sMDBObject2;
            block10: {
                MSSecurity.getInstance().checkAccess(this.getServiceName(), "save", this.getUserSecurityCredential());
                MtTaskSecurity.getInstance().checkAccess(sMTaskData.getTaskType(), "edit", this.security_);
                connection = MSDB.getConnection();
                try {
                    try {
                        CallableStatement callableStatement = connection.prepareCall(SP_UPDATETASK);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMTaskData.getObjectID());
                        callableStatement.setInt(2, sMTaskData.getTaskType());
                        callableStatement.setString(3, sMTaskData.getName());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMTaskData.getDescription());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)this.getUserSecurityCredential().getUser());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (SMDBConcurrencyTimestamp)sMTaskData.getTimestamp());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (Timestamp)sMTaskData.getCreatedDate());
                        callableStatement.registerOutParameter(1, 4);
                        callableStatement.registerOutParameter(6, 93);
                        callableStatement.registerOutParameter(7, 93);
                        callableStatement.execute();
                        SMDBObjectID sMDBObjectID = new SMDBObjectID(callableStatement.getLong(1), "TASK");
                        SMDBObject sMDBObject3 = new SMDBObject(sMDBObjectID);
                        sMDBObject3.setUpdatedBy(this.getUserSecurityCredential().getUser());
                        sMDBObject3.setTimestamp(new SMDBConcurrencyTimestamp(callableStatement.getTimestamp(6)));
                        sMDBObject3.setCreatedDate(callableStatement.getTimestamp(7));
                        callableStatement.close();
                        if (!sMTaskData.isOperationChanged() && sMTaskData.getObjectID() != null) {
                            connection.commit();
                            this.fireEventForSave((SMDBObject)sMTaskData, sMDBObject3);
                            sMDBObject2 = sMDBObject3;
                            Object var5_10 = null;
                            break block10;
                        }
                        this.deleteOperations(connection, sMDBObject3.getObjectID());
                        SMTaskOperationData[] sMTaskOperationDataArray = sMTaskData.getOperations();
                        if (sMTaskOperationDataArray != null) {
                            int n = 0;
                            while (n < sMTaskOperationDataArray.length) {
                                SMTaskOperationData sMTaskOperationData = sMTaskOperationDataArray[n];
                                callableStatement = connection.prepareCall(SP_UPDATETASKOPERATION);
                                callableStatement.setLong(1, sMDBObject3.getObjectID().getID());
                                callableStatement.setInt(2, n + 1);
                                callableStatement.setString(3, sMTaskOperationData.getOperation());
                                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMTaskOperationData.getOperand());
                                MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)sMTaskOperationData.getValue());
                                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (String)sMTaskOperationData.getValueType());
                                callableStatement.setString(7, sMTaskOperationData.getUserData());
                                callableStatement.setBoolean(8, sMTaskOperationData.isAsync());
                                callableStatement.execute();
                                callableStatement.close();
                                ++n;
                            }
                        }
                        connection.commit();
                        this.fireEventForSave((SMDBObject)sMTaskData, sMDBObject3);
                        sMDBObject = sMDBObject3;
                        break block11;
                    }
                    catch (SQLException sQLException) {
                        MSDB.rollback((Connection)connection);
                        if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                            throw new SMStaleDataException((Throwable)sQLException);
                        }
                        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                            throw new SMNoSuchObjectException((Throwable)sQLException);
                        }
                        if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") < 0) throw new SMDatabaseException((Throwable)sQLException);
                        throw new SMDuplicateException((Throwable)sQLException);
                    }
                    catch (Exception exception) {
                        MSDB.rollback((Connection)connection);
                        throw new SMDatabaseException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MSDB.closeConnection((Connection)connection);
            return sMDBObject2;
        }
        Object var5_11 = null;
        MSDB.closeConnection((Connection)connection);
        return sMDBObject;
    }
}

