/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.aurora.server.tools.sess_iiop.Loadjava;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;

public class Loadjar
extends Loadjava {
    public Loadjar() {
    }

    public Loadjar(boolean verbose_, boolean resolve_, boolean force_, boolean bound_, boolean synonym_, String schema_, String resolver_, String grant_, String encoding_, File[] files) throws ToolsException {
        super(verbose_, resolve_, force_, bound_, synonym_, schema_, resolver_, grant_, encoding_, files);
    }

    public Loadjar(boolean verbose_, boolean resolve_, boolean force_, boolean bound_, boolean synonym_, String schema_, String resolver_, String grant_, String encoding_, String[] files) throws ToolsException {
        super(verbose_, resolve_, force_, bound_, synonym_, schema_, resolver_, grant_, encoding_, files);
    }

    public String description() throws ToolsException {
        return this.msg("LOADJAR_DESCRIPTION", null);
    }

    public String help() throws ToolsException {
        return this.msg("LOADJAR_HELP", null);
    }

    protected void invoke() throws ToolsException {
        this.get_loader();
        int i = 0;
        while (i < this.fileNames.length) {
            try {
                ZipFile jar = null;
                try {
                    jar = new ZipFile((File)ToolImpl.local_wd.lookup(this.fileNames[i]));
                    this.loadAndCreate(jar);
                }
                finally {
                    Object var4_4 = null;
                    if (jar != null) {
                        jar.close();
                    }
                }
            }
            catch (IOException e) {
                this.error(e.getMessage());
            }
            ++i;
        }
        this.resolve();
        this.createSynonym();
    }

    private void loadAndCreate(ZipFile jar) throws ToolsException {
        Enumeration<? extends ZipEntry> e = jar.entries();
        try {
            while (e.hasMoreElements()) {
                ZipEntry currentEntry = e.nextElement();
                if (currentEntry.isDirectory()) continue;
                if (currentEntry.getMethod() == 8) {
                    this.error("Loadjar is unable to handle compressed entries: " + currentEntry.getName());
                }
                this.create(currentEntry.getName(), jar.getInputStream(currentEntry));
            }
        }
        catch (IOException iOException) {
            this.error("IO error when processing: " + jar.getName());
        }
    }

    public static void main(String[] args) {
        try {
            new Loadjar().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public String usage() throws ToolsException {
        return this.msg("LOADJAR_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("LOADJAR_VERSION", null);
    }
}

