/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.PrintWriter;
import java.util.Vector;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.Identity;
import javax.ejb.deployment.SessionDescriptor;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedAttribute;
import oracle.aurora.ejb.parser.Util;

public class ParsedProperties
extends ParsedAttribute {
    public Vector values;

    public ParsedProperties(String name, Vector values) {
        this.name = name;
        this.values = values;
    }

    public void dump(PrintWriter out, int indentation) {
        Util.indent(out, indentation);
        Util.dumpString(out, this.name);
        out.print(" = {");
        int length = this.values.size();
        int i = 0;
        while (i < length) {
            String value = (String)this.values.elementAt(i);
            if (i > 0) {
                out.print(", ");
            }
            Util.dumpString(out, value);
            ++i;
        }
        out.println("};");
    }

    public void populateDescriptors(DeploymentDescriptor descriptor, ControlDescriptor control, AccessControlEntry access) throws Exception {
        if (this.name.equals("AllowedIdentities")) {
            if (access.getAllowedIdentities() != null) {
                ParseError.PROPERTY_ALREADY_SET(this.name);
            }
            java.security.Identity[] identities = new java.security.Identity[this.values.size()];
            int i = 0;
            while (i < identities.length) {
                identities[i] = new Identity((String)this.values.elementAt(i));
                ++i;
            }
            access.setAllowedIdentities(identities);
        } else if (control.getMethod() != null) {
            ParseError.UNKNOWN_METHOD_PROPERTY(this.name);
        } else if (descriptor instanceof SessionDescriptor) {
            ParseError.UNKNOWN_SESSION_BEAN_PROPERTY(this.name);
        } else {
            ParseError.UNKNOWN_ENTITY_BEAN_PROPERTY(this.name);
        }
    }
}

