/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedObject;
import oracle.aurora.ejb.parser.ParsedProperty;
import oracle.aurora.ejb.parser.Util;

public class ParsedNamedProperty
extends ParsedObject {
    String name;
    Vector properties;

    public ParsedNamedProperty(String name, Vector properties) {
        this.name = name;
        this.properties = properties;
    }

    public void dump(PrintWriter out, int indentation) {
        Util.indent(out, indentation);
        Util.dumpString(out, this.name);
        out.println();
        Util.indent(out, indentation);
        out.println("{");
        int size = this.properties.size();
        int i = 0;
        while (i < size) {
            ParsedProperty property = (ParsedProperty)this.properties.elementAt(i);
            property.dump(out, indentation + 1);
            ++i;
        }
        Util.indent(out, indentation);
        out.println("}");
    }

    public Properties makeProperties() {
        Properties realProperties = new Properties();
        int size = this.properties.size();
        int i = 0;
        while (i < size) {
            ParsedProperty property = (ParsedProperty)this.properties.elementAt(i);
            ((Hashtable)realProperties).put(property.name, property.value);
            ++i;
        }
        return realProperties;
    }

    public void populateBeanDescriptor(DeploymentDescriptor descriptor) throws Exception {
        if (this.name.equals("EnvironmentProperties")) {
            Properties properties = this.makeProperties();
            descriptor.setEnvironmentProperties(properties);
        } else {
            ParseError.UNKNOWN_BEAN_NAMED_PROPERTY(this.name);
        }
    }
}

