/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import oracle.aurora.ejb.parser.MethodEntry;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedBean;
import oracle.aurora.ejb.parser.ParsedMethod;
import oracle.aurora.ejb.parser.ParsedType;
import oracle.aurora.ejb.parser.ParsedTypes;

public class MethodTable {
    ClassLoader loader;
    Hashtable table;

    MethodTable(ClassLoader loader) {
        this.loader = loader;
        this.table = new Hashtable();
    }

    void addMethods(Method[] methods) {
        if (methods == null) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            MethodEntry oldEntry = (MethodEntry)this.table.get(name);
            MethodEntry newEntry = new MethodEntry(methods[i], oldEntry);
            this.table.put(name, newEntry);
            ++i;
        }
    }

    boolean argumentTypesMatch(ParsedTypes parsedTypes, Class[] parameterTypes) throws ClassNotFoundException {
        Vector typeVector = parsedTypes.types;
        int size = typeVector.size();
        if (size != parameterTypes.length) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (!this.typeMatches((ParsedType)typeVector.elementAt(i), parameterTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    Method findMethod(ParsedMethod parsedMethod) throws Exception {
        MethodEntry entry = (MethodEntry)this.table.get(parsedMethod.name);
        if (entry == null) {
            ParseError.NO_METHOD_NAMED(parsedMethod.name);
        }
        do {
            if (!this.argumentTypesMatch(parsedMethod.argumentTypes, entry.method.getParameterTypes())) continue;
            return entry.method;
        } while ((entry = entry.next) != null);
        ParseError.NO_METHOD_WITH_SIGNATURE(parsedMethod.toString());
        return null;
    }

    boolean typeMatches(ParsedType parsedType, Class clazz) throws ClassNotFoundException {
        Class<?> clazz2 = clazz;
        int i = 0;
        while (i < parsedType.dimension) {
            if (!clazz2.isArray()) {
                return false;
            }
            clazz2 = clazz2.getComponentType();
            ++i;
        }
        Class this_clazz = ParsedBean.findClass(this.loader, parsedType.name);
        return this_clazz == clazz2;
    }
}

