/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.hierarchy;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusResponse;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.client.topology.SMFamilyStatusIcon;
import com.sun.symon.base.client.topology.SMHierarchyResponse;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.tools.buffer.CtTransferBuffer;
import com.sun.symon.base.console.tools.buffer.CtTransferChangeEvent;
import com.sun.symon.base.console.tools.buffer.CtTransferChangeListener;
import com.sun.symon.base.console.views.CvContextPopupEvent;
import com.sun.symon.base.console.views.CvContextPopupListener;
import com.sun.symon.base.console.views.CvNavigationEvent;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.CvPresentationView;
import com.sun.symon.base.console.views.CvSelectionInfo;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyData;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyIdentifier;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyKeyNavigation;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyPathOpen;
import com.sun.symon.base.console.views.hierarchy.CvHierarchySelectEvent;
import com.sun.symon.base.console.views.hierarchy.CvHierarchySelectListener;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyTree;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyTreeCellRenderer;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyTreeModel;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyUpdateChildrenDataRunnable;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyUpdateRootStatusRunnable;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CvHierarchyManager
extends JPanel
implements MouseListener,
MouseMotionListener,
CvPresentationView,
SMHierarchyResponse,
SMAlarmStatusResponse,
TreeExpansionListener,
TreeSelectionListener,
CtTransferChangeListener,
TreeWillExpandListener {
    private SMTopologyRequest dataSource = null;
    private SMAlarmStatusRequest statusSource = null;
    private SMRawDataRequest rawDataSource = null;
    private String mibRootUrl = null;
    private DefaultMutableTreeNode mibTreeRoot = null;
    protected CvHierarchyTreeModel mibTreeModel = null;
    private JTree initTree = null;
    private CvHierarchyTree mibTree = null;
    private CvHierarchyTreeCellRenderer cellRenderer = null;
    private Font labelFont = new Font("SansSerif", 0, 12);
    private String reXsetUrl = null;
    private Vector drillDownListeners = new Vector();
    private Vector contextPopupListeners = new Vector();
    private Vector selectionListeners = new Vector();
    private String refreshPeriod = "120";
    private JScrollPane scrollPane = null;
    private Color treeColor = Color.white;
    private boolean isFromTopology = false;
    private CtTransferBuffer CutPasteBuffer = null;
    private boolean ShowRootNameInNavigation = true;
    private Object rootDataReqHandle = null;
    private SMModuleRequest moduleRequestHandle = null;
    private boolean allowCollapseRoot = false;
    private boolean fromMetadata = false;

    public CvHierarchyManager() {
        this.setPreferredSize(new Dimension(312, 516));
    }

    public void activateBean() {
        try {
            this.rootDataReqHandle = this.isFromTopology ? this.dataSource.getHierarchyRootRequestFromTopology(this.mibRootUrl, "30", (SMHierarchyResponse)this, null) : this.dataSource.getHierarchyRootRequest(this.mibRootUrl, "30", false, (SMHierarchyResponse)this, null);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CvHierarchyManager.activateBean() - Failed to request for hierarchy root node data: " + (Object)((Object)sMAPIException)));
            return;
        }
    }

    public synchronized void addCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        if (!this.contextPopupListeners.contains(cvContextPopupListener)) {
            this.contextPopupListeners.addElement(cvContextPopupListener);
        }
    }

    public synchronized void addCvHierarchySelectListener(CvHierarchySelectListener cvHierarchySelectListener) {
        if (!this.selectionListeners.contains(cvHierarchySelectListener)) {
            this.selectionListeners.addElement(cvHierarchySelectListener);
        }
    }

    public synchronized void addCvNavigationListener(CvNavigationListener cvNavigationListener) {
        if (!this.drillDownListeners.contains(cvNavigationListener)) {
            this.drillDownListeners.addElement(cvNavigationListener);
        }
    }

    public void clearSelection() {
        if (this.mibTree != null) {
            this.mibTree.clearSelection();
        }
    }

    private void fireContextPopupEvents(CvHierarchyData cvHierarchyData, int n, int n2) {
        Vector vector;
        String string;
        String string2;
        String string3 = "sym//iso/org/dod/internet/private/enterprises/sun/prod/sunsymon/agent/base/mibman/modules/";
        n += 15;
        String string4 = "";
        CvHierarchyData cvHierarchyData2 = cvHierarchyData.getParentData();
        while (cvHierarchyData2 != null) {
            string2 = cvHierarchyData2.getObjectId();
            string = cvHierarchyData2.getName();
            if (string2 == null || string2.trim().length() == 0) {
                string = this.ShowRootNameInNavigation ? cvHierarchyData2.getName() : null;
            }
            if (string != null) {
                string4 = string4.length() != 0 ? String.valueOf(string) + "/" + string4 : string;
            }
            cvHierarchyData2 = cvHierarchyData2.getParentData();
        }
        string2 = null;
        string = cvHierarchyData.getTargetUrl();
        if (cvHierarchyData.getParentData() != null) {
            string = cvHierarchyData.getParentData().getTargetUrl();
            string = String.valueOf(UcURL.standardizeURL((String)string)) + "#" + cvHierarchyData.getObjectId();
        } else {
            string = this.isFromTopology ? UcURL.standardizeURL((String)this.mibRootUrl) : UcURL.standardizeURL((String)string);
            string2 = "root";
        }
        SMFamilyCommands sMFamilyCommands = null;
        if (this.fromMetadata) {
            int n3 = string.indexOf("sym//iso/org/dod/internet/private/enterprises/sun/prod/sunsymon/agent/base/mibman/modules/");
            if (n3 != -1) {
                sMFamilyCommands = CmConsoleSession.getMDRModuleCommands();
            }
        } else {
            sMFamilyCommands = cvHierarchyData.getFamilyCommands();
        }
        CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this, string2, string4, cvHierarchyData.getName(), sMFamilyCommands, n, n2, string, cvHierarchyData.getNavigationUrl(), cvHierarchyData.getTargetUrl(), null, null);
        CvHierarchyManager cvHierarchyManager = this;
        synchronized (cvHierarchyManager) {
            vector = (Vector)this.contextPopupListeners.clone();
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            CvContextPopupListener cvContextPopupListener = (CvContextPopupListener)vector.elementAt(n4);
            try {
                cvContextPopupListener.contextPopupOccurred(cvContextPopupEvent);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("CvHierarchyManager.fireContextPopupEvents() - For URL=" + cvHierarchyData.getNavigationUrl() + ", client error in contextPopupOccurred: " + exception));
            }
            ++n4;
        }
    }

    protected void fireDrillDownEvents(CvHierarchyData cvHierarchyData) {
        Vector vector;
        String string = cvHierarchyData.getTargetUrl();
        if (cvHierarchyData.getParentData() != null) {
            string = cvHierarchyData.getParentData().getTargetUrl();
            string = String.valueOf(UcURL.standardizeURL((String)string)) + "#" + cvHierarchyData.getObjectId();
        } else {
            string = this.isFromTopology ? UcURL.standardizeURL((String)this.mibRootUrl) : UcURL.standardizeURL((String)string);
        }
        int n = 0;
        CvHierarchyData cvHierarchyData2 = cvHierarchyData;
        while (cvHierarchyData2 != null) {
            ++n;
            cvHierarchyData2 = cvHierarchyData2.getParentData();
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        cvHierarchyData2 = cvHierarchyData;
        while (cvHierarchyData2 != null) {
            stringArray[--n] = cvHierarchyData2.getObjectId();
            if (stringArray[n] == null || stringArray[n].trim().length() == 0) {
                stringArray[n] = "root";
                stringArray2[n] = this.ShowRootNameInNavigation ? cvHierarchyData2.getName() : null;
            } else {
                stringArray2[n] = cvHierarchyData2.getName();
            }
            stringArray3[n] = cvHierarchyData2.getNavigationUrl();
            cvHierarchyData2 = cvHierarchyData2.getParentData();
        }
        String string2 = null;
        if (cvHierarchyData.getFamilyCommands() != null) {
            string2 = cvHierarchyData.getFamilyCommands().getNavigateSpec();
        }
        CvNavigationEvent cvNavigationEvent = new CvNavigationEvent(this, cvHierarchyData.getName(), string2, string, cvHierarchyData.getNavigationUrl(), cvHierarchyData.getTargetUrl(), stringArray, stringArray2, stringArray3);
        CvHierarchyManager cvHierarchyManager = this;
        synchronized (cvHierarchyManager) {
            vector = (Vector)this.drillDownListeners.clone();
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            CvNavigationListener cvNavigationListener = (CvNavigationListener)vector.elementAt(n2);
            try {
                cvNavigationListener.navigationOccurred(cvNavigationEvent);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("HierarchyManager.fireDrillDownEvents() - For URL=" + cvHierarchyData.getNavigationUrl() + ", client error in navigationOccurred: " + exception));
            }
            ++n2;
        }
    }

    public void getAlarmStatusListResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[] sMAlarmStatusDataArray, Object object) {
    }

    public Font getFont() {
        if (this.cellRenderer == null) {
            return super.getFont();
        }
        return this.cellRenderer.getFont();
    }

    public void getHierarchyChildResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData[] sMHierarchyViewDataArray, Object object) {
        Object object2;
        Serializable serializable;
        int n = sMRequestStatus.getReturnCode();
        String string = sMRequestStatus.getMessageText();
        Exception exception = sMRequestStatus.getException();
        if (n == 0) {
            CvHierarchyIdentifier cvHierarchyIdentifier = (CvHierarchyIdentifier)object;
            serializable = cvHierarchyIdentifier.getTreeNode();
            if (serializable == null) {
                String string2 = cvHierarchyIdentifier.getUrl();
                if (string2 == null) {
                    UcDDL.logErrorMessage((String)"CvHierarchyManager.receiveDataResult() -  Failed to search URL");
                    return;
                }
                CvHierarchyPathOpen cvHierarchyPathOpen = new CvHierarchyPathOpen(string2, sMHierarchyViewDataArray, this.mibTree, this.mibTreeModel);
                TreePath treePath = cvHierarchyPathOpen.getTargetTreePath();
                if (treePath != null) {
                    this.mibTree.selectPath(treePath, true);
                } else {
                    this.setManagedObjectUrl(string2, string2, this.mibTreeRoot, this.mibTree.getSelectionPath(), true);
                }
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                object2 = this.mibTreeModel.updateChildrenData((DefaultMutableTreeNode)serializable, sMHierarchyViewDataArray);
                this.postUpdateChildrenData((DefaultMutableTreeNode)serializable, (DefaultMutableTreeNode)object2);
            } else {
                object2 = new CvHierarchyUpdateChildrenDataRunnable(this.mibTreeModel, (DefaultMutableTreeNode)serializable, sMHierarchyViewDataArray, this);
                SwingUtilities.invokeLater((Runnable)object2);
            }
        } else {
            CvHierarchyIdentifier cvHierarchyIdentifier = (CvHierarchyIdentifier)object;
            DefaultMutableTreeNode defaultMutableTreeNode = cvHierarchyIdentifier.getTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            this.mibTreeModel.disableChildNodes(defaultMutableTreeNode);
            if (SwingUtilities.isEventDispatchThread()) {
                this.mibTreeModel.removeChildNodes(defaultMutableTreeNode);
            } else {
                SwingUtilities.invokeLater(new RemoveChildNodesRunnable(defaultMutableTreeNode));
            }
            return;
        }
        int n2 = this.mibTree.getSelectionCount();
        serializable = new CvHierarchySelectEvent(this, n2);
        CvHierarchyManager cvHierarchyManager = this;
        synchronized (cvHierarchyManager) {
            object2 = (Vector)this.selectionListeners.clone();
        }
        int n3 = 0;
        while (n3 < ((Vector)object2).size()) {
            CvHierarchySelectListener cvHierarchySelectListener = (CvHierarchySelectListener)((Vector)object2).elementAt(n3);
            try {
                cvHierarchySelectListener.selectionOccurred((CvHierarchySelectEvent)serializable);
            }
            catch (Exception exception2) {
                UcDDL.logWarningMessage((String)("HierarchyManager - client error in selectionOccurred" + exception2));
            }
            ++n3;
        }
    }

    public void getHierarchyRootResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData sMHierarchyViewData, Object object) {
        int n = sMRequestStatus.getReturnCode();
        String string = sMRequestStatus.getMessageText();
        Exception exception = sMRequestStatus.getException();
        if (n == 0) {
            Object object2;
            Object object3;
            if (this.rootDataReqHandle != null) {
                try {
                    this.rawDataSource.removeURLRequest(this.rootDataReqHandle);
                }
                catch (SMAPIException sMAPIException) {}
            }
            if (this.initTree != null) {
                this.removeRequests();
                this.remove(this.initTree);
            }
            boolean bl = false;
            if (this.fromMetadata) {
                object3 = new UcURL(this.mibRootUrl);
                object2 = new UcURL(this.rawDataSource.getMDRBaseURL());
                if (object3.getHost().equals(object2.getHost()) && object3.getPort().equals(object2.getPort())) {
                    SMHierarchyViewData sMHierarchyViewData2;
                    bl = true;
                    sMHierarchyViewData = sMHierarchyViewData2 = new SMHierarchyViewData(sMHierarchyViewData.getObjectId(), "Modules", null, null, sMHierarchyViewData.getNavigationUrl(), sMHierarchyViewData.getTargetUrl(), sMHierarchyViewData.getIsBranch(), sMHierarchyViewData.getIsSoftGroupLink());
                }
            }
            object3 = new CvHierarchyData(null, sMHierarchyViewData);
            this.mibTreeRoot = new DefaultMutableTreeNode(object3);
            this.mibTreeRoot.setUserObject(object3);
            this.mibTreeModel = new CvHierarchyTreeModel((TreeNode)this.mibTreeRoot, this.rawDataSource);
            this.mibTree = new CvHierarchyTree(this.mibTreeModel, this);
            this.mibTree.getSelectionModel().setSelectionMode(1);
            this.mibTree.setShowsRootHandles(false);
            if (this.reXsetUrl != null) {
                this.setManagedObjectUrl(this.reXsetUrl);
                this.reXsetUrl = null;
            }
            ToolTipManager.sharedInstance().registerComponent(this.mibTree);
            this.cellRenderer = new CvHierarchyTreeCellRenderer(this.labelFont);
            this.mibTree.setCellRenderer(this.cellRenderer);
            this.mibTree.setRowHeight(-1);
            this.mibTree.putClientProperty("JTree.lineStyle", "Angled");
            this.mibTree.addFocusListener(this.mibTree);
            this.mibTree.addKeyListener(new CvHierarchyKeyNavigation(this.mibTree));
            this.mibTree.addMouseListener(this);
            this.mibTree.addMouseMotionListener(this);
            this.mibTree.addTreeExpansionListener(this);
            this.mibTree.addTreeSelectionListener(this);
            this.mibTree.addTreeWillExpandListener(this);
            try {
                this.mibTreeModel.addChildNode(this.mibTreeRoot, null, 0);
            }
            catch (Exception exception2) {
                UcDDL.logErrorMessage((String)("CvHierarchyManager.getHierarchyRootResponse - Failed to properly display root node: " + exception2));
                return;
            }
            if (!bl) {
                try {
                    object2 = this.statusSource.getTopAlarmStatusRequest(object3.getNavigationUrl(), this.refreshPeriod, (SMAlarmStatusResponse)this, null);
                    ((CvHierarchyData)((Object)object3)).setTopStatusReqHandle(object2);
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)("CvHierarchyManager.receiveDataResult - Failed to request top status for root node: " + (Object)((Object)sMAPIException)));
                    ((CvHierarchyData)((Object)object3)).enable(false);
                }
            }
            this.mibTree.expandRow(0);
            this.setLayout(new BorderLayout());
            this.scrollPane = new JScrollPane(this.mibTree);
            super.setBackground(this.treeColor);
            this.scrollPane.setBackground(this.treeColor);
            this.mibTree.setBackground(this.treeColor);
            this.add((Component)this.scrollPane, "Center");
            this.mibTree.requestFocus();
            object2 = this.getParent();
            if (object2 != null) {
                ((Container)object2).invalidate();
                ((Container)object2).validate();
            }
        } else {
            String string2 = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.readobject");
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
            this.initTree = new JTree(defaultMutableTreeNode, true);
            this.initTree.setEnabled(false);
            this.add(this.initTree);
            UcDDL.logErrorMessage((String)("CvHierarchyManager.getHierarchyRootResponse - Received data exception for root node: " + exception));
        }
    }

    public Point getLocationForName(String string) {
        Cloneable cloneable;
        TreePath treePath = null;
        Enumeration<TreeNode> enumeration = this.mibTreeRoot.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            String string2;
            cloneable = (DefaultMutableTreeNode)enumeration.nextElement();
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)((DefaultMutableTreeNode)cloneable).getUserObject());
            if (cvHierarchyData == null || !cvHierarchyData.isEnabled() || !string.equals(string2 = cvHierarchyData.getName())) continue;
            treePath = new TreePath(((DefaultMutableTreeNode)cloneable).getPath());
            break;
        }
        if (treePath == null) {
            return null;
        }
        cloneable = this.mibTree.getPathBounds(treePath);
        return ((Rectangle)cloneable).getLocation();
    }

    public String getSelectedEntityId() {
        if (this.mibTree.getSelectionCount() == 0) {
            return null;
        }
        TreePath treePath = this.mibTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
        if (cvHierarchyData == null) {
            return null;
        }
        return cvHierarchyData.getObjectId();
    }

    public CvSelectionInfo getSelectionInfo() {
        String string;
        String string2;
        if (this.mibTree.getSelectionCount() == 0) {
            return null;
        }
        TreePath treePath = this.mibTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
        if (cvHierarchyData == null) {
            return null;
        }
        String string3 = "";
        CvHierarchyData cvHierarchyData2 = cvHierarchyData.getParentData();
        while (cvHierarchyData2 != null) {
            string2 = cvHierarchyData2.getObjectId();
            string = cvHierarchyData2.getName();
            if (string2 == null || string2.trim().length() == 0) {
                string = this.ShowRootNameInNavigation ? cvHierarchyData2.getName() : null;
            }
            if (string != null) {
                string3 = string3.length() != 0 ? String.valueOf(string) + "/" + string3 : string;
            }
            cvHierarchyData2 = cvHierarchyData2.getParentData();
        }
        string2 = null;
        string = cvHierarchyData.getTargetUrl();
        String string4 = null;
        if (cvHierarchyData.getParentData() != null) {
            string4 = cvHierarchyData.getParentData().getTargetUrl();
            string = String.valueOf(UcURL.standardizeURL((String)string4)) + "#" + cvHierarchyData.getObjectId();
        } else {
            string = this.isFromTopology ? UcURL.standardizeURL((String)this.mibRootUrl) : UcURL.standardizeURL((String)string);
            string2 = "root";
        }
        CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this, string2, string3, cvHierarchyData.getName(), cvHierarchyData.getFamilyCommands(), 0, 0, string, cvHierarchyData.getNavigationUrl(), cvHierarchyData.getTargetUrl(), null, null);
        return new CvSelectionInfo(string4, new String[]{cvHierarchyData.getObjectId()}, cvContextPopupEvent);
    }

    public void getTopAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData sMAlarmStatusData, Object object) {
        int n = sMRequestStatus.getReturnCode();
        String string = sMRequestStatus.getMessageText();
        Exception exception = sMRequestStatus.getException();
        if (n == 0) {
            SMAlarmStatusData sMAlarmStatusData2 = sMAlarmStatusData;
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)this.mibTreeRoot.getUserObject());
            cvHierarchyData.setAlarmStatusInfo(sMAlarmStatusData2);
            SMFamilyStatusIcon sMFamilyStatusIcon = cvHierarchyData.getFamilyImages().getIcon(sMAlarmStatusData2.getState(), false);
            cvHierarchyData.setIconImage((Icon)sMFamilyStatusIcon);
            cvHierarchyData.enable(true);
            if (SwingUtilities.isEventDispatchThread()) {
                this.mibTreeModel.nodeChanged(this.mibTreeRoot);
            } else {
                CvHierarchyUpdateRootStatusRunnable cvHierarchyUpdateRootStatusRunnable = new CvHierarchyUpdateRootStatusRunnable(this.mibTreeModel, this.mibTreeRoot);
                SwingUtilities.invokeLater(cvHierarchyUpdateRootStatusRunnable);
            }
        } else {
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)this.mibTreeRoot.getUserObject());
            UcDDL.logWarningMessage((String)("CvHierarchyManager.receiveStatusRequestError - Received status exception for root node " + (Object)((Object)cvHierarchyData) + ": " + exception));
            if (cvHierarchyData != null) {
                Object object2;
                cvHierarchyData.enable(false);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.mibTreeModel.nodeChanged(this.mibTreeRoot);
                } else {
                    object2 = new CvHierarchyUpdateRootStatusRunnable(this.mibTreeModel, this.mibTreeRoot);
                    SwingUtilities.invokeLater(object2);
                }
                if (n == 4 || n == 1) {
                    return;
                }
                object2 = (CvHierarchyData)((Object)this.mibTreeRoot.getUserObject());
                UcAgentURL ucAgentURL = new UcAgentURL(object2.getTargetUrl());
                String string2 = ucAgentURL.getModuleSpec();
                if (string2 == null || string2.equals("")) {
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            CvHierarchyManager.this.moduleRequestHandle = new SMModuleRequest(CvHierarchyManager.this.rawDataSource);
                            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)CvHierarchyManager.this.mibTreeRoot.getUserObject());
                            UcAgentURL ucAgentURL = new UcAgentURL(cvHierarchyData.getTargetUrl());
                            String string = ucAgentURL.getHost();
                            int n = Integer.parseInt(ucAgentURL.getPort());
                            String string2 = ucAgentURL.getModuleId();
                            if (!CvHierarchyManager.this.moduleRequestHandle.isModuleLoaded(string, n, string2)) {
                                UcDDL.logInfoMessage((String)"CvHierarchyManager --- stopping request for unloaded module");
                                CvHierarchyManager.this.shutdown();
                            }
                        }
                        catch (SMAPIException sMAPIException) {
                            UcDDL.logErrorMessage((String)("CvHierrarchyManager --- Failed to get module list " + (Object)((Object)sMAPIException)));
                        }
                    }
                }, "StopRequestThread");
                thread.start();
            }
        }
    }

    public DefaultMutableTreeNode getTreeNodeForLocation(int n, int n2) {
        TreePath treePath = this.mibTree.getPathForLocation(n, n2);
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode;
    }

    public void markSelectedPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (defaultMutableTreeNode == null && string2.equals("root")) {
                defaultMutableTreeNode = this.mibTreeRoot;
                continue;
            }
            if (defaultMutableTreeNode == null) break;
            boolean bl = false;
            int n = 0;
            while (n < defaultMutableTreeNode.getChildCount()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode2.getUserObject());
                if (cvHierarchyData != null && cvHierarchyData.getObjectId().equals(string2)) {
                    defaultMutableTreeNode = defaultMutableTreeNode2;
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) break;
        }
        if (defaultMutableTreeNode != null && this.mibTree != null) {
            this.mibTree.selectPath(new TreePath(defaultMutableTreeNode.getPath()), true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (!this.mibTree.isToolTipEnabled()) {
            return;
        }
        int n2 = mouseEvent.getX();
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNodeForLocation(n2, n = mouseEvent.getY());
        if (defaultMutableTreeNode == null) {
            return;
        }
        CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
        if (cvHierarchyData == null || !cvHierarchyData.isEnabled()) {
            return;
        }
        Icon icon = cvHierarchyData.getIconImage();
        if (icon == null) {
            cvHierarchyData.overIconFlag = false;
            return;
        }
        TreePath treePath = this.mibTree.getPathForLocation(n2, n);
        Rectangle rectangle = this.mibTree.getPathBounds(treePath);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, icon.getIconWidth(), icon.getIconHeight());
        if (!rectangle2.contains(n2, n)) {
            cvHierarchyData.overIconFlag = false;
            return;
        }
        cvHierarchyData.overIconFlag = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        CvHierarchyData cvHierarchyData;
        this.mibTree.requestFocus();
        TreePath treePath = this.mibTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        TreePath treePath2 = null;
        if (!this.mibTree.isPathSelected(treePath)) {
            treePath2 = treePath;
        }
        if ((cvHierarchyData = (CvHierarchyData)((Object)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject())) == null) {
            return;
        }
        TreePath treePath3 = this.mibTree.getPreviousSelectedPath();
        if (!cvHierarchyData.isEnabled()) {
            if (!treePath.equals(treePath3)) {
                this.mibTree.selectPath(treePath3, false, treePath2);
            }
            return;
        }
        String string = cvHierarchyData.getNavigationUrl();
        if (mouseEvent.isPopupTrigger()) {
            Point point = this.scrollPane.getViewport().getViewPosition();
            this.fireContextPopupEvents(cvHierarchyData, mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
        } else if (mouseEvent.isAltDown() || mouseEvent.isMetaDown() || mouseEvent.isShiftDown()) {
            if (!treePath.equals(treePath3)) {
                this.mibTree.selectPath(treePath3, false, treePath2);
            }
        } else if (mouseEvent.isControlDown()) {
            SMAlarmStatusData sMAlarmStatusData;
            if (!treePath.equals(treePath3)) {
                this.mibTree.selectPath(treePath3, false, treePath2);
            }
            if ((sMAlarmStatusData = cvHierarchyData.getAlarmStatusInfo()) == null) {
                UcDDL.logWarningMessage((String)"CvHierarchyManager.mousePressed - Status is not available, cannot spot the problem source");
                return;
            }
            String string2 = sMAlarmStatusData.getSourceUrl();
        } else if (!treePath.equals(treePath3)) {
            this.mibTree.setPreviousSelectedPath(treePath);
        } else if (mouseEvent.getClickCount() == 2) {
            this.fireDrillDownEvents(cvHierarchyData);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        TreePath treePath = this.mibTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            if (this.mibTree.getLatestCollapsedPath() != null && this.mibTree.getLatestCollapsedObjectData() != null) {
                if (this.mibTree.getLatestCollapsedPathSelected()) {
                    this.mibTree.selectPath(this.mibTree.getLatestCollapsedPath(), true);
                } else {
                    this.mibTree.scrollPathToVisible(this.mibTree.getLatestCollapsedPath());
                }
                this.mibTree.setLatestCollapsedPath(null);
                this.mibTree.setLatestCollapsedPathSelected(false);
                this.mibTree.setLatestCollapsedObjectData(null);
            }
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
        if (cvHierarchyData == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            Point point = this.scrollPane.getViewport().getViewPosition();
            this.fireContextPopupEvents(cvHierarchyData, mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
        }
    }

    protected void postUpdateChildrenData(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
    }

    public synchronized void removeCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        if (this.contextPopupListeners.contains(cvContextPopupListener)) {
            this.contextPopupListeners.removeElement(cvContextPopupListener);
        }
    }

    public synchronized void removeCvHierarchySelectListener(CvHierarchySelectListener cvHierarchySelectListener) {
        if (this.selectionListeners.contains(cvHierarchySelectListener)) {
            this.selectionListeners.removeElement(cvHierarchySelectListener);
        }
    }

    public synchronized void removeCvNavigationListener(CvNavigationListener cvNavigationListener) {
        if (this.drillDownListeners.contains(cvNavigationListener)) {
            this.drillDownListeners.removeElement(cvNavigationListener);
        }
    }

    private void removeExpandedPathRequests() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration;
        if (this.mibTree == null) {
            return;
        }
        TreePath treePath = this.mibTree.getPathForRow(0);
        Enumeration<TreePath> enumeration2 = this.mibTree.getExpandedDescendants(treePath);
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                enumeration = enumeration2.nextElement();
                defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)((Object)enumeration)).getLastPathComponent();
                this.shutdownRequestOnNode(defaultMutableTreeNode);
            }
        }
        if (this.mibTreeRoot == null) {
            return;
        }
        enumeration = this.mibTreeRoot.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                this.shutdownRequestOnNode(defaultMutableTreeNode);
            }
        }
    }

    private void removeRequests() {
        Object object;
        if (this.mibTree == null) {
            return;
        }
        this.allowCollapseRoot = true;
        this.mibTree.collapseRoot();
        if (this.mibTreeRoot == null) {
            return;
        }
        try {
            this.mibTreeModel.removeChildNodes(this.mibTreeRoot);
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)("CvHierarchyManager.removeRequests() - while removing the children for " + this.mibTreeRoot + " Exception occurred: " + exception));
        }
        CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)this.mibTreeRoot.getUserObject());
        Object object2 = cvHierarchyData.getTopStatusReqHandle();
        if (object2 != null) {
            try {
                this.rawDataSource.removeURLRequest(object2);
            }
            catch (SMAPIException sMAPIException) {}
        }
        if ((object = cvHierarchyData.getChildDataReqHandle()) != null) {
            try {
                this.rawDataSource.removeURLRequest(object);
            }
            catch (SMAPIException sMAPIException) {}
        }
        if (this.CutPasteBuffer != null) {
            this.CutPasteBuffer.removeCtTransferChangeListener(this);
        }
        this.allowCollapseRoot = false;
    }

    protected void scrollNextNodeToVisible(DefaultMutableTreeNode defaultMutableTreeNode) {
        CvHierarchyData cvHierarchyData;
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getNextNode();
        if (defaultMutableTreeNode2 == null) {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        }
        if ((cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode2.getUserObject())) == null && (defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextNode()) == null) {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.mibTree.scrollPathToVisible(treePath);
    }

    public void setBackground(Color color) {
        this.treeColor = color;
        super.setBackground(color);
        if (this.scrollPane != null) {
            this.scrollPane.setBackground(color);
        }
        if (this.mibTree != null) {
            this.mibTree.setBackground(color);
        }
    }

    public void setBufferReference(Object object) {
        this.CutPasteBuffer = (CtTransferBuffer)object;
        this.CutPasteBuffer.addCtTransferChangeListener(this);
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.rawDataSource = sMRawDataRequest;
        this.dataSource = new SMTopologyRequest(sMRawDataRequest);
        this.statusSource = new SMAlarmStatusRequest(sMRawDataRequest);
    }

    public void setFont(Font font) {
        if (font != null) {
            this.labelFont = font;
            if (this.cellRenderer != null) {
                this.cellRenderer.setFont(font);
            }
            super.setFont(font);
        }
    }

    public void setFromMetadata(boolean bl) {
        this.fromMetadata = bl;
    }

    public void setManagedObjectUrl(String string) {
        if (string == null) {
            return;
        }
        if (this.mibTreeRoot == null || this.mibTree == null) {
            this.reXsetUrl = string;
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mibTree.getLastSelectedPathComponent();
        String string2 = null;
        if (defaultMutableTreeNode == null) {
            string2 = this.mibRootUrl;
        } else {
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
            string2 = cvHierarchyData.getNavigationUrl();
            if (UcURL.areURLsEqual((String)string2, (String)string)) {
                this.mibTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
                return;
            }
        }
        this.setManagedObjectUrl(string, string2, this.mibTreeRoot, null, false);
    }

    private void setManagedObjectUrl(String string, String string2, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath, boolean bl) {
    }

    public void setRootUrl(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.mibRootUrl = string;
    }

    public void setShowRootNavigationName(boolean bl) {
        this.ShowRootNameInNavigation = bl;
    }

    public void setStdRefreshPeriod(String string) {
        if (string != null) {
            this.refreshPeriod = string;
        }
    }

    public void setTopologyIndicator(boolean bl) {
        this.isFromTopology = bl;
    }

    public void shutdown() {
        this.drillDownListeners.removeAllElements();
        this.contextPopupListeners.removeAllElements();
        this.selectionListeners.removeAllElements();
        if (this.rootDataReqHandle != null) {
            try {
                this.rawDataSource.removeURLRequest(this.rootDataReqHandle);
            }
            catch (SMAPIException sMAPIException) {}
        }
        this.removeExpandedPathRequests();
        this.removeRequests();
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    private void shutdownRequestOnNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        block7: {
            Object object;
            if (defaultMutableTreeNode == null) {
                return;
            }
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
            if (cvHierarchyData == null) {
                return;
            }
            Object object2 = cvHierarchyData.getTopStatusReqHandle();
            if (object2 != null) {
                try {
                    this.rawDataSource.removeURLRequest(object2);
                }
                catch (SMAPIException sMAPIException) {}
            }
            if ((object = cvHierarchyData.getChildDataReqHandle()) == null) break block7;
            try {
                this.rawDataSource.removeURLRequest(object);
            }
            catch (SMAPIException sMAPIException) {}
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        block15: {
            TreePath treePath = treeExpansionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
            Object object = cvHierarchyData.getTopStatusReqHandle();
            if (object != null) {
                try {
                    this.rawDataSource.removeURLRequest(object);
                }
                catch (SMAPIException sMAPIException) {}
            }
            if (!cvHierarchyData.getIsBranch()) break block15;
            Object object2 = cvHierarchyData.getChildDataReqHandle();
            if (object2 != null) {
                try {
                    this.rawDataSource.removeURLRequest(object2);
                }
                catch (SMAPIException sMAPIException) {}
            }
            try {
                try {
                    this.mibTreeModel.removeChildNodes(defaultMutableTreeNode);
                }
                catch (Exception exception) {
                    UcDDL.logWarningMessage((String)("CvHierarchyManager.treeCollapsed() - while removing the children for " + defaultMutableTreeNode + " Exception occurred: " + exception));
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    this.mibTreeModel.addChildNode(null, defaultMutableTreeNode, 0);
                }
                catch (Exception exception) {
                    UcDDL.logWarningMessage((String)("CvHierarchyManager.treeCollapsed() - while adding the auxiliary child for " + defaultMutableTreeNode + ", exception occurred: " + exception));
                }
                throw throwable;
            }
            try {
                this.mibTreeModel.addChildNode(null, defaultMutableTreeNode, 0);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("CvHierarchyManager.treeCollapsed() - while adding the auxiliary child for " + defaultMutableTreeNode + ", exception occurred: " + exception));
            }
            TreePath treePath2 = this.mibTree.getSelectionPath();
            if (treePath2 != null && !this.mibTree.isPathSelected(treePath) && treePath.isDescendant(treePath2)) {
                this.mibTree.setLatestCollapsedPathSelected(true);
            } else {
                this.mibTree.setLatestCollapsedPathSelected(false);
            }
            this.mibTree.setLatestCollapsedPath(treePath);
            this.mibTree.setLatestCollapsedObjectData(cvHierarchyData);
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
        if (!cvHierarchyData.getIsBranch()) {
            return;
        }
        try {
            CvHierarchyIdentifier cvHierarchyIdentifier = new CvHierarchyIdentifier(defaultMutableTreeNode);
            boolean bl = true;
            String string = this.refreshPeriod;
            if (this.fromMetadata) {
                bl = false;
                string = "0";
            }
            Object object = this.dataSource.getHierarchyChildRequest(cvHierarchyData.getNavigationUrl(), string, bl, (SMHierarchyResponse)this, (Object)cvHierarchyIdentifier);
            cvHierarchyData.setChildDataReqHandle(object);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)("CvHierarchyManager.treeExpanded - Failed to request hierarchy child data for " + defaultMutableTreeNode + ": " + (Object)((Object)sMAPIException)));
            return;
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.getLevel() == 0 && !this.allowCollapseRoot) {
            this.allowCollapseRoot = false;
            throw new ExpandVetoException(treeExpansionEvent, "Cannot collapse root node");
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void txfrChangeOccurred(CtTransferChangeEvent ctTransferChangeEvent) {
        Object object;
        Object object2;
        Enumeration<TreeNode> enumeration;
        if (ctTransferChangeEvent.getTransferType() == 1) {
            if (this.CutPasteBuffer.getCutSourceUrl() != null) {
                enumeration = this.CutPasteBuffer.getCutSourceUrl();
                object2 = this.CutPasteBuffer.getBufferEntityIds();
                object = this.mibTreeRoot.preorderEnumeration();
                while (object.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
                    CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)defaultMutableTreeNode.getUserObject());
                    if (cvHierarchyData == null) continue;
                    boolean bl = false;
                    if (cvHierarchyData.getParentData() != null && UcURL.areURLsEqual(enumeration, (String)cvHierarchyData.getParentData().getTargetUrl())) {
                        String string = cvHierarchyData.getObjectId();
                        int n = 0;
                        while (n < ((Object)object2).length) {
                            if (string.equals(object2[n])) {
                                bl = true;
                            }
                            ++n;
                        }
                    }
                    cvHierarchyData.setCutPending(bl);
                }
            } else {
                enumeration = this.mibTreeRoot.preorderEnumeration();
                while (enumeration.hasMoreElements()) {
                    object2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    object = (CvHierarchyData)((Object)((DefaultMutableTreeNode)object2).getUserObject());
                    if (object == null) continue;
                    ((CvHierarchyData)((Object)object)).setCutPending(false);
                }
            }
        }
        if (ctTransferChangeEvent.getTransferType() == 3) {
            enumeration = this.mibTreeRoot.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                object2 = (DefaultMutableTreeNode)enumeration.nextElement();
                object = (CvHierarchyData)((Object)((DefaultMutableTreeNode)object2).getUserObject());
                if (object == null) continue;
                ((CvHierarchyData)((Object)object)).setCutPending(false);
            }
        }
        this.repaint();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Vector vector;
        int n = this.mibTree.getSelectionCount();
        CvHierarchySelectEvent cvHierarchySelectEvent = new CvHierarchySelectEvent(this, n);
        CvHierarchyManager cvHierarchyManager = this;
        synchronized (cvHierarchyManager) {
            vector = (Vector)this.selectionListeners.clone();
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            CvHierarchySelectListener cvHierarchySelectListener = (CvHierarchySelectListener)vector.elementAt(n2);
            try {
                cvHierarchySelectListener.selectionOccurred(cvHierarchySelectEvent);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("HierarchyManager - client error in selectionOccurred" + exception));
            }
            ++n2;
        }
    }

    class RemoveChildNodesRunnable
    implements Runnable {
        private DefaultMutableTreeNode parentNode;

        public RemoveChildNodesRunnable(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.parentNode = defaultMutableTreeNode;
        }

        public void run() {
            CvHierarchyManager.this.mibTreeModel.removeChildNodes(this.parentNode);
        }
    }
}

