/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class CmTopologySearch
implements AwxServiceManager,
Runnable,
DocumentListener,
MouseListener,
ListSelectionListener {
    private SMTopologyRequest RequestHandle = null;
    private AwxServiceProvider SvcProvider = null;
    private Thread SearchThread = null;
    private AbstractButton StartButton;
    private AbstractButton StopButton;
    private AbstractButton GoToButton;
    private JTextComponent PatternField;
    private JLabel ListStatusLabel;
    private JLabel DomainLabel;
    private JList DisplayList;
    private CmTopologyPath DomainRootPath;
    private Vector TargetMatches = new Vector();

    public void beginSearch() {
        CmTopologySearch cmTopologySearch = this;
        synchronized (cmTopologySearch) {
            if (this.SearchThread != null) {
                Object var2_2 = null;
                return;
            }
            this.SearchThread = new Thread((Runnable)this, "search");
        }
        this.StartButton.setEnabled(false);
        this.StopButton.setEnabled(true);
        this.PatternField.setEnabled(false);
        this.SearchThread.start();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void gotoSelection() {
        int n = this.DisplayList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        CmTopologyPath cmTopologyPath = (CmTopologyPath)this.TargetMatches.elementAt(n);
        if (cmTopologyPath == null) {
            return;
        }
        String string = CmConsoleSession.pathRegister(null, cmTopologyPath);
        String[] stringArray = new String[]{string};
        if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("goto", stringArray);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.PatternField.getText().length() == 0) {
            this.StartButton.setEnabled(false);
        } else {
            this.StartButton.setEnabled(true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.gotoSelection();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
        if (awxServiceProvider == null) {
            this.SearchThread = null;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.PatternField.getText().length() == 0) {
            this.StartButton.setEnabled(false);
        } else {
            this.StartButton.setEnabled(true);
        }
    }

    public void run() {
        Object[] objectArray;
        boolean bl = false;
        boolean bl2 = false;
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.noaccess");
        String string2 = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.noaccess.title");
        Vector<CmTopologyPath> vector = new Vector<CmTopologyPath>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.addElement(this.DomainRootPath);
        vector2.addElement(new Hashtable());
        this.TargetMatches.removeAllElements();
        this.DisplayList.setListData(new Object[0]);
        String string3 = this.PatternField.getText().trim();
        String string4 = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.working");
        String string5 = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.count");
        String[] stringArray = new String[]{string4};
        if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("message", stringArray);
        }
        this.ListStatusLabel.setText(UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.none"));
        String string6 = " ";
        while (vector.size() != 0) {
            objectArray = new Vector();
            Vector vector3 = new Vector();
            try {
                Object object;
                CmTopologyPath cmTopologyPath = (CmTopologyPath)vector.elementAt(0);
                String string7 = cmTopologyPath.getEnd().getNodeUrl();
                string7 = UcURL.standardizeURL((String)string7);
                Hashtable hashtable = (Hashtable)vector2.elementAt(0);
                if (hashtable.containsKey(string7)) {
                    vector.removeElementAt(0);
                    vector2.removeElementAt(0);
                    continue;
                }
                hashtable.put(string7, string7);
                this.RequestHandle.topologySearch(string7, string3, (Vector)objectArray, vector3);
                string6 = String.valueOf(string6) + ".";
                int n = 0;
                while (n < objectArray.size()) {
                    object = (SMHierarchyViewData)objectArray.elementAt(n);
                    CmTopologyPath cmTopologyPath2 = new CmTopologyPath(cmTopologyPath);
                    cmTopologyPath2.push(object.getObjectId(), object.getName(), object.getTargetUrl());
                    this.TargetMatches.addElement(cmTopologyPath2);
                    ++n;
                }
                if (this.TargetMatches.size() == 1) {
                    this.ListStatusLabel.setText(UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.countone"));
                } else if (this.TargetMatches.size() > 1) {
                    this.ListStatusLabel.setText(MessageFormat.format(string5, new Integer(this.TargetMatches.size())));
                }
                object = new Vector();
                int n2 = 0;
                while (n2 < this.TargetMatches.size()) {
                    ((Vector)object).addElement(((CmTopologyPath)this.TargetMatches.elementAt(n2)).getNextStep().toString());
                    ++n2;
                }
                this.DisplayList.setListData(object);
                this.DisplayList.revalidate();
                this.DisplayList.repaint();
                int n3 = 0;
                while (n3 < vector3.size()) {
                    SMHierarchyViewData sMHierarchyViewData = (SMHierarchyViewData)vector3.elementAt(n3);
                    CmTopologyPath cmTopologyPath3 = new CmTopologyPath(cmTopologyPath);
                    cmTopologyPath3.push(sMHierarchyViewData.getObjectId(), sMHierarchyViewData.getName(), sMHierarchyViewData.getTargetUrl());
                    vector.addElement(cmTopologyPath3);
                    vector2.addElement(hashtable.clone());
                    ++n3;
                }
            }
            catch (SMAPIException sMAPIException) {
                if (sMAPIException.getReasonCode() == 1) {
                    string = String.valueOf(string) + "\n" + ((CmTopologyPath)vector.elementAt(0)).toString();
                    bl2 = true;
                }
                string6 = String.valueOf(string6) + ".";
                bl = true;
            }
            stringArray[0] = String.valueOf(string4) + string6;
            if (this.SvcProvider != null) {
                this.SvcProvider.triggerService("message", stringArray);
            }
            if (string6.length() > 10) {
                string6 = " ";
            }
            if (this.SearchThread == null) break;
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
        }
        if (this.SearchThread == null) {
            stringArray[0] = "base.console.ConsoleTopology:search.interrupt";
            if (this.SvcProvider != null) {
                this.SvcProvider.triggerService("messageBell", stringArray);
            }
        } else if (bl) {
            stringArray[0] = "base.console.ConsoleTopology:search.completeerr";
            if (this.SvcProvider != null) {
                this.SvcProvider.triggerService("messageBell", stringArray);
            }
        } else {
            stringArray[0] = "base.console.ConsoleTopology:search.complete";
            if (this.SvcProvider != null) {
                this.SvcProvider.triggerService("message", stringArray);
            }
        }
        if (bl2) {
            objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.ok")};
            JOptionPane.showOptionDialog(null, string, string2, -1, 2, null, objectArray, objectArray[0]);
        }
        this.StartButton.setEnabled(true);
        this.StopButton.setEnabled(false);
        this.PatternField.setEnabled(true);
        this.SearchThread = null;
    }

    public void setDisplayList(Object object) {
        this.DisplayList = (JList)object;
        this.DisplayList.setSelectionMode(0);
        this.DisplayList.addListSelectionListener(this);
        this.DisplayList.addMouseListener(this);
    }

    public void setDomainLabel(Object object) {
        this.DomainLabel = (JLabel)object;
    }

    public void setDomainLabelText() {
        if (this.DomainLabel == null || this.DomainRootPath == null) {
            return;
        }
        this.DomainLabel.setText(String.valueOf(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:navigator.domain.label")) + " " + this.DomainRootPath.toString());
    }

    public void setGoToButton(Object object) {
        this.GoToButton = (AbstractButton)object;
    }

    public void setListLabel(Object object) {
        this.ListStatusLabel = (JLabel)object;
    }

    public void setPatternField(JTextComponent jTextComponent) {
        this.PatternField = jTextComponent;
        this.PatternField.getDocument().addDocumentListener(this);
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.RequestHandle = new SMTopologyRequest(sMRawDataRequest);
    }

    public void setStartButton(Object object) {
        this.StartButton = (AbstractButton)object;
    }

    public void setStartPath(String string) {
        CmTopologyPath cmTopologyPath = CmTopologyPath.decode(string);
        if (cmTopologyPath != null) {
            this.DomainRootPath = new CmTopologyPath("root", cmTopologyPath.getNodeName(), cmTopologyPath.getNodeUrl());
        }
    }

    public void setStopButton(Object object) {
        this.StopButton = (AbstractButton)object;
    }

    public void stopSearch() {
        this.SearchThread = null;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.DisplayList.getSelectedIndex() < 0) {
            this.GoToButton.setEnabled(false);
        } else {
            this.GoToButton.setEnabled(true);
        }
    }
}

