#! /bin/ksh
#
#pragma ident "@(#)es-setup.sh	1.21 01/02/20 Sun Microsystems"
#

/usr/bin/pkginfo -qi SUNWeswga
if [ $? -eq 0 ] ; then
   basedir=`/usr/bin/pkgparam SUNWeswga BASEDIR`
else
   basedir=`/usr/bin/pkgparam SUNWeswgs BASEDIR`
fi

if [ -z $"basedir" ]; then
    basedir=/opt
fi

ESWGS_SBIN=$basedir/SUNWsymon/addons/wgs/sbin
LNECK_CONF=$ESWGS_SBIN/sun4u-Sun-Fire-280R.conf
DAK_CONF=$ESWGS_SBIN/sun4u-Sun-Fire-880.conf

. "$basedir"/SUNWsymon/sbin/es-common.sh

set_basedir
PROGNAME="$0"; export PROGNAME
check_root
check_logfile setup
check_osver
set_xput
setup_textdomain ESWG_SCRIPTS

echolog  '----------------------------------------------------------'
echolog  '         Starting Sun Management Center WGS Setup         '
echolog  '----------------------------------------------------------'

if [ -f /usr/platform/sun4u/sbin/prtdiag ] ; then
    prtline=`/usr/platform/sun4u/sbin/prtdiag | head -1`
    if [ $? -ne 0 ] ] ; then
        echolog 'Unable to determine platform'
        return 1
    fi
else
    echolog 'Unable to determine platform'
    return 1
fi

# setup server

/usr/bin/pkginfo -qi SUNWeswgs
if [ $? -eq 0 ] ; then
   $basedir/SUNWsymon/sbin/es-device -d $LNECK_CONF
   $basedir/SUNWsymon/sbin/es-device -a $LNECK_CONF
   $basedir/SUNWsymon/sbin/es-device -d $DAK_CONF
   $basedir/SUNWsymon/sbin/es-device -a $DAK_CONF
fi

# return if agent not installed
/usr/bin/pkginfo -qi SUNWeswga
if [ $? -eq 1 ] ; then
   return 0
fi

platform_list=`/usr/bin/pkgparam SUNWeswga ES_ADDON_PLATFORM`
if [ -z $"platform_list" ] ; then
  echolog 'Unable to determine package platform'
  return 1              # no platform list, return error
fi


if [ ! -f $VARDIR/base-modules-d.dat ] ; then
        /usr/bin/cp $BASEDIR/base/cfg/base-modules-d.dat $VARDIR/base-modules-d.dat
fi
   

# make dir if not there
mkdir -p ${PLATFORM_FILE%/*}
touch "$PLATFORM_FILE"
rm "$PLATFORM_FILE"
touch "$PLATFORM_FILE"

OIFS=$IFS
IFS=:,
# see if currnet platform is supported by WGS agent pkg.
for i in $platform_list;do
  echo "$prtline" | /usr/bin/grep "$i" > /dev/null 2>&1
  if [ $? -eq 0 ] ; then        # match
    echolog 'Platform Found\\: $i'


    #
    # set a deviceinfo.conf file for newer platforms


    if [ $i = "Sun Fire 280R" ] ; then

      deviceinfo="/var/opt/SUNWsymon/cfg/deviceinfo.conf"
      if [ -f $deviceinfo ] ; then
	rm $deviceinfo
      fi

      touch $deviceinfo

      cat << END_OF_INPUT > $deviceinfo
DID Sun-Fire-280R
OID 1.3.6.1.4.1.42.2.12.3.1.12
FAMILYTYPE sun4u-Sun-Fire-280R
END_OF_INPUT

    fi

    if [ $i = "Sun Fire 880" ] ; then

      deviceinfo="/var/opt/SUNWsymon/cfg/deviceinfo.conf"
      if [ -f $deviceinfo ] ; then
	rm $deviceinfo
      fi

      touch $deviceinfo

      cat << END_OF_INPUT > $deviceinfo
DID Sun-Fire-880
OID 1.3.6.1.4.1.42.2.12.3.1.12
FAMILYTYPE sun4u-Sun-Fire-880
END_OF_INPUT

      /bin/rm -f /usr/platform/SUNW,Sun-Fire-880/lib/picl/plugins/libsmcplugin.so.1 
      /bin/rm -f /usr/platform/SUNW,Sun-Fire-880/lib/picl/plugins/libsmcplugin.so 

      ln -s /opt/SUNWsymon/lib/platform/cfg/SUNW,Sun-Fire-880/libsmcplugin.so.1 /usr/platform/SUNW,Sun-Fire-880/lib/picl/plugins/libsmcplugin.so.1
      ln -s  /usr/platform/SUNW,Sun-Fire-880/lib/picl/plugins/libsmcplugin.so.1  /usr/platform/SUNW,Sun-Fire-880/lib/picl/plugins/libsmcplugin.so

# Stop picld (twice if necessary) and then restart it, so it will recognize SunMC plugin.

      status=`ps -ef | grep picld | wc -l `

      if [ $status -eq 2 ]; then
         /etc/init.d/picld stop ; sleep 1	# stop it once.
         status=`ps -ef | grep picld | wc -l `
         if [ $status -eq 2 ]; then
            /etc/init.d/picld stop		# stop it again if it still exists.
            sleep 1
	 fi
      fi
      /etc/init.d/picld start
    fi
    
    

    if [ $i = "Ultra 5/10" ] ; then
           question="Enter the platform type [1\\\|2]: "
           answer=""
           while [ "$answer" = "" ]
           do
              echolog 'Choose the platform you are installing the agent on:'
              echolog '1.  Ultra Enterprise 5'
              echolog '2.  Ultra Enterprise 10'
              if [ "$LOGFILE" != "" ] ; then
                 eval echo `gettext "$question"` " \\\c" >> "$LOGFILE"
              fi 
              eval echo `gettext "$question"` " \\\c"
              read answer
              if [ "$LOGFILE" != "" ] ; then
                 echo "$answer" >> "$LOGFILE"
              fi 
              case "$answer" in
                1) echo "UltraModel=5" >> "$PLATFORM_FILE"
                    break ;;
                2) echo "UltraModel=10" >> "$PLATFORM_FILE"
                    break ;;
                 *) answer=""
              esac
          done
    fi
    ask_user "Do you want to set up the workgroup server config reader for this platform?"
    if [ $answer -eq 1 ] ; then         # yes, setup
      # See if entry is already there
      /usr/bin/grep WGSETUP "$PLATFORM_FILE" > /dev/null 2>& 1
      if [ $? -eq 1 ] ; then    # WGSSETUP not there yet, add it
        echo "WGSETUP" >> "$PLATFORM_FILE"
      fi

     

   /usr/bin/grep Config-Reader4uwg "$VARDIR"/base-modules-d.dat > /dev/null 2>& 1


      if [ $? -eq 1 ] ; then
        echo "Config-Reader4uwg = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.hardware.Config.Reader4uwg sun Config-Reader4uwg {i18nModuleType = \\\"base.modules.Config-Reader4uwg:moduleType\\\"; enterprise = \\\"sun\\\"; module = \\\"Config-Reader4uwg\\\"; console = \\\"Config-Reader4uwg\\\"; version = \\\"1.0\\\"; moduleName = \\\"Config Reader (Workgroup Server)\\\"; i18nModuleName = \\\"base.modules.Config-Reader4uwg:moduleName\\\"; moduleType = \\\"hardware\\\"; instance = \\\"\\\"; }\"" >> "$VARDIR"/base-modules-d.dat
      fi        # end grep match
    fi  # end $answer==1
    # Done, platform was matched and either setup or not
    IFS=$OIFS
    return 0
  fi  # end match
done  # end for platform_list
IFS=$OIFS
 
# No match
return 0

