#! /usr/bin/sh
#
# ident "@(#)es-service.sh 1.34     03/01/14 SMI"
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

if test -z "$ESROOT"; then
    /usr/bin/gettext "ESROOT environment variable must be set"
    exit 1
fi

. $ESROOT/sbin/es-common.sh

check_osver
setup_textdomain ESADVSERVICES_SCRIPTS

if test -z "$ESDIR"; then
    /usr/bin/gettext "ESDIR environment variable must be set"
    exit 1
fi

SYMON_JAVAHOME=`/usr/bin/cat /var/opt/SUNWsymon/.java_home`
JAVA=$SYMON_JAVAHOME/bin/java

INTERFACE_PATH=$ESDIR/cfg
INTERFACE_PATH=$INTERFACE_PATH:$ESDIR/log
INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/modules/cfg
INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/base/cfg

#-----------------------------------------------------------------------------#
# If IESROOT is set use it, else use default ESROOT [/opt/SUNWsymon]          #
#-----------------------------------------------------------------------------#
if [ ! -z "$IESROOT" ] ; then
  INTERFACE_PATH=$INTERFACE_PATH:$IESROOT/classes/base/server/cfg
  INTERFACE_PATH=$INTERFACE_PATH:$IESROOT/classes/base/service/cfg
  INTERFACE_PATH=$INTERFACE_PATH:$IESROOT/classes/base/console/cfg
else
  INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/classes/base/server/cfg
  INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/classes/base/service/cfg
  INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/classes/base/console/cfg
fi
export INTERFACE_PATH

LD_LIBRARY_PATH=/usr/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/dt/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/openwin/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ESROOT/util/lib/sparc-sun-solaris${OSVERS}
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ESROOT/base/lib/sparc-sun-solaris${OSVERS}
export LD_LIBRARY_PATH

#-----------------------------------------------------------------------------#
# If IESROOT is set use it, else use default ESROOT [/opt/SUNWsymon]          #
#-----------------------------------------------------------------------------#
if [ ! -z "$IESROOT" ] ; then
  BASEPATH=$IESROOT
  CLASSESAPPS=$IESROOT/apps/classes
else
  BASEPATH=$ESROOT
  CLASSESAPPS=$ESROOT/apps/classes
fi

# add application jars and zips to the classpath, if any
APP_JARS=`/usr/bin/ls -1 $CLASSESAPPS/*.jar 2>/dev/null`
APP_ZIPS=`/usr/bin/ls -1 $CLASSESAPPS/*.zip 2>/dev/null`

APP_CLASSES=$APP_JARS' '$APP_ZIPS
APP_CLASSPATH=''

for i in $APP_CLASSES
do
  APP_CLASSPATH=$APP_CLASSPATH:$i
done

CLASSPATH=$ESDIR/classes
CLASSPATH=$CLASSPATH:$BASEPATH/classes
CLASSPATH=$CLASSPATH:$BASEPATH/classes/escom.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/esclt.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/essrv.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/esjrm.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/jndi/jndi.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/jdbc/classes12.zip
CLASSPATH=$CLASSPATH:$BASEPATH/classes/xml/parser.jar
CLASSPATH=$CLASSPATH:$CLASSESAPPS
CLASSPATH=$CLASSPATH$APP_CLASSPATH

#
# Add 3.5 AddON specific CLASSPATH
#
addon_dirs=`/usr/bin/ls -1 $ESROOT/addons 2>/dev/null`
if [ ! -z "$addon_dirs" ]; then
        for i in $addon_dirs
        do
           if [ -d $ESROOT/addons/$i/lib/locale/classes ]; then
                CLASSPATH=$CLASSPATH:$ESROOT/addons/$i/lib/locale/classes
           fi
        done
fi

ulimit -n 1024
MAX_HEAP_SIZE="-Xmx128m"
ARG_LIST=""
for each_param in $*
do
    echo "$each_param" | /usr/bin/grep "\-Xmx" > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
       MAX_HEAP_SIZE="$each_param"
    else
       ARG_LIST="$ARG_LIST $each_param"
    fi
done


trap '' HUP
# Check whether service is already running
COMMAND="java"
SERVICES="com.sun.symon.base.mgmtservice.main.SunMCServices"

NUMSERVERS=`/usr/ucb/ps -ww -a -g -x | /usr/bin/fgrep $COMMAND | /usr/bin/fgrep $SERVICES | /usr/bin/fgrep -v /usr/bin/fgrep | /usr/bin/wc -l`
if [ "$NUMSERVERS" -gt 0 ]; then
    echo "Services is already started."
else
    echo "Running Services..."
    exec $JAVA  -DINTERFACE_PATH=$INTERFACE_PATH \
     $MAX_HEAP_SIZE -Xss2m -Xoss4m -DNUM_FDS=`ulimit -n`\
     -DESROOT=$BASEPATH -DESDIR=$ESDIR -classpath $CLASSPATH $SERVICES $ARG_LIST &
fi
