# Copyright 07/09/01 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)a5x00-models-d.x	1.9 01/07/09 Sun Microsystems"

type       = reference

_rules = { [ source a5x00-d.rul ] }

#a5x00 = { [ use MANAGED-OBJECT ]
#        mediumDesc = a5x00
#       	consoleHint:mediumDesc = base.modules.a5x00:a5x00
#	consoleHint:hidden = true

#        sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
#                mediumDesc        =  tree prop
#                consoleHint:hidden = true
#                consoleHint:mediumDesc = base.modules.a5x00:a5x00.sun.SmTreeProp
#        }
#        sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
#                mediumDesc        =  Name
#                consoleHint:mediumDesc = base.modules.a5x00:a5x00.sun.SmNodeName
#        }
#        timestamp_raw = { [ use STRING MANAGED-PROPERTY ]
#                mediumDesc        = timestamp_raw
#                consoleHint:mediumDesc = base.modules.a5x00:a5x00.sun.timestamp_raw
#        }
#        timestamp = { [ use STRING MANAGED-PROPERTY ]
#                mediumDesc        =  Name
#                consoleHint:mediumDesc = base.modules.a5x00:a5x00.sun.SmNodeName
#        }
#	status_change = { [ use INT MANAGED-PROPERTY ]
#		mediumDesc        =  Number Of Model property/value changed
#                fullDesc  = This value changes whenever there is a difference between previous snapshot and current snapshot.
#                consoleHint:hidden = true
#                consoleHint:mediumDesc = base.modules.a5x00:a5x00.sun.status_change 
#        }
#}

# sena information
sena = { [ use MANAGED-OBJECT ]
	mediumDesc =  Sun StorEdge a5x00 sena
	consoleHint:mediumDesc = base.modules.a5x00:sena
	consoleHint:smallIcon(DFT) = topoimages/storage-front-small.gif
	consoleHint:largeIcon(DFT) = topoimages/storage-front-xlarge.gif

senaTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sena Table
	consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl

        sena-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.sunSmTreeProp
           		mediumDesc        = sunSmTreeProp 
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.entry_no
		}
		box_rev = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Box_rev
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.box_rev
		}
		device_count = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Device_count 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.device_count
		}
		id = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Box Id 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.id
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Instance 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.instance
		}
		logical_path = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Logical Path
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.logical_path
		}
		machine = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Machine 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.machine
		}
		box_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Name 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.box_name
		}
		node-wwn = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Node-wwn 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.node-wwn
		}
		physical_path = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Physical Path
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.physical_path
		}
		platform = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Platform 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.platform
		}
		slot_count = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Slot_count 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.slot_count
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho422
                        consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.status
                }
		type = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Type 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.type
		}
		vendor_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Vendor_name
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.vendor_name
		}
		virtual_node = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = Virtual_node 
			consoleHint:mediumDesc = base.modules.a5x00:sena.senaTbl.sena-entry.virtual_node
		}
		total_config_changes = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  Number Of property/value changed
			fullDesc  = This value changes whenever there is a difference between previous snapshot and current snapshot.
			consoleHint:hidden = true
			consoleHint:mediumDesc = base.modules.a5x00:a5x00.sun.status_change 
		}
	}
}
}

front = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Front Table
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.a5x00:front

        front-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:front.front-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:front.front-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:front.front-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:front.front-entry.entry_no
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Instance 
			consoleHint:mediumDesc = base.modules.a5x00:front.front-entry.instance
		}
	}
}

rear = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Rear Table
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.a5x00:rear

        rear-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:rear.rear-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:rear.rear-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:rear.rear-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:rear.rear-entry.entry_no
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Instance 
			consoleHint:mediumDesc = base.modules.a5x00:rear.rear-entry.instance
		}
	}
}

disk_backplane = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Disk_backplane 
	consoleHint:mediumDesc = base.modules.a5x00:disk_backplane
	consoleHint:smallIcon(DFT) = topoimages/slots-container-small.gif
	consoleHint:largeIcon(DFT) = topoimages/slots-container-xlarge.gif

disk_backplaneTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Disk_backplane Table
	consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl

        disk_backplane-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.entry_no
		}
		box_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Box Name 
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.box_name
		}
		byp_a_enabled = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Byp_a_enabled 
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.byp_a_enabled
		}
		byp_b_enabled = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Byp_b_enabled 
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.byp_b_enabled
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = fru 
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.fru
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho400
			consoleHint:mediumDesc = base.modules.a5x00:disk_backplane.disk_backplaneTbl.disk_backplane-entry.status
		}
	}
}
}

fan_tray = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Fan_tray 
	consoleHint:mediumDesc = base.modules.a5x00:fan_tray
	consoleHint:smallIcon(DFT) = topoimages/fan-tray-small.gif
	consoleHint:largeIcon(DFT) = topoimages/fan-tray-xlarge.gif

fan_trayTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Fan_tray Table
	consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl

        fan_tray-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.entry_no
		}
		box_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Box Name
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.box_name
		}
		fan_fail = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Fan_fail 
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.fan_fail
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = fru 
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.fru
		}
		speed = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Speed 
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.speed
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho401
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.status
		}
		type = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Type 
			consoleHint:mediumDesc = base.modules.a5x00:fan_tray.fan_trayTbl.fan_tray-entry.type
		}
	}
}
}

led    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Led Table
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.a5x00:led.ledTbl

        led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:led.led-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.a5x00:led.led-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.a5x00:led.led-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:led.led-entry.entry_no
		}
       		led-num = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Led No
			consoleHint:mediumDesc = base.modules.a5x00:led.led-entry.led-num 
       		}
       		state = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  State
			consoleHint:mediumDesc = base.modules.a5x00:led.led-entry.state
       		}
	}
}

front_slot = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Front_slot 
	consoleHint:mediumDesc = base.modules.a5x00:front_slot
	consoleHint:smallIcon(DFT) = topoimages/slots-small.gif
	consoleHint:largeIcon(DFT) = topoimages/slots-xlarge.gif

front_slotTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Front_slot Table
	consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl

        front_slot-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.entry_no
		}
		box_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Box Name 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.box_name
		}
        	connect_disk = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  connect_disk_name
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.connect_disk
	        }
		id = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Id 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.id
		}
		loop_status = { [ use GLOBROWNODE STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Loop_status 
			alarmRules	  = rpho411
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.loop_status
		}
		power_status = { [ use GLOBROWNODE STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = power-status
			alarmRules	  = rpho414 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.power_status
		}
		slot-num = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Slot-num 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.slot-num
		}
		status = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Status 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.status
		}
		temperature = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Temperature 
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.temperature
		}
		temperature_status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Temperature_status
			alarmRules	  = rpho407
			consoleHint:mediumDesc = base.modules.a5x00:front_slot.front_slotTbl.front_slot-entry.temperature_status
		}
	}
}
}

rear_slot = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Rear_slot 
	consoleHint:mediumDesc = base.modules.a5x00:rear_slot
	consoleHint:smallIcon(DFT) = topoimages/slots-small.gif
	consoleHint:largeIcon(DFT) = topoimages/slots-xlarge.gif

rear_slotTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Rear_slot Table
	consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl

        rear_slot-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.entry_no
		}
		box_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Box Name
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.box_name
		}
        	connect_disk = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  connect_disk_name
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.connect_disk
	        }
		id = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Id 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.id
		}
		loop_status = { [ use GLOBROWNODE STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Loop_status 
			alarmRules	  = rpho412
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.loop_status
		}
		power_status = { [ use GLOBROWNODE STRINGRULE MANAGED-PROPERTY _rules]
           		mediumDesc        = power-status
			alarmRules	  = rpho414 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.power_status
		}
		slot-num = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Slot-num 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.slot-num
		}
		status = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Status 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.status
		}
		temperature = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Temperature 
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.temperature
		}
		temperature_status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Temperature_status
			alarmRules	  = rpho408
			consoleHint:mediumDesc = base.modules.a5x00:rear_slot.rear_slotTbl.rear_slot-entry.temperature_status
		}
	}
}
}

# ssd(Sun Storage Disk)
ssd = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Disks
	consoleHint:mediumDesc = base.modules.a5x00:ssd
	consoleHint:smallIcon(DFT) = topoimages/disks-small.gif
	consoleHint:largeIcon(DFT) = topoimages/disks-xlarge.gif

ssdTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sun StorEdge a5x00 Disk Table
	consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl

        ssd-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.entry_no
		}
                box_name = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Box Name
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.box_name
                }
                capacity = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Capacity
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.capacity
                }
                device_type = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Device Type
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.device_type
                }
                firmware_revision = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = firmware_revision
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.firmware_revision
                }
		fru = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Fru 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.fru
		}
		hard_address = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Hard Address 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.hard_address
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Instance 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.instance
		}
                logical_path = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = logical_path
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.logical_path
                }
		mounted_partitions = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Mounted Partitions 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.mounted_partitions
		}
		name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Name 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.name
		}
		node-wwn = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Node Wwn 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.node-wwn
		}
                physical_path = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = physical_path
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.physical_path
                }
		port-wwn = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Port Wwn 
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.port-wwn
		}
                product_name = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = product_name
                        consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.product_name
                }
		revision = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = revision
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.revision
		}
		serial_number = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = serial_number
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.serial_number
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho406
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.status
		}
		vendor_name = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = vendor_name
			consoleHint:mediumDesc = base.modules.a5x00:ssd.ssdTbl.ssd-entry.vendor_name
		}
	}
}
}


a5x00_power_supply = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Sena_power_supply 
	consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply
	consoleHint:smallIcon(DFT) = topoimages/power-supply-small.gif
	consoleHint:largeIcon(DFT) = topoimages/power-supply-xlarge.gif

a5x00_power_supplyTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sena_a5x00_power_supply Table
	consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl

        a5x00_power_supply-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.entry_no
		}
		box_name = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Box Name 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.box_name
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Fru
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.fru
		}
		AC_status = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = AC_status 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.AC_status
		}
		DC-current = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = DC-current 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.DC-current
		}
		DC-voltage = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = DC-voltage 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.DC-voltage
		}
		ps-instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Ps-instance 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.ps-instance
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho402
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.status
		}
		temperature_status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Temperature_status 
			alarmRules	  = rpho409
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.temperature_status
		}
		type = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Type 
			consoleHint:mediumDesc = base.modules.a5x00:a5x00_power_supply.a5x00_power_supplyTbl.a5x00_power_supply-entry.type
		}
	}
}
}

interconnect = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Interconnect 
	consoleHint:mediumDesc = base.modules.a5x00:interconnect
	consoleHint:smallIcon(DFT) = topoimages/WCI-module-small.gif
	consoleHint:largeIcon(DFT) = topoimages/WCI-module-xlarge.gif

interconnectTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Interconnect Table
	consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl

        interconnect-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.entry_no
		}
        	box_name = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Box Name
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.box_name
	        }
		eprom_failure = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Eprom_failure 
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.eprom_failure
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Fru 
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.fru
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho405
			consoleHint:mediumDesc = base.modules.a5x00:interconnect.interconnectTbl.interconnect-entry.status
		}
	}
}
}

interface_board = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Interface_board 
	consoleHint:mediumDesc = base.modules.a5x00:interface_board
	consoleHint:smallIcon(DFT) = topoimages/board-small.gif
	consoleHint:largeIcon(DFT) = topoimages/board-xlarge.gif

interface_boardTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Ib Table
	consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl

        interface_board-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.entry_no
		}
        	box_name = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Box Name
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.box_name
	        }
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Fru 	
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.fru
		}
		interface_board-instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Ib-Instance 
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.interface_board-instance
		}
		loop = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Loop 
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.loop
		}
		loop0_fault = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Loop0_fault 
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.loop0_fault
		}
		loop1_fault = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Loop1_fault 
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.loop1_fault
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho400
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.status
		}
		temperature_status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Temperature_status 
			alarmRules	  = rpho410
			consoleHint:mediumDesc = base.modules.a5x00:interface_board.interface_boardTbl.interface_board-entry.temperature_status
		}
	}
}
}

gbic = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Gbic 
	consoleHint:mediumDesc = base.modules.a5x00:gbic
	consoleHint:smallIcon(DFT) = topoimages/attachment-small.gif
	consoleHint:largeIcon(DFT) = topoimages/attachment-xlarge.gif

gbicTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Gbic Table
	consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl

        gbic-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.entry_no
		}
        	box_name = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Box Name
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.box_name
	        }
		fru = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Fru 
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.fru
		}
		gbic-instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Gbic-Instance 
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.gbic-instance
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho403
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.status
		}
		xmit_fail = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Xmit_fail 
			consoleHint:mediumDesc = base.modules.a5x00:gbic.gbicTbl.gbic-entry.xmit_fail
		}
	}
}
}

loop = { [ use MANAGED-OBJECT ]
	mediumDesc = Sun StorEdge a5x00 Loop
	consoleHint:mediumDesc = base.modules.a5x00:loop
	consoleHint:smallIcon(DFT) = topoimages/loop-small.gif
	consoleHint:largeIcon(DFT) = topoimages/loop-xlarge.gif

loopTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Gbic Table
	consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl

        loop-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
           		mediumDesc        = sunSmTreeProp 
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.sunSmTreeProp
		}
        	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Current Name
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.sunSmNodeName
	        }
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.entry_no
		}
        	box_name = { [ use STRING MANAGED-PROPERTY ]
	                mediumDesc        =  Box Name
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.box_name
	        }
		fru = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Fru 
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.fru
		}
		loop-instance = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Gbic-Instance 
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.loop-instance
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
           		mediumDesc        = Status 
			alarmRules	  = rpho413
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.status
		}
		loop_configuration_status = { [ use STRING MANAGED-PROPERTY ]
           		mediumDesc        = Loop Configuration
			consoleHint:mediumDesc = base.modules.a5x00:loop.loopTbl.loop-entry.loop_configuration_status
		}
	}
}
}

a5x00-rules = { [ use MANAGED-OBJECT ]
        mediumDesc = A5x00 Rules
        consoleHint:hidden = true
        consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules
	
	rpho414 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = Fibre Channel OFFLINE
                alarmRules        = rpho414
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho414
        }

	rpho415 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = Fibre Channel CRC Error
                alarmRules        = rpho415
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho415
        }

	rpho416 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = SCSI Parity
                alarmRules        = rpho416
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho416
        }

	rpho417 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = drive operation marginal
                alarmRules        = rpho417
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho417
        }

	rpho418 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = failure prediction
                alarmRules        = rpho418
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho418
        }

	rpho419 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = INCOMPLETE DMA XFER on sbus
                alarmRules        = rpho419
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho419
        }

	rpho420 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = Offline Timeout
                alarmRules        = rpho420
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho420
        }

	rpho421 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = soc lilp map failed
                alarmRules        = rpho421
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho421
        }

	rpho423 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        = ON/OFF Line some parts of a5x00
                alarmRules        = rpho423
                consoleHint:mediumDesc = base.modules.a5x00:a5x00-rules.rpho423
        }
}

[ load a5x00-ruleinit-d.x ]
[ load a5x00-ruletext-d.x ]

