# Copyright 02/06/02 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)t300-models-d.x	1.14 02/02/06 Sun Microsystems"
#
#	File:	t300-models-d.x
#	Version: 1.0 
#
#	Storage T3 Module
#

type       = reference

_rules = {
	[ source t300-d.rul ]
}

system = { [ use MANAGED-OBJECT ]
	mediumDesc = StorEdge T3
	consoleHint:mediumDesc = base.modules.t300:system
	consoleHint:smallIcon(DFT) = topoimages/storage-front-small.gif
	consoleHint:largeIcon(DFT) = topoimages/storage-front-xlarge.gif

# split table
	basic-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = basic properties table
		consoleHint:mediumDesc = base.modules.t300:system.basic-table

		basic-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name
			consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				dataFormat	= instance
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.t300name
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= sunSmTreeProp 
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sunSmNodeName
			}
			rowstatus = { [ use GLOBROWNODE ROWSTATUS MANAGED-PROPERTY ]
				mediumDesc = Row Status
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.rowstatus
			}
			sysId = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
	   			mediumDesc	= id
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysId
			}
			sysVendor = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= vendor
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysVendor
			}
			sysModel = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= model
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysModel
			}
			sysRevision = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= firmware revision
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysRevision
			}
			sysIpAddr = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= IP address
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysIpAddr
			}
			sysSubNet = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
	   			mediumDesc	= subnet mask
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysSubNet
			}
			sysGateway = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
	   			mediumDesc	= gateway
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysGateway
			}
			sysBootMode = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= boot mode
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysBootMode
			}
			sysBootDelay = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
	   			mediumDesc	= boot delay
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysBootDelay
			}
			sysMpSupport = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
	   			mediumDesc	= multi-pathing support
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysMpSupport
			}
			sysHasVolumes = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= has volumes
				consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysHasVolumes
			}
			sysStatus = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
                                mediumDesc      = Connect Status
                                alarmRules      = rple404
                                consoleHint:mediumDesc = base.modules.t300:system.basic-table.basic-entry.sysStatus
                        }

		}
	}

	advanced-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = advanced properties table
		consoleHint:mediumDesc = base.modules.t300:system.advanced-table
	
		advanced-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name
			consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				dataFormat	= instance
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.t300name
			}
			rowstatus = { [ use GLOBROWNODE ROWSTATUS MANAGED-PROPERTY ]
				mediumDesc = Row Status
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.rowstatus
			}
			sysStripeUnitSize = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= stripe unit size
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysStripeUnitSize
			}
			sysCacheMode = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= cache mode
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysCacheMode
			}
			sysCacheMirror = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= cache mirror
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysCacheMirror
			}
			sysReadAhead = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= read ahead
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysReadAhead
			}
			sysReconRate = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= reconRate
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysReconRate
			}
			sysOndgMode = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= ondgMode
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysOndgMode
			}
			sysOndgTimeslice = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= ondgTimeslice
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysOndgTimeslice
			}

#
# sysIdleDiskTimeout is not available, SunMC will support it when the token is available
#
#			sysIdleDiskTimeout = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
#				mediumDesc	= idle disk timeout
#				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysIdleDiskTimeout
#			}
			sysTftpHost = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= tftp host
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysTftpHost
			}
			sysTftpFile = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= tftp file
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysTftpFile
			}
			sysLastRestart = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= last restart time
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysLastRestart
			}
			sysDate = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= date
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysDate
			}
			sysTime = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= time
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysTime
			}
			sysTimezone = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= time zone
				consoleHint:mediumDesc = base.modules.t300:system.advanced-table.advanced-entry.sysTimezone
			}
		}
	}

	statistical-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = statistical properties table
		consoleHint:mediumDesc = base.modules.t300:system.statistical-table
	
		statistical-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name
			consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.t300name
			}

			sysTotalRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= total requests
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysTotalRequests
			}
			sysWriteRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= write requests
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysWriteRequests
			}
			sysReadRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= read requests
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysReadRequests
			}
			sysTotalBlocks = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= total blocks
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysTotalBlocks
			}
			sysBlocksWritten = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= blocks written
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysBlocksWritten
			}
			sysBlocksRead = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= blocks read
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysBlocksRead
			}
			sysCacheWriteHits = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheWriteHits
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheWriteHits
			}
			sysCacheWriteMisses = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheWriteMisses
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheWriteMisses
			}
			sysCacheReadHits = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheReadHits
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheReadHits
			}
			sysCacheReadMisses = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheReadMisses
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheReadMisses
			}
			sysCacheRmwFlushes = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheRmwFlushes
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheRmwFlushes
			}
			sysCacheReconFlushes = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheReconFlushes
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheReconFlushes
			}
			sysCacheStripeFlushes = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= cacheStripeFlushes
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.sysCacheStripeFlushes
			}

			clear-flag = { [ use INT MANAGED-PROPERTY ]
				mediumDesc      = clear flag
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:system.statistical-table.statistical-entry.clear-flag
			}
		}
	}
}


unit = { [ use MANAGED-OBJECT ]
	mediumDesc = unit
	consoleHint:mediumDesc = base.modules.t300:unit
	consoleHint:smallIcon(DFT) = topoimages/unit-small.gif
	consoleHint:largeIcon(DFT) = topoimages/unit-xlarge.gif

	unit-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = unit table
		consoleHint:mediumDesc = base.modules.t300:unit.unit-table
	
		unit-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId
			consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.unitId
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= sunSmTreeProp 
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.sunSmNodeName
			}
			unitType = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= unit type
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.unitType
			}
			unitStandby = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= standby
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.unitStandby
			}
			unitIsControllerUnit = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= isControllerUnit
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.unitIsControllerUnit
			}
			machine = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= machine
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.machine
			}
			platform = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= platform
				consoleHint:mediumDesc = base.modules.t300:unit.unit-table.unit-entry.platform
			}
		}
	}
}


disks = { [ use MANAGED-OBJECT ]
	mediumDesc = disks
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:disks

	disks-table = { [ use MANAGED-OBJECT-TABLE ]
	
		mediumDesc = disks table
		consoleHint:mediumDesc = base.modules.t300:disks.disks-table
	
		disks-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:disks.disks-table.disks-entry
	
			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number  
				consoleHint:mediumDesc = base.modules.t300:disks.disks-table.disks-entry.sunSmTreeProp
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:disks.disks-table.disks-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:disks.disks-table.disks-entry.sunSmTreeProp
			}
		}
	}
}


disk = { [ use MANAGED-OBJECT ]
	mediumDesc = disk
	consoleHint:mediumDesc = base.modules.t300:disk
	consoleHint:smallIcon(DFT) = topoimages/disks-small.gif
	consoleHint:largeIcon(DFT) = topoimages/disks-xlarge.gif

	basic-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = basic properties table
		consoleHint:mediumDesc = base.modules.t300:disk.basic-table
	
		basic-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId fruId
			consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry
	
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.unitId
			}
	
			fruId = { [ use STRING MANAGED-PROPERTY ] 
				mediumDesc      = fru id
				consoleHint:mediumDesc = base.modules.t300:fruprops.fruId
			}
	
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
				mediumDesc	=  Current Name
				alarmRules	= rple400
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.sunSmNodeName
			}
#			fruStatus = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
#				mediumDesc	= status
#				consoleHint:mediumDesc	= base.modules.t300:fruprops.fruStatus
#			}
	
# common fru properties 
			[ load t300-fruprops-models-d.x ]
	
			fruDiskRole = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= disk role
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.fruDiskRole
			}
			fruDiskCapacity = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= disk capacity
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.fruDiskCapacity
			}
			fruDiskTemp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= temperature
				consoleHint:mediumDesc = base.modules.t300:disk.basic-table.basic-entry.fruDiskTemp
			}
		}
	}


	advanced-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = advanced properties table
		consoleHint:mediumDesc = base.modules.t300:disk.advanced-table
	
		advanced-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId fruId
			consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.unitId
			}
			fruId = { [ use STRING MANAGED-PROPERTY ] 
				mediumDesc      = fru id
				consoleHint:mediumDesc = base.modules.t300:fruprops.fruId
			}
	
			fruDiskPort1State = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port1 state
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskPort1State
			}
	
			fruDiskPort2State = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port2 state
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskPort2State
			}
	
			fruDiskStatusCode = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= status code
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskStatusCode
			}
	
			fruDiskVolId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= disk volid
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskVolId
			}
	
			fruDiskVolIndex = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= disk volindex
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskVolIndex
			}
	
			fruDiskVolName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= disk volname
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskVolName
			}
	
			fruDiskIsRoleData = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isRoleData
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskIsRoleData
			}
	
			fruDiskIsRoleStandby = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isRoleStandby
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskIsRoleStandby
			}

			fruDiskIsRoleUndefined = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isUndefined
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskIsRoleUndefined
			}

			fruDiskIsExpendable = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isExpendable
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskIsExpendable
			}

			fruDiskIsRebuildable = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isRebuildable
				consoleHint:mediumDesc = base.modules.t300:disk.advanced-table.advanced-entry.fruDiskIsRebuildable
			}
		}
	}
}


controllers = { [ use MANAGED-OBJECT ]
	mediumDesc = controllers
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:controllers

	controllers-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = controllers table
		consoleHint:mediumDesc = base.modules.t300:controllers.controllers-table

		controllers-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:controllers.controllers-table.controllers-entry

			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number  
				consoleHint:mediumDesc = base.modules.t300:controllers.controllers-table.controllers-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	   			mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:controllers.controllers-table.controllers-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:controllers.controllers-table.controllers-entry.sunSmNodeName
			}
		}
	}
}


controller = { [ use MANAGED-OBJECT ]
	mediumDesc = controller
	consoleHint:mediumDesc = base.modules.t300:controller
	consoleHint:smallIcon(DFT) = topoimages/controller-small.gif
	consoleHint:largeIcon(DFT) = topoimages/controller-xlarge.gif

	controller-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = controller table
		consoleHint:mediumDesc = base.modules.t300:controller.controller-table

		controller-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId fruId
			consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry
	
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.unitId
			}

			fruId = { [ use STRING MANAGED-PROPERTY ] 
				mediumDesc      = fru id
				consoleHint:mediumDesc = base.modules.t300:fruprops.fruId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.sunSmTreeProp
			}
			
			sunSmNodeName = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
				mediumDesc	= Current Name
				alarmRules	= rple401
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.sunSmNodeName
			}

#			fruStatus = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
#				mediumDesc	= status
#				consoleHint:mediumDesc	= base.modules.t300:fruprops.fruStatus
#			}
	
# load common fru properties
			[ load t300-fruprops-models-d.x ]
	
			fruCtlrCpuDesc = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = CPU type
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrCpuDesc
			}
	
			fruCtlrRole = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = controller role
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrRole
			}
	
			fruCtlrPartnerId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = partner id
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrPartnerId
			}
	
			fruCtlrCtState = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = current state
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrCtState
			}
	
			fruCtlrCacheSize = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = cache size
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrCacheSize
			}
	
			fruCtlrTemp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = temperature
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrTemp
			}
	
			fruCtlrIsExpendable = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = isExpendable
				consoleHint:mediumDesc = base.modules.t300:controller.controller-table.controller-entry.fruCtlrIsExpendable
			}
		}
	}
}


loopcards = { [ use MANAGED-OBJECT ]
	mediumDesc = loopcards
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:loopcards

	loopcards-table = { [ use MANAGED-OBJECT-TABLE ]
	
		mediumDesc = loopcards table
		consoleHint:mediumDesc = base.modules.t300:loopcards.loopcards-table
	
		loopcards-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:loopcards.loopcards-table.loopcards-entry
	
			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number  
				consoleHint:mediumDesc = base.modules.t300:loopcards.loopcards-table.loopcards-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:loopcards.loopcards-table.loopcards-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:loopcards.loopcards-table.loopcards-entry.sunSmNodeName
			}
		}
	}
}


loop_card = { [ use MANAGED-OBJECT ]

	mediumDesc = loop_card
	consoleHint:mediumDesc = base.modules.t300:loop_card
	consoleHint:smallIcon(DFT) = topoimages/loop-card-small.gif
	consoleHint:largeIcon(DFT) = topoimages/loop-card-xlarge.gif

	loop_card-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = loop_card table
		consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table
	
		loop_card-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId fruId
			consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry
	
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.unitId
			}
	
			fruId = { [ use STRING MANAGED-PROPERTY ] 
				mediumDesc      = fru id
				consoleHint:mediumDesc = base.modules.t300:fruprops.fruId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.sunSmTreeProp
			}
		
			sunSmNodeName = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
				mediumDesc	= Current Name
				alarmRules	= rple402
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.sunSmNodeName
			}

#			fruStatus = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
#				mediumDesc	= status
#				consoleHint:mediumDesc	= base.modules.t300:fruprops.fruStatus
#			}
	
# load common fru properties
			[ load t300-fruprops-models-d.x ]
	
			fruLoopMode = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = loop mode
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.fruLoopMode
			}
	
			fruLoopCable1State = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = cable1 state
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.fruLoopCable1State
			}

			fruLoopCable2State = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = cable2 state
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.fruLoopCable2State
			}

			fruLoopTemp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = temperature
				consoleHint:mediumDesc = base.modules.t300:loop_card.loop_card-table.loop_card-entry.fruLoopTemp
			}
		}
	}
}


powerunits = { [ use MANAGED-OBJECT ]
	mediumDesc = powerunits
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:powerunits

	powerunits-table = { [ use MANAGED-OBJECT-TABLE ]
	
		mediumDesc = powerunits table
		consoleHint:mediumDesc = base.modules.t300:powerunits.powerunits-table
	
		powerunits-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:powerunits.powerunits-table.powerunits-entry
	
			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number  
				consoleHint:mediumDesc = base.modules.t300:powerunits.powerunits-table.powerunits-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:powerunits.powerunits-table.powerunits-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:powerunits.powerunits-table.powerunits-entry.sunSmNodeName
			}
		}
	}
}


power_cooling_unit = { [ use MANAGED-OBJECT ]
	mediumDesc = power_cooling_unit
	consoleHint:mediumDesc = base.modules.t300:power_cooling_unit
	consoleHint:smallIcon(DFT) = topoimages/power-supply-small.gif
	consoleHint:largeIcon(DFT) = topoimages/power-supply-xlarge.gif

	power_cooling_unit-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = power_cooling_unit table
		consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table
	
		power_cooling_unit-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId fruId
			consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.unitId
			}

			fruId = { [ use STRING MANAGED-PROPERTY ] 
				mediumDesc      = fru id
				consoleHint:mediumDesc = base.modules.t300:fruprops.fruId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.sunSmTreeProp
			}
			
			sunSmNodeName = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
				mediumDesc	= Current Name
				alarmRules	= rple403
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.sunSmNodeName
			}

#			fruStatus = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
#				mediumDesc	= status
#				consoleHint:mediumDesc	= base.modules.t300:fruprops.fruStatus
#			}
	
# load common fru properties
			[ load t300-fruprops-models-d.x ]

			fruPowerPowOutput = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc      = output state
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerPowOutput
			}
	
			fruPowerPowSource = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= input source
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerPowSource
			}

			fruPowerPowTemp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= temperature
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerPowTemp
			}

			fruPowerFan1State = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= fan1 state
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerFan1State
			}

			fruPowerFan2State = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= fan2 state
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerFan2State
			}

			fruPowerBatState = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= battery state
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerBatState
			}

			fruPowerBatLife = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= battery life
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerBatLife
			}

			fruPowerBatUsed = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= battery used
				consoleHint:mediumDesc = base.modules.t300:power_cooling_unit.power_cooling_unit-table.power_cooling_unit-entry.fruPowerBatUsed
			}
		}
	}
}


midplanes = { [ use MANAGED-OBJECT ]
	mediumDesc = midplanes
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:midplanes

	midplanes-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = midplanes table
		consoleHint:mediumDesc = base.modules.t300:midplanes.midplanes-table

		midplanes-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:midplanes.midplanes-table.midplanes-entry

			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number  
				consoleHint:mediumDesc = base.modules.t300:midplanes.midplanes-table.midplanes-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:midplanes.midplanes-table.midplanes-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:midplanes.midplanes-table.midplanes-entry.sunSmNodeName
			}
		}
	}
}


midplane = { [ use MANAGED-OBJECT ]
	mediumDesc = midplane
	consoleHint:mediumDesc = base.modules.t300:midplane
	consoleHint:smallIcon(DFT) = topoimages/board-small.gif
	consoleHint:largeIcon(DFT) = topoimages/board-xlarge.gif

	midplane-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = midplane table
		consoleHint:mediumDesc = base.modules.t300:midplane.midplane-table

		midplane-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId fruId
			consoleHint:mediumDesc = base.modules.t300:midplane.midplane-table.midplane-entry
	
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:midplane.midplane-table.midplane-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:midplane.midplane-table.midplane-entry.unitId
			}

			fruId = { [ use STRING MANAGED-PROPERTY ] 
				mediumDesc      = fru id
				consoleHint:mediumDesc = base.modules.t300:fruprops.fruId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				consoleHint:hidden = true
				mediumDesc	= sunSmTreeProp
				consoleHint:mediumDesc = base.modules.t300:midplane.midplane-table.midplane-entry.sunSmTreeProp
			}
			
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= Current Name
				consoleHint:mediumDesc = base.modules.t300:midplane.midplane-table.midplane-entry.sunSmNodeName
			}
	
#			fruStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
#				mediumDesc	= status
#				consoleHint:mediumDesc	= base.modules.t300:fruprops.fruStatus
#			}

# load common fru properties
			[ load t300-fruprops-models-d.x ]
		}
	}
}


volumes = { [ use MANAGED-OBJECT ]
	mediumDesc = volumes
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:volumes

	volumes-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = volumes table
		consoleHint:mediumDesc = base.modules.t300:volumes.volumes-table

		volumes-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:volumes.volumes-table.volumes-entry

			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number
				consoleHint:mediumDesc = base.modules.t300:volumes.volumes-table.volumes-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:volumes.volumes-table.volumes-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:volumes.volumes-table.volumes-entry.sunSmNodeName
			}
		}
	}
}


volume = { [ use MANAGED-OBJECT ]
	mediumDesc = volume
	consoleHint:mediumDesc = base.modules.t300:volume
	consoleHint:smallIcon(DFT) = topoimages/components-small.gif
	consoleHint:largeIcon(DFT) = topoimages/components-xlarge.gif

	basic-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = basic properties table
		consoleHint:mediumDesc = base.modules.t300:volume.basic-table
	
		basic-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId volId
			consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.unitId
			}
			volId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= volume id
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.sunSmTreeProp
			}
		
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= Current Name
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.sunSmNodeName
			}

			volName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= volume name
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volName
			}

			volWWN = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= volume WWN
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volWWN
			}

			volStatus = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= volume status
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volStatus
			}

			volCacheMode = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cache mode
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volCacheMode
			}

			volCacheMirror = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cache mirror
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volCacheMirror
			}

			volCapacity = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= volume capacity
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volCapacity
			}

			volArrayWidth = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= drive number
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volArrayWidth
			}

			volRaidLevel = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= raid level
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volRaidLevel
			}

			volDisabledDisk = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= disabled disk
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volDisabledDisk
			}

			volSubstitutedDisk = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= substituted disk
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volSubstitutedDisk
			}

			volInitRate = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= init rate
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volInitRate
			}
	
			volVerifyRate = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= verify rate
				consoleHint:mediumDesc = base.modules.t300:volume.basic-table.basic-entry.volVerifyRate
			}
		}
	}


	statistical-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = statistical properties table
		consoleHint:mediumDesc = base.modules.t300:volume.statistical-table
	
		statistical-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId volId
			consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry
	
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.t300name
			}

			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.unitId
			}
			volId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= volume id
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volId
			}

			volTotalRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= total requests
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volTotalRequests
			}

			volWriteRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= write requests
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volWriteRequests
			}

			volReadRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= read requests
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volReadRequests
			}

			volTotalBlocks = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= total blocks
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volTotalBlocks
			}

			volBlocksWritten = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= blocks written
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volBlocksWritten
			}

			volBlocksRead = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= blocks read
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volBlocksRead
			}

			volSoftErrors = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= soft errors
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volSoftErrors
			}

			volFirmErrors = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= firm errors
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volFirmErrors
			}

			volHardErrors = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= hard errors
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volHardErrors
			}

			volCacheWriteHits = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheWriteHits
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheWriteHits
			}

			volCacheWriteMisses = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheWriteMisses
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheWriteMisses
			}

			volCacheReadHits = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheReadHits
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheReadHits
			}

			volCacheReadMisses = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheReadMisses
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheReadMisses
			}

			volCacheRmwFlushes = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheRmwFlushes
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheRmwFlushes
			}

			volCacheReconFlushes = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheReconFlushes
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheReconFlushes
			}

			volCacheStripeFlushes = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= cacheStripeFlushes
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.volCacheStripeFlushes
			}

			clear-flag = { [ use INT MANAGED-PROPERTY ]
				mediumDesc      = clear flag
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:volume.statistical-table.statistical-entry.clear-flag
			}
		}
	}
}


ports = { [ use MANAGED-OBJECT ]
	mediumDesc = ports
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:ports

	ports-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = ports table
		consoleHint:mediumDesc = base.modules.t300:ports.ports-table
	
		ports-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:ports.ports-table.ports-entry
	
			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number
				consoleHint:mediumDesc = base.modules.t300:ports.ports-table.ports-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:ports.ports-table.ports-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:ports.ports-table.ports-entry.sunSmNodeName
			}
		}
	}
}


port = { [ use MANAGED-OBJECT ]
	mediumDesc = port
	consoleHint:mediumDesc = base.modules.t300:port
	consoleHint:smallIcon(DFT) = topoimages/WCI-port-small.gif
	consoleHint:largeIcon(DFT) = topoimages/WCI-port-xlarge.gif

	basic-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = basic properties table
		consoleHint:mediumDesc = base.modules.t300:port.basic-table

		basic-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry
			index = t300name unitId portId
	
			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.unitId
			}
			portId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= portId
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.sunSmTreeProp
			}
		
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= Current Name
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.sunSmNodeName
			}

			portWWN = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port WWN
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portWWN
			}

			portStatus = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port status
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portStatus
			}

			portType = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port type
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portType
			}

			portFruId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port fruId
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portFruId
			}

			portSunHost = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= port sunHost
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portSunHost
			}

			portFibreCount = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= fibre count
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portFibreCount
			}

			portFibreAlpaMode = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= ALPA mode
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portFibreAlpaMode
			}

			portFibreAlpa = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= ALPA
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portFibreAlpa
			}
		}
	}

	statistical-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = statistical properties table
		consoleHint:mediumDesc = base.modules.t300:port.statistical-table
	
		statistical-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry
			index = t300name unitId portId

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.unitId
			}
			portId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= portId
				consoleHint:mediumDesc = base.modules.t300:port.basic-table.basic-entry.portId
			}

			portTotalRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= total requests
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.portTotalRequests
			}

			portWriteRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= write requests
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.portWriteRequests
			}

			portReadRequests = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= read requests
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.portReadRequests
			}

			portTotalBlocks = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= total blocks
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.portTotalBlocks
			}

			portBlocksWritten = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= blocks written
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.portBlocksWritten
			}

			portBlocksRead = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= blocks read
				consoleHint:mediumDesc = base.modules.t300:port.statistical-table.statistical-entry.portBlocksRead
			}
		}
	}
}


attachments = { [ use MANAGED-OBJECT ]
	mediumDesc = attachments
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:attachments

	attachments-table = { [ use MANAGED-OBJECT-TABLE ]
	
		mediumDesc = attachments table
		consoleHint:mediumDesc = base.modules.t300:attachments.attachments-table

		attachments-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:attachments.attachments-table.attachments-entry

			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number
				consoleHint:mediumDesc = base.modules.t300:attachments.attachments-table.attachments-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:attachments.attachments-table.attachments-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:attachments.attachments-table.attachments-entry.sunSmNodeName
			}
		}
	}
}


attachment = { [ use MANAGED-OBJECT ]
	mediumDesc = attachment
	consoleHint:mediumDesc = base.modules.t300:attachment
	consoleHint:smallIcon(DFT) = topoimages/attachment-small.gif
	consoleHint:largeIcon(DFT) = topoimages/attachment-xlarge.gif

	attachment-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = attachment table
		consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table
	
		attachment-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId portId attachId
			consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.unitId
			}
			portId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc 	= portId
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.portId
			}
			attachId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= attach id
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.attachId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.sunSmTreeProp
			}
		
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= Current Name
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.sunSmNodeName
			}

			attachLun = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= attach Lun
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.attachLun
			}

			attachMode = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= attach mode
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.attachMode
			}

			attachVolId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= attach volid
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.attachVolId
			}

			attachVolName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= attach volname
				consoleHint:mediumDesc = base.modules.t300:attachment.attachment-table.attachment-entry.attachVolName
			}
		}
	}
}


loops = { [ use MANAGED-OBJECT ]
	mediumDesc = loops
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.t300:loops

	loops-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = loops table
		consoleHint:mediumDesc = base.modules.t300:loops.loops-table
	
		loops-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = entry_no
			consoleHint:mediumDesc = base.modules.t300:loops.loops-table.loops-entry
	
			entry_no = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  entry number
				consoleHint:mediumDesc = base.modules.t300:loops.loops-table.loops-entry.entry_no
			}
			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= sunSmTreeProp 
				consoleHint:mediumDesc = base.modules.t300:loops.loops-table.loops-entry.sunSmTreeProp
			}
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	=  Current Name
				consoleHint:mediumDesc = base.modules.t300:loops.loops-table.loops-entry.sunSmNodeName
			}
		}
	}
}


loop = { [ use MANAGED-OBJECT ]
	mediumDesc = loop
	consoleHint:mediumDesc = base.modules.t300:loop
	consoleHint:smallIcon(DFT) = topoimages/loop-small.gif
	consoleHint:largeIcon(DFT) = topoimages/loop-xlarge.gif

	loop-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = loop table
		consoleHint:mediumDesc = base.modules.t300:loop.loop-table
	
		loop-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name unitId loopId
			consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.t300name
			}
			unitId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= unit id
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.unitId
			}
			loopId = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= loop id
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopId
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				consoleHint:hidden = true
				mediumDesc	= sunSmTreeProp
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.sunSmTreeProp
			}
		
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= Current Name
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.sunSmNodeName
			}

			loopStatus = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= loop status
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopStatus
			}

			loopMux = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= loop mux
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopMux
			}

			loopIsAvailable = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isAvailable
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopIsAvailable
			}

			loopIsReserved = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isReserved
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopIsReserved
			}

			loopIsIsolated = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isIsolated
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopIsIsolated
			}

			loopIsTop = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isTop
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopIsTop
			}

			loopIsBottom = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isBottom
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopIsBottom
			}

			loopIsMiddle = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= isMiddle
				consoleHint:mediumDesc = base.modules.t300:loop.loop-table.loop-entry.loopIsMiddle
			}
		}
	}
}


logging = { [ use MANAGED-OBJECT ]
	mediumDesc		= Logging
	consoleHint:mediumDesc	= base.modules.t300:logging
	consoleHint:smallIcon(DFT) = topoimages/PFA-rules-small.gif
	consoleHint:largeIcon(DFT) = topoimages/PFA-rules-xlarge.gif

	logging-table = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc		= Logging table
		consoleHint:mediumDesc	= base.modules.t300:logging.logging-table

		logging-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			index = t300name
			consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry

			t300name = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= t300name
				dataFormat	= instance
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.t300name
			}

			sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
				consoleHint:hidden = true
				mediumDesc	= sunSmTreeProp
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.sunSmTreeProp
			}
			
			sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= Current Name
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.sunSmNodeName
			}

			rowstatus = { [ use GLOBROWNODE ROWSTATUS MANAGED-PROPERTY ]
				mediumDesc = Row Status
				consoleHint:hidden = true
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.rowstatus
			}

			logStatus = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc	= log status
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.logStatus
			}
	
			logPort = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= log port
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.logPort
			}
	
			logTo = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= logto
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.logTo
			}
	
			logLevel = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
				mediumDesc	= log level
				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.logLevel
			}
	
#
# logMask is not available, SunMC will support it when the token is available
#
#			logMask = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
#				mediumDesc	= log mask
#				consoleHint:mediumDesc = base.modules.t300:logging.logging-table.logging-entry.logMask
#			}
		}
	}
}


t300-rules = {
	[ use MANAGED-OBJECT ]

	mediumDesc		= T3 Rules
	consoleHint:hidden	= true
	consoleHint:mediumDesc	= base.modules.t300:t300-rules

	rple201	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Controller Error
		alarmRules	= rple201
		consoleHint:mediumDesc	= base.modules.t300:t300-rules.rple201	
	}

	rple202	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Power Cooling Unit Error
		alarmRules	= rple202
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple202
	}

	rple203	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Loop Card Error
		alarmRules	= rple203
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple203
	}

	rple204	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Disk Error
		alarmRules	= rple204
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple204
	}

	rple205	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Controller Warning
		alarmRules	= rple205
		consoleHint:mediumDesc	= base.modules.t300:t300-rules.rple205
	}

	rple206	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Power Cooling Unit Warning
		alarmRules	= rple206
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple206
	}

	rple207	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Loop Card Warning
		alarmRules	= rple207
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple207
	}

	rple208	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Disk Warning
		alarmRules	= rple208
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple208
	}

	rple220	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Disk Error
		alarmRules	= rple220
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple220
	}

	rple221	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Power Cooling Unit Error
		alarmRules	= rple221
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple221
	}

	rple222	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Power Cooling Error
		alarmRules	= rple222
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple222
	}

	rple223	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Controller Warning
		alarmRules	= rple223
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple223
	}

	rple224	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Loop Card Warning
		alarmRules	= rple224
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple224
	}

	rple225	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Disk Warning
		alarmRules	= rple225
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple225
	}

	rple226	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Disk Warning
		alarmRules	= rple226
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple226
	}

	rple227	= {
		[ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc	= Power Cooling Unit Warning
		alarmRules	= rple227
		consoleHint:mediumDesc = base.modules.t300:t300-rules.rple227
	}
}

[ load t300-ruleinit-d.x ]
[ load t300-ruletext-d.x ]
