#   Copyright (c) 2000 Sun Microsystms
#   All rights reserved.
#
#
#   File:    em-d.x
#   Version: 1.0 
#
#   The agent file.


[ use MANAGED-MODULE ]
[ load em-m.x ]
[ requires template em-models-d ]

_emproc = { [ use PROC ]
        [ source em-d.prc ]
}

_services = { [ use SERVICE ] 
        #
        # Standard Bourne Shell
        #

        sh = {
                command = "pipe://localhost//bin/sh;transport=shell"
                max     = 2
        }
}

############
# Events Availability
############
availability = {
        type            = active
        refreshMode     = sync
        refreshService  = _services.sh
        refreshCommand  = em-availabilty.sh
        refreshInterval = 86400

#change the default error message. Change the default alarm.

        errorMessage       = "Is not supported on this platform."
        alarmChecks         = "error-ne";
        alarmlimit:error-ne  = AVAILABLE
        mediumDesc          =
        statusActions(error-ne)      = forcedown
        statusService(forcedown)    = _superior
        statusCommand(forcedown)    = forceModuleState down %[ toe_self ]

}

#The refreshCommand of this node creates an object of type em.
#...The object em creates
#a socket and registers the socketfd with MEL and when something
#needs to be read from the socket, MEL calls the appropriate
#callback in this object. The object is like a daemon, always
#running.. till the agent is brought down.
starteventsd = { [ use templates.em-models-d.em-object.starteventsd ]
		[use _emproc ]
	        [ requires class em ]
	        [ inherit classes.em ]

        type            = active
        refreshMode     = sync
        initInterval = 2
        refreshService  = _internal
        refreshCommand  = starteventd
        refreshInterval = 0

}

#This node will be populated by the em object, when it creates
#a socket for listening for connections from the client.
listenfd = { [ use templates.em-models-d.em-object.listenfd ]

}

#This node will be populated by the em object, when it creates
#a socket for connecting to  the client.
connectfd = { [ use templates.em-models-d.em-object.connectfd ]

}

#These nodes will be populated by the em object, when it receives events
dr-class = { [ use templates.em-models-d.em-object.dr-class ]

}

env-class = { [ use templates.em-models-d.em-object.env-class ]

}

info-class = { [ use templates.em-models-d.em-object.info-class ]

}

#
# This node will be populated by the wci wrsm object, 
# when it receives system events.
#
wrsm-class = { [ use templates.em-models-d.em-object.wrsm-class ]

}

