/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server;

import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.ReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.ReplyHeaderHolder;
import com.visigenic.vbroker.GIOP.ReplyStatusType;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHelper;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.interceptor.ChainServerInterceptor;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorFactoryImpl;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.interceptor.UserException;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.DynamicImplementationDispatcher;
import com.visigenic.vbroker.orb.GiopConnection;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopMessage;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopProtocol;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.SE;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import com.visigenic.vbroker.orb.SkeletonDelegate;
import com.visigenic.vbroker.orb.StubDelegate;
import com.visigenic.vbroker.orb.ThreadLocal;
import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import oracle.aurora.AuroraServices.CredentialIdHelper;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.AuroraServices.SecurityContextHelper;
import oracle.aurora.net.SSLVirtualCircuit;
import oracle.aurora.rdbms.ReauthHolder;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.LoginServerImpl;
import oracle.aurora.server.ORB;
import oracle.aurora.server.VCIiopConnection;
import oracle.aurora.server.VCListener;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Skeleton;

public class GiopProtocolAdapter
extends com.visigenic.vbroker.orb.GiopProtocolAdapter {
    protected int validatedSchema = -1;

    public GiopProtocolAdapter(com.visigenic.vbroker.orb.ORB orb, Adapter adapter, GiopProtocol protocol) {
        super(orb, adapter, protocol);
    }

    private void authenticate(RequestHeader hdr) {
        Socket sock;
        VCIiopConnection iVC = (VCIiopConnection)this._connection.connection();
        if (iVC.authenticated()) {
            return;
        }
        if (this._orb.AuroraDebug) {
            System.out.println("userId is null, so new connection");
        }
        if ((sock = iVC.getVC()) instanceof SSLVirtualCircuit) {
            SSLVirtualCircuit svc = (SSLVirtualCircuit)sock;
            try {
                byte[] cert;
                if (this._orb.AuroraDebug) {
                    System.out.println("Extracting the client certificate");
                }
                if ((cert = svc.getPeerCert()) != null) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert);
                    Certificate xcert = cf.generateCertificate(bais);
                    if (this._orb.AuroraDebug) {
                        System.out.println("Client Certificate : ");
                        System.out.println(xcert);
                    }
                    if (xcert instanceof X509Certificate) {
                        X509Certificate x509Cert = (X509Certificate)xcert;
                        String globalUser = x509Cert.getSubjectDN().getName();
                        if (this._orb.AuroraDebug) {
                            System.out.println("DN out of the cert : " + globalUser);
                        }
                        ReauthHolder holder = new ReauthHolder();
                        holder.extuser = globalUser;
                        int ret = LoginServerImpl.gblAuthenticate(holder, 4, 0);
                        if (ret != 0) {
                            if (this._orb.AuroraDebug) {
                                System.out.println("Reauth failed, throwing NO_PERMISSION");
                            }
                            throw new NO_PERMISSION(MinorCodes.getMessage(17), 17, CompletionStatus.COMPLETED_NO);
                        }
                        if (this._orb.AuroraDebug) {
                            System.out.println("DB user after reauth: " + holder.dbuser);
                        }
                        ServerThreadInfo tls = ServerThreadInfo.instance((com.visigenic.vbroker.orb.ORB)this._orb);
                        ((VCIiopConnection)tls.connection).authenticate(Schema.lookup((String)holder.dbuser).ownerNumber());
                        return;
                    }
                } else if (this._orb.AuroraDebug) {
                    System.out.println("There is no cert ..");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw new NO_PERMISSION(MinorCodes.getMessage(17), 17, CompletionStatus.COMPLETED_NO);
            }
        }
        int i = 0;
        while (i < hdr.service_context.length) {
            if (hdr.service_context[i].context_id == 1330790656) {
                byte[] buffer;
                GiopInputStream input;
                if (this._orb.AuroraDebug) {
                    System.out.println("Found security context");
                }
                if (CredentialIdHelper.read((InputStream)(input = this._orb.newGiopInputStream(buffer = hdr.service_context[i].context_data))) == 0) {
                    String prop = System.getProperty("ALLOW_NON_SSL_CREDENTIAL");
                    if (VCListener.isSSLConnection() || prop != null && prop.equalsIgnoreCase("TRUE")) {
                        if (!LoginServerImpl.authenticate(SecurityContextHelper.read((InputStream)input))) {
                            throw new NO_PERMISSION(MinorCodes.getMessage(4), 4, CompletionStatus.COMPLETED_NO);
                        }
                    } else {
                        throw new NO_PERMISSION(MinorCodes.getMessage(5), 5, CompletionStatus.COMPLETED_NO);
                    }
                    return;
                }
            }
            ++i;
        }
        if (this._orb.AuroraDebug) {
            System.out.println("No security context");
        }
        LoginServerImpl.authenticateDefault();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRequest(GiopMessage message, ServerThreadInfo threadInfo) {
        Closure closure;
        RequestHeader request;
        block32: {
            block29: {
                block30: {
                    request = (RequestHeader)message.operationHeader();
                    if (this._orb.debug) {
                        this._orb.println("Read: " + request);
                    }
                    if (ORB.call_recreate()) {
                        TaggedProfile profile = this._connection.connection().getPeerProfile();
                        ((ChainServerInterceptorFactoryImpl)this._orb.serverInterceptorFactory()).recreate((ChainServerInterceptor)this._interceptor, profile);
                    }
                    GiopInputStream input = message.buffer();
                    boolean byteOrder = input.byteOrder();
                    closure = null;
                    Object target = null;
                    ReplyHeader reply = new ReplyHeader(com.visigenic.vbroker.orb.GiopProtocolAdapter.EMPTY_SERVICE_CONTEXT, request.request_id, ReplyStatusType.NO_EXCEPTION);
                    GiopOutputStream output = null;
                    int replyDataOffset = 0;
                    try {
                        try {
                            threadInfo.principal = request.requesting_principal;
                            threadInfo.connection = this._connection.connection();
                            threadInfo.adapter = this._adapter;
                            this.authenticate(request);
                            threadInfo.target = target = this.getObject(request.object_key);
                            if (target == null) {
                                byte[] objectKey = "INIT".getBytes();
                                String objStr = new String(request.object_key);
                                if (objStr.startsWith("ORCL(CONNECT_DATA=(REP_ID=IDL:CORBA/InitialReferences")) {
                                    threadInfo.target = target = this.getObject(objectKey);
                                }
                            }
                            if (target instanceof DynamicImplementationDispatcher) {
                                threadInfo.target = ((DynamicImplementationDispatcher)target).getObject();
                            }
                            if (this._interceptor != null) {
                                closure = new Closure();
                                ObjectHolder obj = new ObjectHolder(threadInfo.target);
                                InputStream istr = null;
                                int dataOffset = input.dataOffset();
                                input.offset(input.length());
                                istr = this._interceptor.receive_request(request, obj, (InputStream)input, closure);
                                if (istr != null) {
                                    if (!(istr instanceof GiopInputStream)) {
                                        throw new INTERNAL(MinorCodes.getMessage(6), 6, CompletionStatus.COMPLETED_MAYBE);
                                    }
                                    input = (GiopInputStream)istr;
                                }
                                input.offset(dataOffset);
                                if (threadInfo.target != obj.value) {
                                    if (!(obj.value instanceof Skeleton)) {
                                        throw new OBJECT_NOT_EXIST();
                                    }
                                    threadInfo.target = target = obj.value;
                                }
                                if (target == null) {
                                    throw new OBJECT_NOT_EXIST();
                                }
                                if (!this._orb.getDelegate(target).is_local(target)) {
                                    if (request.response_expected) {
                                        reply.reply_status = ReplyStatusType.LOCATION_FORWARD;
                                        StubDelegate stubDelegate = (StubDelegate)this._orb.getDelegate(target);
                                        output = this._connection.createReply(reply, byteOrder);
                                        replyDataOffset = output.offset();
                                        IORHelper.write((OutputStream)output, (IOR)stubDelegate.ior(target));
                                        this.prepareAndSendReply(request, reply, target, output, replyDataOffset, closure);
                                    }
                                    java.lang.Object var12_19 = null;
                                    if (this._interceptor == null || threadInfo.target == null) break block29;
                                    break block30;
                                }
                            }
                            if (target == null) throw new OBJECT_NOT_EXIST();
                            if (!(target instanceof Skeleton)) {
                                throw new OBJECT_NOT_EXIST();
                            }
                            try {
                                if (this._orb.debug) {
                                    this._orb.println("Skeleton: " + target);
                                }
                                SkeletonDelegate skeletonDelegate = (SkeletonDelegate)this._orb.getDelegate(target);
                                output = this._connection.createReply(reply, byteOrder);
                                replyDataOffset = output.offset();
                                output.request(request);
                                boolean userException = skeletonDelegate.execute((Skeleton)target, request, (InputStream)input, (OutputStream)output);
                                if (output.byteOrder() != byteOrder) {
                                    int saveOffset = output.offset();
                                    output.offset(6);
                                    output.write_octet((byte)(output.byteOrder() ? 1 : 0));
                                    output.offset(12);
                                    ReplyHeaderHelper.write((OutputStream)output, (ReplyHeader)reply);
                                    output.offset(saveOffset);
                                }
                                if (userException) {
                                    reply.reply_status = ReplyStatusType.USER_EXCEPTION;
                                }
                            }
                            catch (SystemException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                UNKNOWN se = new UNKNOWN(MinorCodes.getMessage(16), 16, CompletionStatus.COMPLETED_MAYBE);
                                this._orb.printStream().println("VisiBroker for Java runtime caught exception:");
                                e.printStackTrace(this._orb.printStream());
                                throw se;
                            }
                        }
                        catch (SystemException e) {
                            if (this._orb.warn > 1) {
                                this._orb.println("Sending exception to client: " + (java.lang.Object)((java.lang.Object)e));
                                e.printStackTrace(this._orb.printStream());
                            }
                            reply.reply_status = ReplyStatusType.SYSTEM_EXCEPTION;
                            if (output == null) {
                                output = this._connection.createReply(reply, byteOrder);
                                replyDataOffset = output.offset();
                            }
                            output.offset(replyDataOffset);
                            SE.write((OutputStream)output, e);
                        }
                        if (request.response_expected) {
                            this.prepareAndSendReply(request, reply, threadInfo.target, output, replyDataOffset, closure);
                        }
                        break block32;
                    }
                    catch (Throwable throwable) {
                        java.lang.Object var12_21 = null;
                        if (this._interceptor != null && threadInfo.target != null) {
                            this._interceptor.request_completed(request, threadInfo.target, closure);
                        }
                        threadInfo.target = null;
                        threadInfo.principal = null;
                        threadInfo.connection = null;
                        threadInfo.adapter = null;
                        throw throwable;
                    }
                }
                this._interceptor.request_completed(request, threadInfo.target, closure);
            }
            threadInfo.target = null;
            threadInfo.principal = null;
            threadInfo.connection = null;
            threadInfo.adapter = null;
            return;
        }
        java.lang.Object var12_20 = null;
        if (this._interceptor != null && threadInfo.target != null) {
            this._interceptor.request_completed(request, threadInfo.target, closure);
        }
        threadInfo.target = null;
        threadInfo.principal = null;
        threadInfo.connection = null;
        threadInfo.adapter = null;
    }

    protected synchronized Object getObject(byte[] objectKey) {
        boolean equal = false;
        if (objectKey.length == this._objectKey.length) {
            equal = true;
            int i = this._objectKey.length - 1;
            while (i >= 0) {
                if (objectKey[i] != this._objectKey[i]) {
                    equal = false;
                    break;
                }
                --i;
            }
        }
        int userId = ((VCIiopConnection)this._connection.connection()).userId();
        if (!equal || this.validatedSchema != userId) {
            equal = false;
        }
        if (!equal) {
            ObjectId objectId = this._orb.toObjectId(objectKey);
            if (objectId == null) {
                return null;
            }
            this._objectKey = objectKey;
            this._skeleton = this._adapter.getSkeleton(objectId);
            this.validatedSchema = userId;
        }
        return this._skeleton;
    }

    protected void prepareAndSendReply(RequestHeader request, ReplyHeader reply, Object target, GiopOutputStream output, int dataOffset, Closure closure) {
        Environment env;
        if (this._interceptor != null && target != null) {
            ReplyHeaderHolder tmpHdr = new ReplyHeaderHolder(reply);
            this._interceptor.prepare_reply(request, tmpHdr, target, closure);
            if (reply.reply_status == ReplyStatusType.USER_EXCEPTION || reply.reply_status == ReplyStatusType.SYSTEM_EXCEPTION) {
                int saveOffset = output.offset();
                output.offset(12);
                ReplyHeaderHelper.write((OutputStream)output, (ReplyHeader)reply);
                output.offset(saveOffset);
            }
            env = this._orb.create_environment();
            if (reply.reply_status == ReplyStatusType.USER_EXCEPTION) {
                UserException e = new UserException();
                GiopInputStream exceptionInput = (GiopInputStream)output.create_input_stream();
                exceptionInput.offset(dataOffset);
                e.repository_id = exceptionInput.read_string();
                exceptionInput.offset(dataOffset);
                e.exception_data = exceptionInput;
                env.exception((Exception)e);
            } else if (reply.reply_status == ReplyStatusType.SYSTEM_EXCEPTION) {
                GiopInputStream exceptionInput = (GiopInputStream)output.create_input_stream();
                exceptionInput.offset(dataOffset);
                env.exception((Exception)((java.lang.Object)SE.read((InputStream)exceptionInput)));
            }
            int saveOffset = output.offset();
            OutputStream ostr = this._interceptor.send_reply(request, reply, target, (OutputStream)output, env, closure);
            if (ostr != null) {
                if (!(ostr instanceof GiopOutputStream)) {
                    throw new INTERNAL(MinorCodes.getMessage(7), 7, CompletionStatus.COMPLETED_MAYBE);
                }
                output = (GiopOutputStream)ostr;
                output.request(request);
            } else {
                output.offset(saveOffset);
            }
        } else if (reply.reply_status == ReplyStatusType.USER_EXCEPTION || reply.reply_status == ReplyStatusType.SYSTEM_EXCEPTION) {
            int saveOffset = output.offset();
            output.offset(12);
            ReplyHeaderHelper.write((OutputStream)output, (ReplyHeader)reply);
            output.offset(saveOffset);
        }
        try {
            this._connection.send_message(output);
        }
        catch (SystemException e) {
            if (this._interceptor != null && target != null) {
                env = this._orb.create_environment();
                env.exception((Exception)((java.lang.Object)e));
                this._interceptor.send_reply_failed(request, reply, target, env, closure);
            }
            throw e;
        }
    }

    public java.lang.Object readMessage(ThreadLocal tls) {
        GiopConnection giopConnection = this._connection;
        synchronized (giopConnection) {
            if (!this._connection.connection().isPeerAlive()) {
                java.lang.Object var2_3 = null;
                java.lang.Object var4_5 = null;
                return var2_3;
            }
            java.lang.Object object = super.readMessage(tls);
            java.lang.Object var4_6 = null;
            return object;
        }
    }
}

