/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts.server;

import com.visigenic.vbroker.orb.AnyImpl;
import com.visigenic.vbroker.orb.ORB;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import oracle.aurora.AuroraServices.ActivatableObject;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jts.server.AuroraTransactionService;
import oracle.aurora.jts.server.RootCoordinatorImpl;
import oracle.aurora.jts.server.XA_JTSResource;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions._TransactionFactoryImplBase;
import org.omg.CosTransactions.otid_t;

public class TransactionFactoryImpl
extends _TransactionFactoryImplBase
implements TransactionFactory,
ActivatableObject {
    private static Hashtable openTransactions = new Hashtable();
    private static TransactionFactoryImpl singleton;
    private static String seed;
    private static long NextId;
    private static final boolean DEBUG = false;
    private static final int FORMAT_ID = 0x363636;
    private final long time = new Date().getTime();

    static {
        seed = "ORACLE AURORA";
        NextId = 0L;
    }

    public TransactionFactoryImpl() {
    }

    public TransactionFactoryImpl(String name) {
        super(name);
    }

    public Object _initializeAuroraObject() {
        singleton = this;
        return this;
    }

    public synchronized Control create(int time_out) {
        TransIdentity tid = new TransIdentity();
        PropagationContext cxt = new PropagationContext();
        cxt.current = tid;
        cxt.timeout = time_out;
        cxt.parents = new TransIdentity[0];
        AnyImpl any = new AnyImpl();
        java.lang.Object[] obj = new java.lang.Object[1];
        any.init((ORB)org.omg.CORBA.ORB.init(), obj);
        cxt.implementation_specific_data = any;
        cxt.implementation_specific_data.insert_short((short)35);
        this.createXID(tid);
        RootCoordinatorImpl coord = new RootCoordinatorImpl(tid, time_out);
        openTransactions.put(XA_JTSResource.gtridKeyOf(tid.otid.tid), coord);
        try {
            XA_JTSResource r = new XA_JTSResource(tid, (short)time_out);
            coord.register_resource(r);
            r.start();
        }
        catch (XAException xAException) {
            throw new INVALID_TRANSACTION(MinorCodes.getMessage(19), 19, CompletionStatus.COMPLETED_NO);
        }
        catch (Inactive inactive) {
            throw new INVALID_TRANSACTION(MinorCodes.getMessage(19), 19, CompletionStatus.COMPLETED_NO);
        }
        try {
            ((AuroraTransactionService)TS.getTS()).newTxn(cxt);
        }
        catch (NoTransactionServiceException noTransactionServiceException) {}
        return coord;
    }

    private synchronized void createXID(TransIdentity tid) {
        byte[] bqual;
        byte[] gtrid = bqual = (String.valueOf(seed) + this.time + ++NextId).getBytes();
        byte[] txid = new byte[gtrid.length + bqual.length];
        System.arraycopy(gtrid, 0, txid, 0, gtrid.length);
        System.arraycopy(bqual, 0, txid, gtrid.length, bqual.length);
        tid.otid = new otid_t();
        tid.otid.formatID = 0x363636;
        tid.otid.bqual_length = bqual.length;
        tid.otid.tid = txid;
    }

    protected void finalize() {
        Enumeration e = openTransactions.elements();
        while (e.hasMoreElements()) {
            ((RootCoordinatorImpl)e.nextElement()).rollback();
        }
    }

    public static TransactionFactoryImpl initialize() {
        if (singleton == null) {
            singleton = new TransactionFactoryImpl();
            new AuroraTransactionService(singleton);
            Orb.init().BOA_init().obj_is_ready((Object)singleton);
        }
        return singleton;
    }

    public synchronized Control recreate(PropagationContext ctx) {
        return (Control)openTransactions.get(XA_JTSResource.gtridKeyOf(ctx.current.otid.tid));
    }

    protected static synchronized void releaseTxn(TransIdentity tid) {
        String key = XA_JTSResource.gtridKeyOf(tid.otid.tid);
        if (tid != null) {
            RootCoordinatorImpl ctrl = (RootCoordinatorImpl)openTransactions.get(key);
            openTransactions.remove(key);
            ctrl.deactivate();
        }
    }
}

