/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.client;

import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.RequestHeaderHolder;
import com.visigenic.vbroker.IOP.ServiceContext;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.interceptor.DefaultClientInterceptor;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.ORB;
import java.util.Locale;
import oracle.aurora.AuroraServices.Credential;
import oracle.aurora.AuroraServices.CredentialIdHelper;
import oracle.aurora.AuroraServices.SecurityContext;
import oracle.aurora.AuroraServices.SecurityContextHelper;
import org.omg.CORBA.Environment;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class OracleClientInterceptor
extends DefaultClientInterceptor {
    boolean debug = false;
    ORB _orb = null;

    OracleClientInterceptor(org.omg.CORBA.ORB orb) {
        this._orb = (ORB)orb;
    }

    public void exception_occurred(int req_id, Environment env, Closure closure) {
        this.print("exception_occurred");
        System.out.println("  " + env.exception());
    }

    public void prepare_request(RequestHeaderHolder hdr, Closure closure) {
        Object epw = null;
        byte[] buffer = null;
        this.print("prepare_request");
        this.print(Credential.getName());
        this.print(Credential.getPassword());
        this.print("Status = " + Credential.getStatus());
        if (Credential.getStatus()) {
            Locale locale = Locale.getDefault();
            SecurityContext context = new SecurityContext(true, Credential.getName(), Credential.getPassword(), Credential.getRole(), locale.getLanguage(), locale.getCountry(), locale.getVariant());
            GiopOutputStream output = this._orb.newGiopOutputStream();
            CredentialIdHelper.write((OutputStream)output, 0);
            SecurityContextHelper.write((OutputStream)output, context);
            buffer = output.toByteArray();
            int contextListLength = hdr.value.service_context.length;
            if (contextListLength > 0) {
                ServiceContext[] tempList = hdr.value.service_context;
                hdr.value.service_context = new ServiceContext[contextListLength + 1];
                System.arraycopy(tempList, 0, hdr.value.service_context, 0, contextListLength);
            } else {
                hdr.value.service_context = new ServiceContext[1];
            }
            hdr.value.service_context[contextListLength] = new ServiceContext();
            hdr.value.service_context[contextListLength].context_id = 1330790656;
            hdr.value.service_context[contextListLength].context_data = buffer;
        }
    }

    public void print(String msg) {
        if (this.debug) {
            System.out.println("Oracle Client Interceptor : " + msg);
        }
    }

    public void receive_reply(ReplyHeader hdr, InputStream buf, Closure closure) {
        this.print("receive_reply");
        int i = 0;
        while (i < hdr.service_context.length) {
            if (hdr.service_context[i].context_id == 7001) {
                byte[] context = hdr.service_context[i].context_data;
                this.print(new String(context));
                break;
            }
            ++i;
        }
    }
}

