/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.snmp;

import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.jni.SsPacket;
import com.sun.symon.base.server.snmp.v2.SsRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StSnmpCounter;
import com.sun.symon.base.server.types.StSnmpCounter32;
import com.sun.symon.base.server.types.StSnmpCounter64;
import com.sun.symon.base.server.types.StSnmpEndOfMibView;
import com.sun.symon.base.server.types.StSnmpGauge;
import com.sun.symon.base.server.types.StSnmpINTEGER;
import com.sun.symon.base.server.types.StSnmpIpAddress;
import com.sun.symon.base.server.types.StSnmpNULL;
import com.sun.symon.base.server.types.StSnmpNoSuchInstance;
import com.sun.symon.base.server.types.StSnmpNoSuchObject;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.server.types.StSnmpTimeTicks;
import com.sun.symon.base.server.types.StSnmpUInteger32;
import com.sun.symon.base.utility.UcDDL;
import java.util.Vector;

public abstract class SsMessage {
    private static Object lock = new Object();
    private static final int SNMP = UcDDL.createChannel((String)"snmp");
    private int id;
    private int send;
    private long state;
    private int level;
    private int model;
    private long host;
    private int port;
    private String text;
    private String context;
    private String security;
    private Vector name = new Vector();
    private Vector value = new Vector();
    public static final int VERSION1 = 1;
    public static final int VERSION2 = 2;
    public static final int VERSION2c = 2;
    public static final int VERSION2u = 3;
    public static final int NoAuthenticationNoPrivacy = 1;
    public static final int AuthenticationNoPrivacy = 2;
    public static final int AuthenticationPrivacy = 3;
    public static final int AnySecurity = 1;
    public static final int V1CommunitySecurity = 2;
    public static final int V2CommunitySecurity = 3;
    public static final int V2UserSecurity = 4;
    public static final int V3UserSecurity = 5;

    private void dump(String string) {
        Object object = lock;
        synchronized (object) {
            UcDDL.logMessage((int)SNMP, (String)(String.valueOf(string) + " SNMP packet:"));
            UcDDL.logMessage((int)SNMP, (String)("    type = " + this.getClass().getName()));
            UcDDL.logMessage((int)SNMP, (String)("    context = '" + this.getContextName() + "'"));
            UcDDL.logMessage((int)SNMP, (String)("    host = '" + this.getHost() + "'"));
            UcDDL.logMessage((int)SNMP, (String)("    port = " + this.getPort()));
            UcDDL.logMessage((int)SNMP, (String)("    request id = " + this.getRequestId()));
            UcDDL.logMessage((int)SNMP, (String)("    send id = " + this.getSendId()));
            UcDDL.logMessage((int)SNMP, (String)("    security level = " + this.getSecurityLevel()));
            UcDDL.logMessage((int)SNMP, (String)("    security model = " + this.getSecurityModel()));
            UcDDL.logMessage((int)SNMP, (String)("    security name = '" + this.getSecurityName() + "'"));
            UcDDL.logMessage((int)SNMP, (String)("    state = " + this.getState()));
            UcDDL.logMessage((int)SNMP, (String)("    text = '" + this.getText() + "'"));
            UcDDL.logMessage((int)SNMP, (String)("    version = " + this.getVersion()));
            UcDDL.logMessage((int)SNMP, (String)("    type = " + this.getType()));
            String[] stringArray = this.getVariableNames();
            if (stringArray == null) {
                UcDDL.logMessage((int)SNMP, (String)"    names = null");
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    UcDDL.logMessage((int)SNMP, (String)("    names[" + n + "] = '" + stringArray[n] + "'"));
                    ++n;
                }
            }
            String[] stringArray2 = this.getVariableValues();
            if (stringArray2 == null) {
                UcDDL.logMessage((int)SNMP, (String)"    values = null");
            } else {
                int n = 0;
                while (n < stringArray2.length) {
                    UcDDL.logMessage((int)SNMP, (String)("    values[" + n + "] = '" + stringArray2[n] + "'"));
                    ++n;
                }
            }
        }
    }

    public String getContextName() {
        return this.context;
    }

    public long getHost() {
        return this.host;
    }

    public StSnmpOBJECT_IDENTIFIER[] getNames() {
        int n = this.name.size();
        if (n == 0) {
            return null;
        }
        StSnmpOBJECT_IDENTIFIER[] stSnmpOBJECT_IDENTIFIERArray = new StSnmpOBJECT_IDENTIFIER[n];
        int n2 = 0;
        while (n2 < n) {
            stSnmpOBJECT_IDENTIFIERArray[n2] = new StSnmpOBJECT_IDENTIFIER((String)this.name.elementAt(n2));
            ++n2;
        }
        return stSnmpOBJECT_IDENTIFIERArray;
    }

    public int getPort() {
        return this.port;
    }

    public int getRequestId() {
        return this.id;
    }

    public int getSecurityLevel() {
        return this.level;
    }

    public int getSecurityModel() {
        return this.model;
    }

    public String getSecurityName() {
        return this.security;
    }

    public int getSendId() {
        return this.send;
    }

    public long getState() {
        return this.state;
    }

    public String getText() {
        return this.text;
    }

    public abstract int getType();

    public StObject getVariable(String string) {
        int n = this.name.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (StObject)this.value.elementAt(n);
    }

    public String[] getVariableNames() {
        int n = this.name.size();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new String[n];
        this.name.copyInto(objectArray);
        return objectArray;
    }

    public String[] getVariableTypes() {
        int n = this.value.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            StObject stObject = (StObject)this.value.elementAt(n2);
            stringArray[n2] = stObject == null ? null : stObject.getTypeName();
            ++n2;
        }
        return stringArray;
    }

    public String[] getVariableValues() {
        int n = this.value.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            StObject stObject = (StObject)this.value.elementAt(n2);
            stringArray[n2] = stObject == null ? null : stObject.toString();
            ++n2;
        }
        return stringArray;
    }

    public StObject[] getVariables() {
        int n = this.value.size();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new StObject[n];
        this.value.copyInto(objectArray);
        return objectArray;
    }

    public abstract int getVersion();

    public void setContextName(String string) {
        this.context = string;
    }

    public void setHost(long l) {
        this.host = l;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setRequestId(int n) {
        this.id = n;
    }

    public void setSecurityLevel(int n) {
        this.level = n;
    }

    public void setSecurityModel(int n) {
        this.model = n;
    }

    public void setSecurityName(String string) {
        this.security = string;
    }

    public void setSendId(int n) {
        this.send = n;
    }

    public void setState(long l) {
        this.state = l;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setVariable(String string, StObject stObject) {
        this.name.addElement(string);
        this.value.addElement(stObject);
    }

    public void setVariableNames(String[] stringArray) {
        this.name.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.name.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setVariableValues(String[] stringArray, String[] stringArray2) {
        this.value.removeAllElements();
        if (stringArray2 == null || stringArray == null) {
            return;
        }
        StObject stObject = null;
        int n = 0;
        while (n < stringArray2.length) {
            if (stringArray[n] == null) {
                stObject = null;
            } else if (stringArray[n].compareTo("StSnmpNULL") == 0) {
                stObject = new StSnmpNULL();
            } else if (stringArray[n].compareTo("StSnmpINTEGER") == 0) {
                stObject = new StSnmpINTEGER(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpOCTET_STRING") == 0) {
                stObject = new StSnmpOCTET_STRING(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpOBJECT_IDENTIFIER") == 0) {
                stObject = new StSnmpOBJECT_IDENTIFIER(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpIpAddress") == 0) {
                stObject = new StSnmpIpAddress(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpCounter") == 0) {
                stObject = new StSnmpCounter(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpCounter32") == 0) {
                stObject = new StSnmpCounter32(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpUInteger32") == 0) {
                stObject = new StSnmpUInteger32(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpTimeTicks") == 0) {
                stObject = new StSnmpTimeTicks(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpCounter64") == 0) {
                stObject = new StSnmpCounter64(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpGauge") == 0) {
                stObject = new StSnmpGauge(stringArray2[n]);
            } else if (stringArray[n].compareTo("StSnmpNoSuchObject") == 0) {
                stObject = new StSnmpNoSuchObject();
            } else if (stringArray[n].compareTo("StSnmpNoSuchInstance") == 0) {
                stObject = new StSnmpNoSuchInstance();
            } else if (stringArray[n].compareTo("StSnmpEndOfMibView") == 0) {
                stObject = new StSnmpEndOfMibView();
            }
            this.value.addElement(stObject);
            ++n;
        }
    }

    public abstract byte[] toBytestream() throws SsEncodeException;

    public byte[] toBytestreamAndDump() throws SsEncodeException {
        if (UcDDL.channelIsActive((int)SNMP)) {
            this.dump("Sent");
        }
        return this.toBytestream();
    }

    public static SsMessage toMessage(byte[] byArray) throws SsDecodeException {
        SsPacket ssPacket = new SsPacket();
        ssPacket.incoming(byArray);
        SsMessage ssMessage = null;
        switch (ssPacket.version) {
            case 1: {
                ssMessage = com.sun.symon.base.server.snmp.v1.SsRequest.decode(ssPacket);
                ssPacket = null;
                break;
            }
            case 2: {
                ssMessage = SsRequest.decode(ssPacket);
                ssPacket = null;
                break;
            }
            case 3: {
                ssMessage = com.sun.symon.base.server.snmp.v2u.SsRequest.decode(ssPacket);
                ssPacket = null;
                break;
            }
            default: {
                throw new SsDecodeException("unknown version");
            }
        }
        if (UcDDL.channelIsActive((int)SNMP)) {
            ssMessage.dump("Received");
        }
        return ssMessage;
    }
}

