/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.client.table.SMTableResponse;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.console.grouping.task.CgDrillDownEvent;
import com.sun.symon.base.console.grouping.task.CgDrillDownListener;
import com.sun.symon.base.console.views.CvNavigationEvent;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyData;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyIdentifier;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyManager;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyTreeModel;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcURL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;

class CgHierarchyManager
extends CvHierarchyManager
implements CvNavigationListener,
SMTableResponse {
    static final String TAB_INDICATOR = "tabFormat#";
    private SMManagedEntityRequest entReq;
    private SMTableRequest tabReq;
    private boolean isProp;
    private Hashtable tabHash = new Hashtable();
    private Vector ddListeners = new Vector();

    public CgHierarchyManager(SMRawDataRequest sMRawDataRequest) {
        this.entReq = new SMManagedEntityRequest(sMRawDataRequest);
        this.tabReq = new SMTableRequest(sMRawDataRequest);
        super.setDataSource(sMRawDataRequest);
        this.addCvNavigationListener(this);
    }

    public synchronized void addDrillDownListener(CgDrillDownListener cgDrillDownListener) {
        if (!this.ddListeners.contains(cgDrillDownListener)) {
            this.ddListeners.addElement(cgDrillDownListener);
        }
    }

    private void fireDDEvents(String string, String string2, SMTableFormat sMTableFormat) {
        Vector vector;
        CgDrillDownEvent cgDrillDownEvent = new CgDrillDownEvent((Object)this, string, string2, sMTableFormat);
        CgHierarchyManager cgHierarchyManager = this;
        synchronized (cgHierarchyManager) {
            vector = (Vector)this.ddListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CgDrillDownListener cgDrillDownListener = (CgDrillDownListener)vector.elementAt(n);
            try {
                cgDrillDownListener.drillDownOccurred(cgDrillDownEvent);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("fireDrillDownEvents() - client error in drillDownOccurred: " + exception));
            }
            ++n;
        }
    }

    public void getHierarchyChildResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData[] sMHierarchyViewDataArray, Object object) {
        int n = 0;
        while (n < sMHierarchyViewDataArray.length) {
            SMHierarchyViewData sMHierarchyViewData = sMHierarchyViewDataArray[n];
            String string = sMHierarchyViewDataArray[n].getTargetUrl();
            try {
                String[] stringArray = this.entReq.getConsoleDisplayInfo(string);
                if (stringArray[1].compareTo("objectprop-nav") == 0) {
                    sMHierarchyViewDataArray[n] = new SMHierarchyViewData(sMHierarchyViewData.getObjectId(), sMHierarchyViewData.getName(), sMHierarchyViewData.getFamilyImages(), sMHierarchyViewData.getFamilyCommands(), sMHierarchyViewData.getNavigationUrl(), sMHierarchyViewData.getTargetUrl(), true, sMHierarchyViewData.getIsSoftGroupLink());
                }
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logWarningMessage((String)("CgHierarchyManager.getHierarchyChildResponse - request console display info error : " + (Object)((Object)sMAPIException)));
            }
            ++n;
        }
        super.getHierarchyChildResponse(sMRequestStatus, sMHierarchyViewDataArray, object);
    }

    public void getTableAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
    }

    public void getTableFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, Object object) {
    }

    public void getTableLayoutResponse(SMRequestStatus sMRequestStatus, SMTableFormat[] sMTableFormatArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)"Data Request Error receiving layout data.");
            return;
        }
        if (sMTableFormatArray == null || sMTableFormatArray.length == 0) {
            UcDDL.logErrorMessage((String)("Null data received while retrieving layout data ->" + (sMTableFormatArray == null ? "null" : String.valueOf(sMTableFormatArray.length))));
            return;
        }
        CvHierarchyIdentifier cvHierarchyIdentifier = (CvHierarchyIdentifier)object;
        DefaultMutableTreeNode defaultMutableTreeNode = cvHierarchyIdentifier.getTreeNode();
        CvHierarchyData cvHierarchyData = (CvHierarchyData)defaultMutableTreeNode.getUserObject();
        String string = UcURL.standardizeURL((String)cvHierarchyData.getTargetUrl());
        SMHierarchyViewData[] sMHierarchyViewDataArray = new SMHierarchyViewData[sMTableFormatArray.length];
        int n = 0;
        while (n < sMTableFormatArray.length) {
            sMHierarchyViewDataArray[n] = new SMHierarchyViewData(String.valueOf(cvHierarchyData.getObjectId()) + "-" + n, sMTableFormatArray[n].getTitle(), null, null, TAB_INDICATOR + n + "#", string, false, false);
            ++n;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.mibTreeModel.updateChildrenData(defaultMutableTreeNode, sMHierarchyViewDataArray);
        } else {
            updateRunnable updateRunnable2 = new updateRunnable(this.mibTreeModel, sMHierarchyViewDataArray, defaultMutableTreeNode);
            SwingUtilities.invokeLater(updateRunnable2);
        }
        if (!this.tabHash.containsKey(string)) {
            this.tabHash.put(string, sMTableFormatArray);
        }
    }

    public void navigationOccurred(CvNavigationEvent cvNavigationEvent) {
        String string = UcURL.standardizeURL((String)cvNavigationEvent.getNavigationUrl());
        String string2 = UcURL.standardizeURL((String)cvNavigationEvent.getTargetUrl());
        if (string.startsWith(TAB_INDICATOR)) {
            SMTableFormat[] sMTableFormatArray = (SMTableFormat[])this.tabHash.get(string2);
            if (sMTableFormatArray == null) {
                System.out.println("We lost data");
            } else {
                String string3 = string.substring(TAB_INDICATOR.length());
                string3 = string3.substring(0, string3.indexOf("#"));
                this.fireDDEvents(string, string2, sMTableFormatArray[new Integer(string3)]);
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        CvHierarchyData cvHierarchyData = (CvHierarchyData)defaultMutableTreeNode.getUserObject();
        String string = cvHierarchyData.getNavigationUrl();
        CvHierarchyIdentifier cvHierarchyIdentifier = new CvHierarchyIdentifier(defaultMutableTreeNode);
        try {
            String[] stringArray = this.entReq.getConsoleDisplayInfo(string);
            if (stringArray[1].compareTo("objectprop-nav") == 0) {
                this.isProp = true;
                this.tabReq.getTableLayoutRequest(string, (SMTableResponse)this, (Object)cvHierarchyIdentifier);
            } else {
                super.treeExpanded(treeExpansionEvent);
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)("CgHierarchyManager.treeExpanded - Failed to request hierarchy child data for " + defaultMutableTreeNode + ": " + (Object)((Object)sMAPIException)));
        }
    }

    class updateRunnable
    implements Runnable {
        private CvHierarchyTreeModel mibTreeModel;
        private DefaultMutableTreeNode parentNode;
        private SMHierarchyViewData[] sd;

        updateRunnable(CvHierarchyTreeModel cvHierarchyTreeModel, SMHierarchyViewData[] sMHierarchyViewDataArray, DefaultMutableTreeNode defaultMutableTreeNode) {
            this.mibTreeModel = cvHierarchyTreeModel;
            this.parentNode = defaultMutableTreeNode;
            this.sd = sMHierarchyViewDataArray;
        }

        public void run() {
            this.mibTreeModel.updateChildrenData(this.parentNode, this.sd);
        }
    }
}

