/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.groupOperation;

import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.groupOperation.RepeatDlg;
import com.sun.symon.base.console.tools.editor.CtDateTimePanel;
import com.sun.symon.base.console.tools.editor.CtTitledLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CgRequestSchedulePanel
extends JPanel {
    private JRadioButton activeNowBtn;
    private JRadioButton scheduleBtn;
    private JComboBox scheduleCmB;
    private CtDateTimePanel activateDTPanel;
    private JComboBox frequencyCmB;
    SMTaskRequestData groupOper;
    int repeatPeriod = 1;
    int repeatUnit = 0;
    static String[] frequency = new String[]{CgUtil.getI18nMsg((String)"oneTime"), CgUtil.getI18nMsg((String)"daily"), CgUtil.getI18nMsg((String)"weekly"), CgUtil.getI18nMsg((String)"monthly"), CgUtil.getI18nMsg((String)"repeat")};

    public CgRequestSchedulePanel(SMTaskRequestData sMTaskRequestData) {
        this.groupOper = sMTaskRequestData;
        this.createGUI();
        this.initData();
        this.installListeners();
    }

    void createGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        gridBagConstraints.anchor = 17;
        this.activeNowBtn = new JRadioButton(CgUtil.getI18nMsg((String)"activateNow"));
        this.activeNowBtn.setSelected(true);
        this.add((Component)this.activeNowBtn, gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel((LayoutManager)new CtTitledLayout());
        jPanel.add((Component)jPanel2, "West");
        this.scheduleBtn = new JRadioButton(CgUtil.getI18nMsg((String)"setSchedule"));
        jPanel2.add((Component)this.scheduleBtn, "North");
        Dimension dimension = this.scheduleBtn.getPreferredSize();
        jPanel2.setBorder(new CompoundBorder(new EmptyBorder(dimension.height / 2, 2, 2, 2), LineBorder.createGrayLineBorder()));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new EmptyBorder(0, 20, 20, 20));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel2.add(jPanel3);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        jPanel3.add((Component)new JLabel(CgUtil.getI18nMsg((String)"activateDate")), gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        jPanel3.add((Component)new JLabel(CgUtil.getI18nMsg((String)"activateTime")), gridBagConstraints2);
        this.activateDTPanel = new CtDateTimePanel();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.anchor = 17;
        jPanel3.add((Component)this.activateDTPanel, gridBagConstraints2);
        this.activateDTPanel.setEnabled(false);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(15, 0, 0, 5);
        gridBagConstraints2.anchor = 13;
        jPanel3.add((Component)new JLabel(CgUtil.getI18nMsg((String)"occurs")), gridBagConstraints2);
        this.frequencyCmB = new JComboBox();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 1;
        jPanel3.add((Component)this.frequencyCmB, gridBagConstraints2);
        this.frequencyCmB.setEnabled(false);
        int n = 0;
        while (n < frequency.length) {
            this.frequencyCmB.addItem(frequency[n]);
            ++n;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.activeNowBtn);
        buttonGroup.add(this.scheduleBtn);
    }

    public SMTaskRequestData getGroupOperation() {
        boolean bl = this.isScheduled();
        this.groupOper.setScheduled(bl);
        int n = 1;
        if (bl) {
            Calendar calendar = this.activateDTPanel.getCurrentTime();
            calendar.set(13, 0);
            int n2 = this.frequencyCmB.getSelectedIndex();
            int n3 = 0;
            if (n2 == 1) {
                n3 = 3;
            } else if (n2 == 2) {
                n3 = 4;
            } else if (n2 == 3) {
                n3 = 5;
            } else if (n2 == 4) {
                n3 = this.repeatUnit == 0 ? 3 : (this.repeatUnit == 1 ? 4 : 5);
                n = this.repeatPeriod;
            }
            this.groupOper.setPeriod((long)n);
            this.groupOper.setStartDate(calendar.getTime());
            this.groupOper.setPeriodUnits(n3);
        } else {
            this.groupOper.setStartDate(null);
            this.groupOper.setPeriodUnits(0);
            this.groupOper.setPeriod(1L);
        }
        return this.groupOper;
    }

    void initData() {
        if (this.groupOper == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        boolean bl = this.groupOper.isScheduled();
        if (bl) {
            this.scheduleBtn.setSelected(true);
            calendar.setTime(this.groupOper.getStartDate());
            int n = this.groupOper.getPeriodUnits();
            int n2 = (int)this.groupOper.getPeriod();
            int n3 = 0;
            if (n == 3) {
                n3 = 1;
                this.repeatUnit = 0;
            } else if (n == 4) {
                n3 = 2;
                this.repeatUnit = 1;
            } else if (n == 5) {
                n3 = 3;
                this.repeatUnit = 2;
            } else {
                n3 = 0;
            }
            if ((long)n2 != 1L) {
                n3 = 4;
                this.repeatPeriod = n2;
            }
            this.setScheduled(bl);
            this.frequencyCmB.setSelectedIndex(n3);
        }
        this.activateDTPanel.setCurrentTime(calendar);
    }

    void installListeners() {
        this.scheduleBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CgRequestSchedulePanel.this.setScheduled(CgRequestSchedulePanel.this.scheduleBtn.isSelected());
            }
        });
        this.frequencyCmB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CgRequestSchedulePanel.this.frequencyCmB.getSelectedIndex() == 4) {
                    CgRequestSchedulePanel.this.showRepeatDlg();
                }
            }
        });
    }

    public boolean isScheduled() {
        return this.scheduleBtn.isSelected();
    }

    public static void main(String[] stringArray) {
        Frame frame = JOptionPane.getRootFrame();
        JDialog jDialog = new JDialog(frame, "Group operation Schedule Test");
        JPanel jPanel = new JPanel(new BorderLayout());
        jDialog.setContentPane(jPanel);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 6);
        calendar.set(1, 2007);
        calendar.set(5, 7);
        calendar.set(10, 7);
        calendar.set(12, 7);
        SMTaskRequestData sMTaskRequestData = new SMTaskRequestData();
        sMTaskRequestData.setPeriod(1L);
        sMTaskRequestData.setPeriodUnits(4);
        sMTaskRequestData.setStartDate(calendar.getTime());
        sMTaskRequestData.setScheduled(true);
        jPanel.add(new CgRequestSchedulePanel(sMTaskRequestData));
        jDialog.pack();
        ((Component)jDialog).setVisible(true);
    }

    void setScheduled(boolean bl) {
        this.activateDTPanel.setEnabled(bl);
        this.frequencyCmB.setEnabled(bl);
    }

    void showRepeatDlg() {
        JDialog jDialog = (JDialog)SwingUtilities.windowForComponent(this);
        RepeatDlg repeatDlg = new RepeatDlg(jDialog, this.repeatPeriod, this.repeatUnit);
        repeatDlg.pack();
        repeatDlg.setLocationRelativeTo(jDialog);
        ((Component)repeatDlg).setVisible(true);
        if (repeatDlg.isOkClicked) {
            this.repeatPeriod = repeatDlg.repeat;
            this.repeatUnit = repeatDlg.unit;
        } else {
            this.frequencyCmB.setSelectedIndex(0);
        }
    }
}

