/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.web.details.log;

import com.sun.symon.base.client.log.SMLogViewerRequest;
import com.sun.symon.base.web.common.SMWebServlet;
import com.sun.symon.base.web.common.SMWebSession;
import com.sun.symon.base.web.common.SMWebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SMWebLogFilter {
    static final String dateFormatStr = "MMM d yyyy hh mm ss";
    static final String otherFileStr = "otherfile";
    static final String syslogStr = "syslog";
    static final String[] month = new String[]{"month1", "month2", "month3", "month4", "month5", "month6", "month7", "month8", "month9", "month10", "month11", "month12"};
    static final String[] day = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    static String[] year = new String[3];
    static final String[] hour = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    static final String[] minute = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    static final String[] second = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private String pattern = "";
    private String startMonth = month[0];
    private String startDay = day[0];
    private String startYear = year[0];
    private String startHour = hour[0];
    private String startMinute = minute[0];
    private String startSecond = second[0];
    private String endMonth = month[0];
    private String endDay = day[0];
    private String endYear = year[0];
    private String endHour = hour[0];
    private String endMinute = minute[0];
    private String endSecond = second[0];
    private int maxLines = 0;
    private int maxMatches = 100;
    private long startTimeStamp = 0L;
    private long endTimeStamp = 0L;
    private boolean fromLatest = true;
    private boolean changed = false;
    SMWebSession webSession = null;
    SMLogViewerRequest logReq = null;
    String sunmcURL = "";
    String type = null;
    String name = null;

    public SMWebLogFilter() {
        Calendar calendar = Calendar.getInstance();
        int n = 0;
        int n2 = calendar.get(1);
        while (n < year.length) {
            SMWebLogFilter.year[n] = String.valueOf(n2);
            --n2;
            ++n;
        }
        this.setCurrentEndTime();
        this.startYear = this.endYear;
        this.maxMatches = 100;
    }

    public void dialog(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.webSession == null) {
            this.webSession = (SMWebSession)httpServletRequest.getSession(false).getValue("SMWebSession");
        }
        stringBuffer.append("<html><head>\n<title>" + this.webSession.translate("filterDialog") + "</title>\n" + "<script src='/scripts/LogUtil.js'></script>\n" + "</head>\n" + "<body>");
        if (this.type == null || this.name == null) {
            stringBuffer.append("<form name=filter method=POST target=messageFrame action=/logmessage?sunmcURL=" + URLEncoder.encode(this.sunmcURL) + ">");
        } else {
            stringBuffer.append("<form name=filter method=POST target=messageFrame action=/logmessage?sunmcURL=" + URLEncoder.encode(this.sunmcURL) + "&type=" + this.type + "&name=" + URLEncoder.encode(this.name) + ">");
        }
        stringBuffer.append("<table border=0 cellspacing=0 cellpadding=0 style=\"margin-left: 12; margin-top: 12px\">\n");
        if (this.type != null && this.type.equals(syslogStr)) {
            stringBuffer.append("<tr nowrap>\n<td align=right nowrap>\n" + this.webSession.translate("startDate") + "<td>\n" + "<select name=start_month>\n");
            int n = 0;
            while (n < month.length) {
                stringBuffer.append("<option" + this.isSelected(month[n], this.getStartMonth()) + this.webSession.translate(month[n]));
                ++n;
            }
            stringBuffer.append("</select>\n<select name=start_day>\n");
            n = 0;
            while (n < day.length) {
                stringBuffer.append("<option" + this.isSelected(day[n], this.getStartDay()) + day[n]);
                ++n;
            }
            stringBuffer.append("</select>\n<select name=start_year>\n");
            n = 0;
            while (n < year.length) {
                stringBuffer.append("<option" + this.isSelected(year[n], this.getStartYear()) + year[n]);
                ++n;
            }
            stringBuffer.append("</select>\n<tr nowrap>\n<td align=right>\n" + this.webSession.translate("startTime") + "<td>\n" + "<select name=start_hour>\n");
            n = 0;
            while (n < hour.length) {
                stringBuffer.append("<option" + this.isSelected(hour[n], this.getStartHour()) + hour[n]);
                ++n;
            }
            stringBuffer.append("</select>: <select name=start_min>\n");
            n = 0;
            while (n < minute.length) {
                stringBuffer.append("<option" + this.isSelected(minute[n], this.getStartMin()) + minute[n]);
                ++n;
            }
            stringBuffer.append("</select>: <select name=start_sec>\n");
            n = 0;
            while (n < second.length) {
                stringBuffer.append("<option" + this.isSelected(second[n], this.getStartSec()) + second[n]);
                ++n;
            }
            stringBuffer.append("</select>\n<tr>\n<td height=12>\n<tr nowrap>\n<td align=right>\n" + this.webSession.translate("endDate") + "<td>\n" + "<select name=end_month>\n");
            n = 0;
            while (n < month.length) {
                stringBuffer.append("<option" + this.isSelected(month[n], this.getEndMonth()) + this.webSession.translate(month[n]));
                ++n;
            }
            stringBuffer.append("</select>\n<select name=end_day>\n");
            n = 0;
            while (n < day.length) {
                stringBuffer.append("<option" + this.isSelected(day[n], this.getEndDay()) + day[n]);
                ++n;
            }
            stringBuffer.append("</select>\n<select name=end_year>\n");
            n = 0;
            while (n < year.length) {
                stringBuffer.append("<option" + this.isSelected(year[n], this.getEndYear()) + year[n]);
                ++n;
            }
            stringBuffer.append("</select>\n<tr nowrap>\n<td align=right>\n" + this.webSession.translate("endTime") + "<td>\n" + "<select name=end_hour>\n");
            n = 0;
            while (n < hour.length) {
                stringBuffer.append("<option" + this.isSelected(hour[n], this.getEndHour()) + hour[n]);
                ++n;
            }
            stringBuffer.append("</select>: <select name=end_min>\n");
            n = 0;
            while (n < minute.length) {
                stringBuffer.append("<option" + this.isSelected(minute[n], this.getEndMin()) + minute[n]);
                ++n;
            }
            stringBuffer.append("</select>: <select name=end_sec>\n");
            n = 0;
            while (n < second.length) {
                stringBuffer.append("<option" + this.isSelected(second[n], this.getEndSec()) + second[n]);
                ++n;
            }
            stringBuffer.append("</select>\n</table>\n");
        }
        stringBuffer.append("<table border=0 cellspacing=0 style=\"margin-left: 12; margin-top: 12px\" cellpadding=0> <tr><td height=8>\n<tr nowrap>\n<td align=right>\n" + this.webSession.translate("textToMatch") + " " + "<td align=left>\n" + "<input type=text name=pattern size=19 value=\"" + this.getPattern() + "\">\n");
        String string = this.getFromLatest() ? " checked> " : "> ";
        String string2 = this.getFromLatest() ? "> " : " checked> ";
        stringBuffer.append("<tr>\n<td height=10>\n<tr nowrap>\n<td align=right>\n" + this.webSession.translate("searchDirection") + " " + "<td align=left>\n" + "<input type=radio name=direction value=forward" + string2 + this.webSession.translate("forward") + "<tr nowrap>\n" + "<td>\n" + "<td align=left>\n" + "<input type=radio name=direction value=backward" + string + this.webSession.translate("backward"));
        stringBuffer.append("<tr>\n<td height=10>\n<tr nowrap>\n<td align=right>\n" + this.webSession.translate("maxMatches") + " " + "<td align=left>\n" + "<input type=text name=max_matches size=19 value=\"" + this.getMaxMatches() + "\">\n");
        stringBuffer.append("<tr><td height=10>\n<tr nowrap>\n<td align=right colspan=2>\n<input type=submit value=" + this.webSession.translate("button.ok.label") + " name=ok> " + "<input type=button value=" + this.webSession.translate("button.cancel.label") + " name=cancel " + "onClick='window.close();'>" + "</table>\n" + "</form>\n" + "</body></html>\n");
        PrintWriter printWriter = SMWebServlet.initOutput(httpServletResponse);
        printWriter.println(stringBuffer.toString());
    }

    public void doWork(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.getParameters(httpServletRequest, httpServletResponse)) {
            String string = this.getLogData(httpServletRequest, httpServletResponse);
            PrintWriter printWriter = SMWebServlet.initOutput(httpServletResponse);
            if (httpServletRequest.getParameter("direction") != null) {
                printWriter.println("<html><head><script>\nfunction reloadControl() {\n    top.contents.controlFrame.location.reload();\n}\n</script></head>\n<body bgcolor=white onload=reloadControl()>\n<pre>" + string + "</pre>\n" + "</body></html>");
            } else {
                printWriter.println("<html>\n<body bgcolor=white>\n<pre>" + string + "</pre>\n" + "</body></html>");
            }
        }
    }

    String getEndDay() {
        return this.endDay;
    }

    String getEndHour() {
        return this.endHour;
    }

    String getEndMin() {
        return this.endMinute;
    }

    String getEndMonth() {
        return this.endMonth;
    }

    String getEndSec() {
        return this.endSecond;
    }

    long getEndTimeStamp() {
        return this.endTimeStamp;
    }

    String getEndYear() {
        return this.endYear;
    }

    boolean getFromLatest() {
        return this.fromLatest;
    }

    public String getLogData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.webSession == null) {
            this.webSession = (SMWebSession)httpServletRequest.getSession(false).getValue("SMWebSession");
        }
        String string = httpServletRequest.getParameter("sunmcURL");
        this.type = httpServletRequest.getParameter("type");
        this.name = httpServletRequest.getParameter("name");
        if (this.type == null) {
            this.type = syslogStr;
        }
        if (this.name != null) {
            int n = this.name.indexOf(47);
            this.name = n != -1 ? this.name.substring(n) : null;
        }
        StringBuffer stringBuffer = null;
        try {
            if (!string.equals(this.sunmcURL) || this.logReq == null) {
                this.sunmcURL = string;
                this.logReq = this.webSession.getSMLogRequest(this.sunmcURL);
            }
            stringBuffer = this.logReq.logSearch(this.type, this.name, this.getMaxMatches(), this.getMaxLines(), this.getStartTimeStamp(), this.getEndTimeStamp(), this.getFromLatest(), this.getPattern(), 0);
        }
        catch (Exception exception) {
            SMWebUtil.log("Error in searching log data", exception);
            return "<script>alert('" + this.webSession.translate("requestException") + "')</script>";
        }
        if (stringBuffer == null) {
            return "";
        }
        return stringBuffer.toString();
    }

    int getMaxLines() {
        return this.maxLines;
    }

    int getMaxMatches() {
        return this.maxMatches;
    }

    public boolean getParameters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (this.webSession == null) {
            this.webSession = (SMWebSession)httpServletRequest.getSession(false).getValue("SMWebSession");
        }
        if (httpServletRequest.getParameter("start_month") != null) {
            object = httpServletRequest.getParameter("start_month");
            this.setStartDay(httpServletRequest.getParameter("start_day"));
            this.setStartYear(httpServletRequest.getParameter("start_year"));
            this.setStartHour(httpServletRequest.getParameter("start_hour"));
            this.setStartMin(httpServletRequest.getParameter("start_min"));
            this.setStartSec(httpServletRequest.getParameter("start_sec"));
            String string = new String(String.valueOf(object) + " " + this.getStartDay() + " " + this.getStartYear() + " " + this.getStartHour() + " " + this.getStartMin() + " " + this.getStartSec());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatStr, this.webSession.getLocale());
            Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            long l = date.getTime() / 1000L;
            this.setStartTimeStamp(l);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.setStartMonth(month[calendar.get(2)]);
            object = httpServletRequest.getParameter("end_month");
            this.setEndDay(httpServletRequest.getParameter("end_day"));
            this.setEndYear(httpServletRequest.getParameter("end_year"));
            this.setEndHour(httpServletRequest.getParameter("end_hour"));
            this.setEndMin(httpServletRequest.getParameter("end_min"));
            this.setEndSec(httpServletRequest.getParameter("end_sec"));
            string = new String(String.valueOf(object) + " " + this.getEndDay() + " " + this.getEndYear() + " " + this.getEndHour() + " " + this.getEndMin() + " " + this.getEndSec());
            simpleDateFormat = new SimpleDateFormat(dateFormatStr, this.webSession.getLocale());
            date = simpleDateFormat.parse(string, new ParsePosition(0));
            l = date.getTime() / 1000L;
            this.setEndTimeStamp(l);
            calendar.setTime(date);
            this.setEndMonth(month[calendar.get(2)]);
        }
        if (httpServletRequest.getParameter("direction") != null) {
            int n;
            this.setPattern(httpServletRequest.getParameter("pattern"));
            if (httpServletRequest.getParameter("direction").compareTo("backward") == 0) {
                this.setFromLatest(true);
            } else {
                this.setFromLatest(false);
            }
            object = SMWebServlet.initOutput(httpServletResponse);
            try {
                n = Integer.parseInt(httpServletRequest.getParameter("max_matches"));
            }
            catch (NumberFormatException numberFormatException) {
                SMWebUtil.log(this.webSession.translate("enterDecimal"), numberFormatException);
                ((PrintWriter)object).println("<script>alert('" + this.webSession.translate("enterDecimal") + "')</script>");
                return false;
            }
            if (n <= 0) {
                SMWebUtil.log(this.webSession.translate("enterDecimal"));
                ((PrintWriter)object).println("<script>alert('" + this.webSession.translate("enterDecimal") + "')</script>");
                return false;
            }
            this.setMaxMatches(n);
        }
        return true;
    }

    String getPattern() {
        return this.pattern;
    }

    String getStartDay() {
        return this.startDay;
    }

    String getStartHour() {
        return this.startHour;
    }

    String getStartMin() {
        return this.startMinute;
    }

    String getStartMonth() {
        return this.startMonth;
    }

    String getStartSec() {
        return this.startSecond;
    }

    long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    String getStartYear() {
        return this.startYear;
    }

    String isSelected(String string, String string2) {
        return string.compareTo(string2) == 0 ? " selected>" : ">";
    }

    void setCurrentEndTime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        String string = String.valueOf(n);
        int n2 = 0;
        while (n2 < year.length) {
            if (string.compareTo(year[n2]) == 0) {
                this.endYear = year[n2];
                break;
            }
            ++n2;
        }
        if (n2 == 3) {
            this.startYear = year[0];
            this.endYear = year[0];
            n2 = 0;
            int n3 = n;
            while (n2 < year.length) {
                SMWebLogFilter.year[n2] = String.valueOf(n3);
                --n3;
                ++n2;
            }
        }
        this.endMonth = month[calendar.get(2)];
        this.endDay = day[calendar.get(5) - 1];
        this.endHour = hour[calendar.get(11)];
        this.endMinute = minute[calendar.get(12)];
        this.endSecond = second[calendar.get(13)];
    }

    void setEndDay(String string) {
        this.endDay = string;
    }

    void setEndHour(String string) {
        this.endHour = string;
    }

    void setEndMin(String string) {
        this.endMinute = string;
    }

    void setEndMonth(String string) {
        this.endMonth = string;
    }

    void setEndSec(String string) {
        this.endSecond = string;
    }

    void setEndTimeStamp(long l) {
        this.endTimeStamp = l;
    }

    void setEndYear(String string) {
        this.endYear = string;
    }

    void setFromLatest(boolean bl) {
        this.fromLatest = bl;
    }

    void setMaxLines(int n) {
        this.maxLines = n;
    }

    void setMaxMatches(int n) {
        this.maxMatches = n;
    }

    void setNoFilters() {
        this.maxMatches = 0;
    }

    void setPattern(String string) {
        this.pattern = new String(string);
    }

    void setStartDay(String string) {
        this.startDay = string;
    }

    void setStartHour(String string) {
        this.startHour = string;
    }

    void setStartMin(String string) {
        this.startMinute = string;
    }

    void setStartMonth(String string) {
        this.startMonth = string;
    }

    void setStartSec(String string) {
        this.startSecond = string;
    }

    void setStartTimeStamp(long l) {
        this.startTimeStamp = l;
    }

    void setStartYear(String string) {
        this.startYear = string;
    }
}

