/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ssl;

import com.visigenic.vbroker.orb.BaseSocket;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.TcpSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import oracle.aurora.ssl.AuroraCertificateManager;
import oracle.aurora.ssl.AuroraCertificateManagerHelper;
import oracle.aurora.ssl.AuroraCertificateManagerImpl;
import oracle.aurora.ssl.AuroraSSLConnection;
import oracle.aurora.ssl.AuroraSSLConnectionImpl;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INITIALIZE;

public class AuroraSSLSocket
extends TcpSocket
implements OrbObject {
    protected AuroraSSLConnection _connection;

    public Object clone() {
        AuroraSSLSocket socket = new AuroraSSLSocket();
        socket.init(((BaseSocket)this)._orb, null);
        socket.doConnect(this.getHostName(), this.getPortNumber());
        return socket;
    }

    public void close() {
        try {
            this._connection.close();
            super.close();
        }
        catch (Exception e) {
            throw new COMM_FAILURE(e.toString());
        }
    }

    AuroraSSLConnection connection() {
        return this._connection;
    }

    public void doAccept(ServerSocket server) {
    }

    public void doConnect(String hostName, int portNumber) {
        super.doConnect(hostName, portNumber);
        this._connection.setClientSide(true);
        this.handshake();
    }

    public void doConnect(String localHost, int localPort, String hostName, int portNumber) {
        super.doConnect(localHost, localPort, hostName, portNumber);
        this._connection.setClientSide(true);
        this.handshake();
    }

    public InputStream getInputStream() {
        return this._connection.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this._connection.getOutputStream();
    }

    protected void handshake() {
        this._connection.setSocket(this._socket);
        try {
            this._connection.handshake();
        }
        catch (IOException e) {
            throw new COMM_FAILURE("SSL Handshake failed: " + e.toString());
        }
    }

    public void init(ORB orb, Object[] args) {
        ((BaseSocket)this)._orb = orb;
        try {
            this._connection = new AuroraSSLConnectionImpl();
            AuroraCertificateManager cm = AuroraCertificateManagerHelper.narrow(orb.resolve_initial_references("AuroraSSLCertificateManager"));
            this._connection.setCredentials(((AuroraCertificateManagerImpl)cm).getCredentials());
        }
        catch (Exception e) {
            throw new INITIALIZE(e.toString());
        }
    }

    public String toString() {
        return "AuroraSSLSocket[connection=" + this._connection + ",socket=" + this._socket + "]";
    }
}

