/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.DecimalFormat;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;

public class ToolLog {
    private PrintWriter writer;
    private boolean verbose;
    private boolean debug;
    int errorCount;
    int warningCount;
    boolean connectionFailure;

    public ToolLog(OutputStream out, boolean verbose, boolean debug) {
        this(new PrintWriter(out, true), verbose, debug);
    }

    public ToolLog(PrintStream out, boolean verbose, boolean debug) {
        this(new PrintWriter(out, true), verbose, debug);
    }

    public ToolLog(PrintWriter out, boolean verbose, boolean debug) {
        this.writer = out;
        this.verbose = verbose;
        this.debug = debug;
    }

    public boolean checkCode(String msg, int code) {
        String pat = "ORA-" + new DecimalFormat("00000").format(code);
        boolean found = msg != null && msg.indexOf(pat) >= 0;
        return found;
    }

    public boolean checkCode(SQLException ex, int code) {
        boolean result = false;
        boolean found = false;
        SQLException next = ex;
        while (next != null && !found) {
            found = ex.getErrorCode() == code || this.checkCode(ex.getMessage(), code);
            next = ex.getNextException();
        }
        return found;
    }

    public void err(Exception ex, String what) {
        boolean warning = false;
        if (ex instanceof SQLException) {
            SQLException sex = (SQLException)ex;
            if (this.checkCode(sex, 1013)) {
                throw new ToolsError("interrupted by user");
            }
            if (this.checkCode(sex, 3113) || this.checkCode(sex, 3114) || sex.getErrorCode() == 0) {
                this.connectionFailure = true;
            } else if (this.checkCode(sex, 29552)) {
                warning = true;
            }
        }
        String tag = warning ? "Warning" : "Error";
        this.writer.println(String.valueOf(tag) + " while " + what);
        if (ex instanceof SQLException && ((SQLException)ex).getErrorCode() != 0) {
            this.writer.println("    " + ex.getMessage());
        } else {
            this.writer.println("    Exception " + ex.toString());
        }
        if (this.debug) {
            Exception exForTrace = ex;
            if (ex instanceof ToolsException && ((ToolsException)ex).getChain() != null) {
                exForTrace = ((ToolsException)ex).getChain();
            }
            exForTrace.printStackTrace(this.writer);
        }
        if (!warning) {
            ++this.errorCount;
        } else {
            ++this.warningCount;
        }
    }

    public void err(String m) {
        if (this.checkCode(m, 29552)) {
            ++this.warningCount;
        } else {
            ++this.errorCount;
        }
        this.writer.println(m);
    }

    public boolean getConnectionFailure() {
        return this.connectionFailure;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void msg(String m) {
        if (this.verbose) {
            this.writer.println(m);
        }
    }

    public void setConnectionFailure(boolean cf) {
        this.connectionFailure = cf;
    }
}

