/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import md5.MD5InputStream;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.SourceFileReader;
import oracle.aurora.server.tools.loadjava.ToolLog;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.sqljdecl.ParseException;
import oracle.aurora.util.Categorization;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.OrderedCollection;
import oracle.aurora.util.TopSort;
import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.tools.ToolException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;

public class LoadJava {
    byte[] md5;
    private static String loadLobsPackage = "create package loadlobs is   column blob;   end_of_lob binary_integer;   function beginload (classfile varchar2) return varchar2;   procedure appendpiece (piece raw, len binary_integer);   function endload (classfile varchar2) return varchar2;   function beginread (classfile varchar2, len out binary_integer)          return varchar2;   function getpiece (piece out raw, len in out binary_integer)          return varchar2;   function endread (classfile varchar2) return varchar2; end loadlobs;";
    private static String loadLobsBody = "create package body loadlobs is   function beginload (classfile varchar2) return varchar2 is   begin      column := null;      end_of_lob := 1;          delete from CREATE$JAVA$LOB$TABLE where name = classfile;     insert into CREATE$JAVA$LOB$TABLE (name, lob, loadtime)         values (classfile, empty_blob(), sysdate);     select lob into column from CREATE$JAVA$LOB$TABLE          where name = classfile;     return '';   exception when others then return sqlerrm;   end;   procedure appendpiece (piece raw, len binary_integer) is   begin      dbms_lob.write(column, len, end_of_lob, piece);      end_of_lob := end_of_lob + len;   end;   function endload (classfile varchar2) return varchar2 is   begin     if end_of_lob - 1 != dbms_lob.getlength(column)    then return 'length mismatch: sum of piece lengths = ' ||          end_of_lob - 1 ||          ', while dbms_lob.getlength = ' || dbms_lob.getlength(column);    end if;    commit;    return '';    exception when others then return sqlerrm;   end;   function beginread (classfile varchar2, len out binary_integer)          return varchar2 is   begin     end_of_lob := 1;          select lob into column from CREATE$JAVA$LOB$TABLE          where name = classfile;     len := dbms_lob.getlength(column);     return '';   exception when others then return sqlerrm;   end;   function getpiece (piece out raw, len in out binary_integer)          return varchar2 is   begin     dbms_lob.read(column, len, end_of_lob, piece);      end_of_lob := end_of_lob + len;     return '';   exception when others then return sqlerrm;   end;   function endread (classfile varchar2) return varchar2 is   begin    if end_of_lob - 1 != dbms_lob.getlength(column)    then return 'length mismatch: sum of piece lengths = ' ||          end_of_lob - 1 ||          ', while dbms_lob.getlength = ' || dbms_lob.getlength(column);    end if;    return '';   exception when others then return sqlerrm;   end; end loadlobs;";
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    String fieldGrantNames = null;
    boolean fieldVerbose = false;
    boolean fieldDebug = false;
    boolean fieldResolve = false;
    boolean fieldAndresolve = false;
    boolean fieldDefiner = false;
    boolean fieldJdkresolver = false;
    boolean fieldForceLoading = false;
    boolean fieldOrder = false;
    boolean fieldNoverify = false;
    boolean fieldCreateSynonym = false;
    String fieldSchema = null;
    String fieldResolver = null;
    File[] fieldJarFiles = null;
    File[] fieldFiles = null;
    DatabaseOptions fieldDatabase = null;
    String fieldUser = null;
    PrintStream fieldOutput = null;
    boolean initialized = false;
    boolean fieldBound = false;
    boolean fieldCompile = false;
    String fieldEncoding = null;
    String fieldLocalPathPrefix = null;
    String[] fileNames;
    ToolLog log;
    Connection connection;
    private static int CLASS = 1;
    private static int SOURCE = 4;
    private static int RESOURCE = 8;
    private static int DEPENDENT = 16;
    Categorization schemaObjects;
    TopSort sorter;

    public LoadJava() {
        this.initialize();
    }

    private String MD5Name() {
        String name = String.valueOf(this.schemaAsPrefix()) + "JAVA$CLASS$MD5$TABLE";
        return name;
    }

    private void addDependencies(Dig dig) {
        TopSort sorter = this.getSorter();
        Dig.Class clazz = dig.getClazz();
        String classname = clazz.getName().replace('.', '/').intern();
        this.addDependency(classname, classname);
        Dig.ConstantPool constants = clazz.getConstants();
        int x = 0;
        while (x < constants.size()) {
            if (constants.is(x, 7)) {
                String ref = constants.getClass(x).intern();
                this.addDependency(ref, classname);
            } else if (constants.isRef(x)) {
                String descriptor = constants.getDescriptorOfRef(x);
                this.addDescriptorDependencies(descriptor, classname);
            }
            ++x;
        }
        Dig.Methods methods = clazz.getMethods();
        int x2 = 0;
        while (x2 < methods.count()) {
            Dig.Member m = methods.get(x2);
            this.addDescriptorDependencies(m.getDescriptor(), classname);
            ++x2;
        }
        Dig.Fields fields = clazz.getFields();
        int x3 = 0;
        while (x3 < fields.count()) {
            Dig.Member m = fields.get(x3);
            this.addDescriptorDependencies(m.getDescriptor(), classname);
            ++x3;
        }
    }

    private void addDependency(String from, String to) {
        this.getSorter().addEdge((Object)from, (Object)to);
    }

    private void addDescriptorDependencies(String descriptor, String to) {
        DescriptorScanner m = new DescriptorScanner(descriptor);
        Cursor refs = m.referenced();
        while (refs.next()) {
            String ref = ((String)refs.get()).intern();
            this.addDependency(ref, to);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    String andresolveOption() {
        return this.getAndresolve() ? " and resolve " : "";
    }

    private String compile() {
        if (this.getCompile()) {
            return " and compile ";
        }
        return " ";
    }

    public boolean compileSource(String classname) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        if (this.getCompile()) {
            this.msg("compiling: " + classname);
        } else {
            this.msg("creating : " + classname);
        }
        try {
            try {
                stmt = conn.createStatement();
                if (this.getEncoding() != null) {
                    stmt.execute("call dbms_java.set_compiler_option('" + classname + "'," + " 'encoding', " + "'" + this.getEncoding() + "')");
                }
                stmt.execute("create or replace " + this.andresolveOption() + this.compile() + " java source named " + this.schemaAsPrefix() + "\"" + classname + "\" " + this.definerOption() + this.resolver() + this.rights() + " using '" + classname + "'");
                this.grant(classname);
                if (this.getEncoding() != null) {
                    stmt.execute("call dbms_java.reset_compiler_option('" + classname + "'," + "'encoding')");
                }
                conn.commit();
                this.getErrors(classname);
            }
            finally {
                Object var5_4 = null;
                if (stmt != null) {
                    stmt.close();
                }
                this.finishedWithLob(classname);
            }
        }
        catch (SQLException e) {
            this.err(e, "creating " + classname);
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    public boolean createClass(String classname) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        this.msg("creating : " + classname);
        try {
            try {
                stmt = conn.createStatement();
                stmt.execute("create or replace " + this.andresolveOption() + " java class " + this.schemaClause() + this.definerOption() + this.resolver() + this.rights() + " using '" + classname + "'");
                this.getErrors(classname);
                conn.commit();
            }
            finally {
                Object var5_4 = null;
                if (stmt != null) {
                    stmt.close();
                }
                this.finishedWithLob(classname);
            }
        }
        catch (SQLException e) {
            this.err(e, "creating class " + classname);
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    public void createClassSynonym(String classname) {
        Connection conn = this.getConnection();
        this.msg("synonym  : " + classname);
        try {
            Statement stmt = null;
            try {
                block8: {
                    stmt = conn.createStatement();
                    try {
                        stmt.execute("drop public synonym \"" + classname + "\"");
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1432) break block8;
                        this.err(e, "dropping synonym " + classname);
                    }
                }
                stmt.execute("create public synonym \"" + classname + "\" for \"" + classname + "\"");
            }
            finally {
                Object var5_6 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "creating public synonym for " + classname);
        }
    }

    public void createClassSynonymsInJar(ZipFile jar) {
        Enumeration<? extends ZipEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry currentEntry = e.nextElement();
            if (currentEntry.isDirectory()) continue;
            this.createSynonym(currentEntry.getName(), this.transformName(currentEntry.getName()));
        }
    }

    private void createMD5Table() {
        Connection conn = this.getConnection();
        try {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("create table " + this.MD5Name() + " (name varchar2(200) unique, md5 raw(16))");
            }
            finally {
                Object var4_3 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException sQLException) {}
    }

    public boolean createResource(String resourceName) {
        Connection conn = this.getConnection();
        this.msg("creating : " + resourceName);
        try {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("create or replace java resource named \"" + resourceName + "\"  using '" + resourceName + "'");
                if (this.fieldGrantNames != null) {
                    stmt.execute("grant execute on java resource \"" + resourceName + "\" to " + this.fieldGrantNames);
                }
                this.getErrors(resourceName);
            }
            finally {
                Object var5_5 = null;
                if (stmt != null) {
                    stmt.close();
                }
                this.finishedWithLob(resourceName);
            }
        }
        catch (SQLException e) {
            this.err(e, "creating resource " + resourceName);
            return false;
        }
        return true;
    }

    public void createSourceSynonym(String filename, InputStream in) throws IOException {
        try {
            SourceFileReader sfr = new SourceFileReader(filename, in, this.getEncoding());
            Enumeration names = sfr.getNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.createClassSynonym(name);
            }
        }
        catch (ParseException ex) {
            this.err((Exception)((Object)ex), "creating synonyms for " + filename);
        }
    }

    public void createSynonym(String filename, String unitname) {
        if (this.isClassFile(filename)) {
            this.createClassSynonym(unitname);
        } else if (this.isSourceFile(filename)) {
            try {
                this.createSourceSynonym(filename, new FileInputStream(this.newFile(filename)));
            }
            catch (IOException ex) {
                this.err(ex, "creating synonym for " + unitname + " from " + filename);
            }
        } else {
            this.grantResourceExecute(unitname);
        }
    }

    public void createSynonym(ZipFile zipfile, ZipEntry entry) {
        String filename = entry.getName();
        String unitname = this.transformName(filename);
        if (this.isClassFile(filename)) {
            this.createClassSynonym(unitname);
        } else if (this.isSourceFile(filename)) {
            try {
                this.createSourceSynonym(filename, zipfile.getInputStream(entry));
            }
            catch (IOException ex) {
                this.err(ex, "creating synonym for " + unitname + " from " + filename);
            }
        } else {
            this.grantResourceExecute(unitname);
        }
    }

    String definerOption() {
        return this.getDefiner() ? " authid definer " : " ";
    }

    private void err(Exception ex, String when) {
        this.getLog().err(ex, when);
    }

    private void err(String msg) {
        this.getLog().err(msg);
    }

    private boolean fileIsDifferent(String className, InputStream inputStream) {
        boolean result = true;
        this.md5 = this.md5OfStream(inputStream);
        if (this.getForceLoading()) {
            return true;
        }
        Connection conn = this.getConnection();
        try {
            Statement stmt;
            block8: {
                stmt = null;
                try {
                    stmt = conn.createStatement();
                    stmt.execute("SELECT MD5 FROM " + this.MD5Name() + " WHERE NAME = '" + className + "'");
                    ResultSet rs = stmt.getResultSet();
                    if (!rs.next()) break block8;
                    result = this.md5IsEqual(rs.getBytes(1), this.md5) ^ true;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
            }
            Object var7_8 = null;
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.err(e, "accessing MD5 table");
        }
        if (!result) {
            this.msg("identical: " + className + " is unchanged from previously loaded file");
        }
        return result;
    }

    void finishedWithLob(String name) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                stmt.execute(" delete from CREATE$JAVA$LOB$TABLE where name = '" + name + "'");
                conn.commit();
            }
            finally {
                Object var5_4 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException sQLException) {}
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChange.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean getAndresolve() {
        return this.fieldAndresolve;
    }

    public boolean getBound() {
        return this.fieldBound;
    }

    private Cursor getClassNames() {
        return this.getNames(CLASS);
    }

    public boolean getCompile() {
        return this.fieldCompile;
    }

    public Connection getConnection() {
        if (this.connection == null || this.getLog().getConnectionFailure()) {
            try {
                this.connection = this.getDatabase().connect();
            }
            catch (ToolsException ex) {
                this.err(ex.getMessage());
                throw new ToolsError("could not open connection");
            }
            catch (SQLException ex) {
                this.err(ex, "opening connection");
                throw new ToolsError("could not open connection");
            }
            this.getLog().setConnectionFailure(false);
            this.initialized = false;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.init();
        }
        return this.connection;
    }

    public boolean getCreateSynonym() {
        return this.fieldCreateSynonym;
    }

    public DatabaseOptions getDatabase() {
        return this.fieldDatabase;
    }

    public boolean getDebug() {
        return this.fieldDebug;
    }

    public boolean getDefiner() {
        return this.fieldDefiner;
    }

    private Cursor getDependentClassNames() {
        return this.getNames(DEPENDENT);
    }

    public String getEncoding() {
        return this.fieldEncoding;
    }

    private void getErrors(String classname) {
        Connection conn = this.getConnection();
        try {
            Statement stmt = null;
            ResultSet rset = null;
            try {
                stmt = conn.createStatement();
                rset = stmt.executeQuery("select text from user_errors where name = dbms_java.shortname('" + classname.replace('.', '/') + "')");
                boolean firstMsg = true;
                while (rset.next()) {
                    if (firstMsg) {
                        firstMsg = false;
                        this.msg("Errors in " + classname + ":");
                    }
                    this.err("    " + rset.getString(1));
                }
            }
            finally {
                Object var6_7 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (rset != null) {
                    rset.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "retrieving errors for " + classname);
        }
    }

    String[] getFileNames() {
        if (this.fileNames == null) {
            File[] files = this.getFiles();
            this.fileNames = new String[files.length];
            int x = 0;
            while (x < files.length) {
                this.fileNames[x] = files[x].toString();
                ++x;
            }
        }
        return this.fileNames;
    }

    public File[] getFiles() {
        if (this.fieldFiles == null) {
            this.fieldFiles = new File[0];
        }
        return this.fieldFiles;
    }

    public File getFiles(int index) {
        return this.getFiles()[index];
    }

    public boolean getForceLoading() {
        return this.fieldForceLoading;
    }

    public String getGrantNames() {
        return this.fieldGrantNames;
    }

    public File[] getJarFiles() {
        if (this.fieldJarFiles == null) {
            this.fieldJarFiles = new File[0];
        }
        return this.fieldJarFiles;
    }

    public File getJarFiles(int index) {
        return this.getJarFiles()[index];
    }

    public boolean getJdkresolver() {
        return this.fieldJdkresolver;
    }

    public String getLocalPathPrefix() {
        return this.fieldLocalPathPrefix == null ? "" : this.fieldLocalPathPrefix;
    }

    private ToolLog getLog() {
        if (this.log == null) {
            this.log = new ToolLog(this.getOutput(), this.getVerbose(), this.getDebug());
        }
        return this.log;
    }

    private Cursor getNames() {
        return this.getNames(-1);
    }

    private Cursor getNames(int categories) {
        return this.getSchemaObjects().enumerate(categories);
    }

    public boolean getNoverify() {
        return this.fieldNoverify;
    }

    public boolean getOrder() {
        return this.fieldOrder;
    }

    public PrintStream getOutput() {
        block2: {
            if (this.fieldOutput != null) break block2;
            try {
                this.fieldOutput = new PrintStream(System.out);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating output property.");
            }
        }
        return this.fieldOutput;
    }

    public boolean getResolve() {
        return this.fieldResolve;
    }

    public String getResolver() {
        if (this.fieldResolver == null) {
            try {
                this.fieldResolver = new String();
            }
            catch (Exception ex) {
                this.err(ex, "creating resolver property");
            }
            catch (Throwable exception) {
                throw new ToolsError(String.valueOf(String.valueOf(exception)) + " while creating resolver property");
            }
        }
        return this.fieldResolver;
    }

    private Cursor getResourceNames() {
        return this.getNames(RESOURCE);
    }

    public String getSchema() {
        if (this.fieldSchema == null) {
            try {
                this.fieldSchema = new String();
            }
            catch (Exception ex) {
                this.err(ex, "creating resolver property");
            }
            catch (Throwable exception) {
                throw new ToolsError(String.valueOf(String.valueOf(exception)) + " while creating resolver property");
            }
        }
        return this.fieldSchema;
    }

    private Categorization getSchemaObjects() {
        if (this.schemaObjects == null) {
            this.schemaObjects = new Categorization();
        }
        return this.schemaObjects;
    }

    private Cursor getSortedClassNames() {
        TopSort sorter = this.getSorter();
        sorter.sort();
        OrderedCollection names = new OrderedCollection();
        Cursor sets = sorter.enumerate();
        this.msg("classes to be resolved sorted into groups");
        int xGroup = 1;
        while (sets.next()) {
            Cursor set = (Cursor)sets.get();
            int count = 0;
            StringBuffer buf = new StringBuffer();
            while (set.next()) {
                String name = (String)set.get();
                if (!this.getSchemaObjects().test((Object)name, CLASS)) continue;
                ++count;
                buf.append(' ');
                buf.append(name);
                names.append((Object)name);
            }
            if (count <= 0) continue;
            this.msg("group " + xGroup++ + ":" + buf.toString());
        }
        return names.enumerate();
    }

    private TopSort getSorter() {
        if (this.sorter == null) {
            this.sorter = new TopSort();
        }
        return this.sorter;
    }

    private Cursor getSourceNames() {
        return this.getNames(SOURCE);
    }

    public String getUser() {
        return this.getDatabase().user;
    }

    public boolean getVerbose() {
        return this.fieldVerbose;
    }

    public void grant(String name) {
        block6: {
            if (this.getGrantNames() == null) break block6;
            Connection conn = this.getConnection();
            Statement stmt = null;
            try {
                try {
                    stmt = conn.createStatement();
                    stmt.execute("grant execute on \"" + name + "\" to " + this.getGrantNames());
                }
                finally {
                    Object var5_4 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException e) {
                this.err(e, "granting to " + name);
            }
        }
    }

    public void grantResourceExecute(String resourceName) {
        Connection conn = this.getConnection();
        try {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("grant execute on java resource \"" + resourceName + "\" to public");
            }
            finally {
                Object var5_5 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "granting execute on java resource " + resourceName);
        }
    }

    private void handleException(Throwable exception) {
    }

    private void init() {
        Connection conn = this.getConnection();
        try {
            Statement stmt = null;
            try {
                block10: {
                    stmt = conn.createStatement();
                    try {
                        stmt.execute("create table CREATE$JAVA$LOB$TABLE (name varchar2(200) unique, lob blob, loadtime date)");
                    }
                    catch (SQLException sQLException) {}
                    try {
                        stmt.execute(loadLobsPackage);
                        stmt.execute(loadLobsBody);
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 955) break block10;
                        this.err(e, "creating LOADLOBS package");
                        this.getErrors("LOADLOBS");
                        throw new ToolsError("aborting because of failure during initialization");
                    }
                }
                this.createMD5Table();
            }
            finally {
                Object var4_5 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "loading the LOADLOBS package");
        }
        this.msg("initialization complete");
    }

    private void initialize() {
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    private boolean isSourceFile(String name) {
        return name.endsWith(".java") || name.endsWith(".sqlj");
    }

    public boolean load(String classname, InputStream inputStream) {
        return this.load(classname, inputStream, Long.MAX_VALUE);
    }

    public boolean load(String classname, InputStream inputStream, long size) {
        byte[] buf = new byte[4096];
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            try {
                this.msg("loading  : " + classname);
                this.finishedWithLob(classname);
                stmt = conn.prepareStatement("insert into CREATE$JAVA$LOB$TABLE (name, lob, loadtime)  values( ?, empty_blob(), sysdate)");
                stmt.setString(1, classname);
                stmt.execute();
                stmt.close();
                stmt = conn.prepareStatement("select lob from CREATE$JAVA$LOB$TABLE where name = ? ");
                stmt.setString(1, classname);
                OracleResultSet r = (OracleResultSet)stmt.executeQuery();
                r.next();
                BLOB blob = r.getBLOB(1);
                OutputStream outputStream = blob.getBinaryOutputStream();
                boolean atEof = false;
                long remaining = size;
                while (!atEof) {
                    int want = (long)buf.length <= size ? buf.length : (int)size;
                    int n = inputStream.read(buf, 0, want);
                    if (n > 0) {
                        size -= (long)n;
                        outputStream.write(buf, 0, n);
                        continue;
                    }
                    atEof = true;
                }
                outputStream.close();
                stmt.close();
                conn.commit();
            }
            finally {
                Object var13_14 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "loading " + classname);
            return false;
        }
        catch (IOException e) {
            this.err(e, "loading " + classname);
            return false;
        }
        return true;
    }

    public void loadAndCreateJar(ZipFile jar) {
        boolean count = false;
        try {
            String className;
            ZipEntry currentEntry;
            Enumeration<? extends ZipEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                currentEntry = e.nextElement();
                if (currentEntry.isDirectory()) continue;
                className = this.transformName(currentEntry.getName());
                if (this.isClassFile(currentEntry.getName())) {
                    this.noteClass(className, jar.getInputStream(currentEntry));
                    if (!this.fileIsDifferent(className, jar.getInputStream(currentEntry))) continue;
                    this.load(className, jar.getInputStream(currentEntry), currentEntry.getSize());
                    if (!this.createClass(className)) continue;
                    this.updateMD5(className);
                    continue;
                }
                if (!this.isSourceFile(currentEntry.getName()) || !this.fileIsDifferent(className = this.noteSource(currentEntry.getName(), jar.getInputStream(currentEntry)), jar.getInputStream(currentEntry))) continue;
                this.load(className, jar.getInputStream(currentEntry));
                if (!this.compileSource(className)) continue;
                this.updateMD5(className);
            }
            e = jar.entries();
            while (e.hasMoreElements()) {
                currentEntry = e.nextElement();
                className = this.transformName(currentEntry.getName());
                if (currentEntry.isDirectory() || this.isClassFile(currentEntry.getName()) || this.isSourceFile(currentEntry.getName()) || !this.fileIsDifferent(className, jar.getInputStream(currentEntry))) continue;
                this.load(className, jar.getInputStream(currentEntry), currentEntry.getSize());
                if (!this.createResource(className)) continue;
                this.updateMD5(className);
            }
        }
        catch (IOException ex) {
            this.err(ex, "processing jar " + jar.getName());
        }
    }

    private boolean md5IsEqual(byte[] a1, byte[] a2) {
        int i = 0;
        while (i < 16) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private byte[] md5OfStream(InputStream in) {
        int l;
        MD5InputStream md5in = new MD5InputStream(in);
        do {
            try {
                l = md5in.read();
            }
            catch (IOException iOException) {
                l = -1;
            }
        } while (l >= 0);
        return md5in.hash();
    }

    private void msg(String msg) {
        this.getLog().msg(msg);
    }

    private File newFile(String filename) {
        filename = filename.replace('/', File.separatorChar);
        File f = new File(filename);
        String prefix = this.getLocalPathPrefix();
        if (!f.isAbsolute()) {
            f = new File(String.valueOf(prefix) + filename);
        }
        return f;
    }

    private void noteClass(String name) {
        this.getSchemaObjects().or((Object)name, CLASS);
    }

    private void noteClass(String name, InputStream in) {
        block6: {
            if (this.getOrder() && in != null) {
                try {
                    this.noteClass(name, new Dig(new Raw.Class(in)));
                }
                catch (IOException ex) {
                    this.err(ex, "resolving " + name);
                }
                catch (ToolException ex) {
                    if (ex.getChain() != null) {
                        this.err(ex.getChain(), "resolving " + name);
                        break block6;
                    }
                    this.err((Exception)((Object)ex), "resolving " + name);
                }
            } else {
                this.noteClass(name);
            }
        }
    }

    private void noteClass(String name, Dig dig) {
        name = name.intern();
        this.noteClass(name);
        if (this.getOrder() && dig != null) {
            this.addDependencies(dig);
        } else if (this.getOrder() && dig == null) {
            this.addDependency(name, name);
        }
    }

    private void noteDependent(String name) {
        this.getSchemaObjects().or((Object)name, DEPENDENT);
    }

    private void noteResource(String name) {
        this.getSchemaObjects().or((Object)name, RESOURCE);
    }

    private void noteSource(String name) {
        this.getSchemaObjects().or((Object)name, SOURCE);
    }

    private String noteSource(String filename, InputStream in) {
        String name = this.transformName(filename);
        try {
            SourceFileReader r = new SourceFileReader(filename, in, this.getEncoding());
            if (r.getFirstName() != null) {
                name = r.getFirstName();
            }
            this.noteSource(name);
            Enumeration dnames = r.getNames();
            while (dnames.hasMoreElements()) {
                this.noteDependent((String)dnames.nextElement());
            }
        }
        catch (IOException ex) {
            this.err(ex, "parsing " + filename);
        }
        catch (ParseException ex) {
            this.err((Exception)((Object)ex), "parsing " + filename);
        }
        return name;
    }

    public void process() throws ToolsException {
        try {
            File[] jarFiles = this.getJarFiles();
            File[] files = this.getFiles();
            if (this.getDebug()) {
                DriverManager.setLogStream(this.getOutput());
                OracleLog.setLogStream((PrintStream)System.out);
                OracleLog.config((int)10, (int)1, (int)32);
                OracleLog.setSubmodMask((int)1, (int)20);
            }
            this.processLoadAndCreate();
            if (this.getResolve()) {
                this.processResolve();
            }
            if (this.getCreateSynonym()) {
                this.processCreateSynonym();
            }
            if (this.getGrantNames() != null) {
                this.processGrant();
            }
        }
        catch (ToolsError ex) {
            this.err(ex.getMessage());
        }
        if (this.getLog().getErrorCount() > 0) {
            throw new ToolsException(String.valueOf(this.getLog().getErrorCount()) + " errors");
        }
    }

    private void processCreateSynonym() {
        Cursor cnames = this.getClassNames();
        while (cnames.next()) {
            this.createClassSynonym((String)cnames.get());
        }
        Cursor dnames = this.getDependentClassNames();
        while (dnames.next()) {
            this.createClassSynonym((String)dnames.get());
        }
        Cursor rnames = this.getResourceNames();
        while (rnames.next()) {
            this.grantResourceExecute((String)rnames.get());
        }
    }

    private void processGrant() {
        Cursor names = this.getNames();
        while (names.next()) {
            this.grant((String)names.get());
        }
    }

    private void processLoadAndCreate() {
        if (this.getAndresolve()) {
            this.msg("resolver : " + this.resolver());
        }
        File[] jarFiles = this.getJarFiles();
        File[] files = this.getFiles();
        int i = 0;
        while (i < files.length) {
            try {
                Object var6_14;
                FileInputStream file;
                block24: {
                    if (files[i].isDirectory()) {
                        throw new ToolsException(String.valueOf(String.valueOf(files[i])) + " is a directory");
                    }
                    file = null;
                    try {
                        file = new FileInputStream(files[i]);
                        byte[] classBits = new byte[file.available()];
                        file.read(classBits);
                        file.close();
                        ByteArrayInputStream is = new ByteArrayInputStream(classBits);
                        is.mark(is.available() * 2);
                        String name = null;
                        if (this.isClassFile(files[i].toString())) {
                            Raw.Class r = new Raw.Class((InputStream)is);
                            Dig d = new Dig(r);
                            name = d.getClazz().getName().replace('.', '/');
                            this.noteClass(name, d);
                            is.reset();
                        } else if (this.isSourceFile(files[i].toString())) {
                            name = this.noteSource(files[i].toString(), is);
                            is.reset();
                        } else {
                            name = this.transformName(files[i].toString());
                        }
                        if (!this.fileIsDifferent(name, is)) break block24;
                        is.reset();
                        this.load(name, is);
                        is.reset();
                        boolean succeed = false;
                        succeed = this.isClassFile(files[i].toString()) ? this.createClass(name) : (this.isSourceFile(files[i].toString()) ? this.compileSource(name) : this.createResource(name));
                        if (!succeed) break block24;
                        this.updateMD5(name);
                    }
                    catch (Throwable throwable) {
                        var6_14 = null;
                        if (file != null) {
                            file.close();
                        }
                        throw throwable;
                    }
                }
                var6_14 = null;
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                this.err(e, "opening or reading " + files[i]);
            }
            catch (ToolsException e) {
                System.out.println("ToolsException");
                this.err(e, "opening or reading " + files[i]);
            }
            catch (ToolException e) {
                ToolsException te = new ToolsException("file format error", (Exception)((Object)e));
                this.err(te, "opening or reading " + files[i]);
            }
            catch (ToolsError ex) {
                throw ex;
            }
            catch (Throwable t) {
                this.err("internal error: unanticipated exception: " + t);
                t.printStackTrace(this.getOutput());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < jarFiles.length) {
            try {
                ZipFile jar = null;
                try {
                    jar = new ZipFile(jarFiles[i2]);
                    this.loadAndCreateJar(jar);
                }
                finally {
                    Object var7_16 = null;
                    if (jar != null) {
                        jar.close();
                    }
                }
            }
            catch (IOException e) {
                this.err(e, "opening: " + jarFiles[i2]);
            }
            ++i2;
        }
    }

    private void processResolve() {
        this.msg("resolver : " + this.resolver());
        if (this.getNoverify()) {
            this.turnVerifierOff();
        }
        Cursor classnames = this.getOrder() ? this.getSortedClassNames() : this.getClassNames();
        while (classnames.next()) {
            this.resolve((String)classnames.get(), CLASS);
        }
        Cursor sourcenames = this.getSourceNames();
        while (sourcenames.next()) {
            this.resolve((String)sourcenames.get(), SOURCE);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resolve(String classname, int category) {
        boolean isClass;
        boolean isSource = category == SOURCE;
        boolean bl = isClass = category == CLASS;
        if (classname == null) {
            return false;
        }
        if (!isSource && !isClass) {
            return false;
        }
        Connection conn = this.getConnection();
        long startTime = System.currentTimeMillis();
        try {
            Statement getNameStmt = null;
            Statement stmt = null;
            try {
                getNameStmt = conn.createStatement();
                getNameStmt.execute("select dbms_java.shortname('" + classname + "')" + " from dual");
                ResultSet nameRs = getNameStmt.getResultSet();
                nameRs.next();
                String shortName = nameRs.getString(1);
                stmt = conn.createStatement();
                stmt.execute("select status from user_objects where object_type = " + (isClass ? "'JAVA CLASS'" : "'JAVA SOURCE'") + " and object_name = " + "'" + shortName + "'");
                ResultSet rs = stmt.getResultSet();
                if (rs.next() && rs.getString(1).equals("VALID")) {
                    this.msg(String.valueOf(classname) + " is already resolved");
                    this.getErrors(classname);
                    boolean bl2 = true;
                    Object var14_15 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (getNameStmt == null) return bl2;
                    getNameStmt.close();
                    return bl2;
                }
                this.msg("resolving: " + classname);
                if (isClass) {
                    stmt.execute("alter java class \"" + classname + "\" compile");
                } else if (isSource) {
                    stmt.execute("alter java source \"" + classname + "\" compile");
                }
                conn.commit();
                this.getErrors(classname);
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (getNameStmt == null) throw throwable;
                getNameStmt.close();
                throw throwable;
            }
            Object var14_16 = null;
            if (stmt != null) {
                stmt.close();
            }
            if (getNameStmt != null) {
                getNameStmt.close();
            }
        }
        catch (SQLException e) {
            this.err(e, "resolving class " + classname);
            try {
                conn.rollback();
                return false;
            }
            catch (SQLException sQLException) {}
            return false;
        }
        long endTime = System.currentTimeMillis();
        return true;
    }

    private String resolver() {
        String resolverString = null;
        if (this.getResolver().equals("") && this.getJdkresolver() && this.getUser() != null) {
            String schema = this.getSchema();
            if (schema.equals("")) {
                schema = this.getUser();
            }
            if (schema == null) {
                schema = "public";
            }
            if (schema.equalsIgnoreCase("internal")) {
                schema = "SYS";
            }
            resolverString = "( (\"*\" " + schema + ")" + " (\"*\" public)" + " (\"*\" -)" + ")";
        } else if (!this.getResolver().equals("")) {
            resolverString = this.getResolver();
        }
        if (resolverString == null) {
            return " ";
        }
        return " resolver " + resolverString;
    }

    private String rights() {
        return " ";
    }

    private String schemaAsPrefix() {
        String name = "";
        if (!this.getSchema().equals("")) {
            name = String.valueOf(this.getSchema()) + "." + name;
        }
        return name;
    }

    private String schemaClause() {
        if (this.getSchema().equals("")) {
            return " ";
        }
        return " schema " + this.getSchema();
    }

    public void setAndresolve(boolean andresolve) {
        boolean oldValue = this.fieldAndresolve;
        this.fieldAndresolve = andresolve;
        this.firePropertyChange("resolve", new Boolean(oldValue), new Boolean(andresolve));
    }

    public void setBound(boolean bound) {
        boolean oldValue = this.fieldBound;
        this.fieldBound = bound;
        this.firePropertyChange("bound", new Boolean(oldValue), new Boolean(bound));
    }

    public void setCompile(boolean compile) {
        boolean oldValue = this.fieldCompile;
        this.fieldCompile = compile;
        this.firePropertyChange("compile", new Boolean(oldValue), new Boolean(compile));
    }

    public void setCreateSynonym(boolean createSynonym) {
        boolean oldValue = this.fieldCreateSynonym;
        this.fieldCreateSynonym = createSynonym;
        this.firePropertyChange("createSynonym", new Boolean(oldValue), new Boolean(createSynonym));
    }

    public void setDatabase(DatabaseOptions database) {
        DatabaseOptions oldValue = this.fieldDatabase;
        this.fieldDatabase = database;
        this.firePropertyChange("database", oldValue, database);
    }

    public void setDebug(boolean debug) {
        boolean oldValue = this.fieldDebug;
        this.fieldDebug = debug;
        this.firePropertyChange("debug", new Boolean(oldValue), new Boolean(debug));
    }

    public void setDefiner(boolean definer) {
        boolean oldValue = this.fieldDefiner;
        this.fieldDefiner = definer;
        this.firePropertyChange("definer", new Boolean(oldValue), new Boolean(definer));
    }

    public void setEncoding(String encoding) {
        String oldValue = this.fieldEncoding;
        this.fieldEncoding = encoding;
        this.firePropertyChange("encoding", oldValue, encoding);
    }

    public void setFilenames(String[] filenames) {
        File[] files = new File[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            files[i] = this.newFile(filenames[i]);
            ++i;
        }
        this.setFiles(files);
    }

    public void setFiles(int index, File files) {
        File[] oldValue = this.fieldFiles;
        this.fieldFiles[index] = files;
        this.firePropertyChange("files", oldValue, this.fieldFiles);
    }

    public void setFiles(File[] files) {
        File[] oldValue = this.fieldFiles;
        this.fieldFiles = files;
        this.firePropertyChange("files", oldValue, files);
    }

    public void setForceLoading(boolean forceLoading) {
        boolean oldValue = this.fieldForceLoading;
        this.fieldForceLoading = forceLoading;
        this.firePropertyChange("forceLoading", new Boolean(oldValue), new Boolean(forceLoading));
    }

    public void setGrantNames(String grantNames) {
        String oldValue = this.fieldGrantNames;
        this.fieldGrantNames = grantNames;
        this.firePropertyChange("grantNames", oldValue, grantNames);
    }

    public void setJarFilenames(String[] filenames) {
        File[] files = new File[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            files[i] = this.newFile(filenames[i]);
            ++i;
        }
        this.setJarFiles(files);
    }

    public void setJarFiles(int index, File jarFiles) {
        File[] oldValue = this.fieldJarFiles;
        this.fieldJarFiles[index] = jarFiles;
        this.firePropertyChange("jarFiles", oldValue, this.fieldJarFiles);
    }

    public void setJarFiles(File[] jarFiles) {
        File[] oldValue = this.fieldJarFiles;
        this.fieldJarFiles = jarFiles;
        this.firePropertyChange("jarFiles", oldValue, jarFiles);
    }

    public void setJdkresolver(boolean jdkresolver) {
        boolean oldValue = this.fieldJdkresolver;
        this.fieldJdkresolver = jdkresolver;
        this.firePropertyChange("jdkresolver", new Boolean(oldValue), new Boolean(jdkresolver));
    }

    public void setLocalPathPrefix(String localPathPrefix) {
        String oldValue = this.fieldLocalPathPrefix;
        this.fieldLocalPathPrefix = localPathPrefix;
        if (this.fieldLocalPathPrefix == null) {
            this.fieldLocalPathPrefix = "";
        }
        this.fieldLocalPathPrefix = this.fieldLocalPathPrefix.replace('/', File.separatorChar);
        int length = this.fieldLocalPathPrefix.length();
        if (length > 0 && this.fieldLocalPathPrefix.charAt(length - 1) != File.separatorChar) {
            this.fieldLocalPathPrefix = String.valueOf(this.fieldLocalPathPrefix) + File.separator;
        }
        this.firePropertyChange("localPathPrefix", oldValue, localPathPrefix);
    }

    public void setNoverify(boolean noverify) {
        boolean oldValue = this.fieldNoverify;
        this.fieldNoverify = noverify;
        this.firePropertyChange("noverify", new Boolean(oldValue), new Boolean(noverify));
    }

    public void setOrder(boolean order) {
        boolean oldValue = this.fieldOrder;
        this.fieldOrder = order;
        this.firePropertyChange("order", new Boolean(oldValue), new Boolean(order));
    }

    public void setOutput(PrintStream output) {
        PrintStream oldValue = this.fieldOutput;
        this.fieldOutput = output;
        this.firePropertyChange("output", oldValue, output);
        this.log = null;
    }

    public void setResolve(boolean resolve) {
        boolean oldValue = this.fieldResolve;
        this.fieldResolve = resolve;
        this.firePropertyChange("resolve", new Boolean(oldValue), new Boolean(resolve));
    }

    public void setResolver(String resolver) {
        String oldValue = this.fieldResolver;
        this.fieldResolver = resolver;
        this.firePropertyChange("resolver", oldValue, resolver);
    }

    public void setSchema(String schema) {
        String oldValue = this.fieldSchema;
        this.fieldSchema = schema;
        this.firePropertyChange("schema", oldValue, schema);
    }

    public void setVerbose(boolean verbose) {
        boolean oldValue = this.fieldVerbose;
        this.fieldVerbose = verbose;
        this.firePropertyChange("verbose", new Boolean(oldValue), new Boolean(verbose));
    }

    public String transformName(String name) {
        if (this.isClassFile(name)) {
            name = name.substring(0, name.lastIndexOf(".class"));
            name.replace('.', '/');
        }
        if (this.isSourceFile(name)) {
            if (name.lastIndexOf(".java") > 0) {
                name = name.substring(0, name.lastIndexOf(".java"));
            } else if (name.lastIndexOf(".sqlj") > 0) {
                name = name.substring(0, name.lastIndexOf(".sqlj"));
            }
            name.replace('.', '/');
        }
        if (name.charAt(0) == '/') {
            name = "ROOT" + name;
        }
        return name.replace('\\', '/');
    }

    private void turnVerifierOff() {
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                stmt.execute("call dbms_java.set_verifier(0)");
                this.msg("verifier off: ");
            }
            finally {
                Object var4_3 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "turning off verifier");
        }
    }

    private void updateMD5(String classname) {
        Connection conn = this.getConnection();
        Statement pstmt = null;
        try {
            try {
                pstmt = conn.prepareStatement("DELETE FROM " + this.MD5Name() + " WHERE NAME = ? ");
                pstmt.setString(1, classname);
                pstmt.executeUpdate();
                pstmt.close();
                pstmt = conn.prepareStatement("INSERT INTO " + this.MD5Name() + " (NAME, MD5) VALUES(?, ?)");
                pstmt.setString(1, classname);
                pstmt.setBytes(2, this.md5);
                pstmt.executeUpdate();
                conn.commit();
            }
            finally {
                Object var5_4 = null;
                if (pstmt != null) {
                    pstmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "updating MD5 of: " + classname);
        }
    }

    static class DescriptorScanner {
        String descriptor;

        DescriptorScanner(String descriptor) {
            this.descriptor = descriptor;
        }

        public static void main(String[] argv) {
            DescriptorScanner m = new DescriptorScanner(argv[0]);
            Cursor c = m.referenced();
            while (c.next()) {
                System.out.println(c.get());
            }
        }

        Cursor referenced() {
            return new Referenced();
        }

        class Referenced
        implements Cursor {
            int xCurrent;
            int ndx;

            Referenced() {
                this.reset();
            }

            boolean done() {
                return this.xCurrent >= DescriptorScanner.this.descriptor.length();
            }

            public Object get() {
                int start = this.xCurrent;
                String s = null;
                this.moveTo(';');
                int end = this.xCurrent;
                if (start < DescriptorScanner.this.descriptor.length() && end <= DescriptorScanner.this.descriptor.length()) {
                    s = DescriptorScanner.this.descriptor.substring(start, end);
                }
                return s;
            }

            char getChar() {
                if (this.xCurrent >= DescriptorScanner.this.descriptor.length()) {
                    return ' ';
                }
                return DescriptorScanner.this.descriptor.charAt(this.xCurrent);
            }

            public int getIndex() {
                return this.ndx;
            }

            void moveTo(char c) {
                while (this.nextChar() && this.getChar() != c) {
                }
            }

            public boolean next() {
                if (!this.done()) {
                    this.moveTo('L');
                    this.nextChar();
                    ++this.ndx;
                }
                return this.done() ^ true;
            }

            boolean nextChar() {
                if (!this.done()) {
                    ++this.xCurrent;
                }
                return this.done() ^ true;
            }

            public void reset() {
                this.ndx = -1;
                this.xCurrent = -1;
            }
        }
    }
}

