/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts;

import javax.jts.HeuristicMixedException;
import javax.jts.HeuristicRollbackException;
import javax.jts.TransactionRolledbackException;
import javax.jts.UserTransaction;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.SubtransactionsUnavailable;

public class AuroraUserTransaction
implements UserTransaction {
    private Control txn;

    public void begin() throws IllegalStateException {
        if (this.txn != null) {
            throw new IllegalStateException("Subtransactions Unavailable");
        }
        try {
            this.getCurrent().begin();
            this.txn = this.getCurrent().get_control();
        }
        catch (SubtransactionsUnavailable subtransactionsUnavailable) {
            throw new IllegalStateException("Subtransactions Unavailable");
        }
    }

    public void commit() throws TransactionRolledbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException {
        try {
            try {
                this.getCurrent().commit(true);
            }
            catch (NoTransaction noTransaction) {
                throw new IllegalStateException("No transaction!");
            }
            catch (HeuristicMixed heuristicMixed) {
                throw new HeuristicMixedException();
            }
            catch (HeuristicHazard heuristicHazard) {
                throw new HeuristicRollbackException();
            }
            catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
                throw new TransactionRolledbackException();
            }
            Object var2_1 = null;
            this.txn = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.txn = null;
            throw throwable;
        }
    }

    private Current getCurrent() {
        try {
            return TS.getTS().getCurrent();
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getStatus() {
        return this.getCurrent().get_status().value();
    }

    public void resume() {
        if (this.txn == null) {
            return;
        }
        try {
            this.getCurrent().resume(this.txn);
        }
        catch (InvalidControl e) {
            this.txn = null;
            System.out.println("Invalid Control in UserTransaction");
            ((Throwable)((Object)e)).printStackTrace();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException {
        try {
            try {
                this.getCurrent().rollback();
            }
            catch (NoTransaction noTransaction) {
                throw new IllegalStateException("No transaction!");
            }
            Object var2_1 = null;
            this.txn = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.txn = null;
            throw throwable;
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        try {
            this.getCurrent().rollback_only();
        }
        catch (NoTransaction noTransaction) {
            throw new IllegalStateException("No transaction!");
        }
    }

    public void setTransactionTimeout(int arg1) {
        this.getCurrent().set_timeout(arg1);
    }

    public void suspend() {
        if (this.txn == null) {
            return;
        }
        this.txn = this.getCurrent().suspend();
    }
}

