/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.ejb.deployment.DeploymentDescriptor;
import oracle.aurora.ejb.parser.DescriptorDumper;
import oracle.aurora.ejb.parser.EnterpriseBeanParser;
import oracle.aurora.ejb.parser.OracleOutputStreamWriter;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.xml.parser.DOMWriter;
import oracle.aurora.ejb.xml.parser.EnterpriseBeanXMLParser;
import org.w3c.dom.Document;

public class Main {
    static final int UNKNOWN = 0;
    static final int PARSE = 1;
    static final int DUMP = 2;
    static final int PARSEXML = 3;
    static final int DUMPXML = 4;
    static int action;
    static String encoding;
    static InputStream in;
    static InputStream out;

    static {
        encoding = null;
    }

    static void doDump(String in, String out) throws Exception {
        ObjectInputStream inStream = in.equals("-") ? new ObjectInputStream(System.in) : new ObjectInputStream(new FileInputStream(in));
        PrintWriter outWriter = out.equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new OracleOutputStreamWriter((OutputStream)new FileOutputStream(out), encoding));
        Object object = inStream.readObject();
        if (!(object instanceof DeploymentDescriptor)) {
            ParseError.NO_SUCH_BEAN_TYPE(object.getClass().toString());
        }
        DeploymentDescriptor descriptor = (DeploymentDescriptor)object;
        DescriptorDumper.dumpDescriptor(outWriter, descriptor);
        outWriter.close();
    }

    static void doDumpXML(String in, String out) throws Exception {
        InputStream inStream = in.equals("-") ? System.in : new FileInputStream(in);
        PrintWriter outWriter = out.equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new OracleOutputStreamWriter((OutputStream)new FileOutputStream(out), encoding));
        DeploymentDescriptor descriptor = EnterpriseBeanParser.parseDescriptor(inStream, null);
        Document doc = EnterpriseBeanXMLParser.generateDocument(descriptor);
        new DOMWriter(outWriter).print(doc);
    }

    static void doParse(String in, String out) throws Exception {
        InputStream inStream = in.equals("-") ? System.in : new FileInputStream(in);
        ObjectOutputStream outStream = out.equals("-") ? new ObjectOutputStream(System.out) : new ObjectOutputStream(new FileOutputStream(out));
        DeploymentDescriptor descriptor = EnterpriseBeanParser.parseDescriptor(inStream, null, encoding);
        outStream.writeObject(descriptor);
        outStream.close();
    }

    static void doParseXML(String in, String out) throws Exception {
        InputStream inStream = in.equals("-") ? System.in : new FileInputStream(in);
        PrintWriter outStream = out.equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new OracleOutputStreamWriter((OutputStream)new FileOutputStream(out), encoding));
        DeploymentDescriptor descriptor = EnterpriseBeanXMLParser.generateDD(inStream, null);
        DescriptorDumper.dumpDescriptor(outStream, descriptor);
        outStream.close();
    }

    public static void main(String[] args) {
        try {
            action = 0;
            String in = null;
            String out = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-parsexml")) {
                    if (action != 0) {
                        Main.usage();
                    } else {
                        action = 3;
                    }
                } else if (args[i].equals("-dumpxml")) {
                    if (action != 0) {
                        Main.usage();
                    } else {
                        action = 4;
                    }
                } else if (args[i].equals("-parse")) {
                    if (action != 0) {
                        Main.usage();
                    } else {
                        action = 1;
                    }
                } else if (args[i].equals("-dump")) {
                    if (action != 0) {
                        Main.usage();
                    } else {
                        action = 2;
                    }
                } else if (args[i].equals("-encoding")) {
                    if (encoding != null || i >= args.length - 1) {
                        Main.usage();
                    } else {
                        encoding = args[++i];
                    }
                } else if (args[i].equals("-")) {
                    if (in == null) {
                        in = "-";
                    } else if (out == null) {
                        out = "-";
                    } else {
                        Main.usage();
                    }
                } else if (args[i].length() != 0 && args[i].charAt(0) == '-') {
                    Main.usage();
                } else if (in == null) {
                    in = args[i];
                } else if (out == null) {
                    out = args[i];
                } else {
                    Main.usage();
                }
                ++i;
            }
            if (action == 0) {
                Main.usage();
            }
            if (in == null) {
                in = "-";
            }
            if (out == null) {
                out = "-";
            }
            if (encoding == null) {
                encoding = System.getProperty("file.encoding");
            }
            switch (action) {
                case 1: {
                    Main.doParse(in, out);
                    break;
                }
                case 2: {
                    Main.doDump(in, out);
                    break;
                }
                case 3: {
                    Main.doParseXML(in, out);
                    break;
                }
                case 4: {
                    Main.doDumpXML(in, out);
                    break;
                }
                default: {
                    Main.usage();
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    static void usage() throws Exception {
        ParseError.BAD_MAIN_USAGE();
    }
}

