/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security.strong;

import com.sun.symon.base.security.SyEndInsecureInterface;
import com.sun.symon.base.security.SyEndSecureInterface;
import com.sun.symon.base.security.SySchemeInterface;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.security.strong.EndInsecure;
import com.sun.symon.base.security.strong.EndSecure;
import com.sun.symon.base.utility.UcDDL;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;

public class SyScheme
implements SySchemeInterface {
    public SyEndInsecureInterface getInsecureEnd(String string) throws SySecurityException {
        return new EndInsecure(string);
    }

    public SyEndSecureInterface getSecureEnd(String string) throws SySecurityException {
        return new EndSecure(string);
    }

    static void handleEx(Exception exception) throws SySecurityException {
        UcDDL.logErrorMessage("Unexpected internal problem", exception);
        throw new SySecurityException("Unexpected internal problem: " + exception, 3);
    }

    static byte[] joinBytes(byte[] byArray, byte[] byArray2) throws SySecurityException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(byArray);
            objectOutputStream.writeObject(byArray2);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidClassException invalidClassException) {
            SyScheme.handleEx(invalidClassException);
        }
        catch (NotSerializableException notSerializableException) {
            SyScheme.handleEx(notSerializableException);
        }
        catch (IOException iOException) {
            SyScheme.handleEx(iOException);
        }
        return null;
    }

    static byte[][] splitBytes(byte[] byArray) throws SySecurityException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            byte[] byArray2 = (byte[])objectInputStream.readObject();
            byte[] byArray3 = (byte[])objectInputStream.readObject();
            return new byte[][]{byArray2, byArray3};
        }
        catch (OptionalDataException optionalDataException) {
            SyScheme.handleEx(optionalDataException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SyScheme.handleEx(classNotFoundException);
        }
        catch (IOException iOException) {
            SyScheme.handleEx(iOException);
        }
        return null;
    }
}

