/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.topology;

import com.sun.symon.tools.migration.TmXMLMapReader;
import com.sun.symon.tools.migration.datasource.MdDataSource;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.datasource.MdTableSpace;
import com.sun.symon.tools.migration.topology.MoEntityInfo;
import com.sun.symon.tools.migration.topology.MoLeaf;
import com.sun.symon.tools.migration.topology.MoNode;
import com.sun.symon.tools.migration.topology.MoRecordStore;
import com.sun.symon.tools.migration.topology.MoViewInfo;
import com.sun.symon.tools.migration.util.MuDebug;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class MoMain {
    public static void exportShadowTopology() throws Exception {
        MdTableSpace mdTableSpace = MdTableSpace.getInstance("oracle");
        MdTable mdTable = mdTableSpace.getMdTable("node");
        MdTable mdTable2 = mdTableSpace.getMdTable("leaf");
        MdTable mdTable3 = mdTableSpace.getMdTable("node_relator");
        MdTable mdTable4 = mdTableSpace.getMdTable("node_leaf_relator");
        MdTable mdTable5 = mdTableSpace.getMdTable("node_entity_relator");
        MoMain.writeMdRecords(mdTable, new MdRecordWriter(){

            public void write(MdDataSource mdDataSource) throws Exception {
                MoMain.recurseDomainNodes(new NodeObserver(mdDataSource){
                    private final /* synthetic */ MdDataSource val$source;
                    {
                        this.val$source = mdDataSource;
                    }

                    public void observe(MoNode moNode) throws Exception {
                        MdRecord mdRecord = this.val$source.getMdTable().newMdRecord();
                        mdRecord = moNode.getMdRecord(mdRecord);
                        MuDebug.println(mdRecord);
                        this.val$source.write(mdRecord);
                    }
                });
            }
        });
        MoMain.writeMdRecords(mdTable2, new MdRecordWriter(){

            public void write(MdDataSource mdDataSource) throws Exception {
                MoMain.recurseDomainNodes(new NodeObserver(mdDataSource){
                    private final /* synthetic */ MdDataSource val$source;
                    {
                        this.val$source = mdDataSource;
                    }

                    public void observe(MoNode moNode) throws Exception {
                        ArrayList arrayList = moNode.getMoLeafs();
                        if (arrayList.size() > 0) {
                            int n = 0;
                            while (n < arrayList.size()) {
                                MoLeaf moLeaf = (MoLeaf)arrayList.get(n);
                                MdRecord mdRecord = this.val$source.getMdTable().newMdRecord();
                                mdRecord = moLeaf.getMdRecord(mdRecord);
                                MuDebug.println(mdRecord);
                                if (!moLeaf.isWritten()) {
                                    this.val$source.write(mdRecord);
                                    moLeaf.setWritten(true);
                                }
                                ++n;
                            }
                        }
                    }
                });
            }
        });
        MoMain.writeMdRecords(mdTable3, new MdRecordWriter(){

            public void write(MdDataSource mdDataSource) throws Exception {
                MoMain.recurseDomainNodes(new NodeObserver(mdDataSource){
                    private final /* synthetic */ MdDataSource val$source;
                    {
                        this.val$source = mdDataSource;
                    }

                    public void observe(MoNode moNode) throws Exception {
                        ArrayList arrayList = moNode.getNodes();
                        if (arrayList.size() > 0) {
                            long l = moNode.getNode_id();
                            int n = 0;
                            while (n < arrayList.size()) {
                                MoNode moNode2 = (MoNode)arrayList.get(n);
                                MdRecord mdRecord = this.val$source.getMdTable().newMdRecord();
                                mdRecord.getMdValue("parent_node_id").set(l);
                                mdRecord.getMdValue("child_node_id").set(moNode2.getNode_id());
                                MuDebug.println(mdRecord);
                                this.val$source.write(mdRecord);
                                ++n;
                            }
                        }
                    }
                });
            }
        });
        MoMain.writeMdRecords(mdTable4, new MdRecordWriter(){

            public void write(MdDataSource mdDataSource) throws Exception {
                MoMain.recurseDomainNodes(new NodeObserver(mdDataSource){
                    private final /* synthetic */ MdDataSource val$source;
                    {
                        this.val$source = mdDataSource;
                    }

                    public void observe(MoNode moNode) throws Exception {
                        ArrayList arrayList = moNode.getMoLeafs();
                        if (arrayList.size() > 0) {
                            long l = moNode.getNode_id();
                            int n = 0;
                            while (n < arrayList.size()) {
                                MoLeaf moLeaf = (MoLeaf)arrayList.get(n);
                                MdRecord mdRecord = this.val$source.getMdTable().newMdRecord();
                                mdRecord.getMdValue("node_id").set(l);
                                mdRecord.getMdValue("leaf_id").set(moLeaf.getMoLeaf_id());
                                MuDebug.println(mdRecord);
                                try {
                                    this.val$source.write(mdRecord);
                                }
                                catch (Exception exception) {
                                    MuDebug.println(exception);
                                    exception.printStackTrace(System.out);
                                }
                                ++n;
                            }
                        }
                    }
                });
            }
        });
        MoMain.writeMdRecords(mdTable5, new MdRecordWriter(){

            public void write(MdDataSource mdDataSource) throws Exception {
                MoMain.recurseDomainNodes(new NodeObserver(mdDataSource){
                    private final /* synthetic */ MdDataSource val$source;
                    {
                        this.val$source = mdDataSource;
                    }

                    public void observe(MoNode moNode) throws Exception {
                        ArrayList arrayList = moNode.getEntities();
                        if (arrayList.size() > 0) {
                            long l = moNode.getNode_id();
                            int n = 0;
                            while (n < arrayList.size()) {
                                MoNode.MoNodeEntityRelation moNodeEntityRelation = (MoNode.MoNodeEntityRelation)arrayList.get(n);
                                MdRecord mdRecord = this.val$source.getMdTable().newMdRecord();
                                mdRecord.getMdValue("node_id").set(l);
                                mdRecord.getMdValue("entity_id").set(moNodeEntityRelation.entity.getEntity_id());
                                mdRecord.getMdValue("leaf_id").set(moNodeEntityRelation.leaf.getMoLeaf_id());
                                MuDebug.println(mdRecord);
                                this.val$source.write(mdRecord);
                                ++n;
                            }
                        }
                    }
                });
            }
        });
    }

    public static void generateShadowTopology() throws Exception {
        ArrayList arrayList = MoViewInfo.getDomains();
        int n = 0;
        while (n < arrayList.size()) {
            MoViewInfo moViewInfo = (MoViewInfo)arrayList.get(n);
            MoNode moNode = new MoNode(null, moViewInfo);
            MoMain.recurseView(moViewInfo, moNode);
            ++n;
        }
    }

    public static void importTopology() throws Exception {
        MdTableSpace mdTableSpace = MdTableSpace.getInstance("oracle");
        MdTable mdTable = mdTableSpace.getMdTable("view_info");
        MdTable mdTable2 = mdTableSpace.getMdTable("entity_info");
        MdTable mdTable3 = mdTableSpace.getMdTable("view_entity_relator");
        MdTable mdTable4 = mdTableSpace.getMdTable("entity_view_relator");
        MoMain.readMdRecords(mdTable, new MdRecordReader(){

            public void read(MdRecord mdRecord) throws Exception {
                MoViewInfo moViewInfo = new MoViewInfo(mdRecord);
                MoRecordStore.put("view_info", moViewInfo.getView_id(), moViewInfo);
            }
        });
        MoMain.readMdRecords(mdTable2, new MdRecordReader(){

            public void read(MdRecord mdRecord) throws Exception {
                MoEntityInfo moEntityInfo = new MoEntityInfo(mdRecord);
                MoRecordStore.put("entity_info", moEntityInfo.getEntity_id(), moEntityInfo);
            }
        });
        MoMain.readMdRecords(mdTable3, new MdRecordReader(){

            public void read(MdRecord mdRecord) throws Exception {
                long l = mdRecord.getMdValue("view_id").toLong();
                long l2 = mdRecord.getMdValue("entity_id").toLong();
                MoViewInfo moViewInfo = (MoViewInfo)MoRecordStore.get("view_info", l);
                MoEntityInfo moEntityInfo = (MoEntityInfo)MoRecordStore.get("entity_info", l2);
                moViewInfo.getMoEntityInfos().add(moEntityInfo);
            }
        });
        MoMain.readMdRecords(mdTable4, new MdRecordReader(){

            public void read(MdRecord mdRecord) throws Exception {
                long l = mdRecord.getMdValue("entity_id").toLong();
                long l2 = mdRecord.getMdValue("view_id").toLong();
                MoEntityInfo moEntityInfo = (MoEntityInfo)MoRecordStore.get("entity_info", l);
                MoViewInfo moViewInfo = (MoViewInfo)MoRecordStore.get("view_info", l2);
                moEntityInfo.getMoViewInfos().add(moViewInfo);
            }
        });
    }

    public static void main(String[] stringArray) throws Exception {
        Arguments arguments = new Arguments(stringArray);
        TmXMLMapReader tmXMLMapReader = new TmXMLMapReader(arguments.mapFile);
        tmXMLMapReader.registerMdDataSources();
        MdTableSpace mdTableSpace = MdTableSpace.getInstance("oracle");
        MdDataSourceProperties mdDataSourceProperties = mdTableSpace.getMdDataSourceProperties();
        mdDataSourceProperties.setProperty("driver", arguments.driver);
        mdDataSourceProperties.setProperty("url", arguments.url);
        mdDataSourceProperties.setProperty("user", arguments.user);
        mdDataSourceProperties.setProperty("password", arguments.password);
        MdTable mdTable = mdTableSpace.newMdTable("node");
        mdTable.newMdAttribute("node_id", 2, null, null);
        mdTable.newMdAttribute("family", 7, null, null);
        mdTable.newMdAttribute("description", 7, null, null);
        mdTable.newMdAttribute("url", 7, null, null);
        mdTable.newMdAttribute("isdomain", 7, null, null);
        mdTable.newMdAttribute("arch", 7, null, null);
        mdTable.newMdAttribute("path", 7, null, null);
        mdTable = mdTableSpace.newMdTable("leaf");
        mdTable.newMdAttribute("leaf_id", 2, null, null);
        mdTable.newMdAttribute("hostname", 7, null, null);
        mdTable.newMdAttribute("ip_address", 7, null, null);
        mdTable.newMdAttribute("port", 2, null, null);
        mdTable.newMdAttribute("arch", 7, null, null);
        mdTable.newMdAttribute("family_type_id", 2, null, null);
        mdTable.newMdAttribute("licensable", 2, null, null);
        mdTable = mdTableSpace.newMdTable("node_relator");
        mdTable.newMdAttribute("parent_node_id", 2, null, null);
        mdTable.newMdAttribute("child_node_id", 2, null, null);
        mdTable = mdTableSpace.newMdTable("node_leaf_relator");
        mdTable.newMdAttribute("node_id", 2, null, null);
        mdTable.newMdAttribute("leaf_id", 2, null, null);
        mdTable = mdTableSpace.newMdTable("node_entity_relator");
        mdTable.newMdAttribute("node_id", 2, null, null);
        mdTable.newMdAttribute("entity_id", 2, null, null);
        mdTable.newMdAttribute("leaf_id", 2, null, null);
        MoMain.importTopology();
        MoMain.generateShadowTopology();
        MuDebug.println("----------------");
        Iterator iterator = ((AbstractList)MoNode.getDomains()).iterator();
        while (iterator.hasNext()) {
            MuDebug.println("[DOMAIN]:" + iterator.next());
        }
        MuDebug.println("----------------");
        MoMain.exportShadowTopology();
        MuDebug.println("----------------");
        Iterator iterator2 = ((AbstractList)MoViewInfo.getDomains()).iterator();
        while (iterator2.hasNext()) {
            MuDebug.println("[DOMAIN]:" + iterator2.next());
        }
        MuDebug.println("----------------");
    }

    private static void readMdRecords(MdTable mdTable, MdRecordReader mdRecordReader) throws Exception {
        MdRecord mdRecord;
        MdDataSource mdDataSource = MdDataSource.getInstance(mdTable);
        mdDataSource.open(1);
        while ((mdRecord = mdDataSource.read()) != null) {
            mdRecordReader.read(mdRecord);
        }
        mdDataSource.close();
    }

    public static void recurseDomainNodes(NodeObserver nodeObserver) throws Exception {
        ArrayList arrayList = MoNode.getDomains();
        int n = 0;
        while (n < arrayList.size()) {
            MoNode moNode = (MoNode)arrayList.get(n);
            MoMain.recurseNode(moNode, nodeObserver);
            ++n;
        }
    }

    private static void recurseNode(MoNode moNode, NodeObserver nodeObserver) throws Exception {
        nodeObserver.observe(moNode);
        ArrayList arrayList = moNode.getNodes();
        int n = 0;
        while (n < arrayList.size()) {
            MoNode moNode2 = (MoNode)arrayList.get(n);
            if (moNode2.getNodes().size() > 0) {
                MoMain.recurseNode(moNode2, nodeObserver);
            } else {
                nodeObserver.observe(moNode2);
            }
            ++n;
        }
    }

    private static void recurseView(MoViewInfo moViewInfo, MoNode moNode) throws Exception {
        ArrayList arrayList = moViewInfo.getMoEntityInfos();
        int n = 0;
        while (n < arrayList.size()) {
            MoEntityInfo moEntityInfo = (MoEntityInfo)arrayList.get(n);
            ArrayList arrayList2 = moEntityInfo.getMoViewInfos();
            if (!"aview".equals(moEntityInfo.getPoll_type())) {
                MoLeaf moLeaf = MoLeaf.leafFor(moEntityInfo);
                moNode.getMoLeafs().add(moLeaf);
                moNode.getEntities().add(new MoNode.MoNodeEntityRelation(moLeaf, moEntityInfo));
            } else {
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    MoViewInfo moViewInfo2 = (MoViewInfo)arrayList2.get(n2);
                    MoNode moNode2 = new MoNode(moEntityInfo, moViewInfo2);
                    moNode.getNodes().add(moNode2);
                    MoMain.recurseView(moViewInfo2, moNode2);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static void writeMdRecords(MdTable mdTable, MdRecordWriter mdRecordWriter) throws Exception {
        MdDataSource mdDataSource = MdDataSource.getInstance(mdTable);
        mdDataSource.open(3);
        mdRecordWriter.write(mdDataSource);
        mdDataSource.close();
    }

    static interface MdRecordReader {
        public void read(MdRecord var1) throws Exception;
    }

    static interface MdRecordWriter {
        public void write(MdDataSource var1) throws Exception;
    }

    static interface NodeObserver {
        public void observe(MoNode var1) throws Exception;
    }

    static class Arguments {
        public String mapFile;
        public String driver;
        public String url;
        public String user;
        public String password;

        public Arguments(String[] stringArray) throws Exception {
            try {
                this.mapFile = stringArray[0];
                this.driver = stringArray[1];
                this.url = stringArray[2];
                this.user = stringArray[3];
                this.password = stringArray[4];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException("expected <map.xml> <driver> <url> <user> <password>");
            }
        }
    }
}

