/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration;

import com.sun.symon.tools.migration.datasource.MdAttribute;
import com.sun.symon.tools.migration.datasource.MdDataSource;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.datasource.MdTableSpace;
import com.sun.symon.tools.migration.datasource.MdValue;
import com.sun.symon.tools.migration.util.MuDebug;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class TmJDBCDataSource
extends MdDataSource {
    private String driver;
    private String url;
    private String user;
    private String password;
    private final Properties dbProperties = new Properties();
    private Connection connection;
    private PreparedStatement statement;
    private ResultSet resultSet;

    public TmJDBCDataSource(MdTable mdTable, MdDataSourceProperties mdDataSourceProperties) throws Exception {
        super(mdTable, mdDataSourceProperties);
        this.parseProperties();
    }

    public Object clone() {
        TmJDBCDataSource tmJDBCDataSource = (TmJDBCDataSource)super.clone();
        tmJDBCDataSource.connection = null;
        return tmJDBCDataSource;
    }

    protected void closeImpl() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            this.statement = null;
            this.resultSet = null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public static void main(String[] stringArray) throws Exception {
        MdTableSpace mdTableSpace = MdTableSpace.newInstance("SomeMdTableSpace", "JDBC", null);
        MdTable mdTable = mdTableSpace.newMdTable("user");
        mdTable.newMdAttribute("first_name", 7, null, null);
        mdTable.newMdAttribute("last_name", 7, null, null);
        mdTable.newMdAttribute("address", 7, null, null);
        MuDebug.println(TmJDBCDataSource.prepareInsertStatement(mdTable));
        MuDebug.println(TmJDBCDataSource.prepareSelectStatement(mdTable));
        MuDebug.println(TmJDBCDataSource.prepareDeleteStatement(mdTable));
    }

    protected void openAppendImpl() throws Exception {
        this.openImpl();
        String string = TmJDBCDataSource.prepareInsertStatement(this.getMdTable());
        this.statement = this.connection.prepareStatement(string);
    }

    private void openImpl() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Driver driver = (Driver)Class.forName(this.driver).newInstance();
        this.connection = driver.connect(this.url, this.dbProperties);
        if (this.connection == null) {
            throw new SQLException("unable to connect: connection == null");
        }
        this.connection.setAutoCommit(true);
    }

    protected void openReadImpl() throws Exception {
        this.openImpl();
        String string = TmJDBCDataSource.prepareSelectStatement(this.getMdTable());
        this.statement = this.connection.prepareStatement(string);
        this.resultSet = this.statement.executeQuery();
    }

    protected void openWriteImpl() throws Exception {
        this.openImpl();
        String string = TmJDBCDataSource.prepareInsertStatement(this.getMdTable());
        this.statement = this.connection.prepareStatement(string);
    }

    protected void parsePropertiesImpl(MdDataSourceProperties mdDataSourceProperties) {
        this.driver = mdDataSourceProperties.getProperty("driver");
        this.url = mdDataSourceProperties.getProperty("url");
        this.user = mdDataSourceProperties.getProperty("user");
        this.password = mdDataSourceProperties.getProperty("password");
        ((Hashtable)this.dbProperties).clear();
        ((Hashtable)this.dbProperties).put("user", this.user);
        ((Hashtable)this.dbProperties).put("password", this.password);
        Enumeration enumeration = mdDataSourceProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("driver") || string.equals("url") || string.equals("user") || string.equals("password")) continue;
            ((Hashtable)this.dbProperties).put(string, mdDataSourceProperties.getProperty(string));
        }
        this.setName(this.url);
    }

    public static final String prepareDeleteStatement(MdTable mdTable) {
        return "DELETE FROM " + mdTable.getName();
    }

    public static String prepareInsertStatement(MdTable mdTable) {
        int n = mdTable.attributes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(mdTable.getName()).append(" (");
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(mdTable.getMdAttribute(n2).getName());
            ++n2;
        }
        stringBuffer.append(") VALUES(");
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('?');
            ++n3;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String prepareSelectStatement(MdTable mdTable) {
        int n = mdTable.attributes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(mdTable.getMdAttribute(n2).getName());
            ++n2;
        }
        stringBuffer.append(" FROM ").append(mdTable.getName());
        return stringBuffer.toString();
    }

    public static MdRecord read(MdTable mdTable, ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            MdRecord mdRecord = mdTable.newMdRecord();
            int n = mdTable.attributes();
            int n2 = 0;
            while (n2 < n) {
                mdRecord.getMdValue(n2).set(resultSet.getString(n2 + 1));
                ++n2;
            }
            return mdRecord;
        }
        return null;
    }

    protected MdRecord readImpl() throws Exception {
        return TmJDBCDataSource.read(this.getMdTable(), this.resultSet);
    }

    public static void setParameter(PreparedStatement preparedStatement, int n, MdValue mdValue) throws SQLException {
        if (mdValue.isNull() || mdValue.toString().length() == 0) {
            preparedStatement.setNull(n, TmJDBCDataSource.toSQLType(mdValue.getMdAttribute()));
        } else {
            switch (mdValue.getMdAttribute().getType()) {
                case 1: {
                    preparedStatement.setInt(n, mdValue.toInt());
                    break;
                }
                case 2: {
                    preparedStatement.setLong(n, mdValue.toLong());
                    break;
                }
                case 3: {
                    preparedStatement.setDouble(n, mdValue.toDouble());
                    break;
                }
                case 4: {
                    preparedStatement.setBoolean(n, mdValue.toBoolean());
                    break;
                }
                case 5: 
                case 6: {
                    preparedStatement.setTimestamp(n, mdValue.toTimestamp());
                    break;
                }
                case 7: {
                    preparedStatement.setString(n, mdValue.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(mdValue.getMdAttribute().getType()) + " is not a valid type for " + mdValue);
                }
            }
        }
    }

    public static int toSQLType(MdAttribute mdAttribute) {
        switch (mdAttribute.getType()) {
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return -7;
            }
            case 5: {
                return 93;
            }
            case 6: {
                return 93;
            }
            case 7: {
                return 12;
            }
        }
        throw new IllegalArgumentException(String.valueOf(mdAttribute.getType()) + " is not a valid type");
    }

    protected void writeImpl(MdRecord mdRecord) throws Exception {
        int n = this.getMdTable().attributes();
        int n2 = 0;
        while (n2 < n) {
            TmJDBCDataSource.setParameter(this.statement, n2 + 1, mdRecord.getMdValue(n2));
            ++n2;
        }
        if (this.statement.executeUpdate() != 1) {
            throw new SQLException("Update failed: recordsAffected==1");
        }
    }
}

