/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.console.grouping.filter.CgFilterDataPanel;
import com.sun.symon.base.console.grouping.filter.CgFilterManagerDlg;
import com.sun.symon.base.console.grouping.filter.CgFilterSubPanel;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConstants;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import com.sun.symon.tools.discovery.console.presentation.FilterData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RequestFilterPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private DiscoverPanel parent;
    private DiscoverRequest request;
    private FilterData filterData;
    private CgFilterDataPanel filterDataPanel = new CgFilterDataPanel(null);
    private JCheckBox hostCheckBox;
    private JRadioButton hostInclude;
    private JRadioButton hostExclude;
    private JTextField inputHost;
    private JButton deleteBtn;
    private JButton addBtn;
    private JList hostList = new JList(new DefaultListModel());
    private Hashtable modName2InterHash = new Hashtable();
    private Hashtable modInter2NameHash = new Hashtable();

    public RequestFilterPanel(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest) throws SMAPIException {
        this.parent = discoverPanel;
        this.request = discoverRequest;
        SMRawDataRequest sMRawDataRequest = this.parent.getRequestHandle();
        this.filterData = new FilterData(new SMResourceAccess(sMRawDataRequest));
        this.filterData.parseData();
        this.buildGUI();
        this.filterDataPanel.getPlatformPanel().setTypeList(this.filterData.i18nPlatforms);
        this.filterDataPanel.getOSPanel().setTypeList(DiscoverConstants.OS_ARR);
        Object[] objectArray = CgFilterManagerDlg.getMDRModNames(sMRawDataRequest, this.modName2InterHash, this.modInter2NameHash);
        if (objectArray != null) {
            this.filterDataPanel.getModulePanel().setTypeList(objectArray);
        }
        this.showFilterData();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.hostCheckBox) {
            this.hostBoxActivated();
        } else if (object == this.inputHost) {
            this.inputHostActivated();
        } else if (object == this.deleteBtn) {
            this.deleteActivated();
        } else if (object == this.addBtn) {
            this.addActivated();
        }
    }

    public void addActivated() {
        this.inputHostActivated();
    }

    public void buildGUI() {
        this.hostInclude = new JRadioButton(this.parent.getI18NString("Include"), true);
        this.hostExclude = new JRadioButton(this.parent.getI18NString("Exclude"), false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hostInclude);
        buttonGroup.add(this.hostExclude);
        this.deleteBtn = new JButton(this.parent.getI18NString("Delete"));
        this.addBtn = new JButton(this.parent.getI18NString("Add"));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(12, 6, 12, 6));
        this.hostCheckBox = new JCheckBox(this.parent.getI18NString("HostNameOrLabel"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.hostCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.hostInclude, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.hostExclude, gridBagConstraints);
        this.inputHost = new JTextField("", 20);
        this.inputHost.setBackground(UcCommon.getLightGrayColor());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.inputHost, gridBagConstraints);
        this.hostList.setBackground(UcCommon.getLightGrayColor());
        this.hostList.setFixedCellWidth(180);
        this.hostList.setFixedCellHeight(15);
        this.hostList.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.hostList, 22, 30);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 6);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addBtn, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.deleteBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        this.filterDataPanel = new CgFilterDataPanel(null);
        this.filterDataPanel.setAlignmentX(0.0f);
        jPanel.add((Component)this.filterDataPanel, gridBagConstraints);
        this.add((Component)jPanel, "West");
        this.hostCheckBox.addActionListener(this);
        this.inputHost.addActionListener(this);
        this.deleteBtn.addActionListener(this);
        this.addBtn.addActionListener(this);
        this.hostList.addListSelectionListener(this);
        this.hostNameSetStatus(false);
    }

    public void deleteActivated() {
        int[] nArray = this.hostList.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)this.hostList.getModel();
        int n = 0;
        while (n < nArray.length) {
            defaultListModel.removeElementAt(nArray[n]);
            ++n;
        }
        this.deleteBtn.setEnabled(false);
    }

    public void hostBoxActivated() {
        this.hostNameSetStatus(this.hostCheckBox.isSelected());
    }

    public void hostNameSetStatus(boolean bl) {
        this.hostCheckBox.setSelected(bl);
        this.hostInclude.setEnabled(bl);
        this.hostExclude.setEnabled(bl);
        this.inputHost.setEnabled(bl);
        this.hostList.setEnabled(bl);
        this.addBtn.setEnabled(bl);
        if (!bl) {
            this.deleteBtn.setEnabled(bl);
        }
    }

    public void inputHostActivated() {
        String string = this.inputHost.getText();
        if (string == null || string.length() == 0) {
            UcDialog.showError((Object)this.parent.getI18NString("inputHostEmpty"));
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.hostList.getModel();
        if (!defaultListModel.contains(string)) {
            defaultListModel.addElement(string);
            this.hostList.setModel(defaultListModel);
            if (this.hostList.isShowing()) {
                this.hostList.revalidate();
            }
        }
        this.inputHost.setText("");
    }

    public void listActivated() {
        if (this.hostList.getSelectedIndex() != -1) {
            this.deleteBtn.setEnabled(true);
        } else {
            this.deleteBtn.setEnabled(false);
        }
    }

    public void readFilterData() {
        int n;
        int n2 = 0;
        if (this.hostCheckBox.isSelected()) {
            ++n2;
        }
        if (this.filterDataPanel.getPlatformPanel().getCheckBoxSelected()) {
            ++n2;
        }
        if (this.filterDataPanel.getOSPanel().getCheckBoxSelected()) {
            ++n2;
        }
        if (this.filterDataPanel.getModulePanel().getCheckBoxSelected()) {
            ++n2;
        }
        this.request.setNumFilterCriteria(n2);
        CgFilterSubPanel[] cgFilterSubPanelArray = new CgFilterSubPanel[]{this.filterDataPanel.getOSPanel(), this.filterDataPanel.getPlatformPanel(), this.filterDataPanel.getModulePanel()};
        int n3 = 0;
        if (this.hostCheckBox.isSelected()) {
            n = ((DefaultListModel)this.hostList.getModel()).getSize();
            String[] stringArray = new String[n];
            int n4 = 0;
            while (n4 < n) {
                stringArray[n4] = (String)((DefaultListModel)this.hostList.getModel()).getElementAt(n4);
                ++n4;
            }
            if (this.hostInclude.isSelected()) {
                this.request.setIncludeItemValue(n3, stringArray);
            } else {
                this.request.setExcludeItemValue(n3, stringArray);
            }
            this.request.setFilterCriteria(n3, 0);
            ++n3;
        }
        n = 0;
        while (n < cgFilterSubPanelArray.length) {
            if (cgFilterSubPanelArray[n].getCheckBoxSelected()) {
                int n5 = ((DefaultListModel)cgFilterSubPanelArray[n].getList().getModel()).getSize();
                String[] stringArray = new String[n5];
                int n6 = 0;
                while (n6 < n5) {
                    if (n == 0) {
                        stringArray[n6] = (String)((DefaultListModel)cgFilterSubPanelArray[n].getList().getModel()).getElementAt(n6);
                        stringArray[n6] = stringArray[n6].substring(6);
                    } else if (n == 1) {
                        stringArray[n6] = this.filterData.getPlatformforI18N((String)((DefaultListModel)cgFilterSubPanelArray[n].getList().getModel()).getElementAt(n6));
                    } else {
                        String string = (String)((DefaultListModel)cgFilterSubPanelArray[n].getList().getModel()).getElementAt(n6);
                        stringArray[n6] = (String)this.modName2InterHash.get(string);
                    }
                    ++n6;
                }
                if (cgFilterSubPanelArray[n].getIncludeSelected()) {
                    this.request.setIncludeItemValue(n3, stringArray);
                } else {
                    this.request.setExcludeItemValue(n3, stringArray);
                }
                switch (n) {
                    case 0: {
                        this.request.setFilterCriteria(n3, 1);
                        break;
                    }
                    case 1: {
                        this.request.setFilterCriteria(n3, 2);
                        break;
                    }
                    case 2: {
                        this.request.setFilterCriteria(n3, 3);
                        break;
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public void showFilterData() {
        CgFilterSubPanel[] cgFilterSubPanelArray = new CgFilterSubPanel[]{this.filterDataPanel.getOSPanel(), this.filterDataPanel.getPlatformPanel(), this.filterDataPanel.getModulePanel()};
        int n = this.request.getNumFilterCriteria();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this.request.getFilterCriteria(n2);
            String[] stringArray = this.request.getIncludeItemValue(n2);
            String[] stringArray2 = this.request.getExcludeItemValue(n2);
            if (n4 == 0) {
                this.hostNameSetStatus(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.hostExclude.doClick();
                    n3 = 0;
                    while (n3 < stringArray2.length) {
                        ((DefaultListModel)this.hostList.getModel()).addElement(stringArray2[n3]);
                        ++n3;
                    }
                } else {
                    this.hostInclude.doClick();
                    n3 = 0;
                    while (n3 < stringArray.length) {
                        ((DefaultListModel)this.hostList.getModel()).addElement(stringArray[n3]);
                        ++n3;
                    }
                }
            } else {
                String string;
                cgFilterSubPanelArray[n4 - 1].setStatus(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    cgFilterSubPanelArray[n4 - 1].setExcludeSelected();
                    n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (n4 == 1) {
                            ((DefaultListModel)cgFilterSubPanelArray[0].getList().getModel()).addElement("SunOS " + stringArray2[n3]);
                        } else if (n4 == 2) {
                            ((DefaultListModel)cgFilterSubPanelArray[1].getList().getModel()).addElement(this.filterData.getI18NforPlatform(stringArray2[n3]));
                        } else if (n4 == 3) {
                            string = (String)this.modInter2NameHash.get(stringArray2[n3]);
                            ((DefaultListModel)cgFilterSubPanelArray[2].getList().getModel()).addElement(string);
                        }
                        ++n3;
                    }
                } else {
                    cgFilterSubPanelArray[n4 - 1].setIncludeSelected();
                    n3 = 0;
                    while (n3 < stringArray.length) {
                        if (n4 == 1) {
                            ((DefaultListModel)cgFilterSubPanelArray[0].getList().getModel()).addElement("SunOS " + stringArray[n3]);
                        } else if (n4 == 2) {
                            ((DefaultListModel)cgFilterSubPanelArray[1].getList().getModel()).addElement(this.filterData.getI18NforPlatform(stringArray[n3]));
                        } else if (n4 == 3) {
                            string = (String)this.modInter2NameHash.get(stringArray[n3]);
                            ((DefaultListModel)cgFilterSubPanelArray[2].getList().getModel()).addElement(string);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.hostList) {
            this.listActivated();
        }
    }
}

